<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\LoanInterestService;

class CalculateDailyInterest extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'loans:calculate-daily-interest';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Calculate daily interest income for all active loans';

    /**
     * Execute the console command.
     */
    public function handle()
{
    $this->info('Starting daily interest calculation...');
    
    $service = new LoanInterestService();
    $result = $service->calculateDailyInterest();
    
    $this->info("=== DAILY INTEREST CALCULATION RESULTS ===");
    $this->info("Total active loans: {$result['total_loans']}");
    $this->info("Loans processed: {$result['loans_processed']}");
    $this->info("Total Interest: $" . number_format($result['total_interest_amount'], 2));
    $this->info("Total Processing Fees: $" . number_format($result['total_processing_fee_amount'], 2));
    $this->info("Errors: {$result['errors']}");
    
    if ($result['errors'] > 0) {
        $this->error("Some loans had errors. Check the logs for details.");
    } else {
        $this->info("✅ Interest calculation completed successfully!");
    }
    
    // Log to system logs as well
    \Log::info('Daily interest calculation completed', $result);
    
    return 0;
}
}