<?php

namespace App\Http\Controllers\Accounting;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\AccountGroup;
use App\Models\PrimaryCategory; // ADD THIS

class AccountGroupController extends Controller
{
    public function index()
    {
        $accountGroups = AccountGroup::with(['primaryCategory'])->orderBy('name')->get();
        
        return view('accounting.settings.account-groups.index', compact('accountGroups'));
    }

    public function create()
    {
        $primaryCategories = PrimaryCategory::where('is_active', true)->orderBy('name')->get(); // ADD THIS
        return view('accounting.settings.account-groups.create', compact('primaryCategories')); // UPDATE THIS
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required',
            'description' => 'nullable',
            'primary_category_id' => 'required|exists:primary_categories,id', // UPDATE THIS
            'is_active' => 'boolean',
        ]);

        // Add authenticated user as creator
        $validated['created_by'] = auth()->id();
        $validated['updated_by'] = auth()->id();

        AccountGroup::create($validated);

        return redirect()->route('admin.accounting.settings.account-groups.index')
            ->with('success', 'Account group created successfully.');
    }

    public function show($id)
    {
        $accountGroup = AccountGroup::with(['primaryCategory'])->findOrFail($id); // UPDATE THIS
        
        return view('accounting.settings.account-groups.show', compact('accountGroup'));
    }

    public function edit($id)
    {
        $accountGroup = AccountGroup::findOrFail($id);
        $primaryCategories = PrimaryCategory::where('is_active', true)->orderBy('name')->get(); // ADD THIS
        
        return view('accounting.settings.account-groups.edit', compact('accountGroup', 'primaryCategories')); // UPDATE THIS
    }

    public function update(Request $request, $id)
    {
        $accountGroup = AccountGroup::findOrFail($id);
        
        $validated = $request->validate([
            'name' => 'required',
            'description' => 'nullable',
            'primary_category_id' => 'required|exists:primary_categories,id', // UPDATE THIS
            'is_active' => 'boolean',
        ]);

        // Add authenticated user as updater
        $validated['updated_by'] = auth()->id();

        $accountGroup->update($validated);

        return redirect()->route('admin.accounting.settings.account-groups.index')
            ->with('success', 'Account group updated successfully.');
    }

    public function destroy($id)
    {
        $accountGroup = AccountGroup::findOrFail($id);
        $accountGroup->delete();

        return redirect()->route('admin.accounting.settings.account-groups.index')
            ->with('success', 'Account group deleted successfully.');
    }
}