<?php


namespace App\Http\Controllers\Accounting;

use App\Http\Controllers\Controller;
use App\Models\CashBankAccount;
use App\Models\InternalCashBankTransfer;
use App\Models\PettyCash;
use Illuminate\Http\Request;

class CashBankingController extends Controller
{
    public function __construct()
    {
        // Removed middleware permission check
    }

    /**
     * Display the cash and banking dashboard
     */
    public function index()
    {
        // Get the user's company ID
        $companyId = auth()->user()->companyid;
        
        // Check if company ID exists
        if (!$companyId) {
            return redirect()->back()
                ->with('error', 'User is not associated with a company. Please contact administrator.');
        }

        $accounts = CashBankAccount::with(['glAccount'])
            ->where('companyid', $companyId)
            ->where('isActive', true)
            ->orderBy('accountType')
            ->orderBy('accountName')
            ->get();

        $recentTransfers = InternalCashBankTransfer::with(['fromAccount', 'toAccount'])
            ->where('companyid', $companyId)
            ->orderBy('created_at', 'desc')
            ->take(10)
            ->get();

        $recentPettyCash = PettyCash::with(['sourceAccount', 'requester'])
            ->where('company_id', $companyId)
            ->orderBy('created_at', 'desc')
            ->take(10)
            ->get();

        // Calculate total balances
        $totalBalance = $accounts->sum('current_balance');
        $cashBalance = $accounts->where('accountType', 'Cash')->sum('current_balance');
        $bankBalance = $accounts->where('accountType', 'Bank')->sum('current_balance');
        $mobileMoneyBalance = $accounts->where('accountType', 'Mobile Money')->sum('current_balance');

        return view('accounting.cash-banking.index', compact(
            'accounts', 
            'recentTransfers',
            'recentPettyCash',
            'totalBalance',
            'cashBalance',
            'bankBalance',
            'mobileMoneyBalance'
        ));
    }
}