<?php

namespace App\Http\Controllers\Accounting;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Artisan;

class NotificationSettingsController extends Controller
{
    public function index()
    {
        $events = DB::table('notification_events')->get();
        $settingsData = DB::table('notification_settings')->get();
        
        $settings = [];
        foreach ($settingsData as $setting) {
            $settings[$setting->channel][$setting->event_key] = $setting->is_enabled;
        }

        return view('accounting.notifications.index', compact('events', 'settings'));
    }

    public function update(Request $request)
    {
        $eventKeys = DB::table('notification_events')->pluck('event_key');

        try {
            DB::beginTransaction();

            foreach ($eventKeys as $event) {
                // Update Toggles
                foreach (['email', 'sms'] as $channel) {
                    DB::table('notification_settings')->updateOrInsert(
                        ['event_key' => $event, 'channel' => $channel],
                        ['is_enabled' => $request->has("{$channel}_{$event}"), 'updated_at' => now()]
                    );
                }

                // Update Templates & Days
                $updateData = [];
                if ($request->has("sms_template_{$event}")) {
                    $updateData['sms_template'] = $request->input("sms_template_{$event}");
                }
                if ($event === 'payment_due' && $request->has('reminder_days')) {
                    $updateData['reminder_days'] = $request->input('reminder_days');
                }
                if ($event === 'payment_overdue' && $request->has('overdue_frequency_days')) {
                    $updateData['overdue_frequency_days'] = $request->input('overdue_frequency_days');
                }

                if (!empty($updateData)) {
                    DB::table('notification_events')->where('event_key', $event)->update($updateData);
                }
            }

            DB::commit();
            Artisan::call('cache:clear');
            return back()->with('success', 'Preferences and SMS templates updated successfully.');
        } catch (\Exception $e) {
            DB::rollBack();
            return back()->with('error', 'Update failed: ' . $e->getMessage());
        }
    }
}