<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class CollectionController extends Controller
{
    public function index()
    {
        // Manual permission check
        if (!auth()->user()->hasPermission('collections.view')) {
            abort(403, 'You do not have permission to view collections.');
        }

        return view('admin.collections.index');
    }

    public function recordCollection(Request $request)
    {
        // Manual permission check for specific action
        if (!auth()->user()->hasPermission('collections.record')) {
            abort(403, 'You do not have permission to record collections.');
        }

        // Your collection recording logic here

        return redirect()->back()->with('success', 'Collection recorded successfully.');
    }

    public function reverseCollection($id)
    {
        // Manual permission check for specific action
        if (!auth()->user()->hasPermission('collections.reverse')) {
            abort(403, 'You do not have permission to reverse collections.');
        }

        // Your collection reversal logic here

        return redirect()->back()->with('success', 'Collection reversed successfully.');
    }
}