<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class LoanController extends Controller
{
    /**
     * Get all active and closed loans for a specific customer
     */
    public function getCustomerLoans(Request $request)
    {
        $customerId = $request->query('customer_id');

        if (!$customerId) {
            return response()->json([
                'success' => false,
                'message' => 'Customer ID is required'
            ], 400);
        }

        // Join disbursedloans with loantype to get the Product Name
        $loans = DB::table('disbursedloans')
            ->join('loantype', 'disbursedloans.loantypeid', '=', 'loantype.id')
            ->where('disbursedloans.customerid', $customerId)
            ->select(
                'disbursedloans.loannumber as loan_number',
                'loantype.product as product_name',
                'disbursedloans.totalbalance as total_balance',
                'disbursedloans.interestbalance as interest_balance',
                'disbursedloans.principalbalance as principal_balance',
                'disbursedloans.status',
                'disbursedloans.disburseddate as disbursed_date'
            )
            ->orderBy('disbursedloans.created_at', 'desc')
            ->get();

        return response()->json([
            'success' => true,
            'data' => $loans
        ]);
    }
}