<?php

namespace App\Http\Controllers\Api;

// 1. You must import the base Controller from the parent namespace
use App\Http\Controllers\Controller; 
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class TransactionHistoryController extends Controller
{
    public function getHistory(Request $request)
    {
        $customerId = $request->query('customer_id');

        if (!$customerId) {
            return response()->json(['success' => false, 'message' => 'Customer ID is required'], 400);
        }

        // 1. Get Collections (Repayments - Money In)
        // We include reference_id as requested previously for the search feature
        $collections = DB::table('payment_collections')
            ->select([
                'id',
                'amount',
                'status',
                'created_at',
                'payment_type',
                'reference_id',
                'narration',
                DB::raw("'repayment' as type"),
                DB::raw("'in' as direction")
            ])
            ->where('loan_customer_id', $customerId);

        // 2. Get Disbursements (Loans - Money Out)
        $history = DB::table('payment_disbursements')
            ->select([
                'id',
                'amount',
                'status',
                'created_at',
                'payment_type',
                'reference_id',
                'narration',
                DB::raw("'disbursement' as type"),
                DB::raw("'out' as direction")
            ])
            ->where('customer_id', $customerId)
            ->union($collections)
            ->orderBy('created_at', 'desc')
            ->get();

        return response()->json([
            'success' => true,
            'data' => $history
        ]);
    }
}