<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use App\Models\Application;
use App\Models\DisbursedLoan;

class LoanDisbursed extends Mailable
{
    use Queueable, SerializesModels;

    public $application;
    public $disbursedLoan;

    /**
     * Create a new message instance.
     */
    public function __construct(Application $application, DisbursedLoan $disbursedLoan)
    {
        $this->application = $application;
        $this->disbursedLoan = $disbursedLoan;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Loan Disbursed - ' . $this->disbursedLoan->loannumber,
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.loan-disbursed',
        );
    }

    /**
     * Get the attachments for the message.
     */
    public function attachments(): array
    {
        return [];
    }
}