<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class PaymentDueReminder extends Mailable
{
    use Queueable, SerializesModels;

    public $customer;
    public $schedule;
    public $loan;
    public $dueAmount;
    public $daysUntilDue;

    public function __construct($customer, $schedule, $loan, $dueAmount, $daysUntilDue)
    {
        $this->customer = $customer;
        $this->schedule = $schedule;
        $this->loan = $loan;
        $this->dueAmount = $dueAmount;
        $this->daysUntilDue = $daysUntilDue;
    }

    public function build()
    {
        $subject = 'Payment Due Reminder - Loan #' . $this->schedule->loannumber;
        
        if ($this->daysUntilDue === 1) {
            $subject = 'FINAL REMINDER: Payment Due Tomorrow - Loan #' . $this->schedule->loannumber;
        } elseif ($this->daysUntilDue === 0) {
            $subject = 'URGENT: Payment Due Today - Loan #' . $this->schedule->loannumber;
        }
        
        return $this->subject($subject)
                    ->view('emails.payment_due_reminder')
                    ->with([
                        'customer' => $this->customer,
                        'schedule' => $this->schedule,
                        'loan' => $this->loan,
                        'dueAmount' => $this->dueAmount,
                        'daysUntilDue' => $this->daysUntilDue
                    ]);
    }
}