<?php

namespace App\Mail;

use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class UserCreatedMail extends Mailable
{
    use Queueable, SerializesModels;

    public $user;
    public $generatedPassword;
    public $loginUrl;

    /**
     * Create a new message instance.
     */
    public function __construct(User $user, string $generatedPassword)
    {
        $this->user = $user;
        $this->generatedPassword = $generatedPassword;
        $this->loginUrl = url('/admin/login');
    }

    /**
     * Build the message.
     */
    public function build()
    {
        return $this->subject('Your IMMIA FINANCE LIMITED Account Has Been Created')
                    ->markdown('emails.user-created')
                    ->with([
                        'user' => $this->user,
                        'password' => $this->generatedPassword,
                        'loginUrl' => $this->loginUrl,
                    ]);
    }
}