<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CompanySettingsHistory extends Model
{
    use HasFactory;

    protected $table = 'company_settings_history';

    protected $fillable = [
        'company_id',
        'setting_type',
        'old_value_id',
        'old_value_name',
        'new_value_id',
        'new_value_name',
        'changed_by',
        'reason'
    ];

    // Relationships
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function changedBy()
    {
        return $this->belongsTo(User::class, 'changed_by');
    }

    // Scopes
    public function scopeForCurrency($query)
    {
        return $query->where('setting_type', 'reporting_currency');
    }

    public function scopeForFinancialYear($query)
    {
        return $query->where('setting_type', 'financial_year');
    }

    // Accessors
    public function getSettingTypeLabelAttribute()
    {
        $types = [
            'reporting_currency' => 'Reporting Currency',
            'financial_year' => 'Financial Year'
        ];

        return $types[$this->setting_type] ?? $this->setting_type;
    }

    public function getChangeDescriptionAttribute()
    {
        if ($this->old_value_name && $this->new_value_name) {
            return "Changed from {$this->old_value_name} to {$this->new_value_name}";
        } elseif ($this->new_value_name) {
            return "Set to {$this->new_value_name}";
        } else {
            return "Removed setting";
        }
    }
}