<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Currency extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_id',
        'branch_id',
        'code',
        'name',
        'symbol',
        'symbol_native',
        'decimal_digits',
        'rounding',
        'is_active',
        'created_by',
        'updated_by'
    ];

    protected $casts = [
        'decimal_digits' => 'integer',
        'rounding' => 'decimal:2',
        'is_active' => 'boolean'
    ];

    // Relationships
    public function company()
    {
        return $this->belongsTo(Company::class, 'company_id');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function updater()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }

    public function baseCurrencyRates()
    {
        return $this->hasMany(CurrencyRate::class, 'base_currency_id');
    }

    public function targetCurrencyRates()
    {
        return $this->hasMany(CurrencyRate::class, 'target_currency_id');
    }

    public function chartOfAccounts()
    {
        return $this->hasMany(ChartOfAccount::class);
    }

    public function reportingCompanies()
    {
        return $this->hasMany(Company::class, 'reporting_currency_id');
    }

    // Accessor for formatted name
    public function getFormattedNameAttribute()
    {
        return "{$this->code} - {$this->name} ({$this->symbol})";
    }
}