<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CurrencyRate extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_id',
        'branch_id',
        'base_currency_id',
        'target_currency_id',
        'rate',
        'rate_date',
        'created_by'
    ];

    protected $casts = [
        'rate' => 'decimal:6',
        'rate_date' => 'date'
    ];

    // Relationships
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function baseCurrency()
    {
        return $this->belongsTo(Currency::class, 'base_currency_id');
    }

    public function targetCurrency()
    {
        return $this->belongsTo(Currency::class, 'target_currency_id');
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}