<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DisbursementChannel extends Model
{
    use HasFactory;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'disbursement_channels';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'disbursmentchannel',
        'companyid',
        'createdby',
    ];

    /**
     * Get the company that owns the disbursement channel.
     */
    public function company()
    {
        return $this->belongsTo(Company::class, 'companyid');
    }

    /**
     * Get the user who created the disbursement channel.
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'createdby');
    }
}