<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LeaveType extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_id',
        'name',
        'code',
        'description',
        'max_days_per_year',
        'accrual_rate_days',
        'is_paid',
        'requires_approval',
        'can_carry_forward',
        'max_carry_forward_days',
        'is_active'
    ];

    protected $casts = [
        'is_paid' => 'boolean',
        'requires_approval' => 'boolean',
        'can_carry_forward' => 'boolean',
        'is_active' => 'boolean'
    ];

    public function company()
    {
        return $this->belongsTo(Company::class, 'company_id');
    }

    public function leaveRequests()
    {
        return $this->hasMany(LeaveRequest::class, 'leave_type_id');
    }

    public function leaveBalances()
    {
        return $this->hasMany(LeaveBalance::class, 'leave_type_id');
    }

    public function getAccrualDescriptionAttribute()
    {
        if ($this->accrual_rate_days > 0) {
            return "{$this->accrual_rate_days} days per month";
        }
        
        if ($this->max_days_per_year) {
            return "{$this->max_days_per_year} days per year";
        }
        
        return "No accrual limit";
    }
}