<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LoanQuotation extends Model
{
    use HasFactory;

    /**
     * The table associated with the model.
     * * @var string
     */
    protected $table = 'loan_quotations';

    /**
     * The attributes that are mass assignable.
     * These must match the keys used in your QuotationController.
     */
    protected $fillable = [
        'quotation_number',
        'customer_name',
        'product_id',
        'principal_amount',
        'tenure',
        'tenure_type',
        'interest_method',
        'base_interest_rate',
        'interest_discount',
        'effective_interest_rate',
        'base_processing_rate',
        'processing_discount',
        'effective_processing_rate',
        'admin_rate',
        'insurance_rate',
        'monthly_installment',
        'total_interest',
        'total_repayable',
        'net_disbursement',
        'status',
        'created_by'
    ];

    /**
     * The attributes that should be cast to native types.
     * This ensures that decimals come back as floats/doubles in PHP.
     */
    protected $casts = [
        'principal_amount'           => 'double',
        'base_interest_rate'         => 'double',
        'interest_discount'          => 'double',
        'effective_interest_rate'    => 'double',
        'base_processing_rate'       => 'double',
        'processing_discount'        => 'double',
        'effective_processing_rate'  => 'double',
        'admin_rate'                 => 'double',
        'insurance_rate'             => 'double',
        'monthly_installment'        => 'double',
        'total_interest'             => 'double',
        'total_repayable'            => 'double',
        'net_disbursement'           => 'double',
        'tenure'                     => 'integer',
        'created_at'                 => 'datetime',
        'updated_at'                 => 'datetime',
    ];

    /**
     * RELATIONSHIP: Loan Product
     * Links the quotation to the original product template.
     */
    public function product()
    {
        // Using 'loantype' table logic as per your controller
        return $this->belongsTo(LoanType::class, 'product_id');
    }

    /**
     * RELATIONSHIP: Creator
     * Links the quotation to the user who created it.
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}