<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PaymentDisbursement extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_id',
        'customer_id',    // ADDED THIS
        'created_by',
        'loan_id',        
        'reference_id',
        'identifier',
        'amount',
        'currency',
        'account_number',
        'status',
        'payment_type',
        'narration',
        'ip_address',
        'api_created_at'
    ];

    protected $casts = [
        'amount' => 'decimal:4',
        'api_created_at' => 'datetime',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'loan_id' => 'integer',
        'customer_id' => 'integer', // ADDED THIS
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customer_id');
    }

    public function loan()
    {
        return $this->belongsTo(DisbursedLoan::class, 'loan_id', 'loanid');
    }

    public function company()
    {
        return $this->belongsTo(Company::class, 'company_id');
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}