<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PayrollRun extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_id',
        'payroll_period_id',
        'run_number',
        'run_date',
        'status',
        'total_gross_salary',
        'total_paye_tax',
        'total_napsa_employee',
        'total_napsa_employer',
        'total_nhima_employee',
        'total_nhima_employer',
        'total_other_deductions',
        'total_net_pay',
        'approved_by',
        'approved_at',
        'paid_by',
        'paid_at',
        'reversed_by',
        'reversed_at',
        'notes',
        'created_by',
        'updated_by'
    ];

    protected $casts = [
        'run_date' => 'date',
        'approved_at' => 'datetime',
        'paid_at' => 'datetime',
        'reversed_at' => 'datetime',
        'total_gross_salary' => 'decimal:2',
        'total_paye_tax' => 'decimal:2',
        'total_napsa_employee' => 'decimal:2',
        'total_napsa_employer' => 'decimal:2',
        'total_nhima_employee' => 'decimal:2',
        'total_nhima_employer' => 'decimal:2',
        'total_other_deductions' => 'decimal:2',
        'total_net_pay' => 'decimal:2'
    ];

    public function company()
    {
        return $this->belongsTo(Company::class, 'company_id');
    }

    public function payrollPeriod()
    {
        return $this->belongsTo(PayrollPeriod::class, 'payroll_period_id');
    }

    public function payrollEntries()
    {
        return $this->hasMany(PayrollEntry::class, 'payroll_run_id');
    }

    public function approvedBy()
    {
        return $this->belongsTo(User::class, 'approved_by');
    }

    public function paidBy()
    {
        return $this->belongsTo(User::class, 'paid_by');
    }

    public function reversedBy()
    {
        return $this->belongsTo(User::class, 'reversed_by');
    }

    public function canApprove()
    {
        return $this->status === 'calculated';
    }

    public function canPay()
    {
        return $this->status === 'approved';
    }

    public function canReverse()
    {
        return $this->status === 'paid';
    }
}