<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PettyCashItem extends Model
{
    use HasFactory;

    protected $primaryKey = 'petty_cash_item_id';
    protected $table = 'petty_cash_items';
    
    protected $fillable = [
        'petty_cash_id',
        'item_description',
        'amount',
        'chart_of_account_id'
    ];

    protected $casts = [
        'amount' => 'decimal:2',
    ];

    /**
     * Get the petty cash header
     */
    public function pettyCash(): BelongsTo
    {
        return $this->belongsTo(PettyCash::class, 'petty_cash_id');
    }

    /**
     * Get the chart of account
     */
    public function chartOfAccount(): BelongsTo
    {
        return $this->belongsTo(ChartOfAccount::class, 'chart_of_account_id', 'id');
    }

    /**
     * Get formatted amount
     */
    public function getFormattedAmountAttribute(): string
    {
        return number_format($this->amount, 2);
    }
}