<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProcessingFee extends Model
{
    use HasFactory;

    // The table name (your table is 'processingfees', not the default 'processing_fees')
    protected $table = 'processingfees';

    // Primary key
    protected $primaryKey = 'id';

    // Timestamps - your table has created_at and updated_at
    public $timestamps = true;

    // Fillable fields
    protected $fillable = [
        'iloanid',
        'customerid',
        'ipid',
        'charge',
        'chargeddate',
        'poster',
        'branchid',
        'companyid',
        'created_at',
        'updated_at'
    ];

    // Casts
    protected $casts = [
        'charge' => 'decimal:2',
        'chargeddate' => 'date',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

    // Relationships
    public function loan()
    {
        return $this->belongsTo(DisbursedLoan::class, 'iloanid', 'loanid');
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customerid');
    }

    public function loanType()
    {
        return $this->belongsTo(LoanType::class, 'ipid');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branchid');
    }

    public function company()
    {
        return $this->belongsTo(Company::class, 'companyid');
    }

    public function posterUser()
    {
        return $this->belongsTo(User::class, 'poster');
    }
}