<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VendorNote extends Model
{
    use HasFactory;

    // Note: Your table has 'note' column but your fillable should match
    protected $fillable = [
        'vendor_id',
        'user_id',
        'note', // This matches your database column
    ];

    /**
     * Get the vendor that owns the note
     */
    public function vendor()
    {
        return $this->belongsTo(Vendor::class);
    }

    /**
     * Get the user who created the note
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}