<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VendorStatement extends Model
{
    use HasFactory;

    protected $fillable = [
        'vendor_id',
        'statement_date',
        'period_start',
        'period_end',
        'opening_balance',
        'closing_balance',
        'total_charges',
        'total_payments',
        'file_path',
        'sent_via_email',
        'sent_at',
    ];

    protected $casts = [
        'statement_date' => 'date',
        'period_start' => 'date',
        'period_end' => 'date',
        'opening_balance' => 'decimal:2',
        'closing_balance' => 'decimal:2',
        'total_charges' => 'decimal:2',
        'total_payments' => 'decimal:2',
        'sent_via_email' => 'boolean',
        'sent_at' => 'datetime',
    ];

    /**
     * Get the vendor that owns the statement
     */
    public function vendor()
    {
        return $this->belongsTo(Vendor::class);
    }
}