<?php

namespace App\Services;

use App\Models\ChartOfAccount;
use App\Models\GeneralLedgerEntry;

class GeneralLedgerService
{
    public static function postOpeningBalance(ChartOfAccount $account, $amount, $description = null)
    {
        if ($amount != 0) {
            return GeneralLedgerEntry::createOpeningBalanceEntry($account, $amount, $description);
        }
        
        return null;
    }

    public static function getAccountBalance($accountId, $asOfDate = null)
    {
        return GeneralLedgerEntry::calculateAccountBalance($accountId, $asOfDate);
    }

    public static function createJournalEntry($entries, $description, $referenceDocument = null, $documentNo = null)
    {
        // Ensure debits equal credits
        $totalDebits = collect($entries)->where('entrytype', 'debit')->sum('amount');
        $totalCredits = collect($entries)->where('entrytype', 'credit')->sum('amount');
        
        if ($totalDebits != $totalCredits) {
            throw new \Exception('Debits and credits must be equal');
        }

        $createdEntries = [];
        foreach ($entries as $entry) {
            $createdEntries[] = GeneralLedgerEntry::create([
                'entrydate' => now(),
                'description' => $description,
                'accountid' => $entry['accountid'],
                'referencedocument' => $referenceDocument,
                'documentno' => $documentNo,
                'entrytype' => $entry['entrytype'],
                'amount' => $entry['amount'],
                'createdby' => auth()->id() ?? 1,
                'companyid' => $entry['companyid'] ?? 1,
                'branchid' => $entry['branchid'] ?? 1,
            ]);
        }

        return $createdEntries;
    }

    // Helper to determine entry type for any transaction
    public static function determineEntryTypeForAccount($accountId, $amount)
    {
        $account = ChartOfAccount::with('accountType')->find($accountId);
        $normalBalance = $account->accountType->normal_balance ?? 'debit';
        
        return GeneralLedgerEntry::determineEntryType($normalBalance, $amount);
    }
}