@php
    // Define variables for header partial and view
    $pageTitle = 'Edit Application Requirement';
    $pageSubtitle = 'Updating: ' . ($requirement->documentname ?? 'N/A'); 
    
    // Helper to format the dates (Using accessors from ApplicationRequirement model)
    $createdAt = $requirement->createdat_formatted ?? (optional($requirement->createdat)->format('M d, Y H:i') ?? 'N/A');
    $updatedAt = $requirement->updatedat_formatted ?? (optional($requirement->updatedat)->format('M d, Y H:i') ?? 'N/A');

    // Assuming the controller passes the requirement object.
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $pageTitle }} | {{ config('app.name', 'IMMIA FINANCE') }}</title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <script>
        // Custom Tailwind Configuration (from your provided source)
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#146CAA',
                        primaryLight: '#E1F0FA',
                        secondary: '#6b7280',
                        success: '#107C10',
                        warning: '#F68C1E',
                        danger: '#D83B01',
                        info: '#0078D4',
                        gray50: '#FAF9F8',
                        gray100: '#F3F2F1',
                        gray200: '#EDEBE9',
                        gray300: '#E1DFDD',
                        gray400: '#C8C6C4',
                        gray500: '#A19F9D',
                        gray600: '#605E5C',
                        gray700: '#323130',
                        gray800: '#201F1E',
                        gray900: '#000000'
                    }
                }
            }
        }
    </script>
    <style>
        /* CSS from your provided source for QuickBooks/ZedBankOS look */
        .quickbooks-input {
            border: 1px solid #E1DFDD;
            border-radius: 4px;
            padding: 8px 12px;
            font-size: 14px;
            transition: border-color 0.2s;
            width: 100%;
        }
        .quickbooks-input:focus {
            outline: none;
            border-color: #146CAA;
            box-shadow: 0 0 0 2px rgba(20, 108, 170, 0.1);
        }
        .lg\:ml-64 { margin-left: 16rem; }
        @media (max-width: 1024px) { .lg\:ml-64 { margin-left: 0 !important; } }
    </style>
</head>
<body class="bg-gray50">
    {{-- Assuming this sidebar is correctly included and styled --}}
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        
        {{-- Dedicated Header Partial --}}
        @include('accounting.partials.header', [
            'title' => $pageTitle,
            'subtitle' => $pageSubtitle
        ])

        <main class="p-6">
            
            @if(session('success'))
                <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-check-circle text-green-500 mr-2"></i>
                        <span class="text-green-800 font-medium">{{ session('success') }}</span>
                    </div>
                </div>
            @endif

            @if(session('error'))
                <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-exclamation-circle text-red-500 mr-2"></i>
                        <span class="text-red-800 font-medium">{{ session('error') }}</span>
                    </div>
                </div>
            @endif
            
            @if ($errors->any())
                <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4">
                    <h4 class="text-red-800 font-medium mb-2">Please correct the following errors:</h4>
                    <ul class="list-disc ml-5 text-sm text-red-700">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="max-w-3xl mx-auto bg-white rounded-lg shadow-lg border border-gray200">
                <div class="p-6 border-b border-gray200 flex justify-between items-center">
                    <h2 class="text-xl font-semibold text-gray900">
                        Editing Requirement: {{ $requirement->documentname }}
                    </h2>
                    <span class="text-xs font-medium px-3 py-1 rounded-full 
                        {{ $requirement->status == 'active' ? 'bg-green-100 text-success' : 'bg-red-100 text-danger' }}">
                        {{ ucfirst($requirement->status) }}
                    </span>
                </div>
                
                <form method="POST" action="{{ route('admin.accounting.application-requirements.update', $requirement->id) }}" class="p-6">
                    @csrf
                    @method('PUT')
                    
                    <div class="space-y-6">
                        
                        {{-- Document Name --}}
                        <div>
                            <label for="documentname" class="block text-sm font-medium text-gray700 mb-1">Document Name <span class="text-danger">*</span></label>
                            <input type="text" 
                                   name="documentname" 
                                   id="documentname" 
                                   class="quickbooks-input" 
                                   value="{{ old('documentname', $requirement->documentname) }}" 
                                   required>
                        </div>

                        {{-- Description (Note: Your database schema/model did not explicitly show 'description', but we include it based on common practice) --}}
                        <div>
                            <label for="description" class="block text-sm font-medium text-gray700 mb-1">Description</label>
                            <textarea name="description" 
                                      id="description" 
                                      rows="4"
                                      class="quickbooks-input resize-none">{{ old('description', $requirement->description ?? '') }}</textarea>
                        </div>
                        
                        {{-- Status (Note: Your controller update method does not currently save status, only documentname. The form includes it for completeness.) --}}
                        <div>
                            <label for="status" class="block text-sm font-medium text-gray700 mb-1">Status <span class="text-danger">*</span></label>
                            <select name="status" id="status" class="quickbooks-input" required>
                                <option value="active" {{ old('status', $requirement->status) == 'active' ? 'selected' : '' }}>Active</option>
                                <option value="inactive" {{ old('status', $requirement->status) == 'inactive' ? 'selected' : '' }}>Inactive</option>
                            </select>
                            <p class="text-xs text-gray500 mt-1">
                                Changing status to Inactive will prevent this requirement from being used in new applications.
                            </p>
                        </div>
                        
                        {{-- Read-only Metadata --}}
                        <div class="grid grid-cols-2 gap-4 border-t border-gray200 pt-6">
                            <div>
                                <p class="text-xs text-gray500">Created By:</p>
                                <p class="text-sm font-medium text-gray700">{{ $requirement->createdby }}</p>
                            </div>
                            <div>
                                <p class="text-xs text-gray500">Created At:</p>
                                <p class="text-sm font-medium text-gray700">{{ $createdAt }}</p>
                            </div>
                            <div>
                                <p class="text-xs text-gray500">Last Updated At:</p>
                                <p class="text-sm font-medium text-gray700">{{ $updatedAt }}</p>
                            </div>
                        </div>

                    </div>
                    
                    <div class="flex justify-between items-center pt-6 mt-6 border-t border-gray200">
                        <a href="{{ route('admin.accounting.application-requirements.index') }}" 
                           class="px-4 py-2 bg-gray100 text-gray700 rounded-lg text-sm font-medium hover:bg-gray200">
                            <i class="fas fa-arrow-left mr-2"></i>
                            Back to Requirements
                        </a>
                        
                        <button type="submit" 
                                class="px-6 py-2 bg-primary text-white rounded-lg text-sm font-medium hover:bg-primary/90 transition shadow-md">
                            <i class="fas fa-save mr-2"></i>
                            Update Requirement
                        </button>
                    </div>
                </form>
            </div>
            
        </main>
    </div>

    {{-- Script placeholder for potential global scripts/modals --}}
    <script>
        // No specific JavaScript needed for this basic form view
    </script>
</body>
</html>