<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Cash/Bank Account | IMMIA FINANCE</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        @include('accounting.partials.header', ['title' => 'Edit Cash/Bank Account', 'subtitle' => 'Update account details'])

        <main class="p-6">
            <!-- Success/Error Messages -->
            @if($errors->any())
                <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-exclamation-circle text-red-500 mr-2"></i>
                        <div>
                            <span class="text-red-800 font-semibold">Please fix the following errors:</span>
                            <ul class="text-red-700 text-sm mt-1 list-disc list-inside">
                                @foreach($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
            @endif

            <div class="max-w-4xl mx-auto">
                <div class="bg-white rounded-xl shadow-sm border">
                    <div class="p-6 border-b border-gray-200">
                        <h2 class="text-lg font-semibold text-gray-900">Edit Account Information</h2>
                        <p class="text-gray-600 text-sm mt-1">Update the details for {{ $account->accountName }}</p>
                    </div>
                    
                    <div class="p-6">
                        <form method="POST" action="{{ route('admin.accounting.cash-banking.accounts.update', $account->cashBankId) }}">
                            @csrf
                            @method('PUT')

                            <!-- General Details Section -->
                            <div class="mb-8">
                                <h3 class="text-md font-semibold text-gray-900 mb-4 flex items-center">
                                    <i class="fas fa-info-circle text-blue-500 mr-2"></i>
                                    General Details
                                </h3>
                                
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div>
                                        <label for="accountType" class="block text-sm font-medium text-gray-700 mb-2">Account Type *</label>
                                        <select class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('accountType') border-red-500 @enderror" 
                                                id="accountType" name="accountType" required>
                                            <option value="">Select Account Type</option>
                                            <option value="Cash" {{ old('accountType', $account->accountType) == 'Cash' ? 'selected' : '' }}>Cash</option>
                                            <option value="Mobile Money" {{ old('accountType', $account->accountType) == 'Mobile Money' ? 'selected' : '' }}>Mobile Money</option>
                                            <option value="Bank" {{ old('accountType', $account->accountType) == 'Bank' ? 'selected' : '' }}>Bank</option>
                                        </select>
                                        @error('accountType')
                                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                        @enderror
                                    </div>
                                    
                                    <div>
                                        <label for="accountName" class="block text-sm font-medium text-gray-700 mb-2">Account Name *</label>
                                        <input type="text" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('accountName') border-red-500 @enderror" 
                                               id="accountName" name="accountName" value="{{ old('accountName', $account->accountName) }}" 
                                               placeholder="Enter account name" required>
                                        @error('accountName')
                                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                        @enderror
                                    </div>
                                    
                                    <div>
                                        <label for="currency" class="block text-sm font-medium text-gray-700 mb-2">Currency *</label>
                                        <select class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('currency') border-red-500 @enderror" 
                                                id="currency" name="currency" required>
                                            <option value="">Select Currency</option>
                                            @foreach($currencies as $currency)
                                                <option value="{{ $currency->code }}" {{ old('currency', $account->currency) == $currency->code ? 'selected' : '' }}>
                                                    {{ $currency->code }} - {{ $currency->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('currency')
                                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    <div>
                                        <label for="glAccountId" class="block text-sm font-medium text-gray-700 mb-2">GL Account</label>
                                        <select class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('glAccountId') border-red-500 @enderror" 
                                                id="glAccountId" name="glAccountId">
                                            <option value="">Select GL Account</option>
                                            @foreach($glAccounts as $glAccount)
                                                <option value="{{ $glAccount->id }}" {{ old('glAccountId', $account->glAccountId) == $glAccount->id ? 'selected' : '' }}>
                                                    {{ $glAccount->code }} - {{ $glAccount->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('glAccountId')
                                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                        @enderror
                                        @if($account->glAccount)
                                            <p class="text-sm text-green-600 mt-1">
                                                <i class="fas fa-check-circle mr-1"></i>
                                                Currently linked to: {{ $account->glAccount->code }} - {{ $account->glAccount->name }}
                                            </p>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <!-- Bank Account Information -->
                            <div class="mb-8 bank-info-section" style="display: {{ $account->accountType == 'Bank' ? 'block' : 'none' }};">
                                <h3 class="text-md font-semibold text-gray-900 mb-4 flex items-center">
                                    <i class="fas fa-landmark text-blue-500 mr-2"></i>
                                    Bank Account Information
                                </h3>
                                
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div>
                                        <label for="bankAccountName" class="block text-sm font-medium text-gray-700 mb-2">Bank Account Name</label>
                                        <input type="text" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('bankAccountName') border-red-500 @enderror" 
                                               id="bankAccountName" name="bankAccountName" value="{{ old('bankAccountName', $account->bankAccountName) }}">
                                        @error('bankAccountName')
                                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                        @enderror
                                    </div>
                                    
                                    <div>
                                        <label for="accountNumber" class="block text-sm font-medium text-gray-700 mb-2">Account Number</label>
                                        <input type="text" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('accountNumber') border-red-500 @enderror" 
                                               id="accountNumber" name="accountNumber" value="{{ old('accountNumber', $account->accountNumber) }}">
                                        @error('accountNumber')
                                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                        @enderror
                                    </div>
                                    
                                    <div>
                                        <label for="branchName" class="block text-sm font-medium text-gray-700 mb-2">Branch Name</label>
                                        <input type="text" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('branchName') border-red-500 @enderror" 
                                               id="branchName" name="branchName" value="{{ old('branchName', $account->branchName) }}">
                                        @error('branchName')
                                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    <div>
                                        <label for="bankName" class="block text-sm font-medium text-gray-700 mb-2">Bank Name</label>
                                        <input type="text" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('bankName') border-red-500 @enderror" 
                                               id="bankName" name="bankName" value="{{ old('bankName', $account->bankName) }}">
                                        @error('bankName')
                                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <!-- Options -->
                            <div class="mb-8">
                                <h3 class="text-md font-semibold text-gray-900 mb-4 flex items-center">
                                    <i class="fas fa-cog text-blue-500 mr-2"></i>
                                    Options
                                </h3>
                                
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div>
                                        <label for="openingBalance" class="block text-sm font-medium text-gray-700 mb-2">Opening Balance *</label>
                                        <input type="number" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('openingBalance') border-red-500 @enderror" 
                                               id="openingBalance" name="openingBalance" value="{{ old('openingBalance', $account->openingBalance) }}" 
                                               step="0.01" min="0" required>
                                        @error('openingBalance')
                                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                        @enderror
                                    </div>
                                    
                                    <div>
                                        <label for="openingBalanceDate" class="block text-sm font-medium text-gray-700 mb-2">Opening Balance as At *</label>
                                        <input type="date" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('openingBalanceDate') border-red-500 @enderror" 
                                               id="openingBalanceDate" name="openingBalanceDate" value="{{ old('openingBalanceDate', $account->openingBalanceDate) }}" required>
                                        @error('openingBalanceDate')
                                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>

                                <div class="mt-6 space-y-3">
                                    <div class="flex items-center">
                                        <input type="checkbox" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded" 
                                               id="isActive" name="isActive" value="1" {{ old('isActive', $account->isActive) ? 'checked' : '' }}>
                                        <label for="isActive" class="ml-2 block text-sm text-gray-700">Active Account</label>
                                    </div>

                                    <div class="flex items-center">
                                        <input type="checkbox" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded" 
                                               id="isDefault" name="isDefault" value="1" {{ old('isDefault', $account->isDefault) ? 'checked' : '' }}>
                                        <label for="isDefault" class="ml-2 block text-sm text-gray-700">Set as Default Account</label>
                                    </div>
                                </div>
                            </div>

                            <!-- Additional Fields -->
                            <div class="mb-8">
                                <h3 class="text-md font-semibold text-gray-900 mb-4 flex items-center">
                                    <i class="fas fa-list text-blue-500 mr-2"></i>
                                    Additional Information
                                </h3>
                                
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div>
                                        <label for="category" class="block text-sm font-medium text-gray-700 mb-2">Category</label>
                                        <input type="text" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                                               id="category" name="category" value="{{ old('category', $account->category) }}" 
                                               placeholder="e.g., Operating, Savings, Petty Cash">
                                    </div>
                                    
                                    <div>
                                        <label for="defaultPaymentMethod" class="block text-sm font-medium text-gray-700 mb-2">Default Payment Method</label>
                                        <select class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                                                id="defaultPaymentMethod" name="defaultPaymentMethod">
                                            <option value="">Select Payment Method</option>
                                            <option value="Cash" {{ old('defaultPaymentMethod', $account->defaultPaymentMethod) == 'Cash' ? 'selected' : '' }}>Cash</option>
                                            <option value="Cheque" {{ old('defaultPaymentMethod', $account->defaultPaymentMethod) == 'Cheque' ? 'selected' : '' }}>Cheque</option>
                                            <option value="Transfer" {{ old('defaultPaymentMethod', $account->defaultPaymentMethod) == 'Transfer' ? 'selected' : '' }}>Bank Transfer</option>
                                            <option value="Mobile Money" {{ old('defaultPaymentMethod', $account->defaultPaymentMethod) == 'Mobile Money' ? 'selected' : '' }}>Mobile Money</option>
                                            <option value="Card" {{ old('defaultPaymentMethod', $account->defaultPaymentMethod) == 'Card' ? 'selected' : '' }}>Card</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <!-- Description -->
                            <div class="mb-8">
                                <label for="description" class="block text-sm font-medium text-gray-700 mb-2">Description</label>
                                <textarea class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('description') border-red-500 @enderror" 
                                          id="description" name="description" rows="3" placeholder="Optional description of the account">{{ old('description', $account->description) }}</textarea>
                                @error('description')
                                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                @enderror
                            </div>
                            
                            <!-- Buttons -->
                            <div class="flex justify-end space-x-3 pt-6 border-t border-gray-200">
                                <a href="{{ route('admin.accounting.cash-banking.accounts.index') }}" 
                                   class="px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50 transition duration-150 font-medium">
                                    Cancel
                                </a>
                                <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition duration-150 font-medium flex items-center">
                                    <i class="fas fa-save mr-2"></i>
                                    Update Account
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <script>
        // Mobile menu functionality
        const mobileMenuButton = document.getElementById('mobile-menu-button');
        const sidebar = document.getElementById('sidebar');
        
        if (mobileMenuButton && sidebar) {
            mobileMenuButton.addEventListener('click', function() {
                sidebar.classList.toggle('active');
            });
        }

        // Show/hide bank information based on account type
        function toggleBankInfo() {
            const accountType = document.getElementById('accountType').value;
            const bankInfoSection = document.querySelector('.bank-info-section');
            const bankFields = document.querySelectorAll('.bank-info-section input, .bank-info-section select');
            
            if (accountType === 'Bank') {
                bankInfoSection.style.display = 'block';
                bankFields.forEach(field => field.required = true);
            } else {
                bankInfoSection.style.display = 'none';
                bankFields.forEach(field => field.required = false);
            }
        }

        document.getElementById('accountType').addEventListener('change', toggleBankInfo);
    </script>
</body>
</html>