<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Account Details | IMMIA FINANCE</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        @include('accounting.partials.header', ['title' => 'Account Details', 'subtitle' => 'View account information and transactions'])

        <main class="p-6">
            <!-- Success/Error Messages -->
            @if(session('success'))
                <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-check-circle text-green-500 mr-2"></i>
                        <span class="text-green-800 font-semibold">{{ session('success') }}</span>
                    </div>
                </div>
            @endif

            @if(session('error'))
                <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-exclamation-circle text-red-500 mr-2"></i>
                        <span class="text-red-800 font-semibold">{{ session('error') }}</span>
                    </div>
                </div>
            @endif

            <div class="max-w-6xl mx-auto">
                <!-- Action Bar -->
                <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6 space-y-3 sm:space-y-0">
                    <div>
                        <div class="flex items-center">
                            <a href="{{ route('admin.accounting.cash-banking.accounts.index') }}" 
                               class="text-blue-600 hover:text-blue-700 mr-4">
                                <i class="fas fa-arrow-left"></i>
                            </a>
                            <h2 class="text-2xl font-bold text-gray-900">{{ $account->accountName }}</h2>
                            @if($account->isDefault)
                                <span class="ml-3 inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                    <i class="fas fa-star mr-1"></i> Default
                                </span>
                            @endif
                        </div>
                        <p class="text-gray-600 mt-1">{{ $account->accountType }} Account</p>
                    </div>
                    
                    <div class="flex items-center space-x-2">
                        @can('cash-banking.accounts.edit')
                        <a href="{{ route('admin.accounting.cash-banking.accounts.edit', $account->cashBankId) }}" 
                           class="px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-lg font-medium flex items-center transition duration-150">
                            <i class="fas fa-edit mr-2"></i>
                            Edit Account
                        </a>
                        @endcan
                        
                        @can('cash-banking.accounts.delete')
                        <form action="{{ route('admin.accounting.cash-banking.accounts.destroy', $account->cashBankId) }}" 
                              method="POST" 
                              onsubmit="return confirm('Are you sure you want to delete this account? This action cannot be undone.')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" 
                                    class="px-4 py-2 bg-red-600 hover:bg-red-700 text-white rounded-lg font-medium flex items-center transition duration-150">
                                <i class="fas fa-trash mr-2"></i>
                                Delete Account
                            </button>
                        </form>
                        @endcan
                    </div>
                </div>

                <!-- Account Details Cards -->
                <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-8">
                    <!-- Account Summary Card -->
                    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                        <div class="flex items-center justify-between mb-4">
                            <h3 class="text-lg font-semibold text-gray-900">Account Summary</h3>
                            <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center">
                                <i class="fas fa-wallet text-blue-600 text-xl"></i>
                            </div>
                        </div>
                        
                        <div class="space-y-4">
                            <div class="flex justify-between items-center pb-3 border-b border-gray-100">
                                <span class="text-sm text-gray-600">Account Type:</span>
                                <span class="text-sm font-medium text-gray-900">{{ $account->accountType }}</span>
                            </div>
                            
                            <div class="flex justify-between items-center pb-3 border-b border-gray-100">
                                <span class="text-sm text-gray-600">Currency:</span>
                                <span class="text-sm font-medium text-gray-900">{{ $account->currency }}</span>
                            </div>
                            
                            <div class="flex justify-between items-center pb-3 border-b border-gray-100">
                                <span class="text-sm text-gray-600">Account Number:</span>
                                <span class="text-sm font-medium text-gray-900">
                                    {{ $account->accountNumber ?? 'N/A' }}
                                </span>
                            </div>
                            
                            <div class="flex justify-between items-center pb-3 border-b border-gray-100">
                                <span class="text-sm text-gray-600">Status:</span>
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $account->isActive ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                    {{ $account->isActive ? 'Active' : 'Inactive' }}
                                </span>
                            </div>
                            
                            <div class="flex justify-between items-center">
                                <span class="text-sm text-gray-600">Created On:</span>
                                <span class="text-sm font-medium text-gray-900">
                                    {{ \Carbon\Carbon::parse($account->created_at)->format('M d, Y') }}
                                </span>
                            </div>
                        </div>
                    </div>

                    <!-- Balance Card -->
                    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                        <div class="flex items-center justify-between mb-4">
                            <h3 class="text-lg font-semibold text-gray-900">Balance Information</h3>
                            <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center">
                                <i class="fas fa-chart-line text-green-600 text-xl"></i>
                            </div>
                        </div>
                        
                        <div class="space-y-4">
                            <div class="flex justify-between items-center pb-3 border-b border-gray-100">
                                <span class="text-sm text-gray-600">Opening Balance:</span>
                                <span class="text-sm font-medium text-gray-900">
                                    {{ number_format($account->openingBalance, 2) }} {{ $account->currency }}
                                </span>
                            </div>
                            
                            <div class="flex justify-between items-center pb-3 border-b border-gray-100">
                                <span class="text-sm text-gray-600">Current Balance:</span>
                                <span class="text-lg font-bold text-blue-600">
                                    {{ number_format($account->current_balance, 2) }} {{ $account->currency }}
                                </span>
                            </div>
                            
                            <div class="flex justify-between items-center">
                                <span class="text-sm text-gray-600">Opening Date:</span>
                                <span class="text-sm font-medium text-gray-900">
                                    {{ \Carbon\Carbon::parse($account->openingBalanceDate)->format('M d, Y') }}
                                </span>
                            </div>
                        </div>
                        
                        @if($account->current_balance > 0)
                        <div class="mt-6 p-3 bg-blue-50 rounded-lg border border-blue-200">
                            <div class="flex items-center">
                                <i class="fas fa-info-circle text-blue-500 mr-2"></i>
                                <span class="text-sm text-blue-700">
                                    Account has available funds
                                </span>
                            </div>
                        </div>
                        @endif
                    </div>

                    <!-- Bank Information Card (Only for Bank accounts) -->
                    @if($account->accountType == 'Bank')
                    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                        <div class="flex items-center justify-between mb-4">
                            <h3 class="text-lg font-semibold text-gray-900">Bank Details</h3>
                            <div class="w-12 h-12 bg-amber-100 rounded-lg flex items-center justify-center">
                                <i class="fas fa-landmark text-amber-600 text-xl"></i>
                            </div>
                        </div>
                        
                        <div class="space-y-4">
                            @if($account->bankName)
                            <div class="flex justify-between items-center pb-3 border-b border-gray-100">
                                <span class="text-sm text-gray-600">Bank Name:</span>
                                <span class="text-sm font-medium text-gray-900">{{ $account->bankName }}</span>
                            </div>
                            @endif
                            
                            @if($account->accountNumber)
                            <div class="flex justify-between items-center pb-3 border-b border-gray-100">
                                <span class="text-sm text-gray-600">Account Number:</span>
                                <span class="text-sm font-medium text-gray-900">{{ $account->accountNumber }}</span>
                            </div>
                            @endif
                            
                            @if($account->bankAccountName)
                            <div class="flex justify-between items-center pb-3 border-b border-gray-100">
                                <span class="text-sm text-gray-600">Account Holder:</span>
                                <span class="text-sm font-medium text-gray-900">{{ $account->bankAccountName }}</span>
                            </div>
                            @endif
                            
                            @if($account->branchName)
                            <div class="flex justify-between items-center">
                                <span class="text-sm text-gray-600">Branch:</span>
                                <span class="text-sm font-medium text-gray-900">{{ $account->branchName }}</span>
                            </div>
                            @endif
                        </div>
                    </div>
                    @endif
                </div>

                <!-- Additional Information Section -->
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-8">
                    <!-- GL Account Information -->
                    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                        <div class="flex items-center justify-between mb-4">
                            <h3 class="text-lg font-semibold text-gray-900">General Ledger Integration</h3>
                            <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center">
                                <i class="fas fa-book text-purple-600"></i>
                            </div>
                        </div>
                        
                        @if($account->glAccount)
                        <div class="space-y-3">
                            <div class="flex justify-between items-center">
                                <span class="text-sm text-gray-600">GL Account:</span>
                                <span class="text-sm font-medium text-gray-900">
                                    {{ $account->glAccount->code }} - {{ $account->glAccount->name }}
                                </span>
                            </div>
                            
                            <div class="flex justify-between items-center">
                                <span class="text-sm text-gray-600">GL Account Balance:</span>
                                <span class="text-sm font-medium text-gray-900">
                                    {{ number_format($account->glAccount->current_balance, 2) }}
                                </span>
                            </div>
                            
                            <div class="flex justify-between items-center">
                                <span class="text-sm text-gray-600">Status:</span>
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $account->glAccount->is_active ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                    {{ $account->glAccount->is_active ? 'Active' : 'Inactive' }}
                                </span>
                            </div>
                            
                            <a href="{{ route('admin.accounting.chart-of-accounts.show', $account->glAccount->id) }}" 
                               class="mt-3 inline-flex items-center text-blue-600 hover:text-blue-700 text-sm font-medium">
                                <i class="fas fa-external-link-alt mr-1"></i>
                                View GL Account Details
                            </a>
                        </div>
                        @else
                        <div class="text-center py-4">
                            <div class="w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-3">
                                <i class="fas fa-unlink text-gray-400 text-xl"></i>
                            </div>
                            <p class="text-gray-600 mb-3">No GL Account linked</p>
                            <a href="{{ route('admin.accounting.cash-banking.accounts.edit', $account->cashBankId) }}" 
                               class="inline-flex items-center text-blue-600 hover:text-blue-700 text-sm font-medium">
                                <i class="fas fa-link mr-1"></i>
                                Link to GL Account
                            </a>
                        </div>
                        @endif
                    </div>

                    <!-- Account Description -->
                    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                        <div class="flex items-center justify-between mb-4">
                            <h3 class="text-lg font-semibold text-gray-900">Description & Notes</h3>
                            <div class="w-10 h-10 bg-gray-100 rounded-lg flex items-center justify-center">
                                <i class="fas fa-sticky-note text-gray-600"></i>
                            </div>
                        </div>
                        
                        @if($account->description)
                        <div class="prose prose-sm max-w-none">
                            <p class="text-gray-700">{{ $account->description }}</p>
                        </div>
                        @else
                        <div class="text-center py-4">
                            <p class="text-gray-500">No description provided</p>
                        </div>
                        @endif
                        
                        @if($account->category || $account->defaultPaymentMethod)
                        <div class="mt-4 pt-4 border-t border-gray-100">
                            <div class="grid grid-cols-2 gap-4">
                                @if($account->category)
                                <div>
                                    <span class="text-xs text-gray-500">Category</span>
                                    <p class="text-sm font-medium">{{ $account->category }}</p>
                                </div>
                                @endif
                                
                                @if($account->defaultPaymentMethod)
                                <div>
                                    <span class="text-xs text-gray-500">Default Payment Method</span>
                                    <p class="text-sm font-medium">{{ $account->defaultPaymentMethod }}</p>
                                </div>
                                @endif
                            </div>
                        </div>
                        @endif
                    </div>
                </div>

                <!-- General Ledger Entries Section -->
                @if($account->glAccount && $account->glAccount->generalLedgerEntries->count() > 0)
                <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden mb-8">
                    <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 class="text-lg font-semibold text-gray-900">General Ledger Entries</h3>
                                <p class="text-gray-600 text-sm mt-1">Journal entries for this account</p>
                            </div>
                            <div class="text-sm text-gray-500">
                                {{ $account->glAccount->generalLedgerEntries->count() }} entries found
                            </div>
                        </div>
                    </div>
                    
                    <div class="p-6">
                        <div class="overflow-x-auto">
                            <table class="w-full text-sm">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Transaction ID</th>
                                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Type</th>
                                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Description</th>
                                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Debit</th>
                                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Credit</th>
                                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Balance</th>
                                    </tr>
                                </thead>
                                <tbody class="divide-y divide-gray-200">
                                    @php
                                        $runningBalance = 0;
                                    @endphp
                                    @foreach($account->glAccount->generalLedgerEntries->sortBy('entrydate') as $entry)
                                    @php
                                        $runningBalance += $entry->amount;
                                    @endphp
                                    <tr class="hover:bg-gray-50">
                                        <td class="px-4 py-3 whitespace-nowrap">
                                            {{ \Carbon\Carbon::parse($entry->entrydate)->format('M d, Y') }}
                                        </td>
                                        <td class="px-4 py-3">
                                            <span class="font-mono text-xs bg-gray-100 px-2 py-1 rounded">
                                                {{ $entry->transactionid }}
                                            </span>
                                        </td>
                                        <td class="px-4 py-3">
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium 
                                                {{ $entry->transtype == 'Opening Balance' ? 'bg-blue-100 text-blue-800' : 
                                                   ($entry->transtype == 'Opening Balance Adjustment' ? 'bg-amber-100 text-amber-800' :
                                                   ($entry->transtype == 'Opening Balance Reversal' ? 'bg-red-100 text-red-800' : 'bg-gray-100 text-gray-800')) }}">
                                                {{ $entry->transtype }}
                                            </span>
                                        </td>
                                        <td class="px-4 py-3">
                                            <div class="text-gray-700">{{ $entry->description }}</div>
                                            <div class="text-xs text-gray-500 mt-1">
                                                <i class="fas fa-user mr-1"></i>
                                                User ID: {{ $entry->createdby }}
                                            </div>
                                        </td>
                                        <td class="px-4 py-3">
                                            @if($entry->entrytype == 'debit')
                                            <span class="text-green-600 font-medium">
                                                {{ number_format($entry->amount, 2) }}
                                            </span>
                                            @else
                                            <span class="text-gray-400">-</span>
                                            @endif
                                        </td>
                                        <td class="px-4 py-3">
                                            @if($entry->entrytype == 'credit')
                                            <span class="text-red-600 font-medium">
                                                {{ number_format(abs($entry->amount), 2) }}
                                            </span>
                                            @else
                                            <span class="text-gray-400">-</span>
                                            @endif
                                        </td>
                                        <td class="px-4 py-3 font-medium {{ $runningBalance >= 0 ? 'text-blue-600' : 'text-red-600' }}">
                                            {{ number_format($runningBalance, 2) }}
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                                <tfoot class="bg-gray-50">
                                    <tr>
                                        <td colspan="6" class="px-4 py-3 text-right text-sm font-medium text-gray-700">
                                            Final Balance:
                                        </td>
                                        <td class="px-4 py-3 text-lg font-bold {{ $account->glAccount->current_balance >= 0 ? 'text-blue-600' : 'text-red-600' }}">
                                            {{ number_format($account->glAccount->current_balance, 2) }}
                                        </td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        
                        <!-- Opening Balance Summary -->
                        @php
                            $openingEntries = $account->glAccount->generalLedgerEntries
                                ->where('transtype', 'like', '%Opening Balance%')
                                ->sortBy('entrydate');
                            $totalOpening = $openingEntries->sum('amount');
                        @endphp
                        
                        @if($openingEntries->count() > 0)
                        <div class="mt-6 p-4 bg-blue-50 border border-blue-200 rounded-lg">
                            <h4 class="text-sm font-semibold text-blue-900 mb-2 flex items-center">
                                <i class="fas fa-info-circle mr-2"></i>
                                Opening Balance Summary
                            </h4>
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                <div class="text-center">
                                    <div class="text-xs text-gray-600">Total Opening Balance</div>
                                    <div class="text-lg font-bold {{ $totalOpening >= 0 ? 'text-green-600' : 'text-red-600' }}">
                                        {{ number_format($totalOpening, 2) }}
                                    </div>
                                </div>
                                <div class="text-center">
                                    <div class="text-xs text-gray-600">Total Entries</div>
                                    <div class="text-lg font-bold text-blue-600">
                                        {{ $openingEntries->count() }}
                                    </div>
                                </div>
                                <div class="text-center">
                                    <div class="text-xs text-gray-600">First Entry Date</div>
                                    <div class="text-sm font-medium text-gray-900">
                                        {{ $openingEntries->first() ? \Carbon\Carbon::parse($openingEntries->first()->entrydate)->format('M d, Y') : 'N/A' }}
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
                @elseif($account->glAccount)
                <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden mb-8">
                    <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                        <h3 class="text-lg font-semibold text-gray-900">General Ledger Entries</h3>
                        <p class="text-gray-600 text-sm mt-1">Journal entries for this account</p>
                    </div>
                    
                    <div class="p-6 text-center">
                        <div class="w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-3">
                            <i class="fas fa-book-open text-gray-400 text-xl"></i>
                        </div>
                        <p class="text-gray-600 mb-2">No journal entries found</p>
                        <p class="text-gray-500 text-sm">
                            This GL account hasn't been involved in any transactions yet.
                            Opening balance entries will appear here when posted.
                        </p>
                    </div>
                </div>
                @endif

                <!-- Transactions Section -->
                <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden mb-8">
                    <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 class="text-lg font-semibold text-gray-900">Cash/Bank Transactions</h3>
                                <p class="text-gray-600 text-sm mt-1">Transactions involving this account</p>
                            </div>
                            @php
                                $totalTransactions = $account->outgoingTransfers->count() + 
                                                   $account->incomingTransfers->count() + 
                                                   $account->pettyCashTransactions->count();
                            @endphp
                            <div class="text-sm text-gray-500">
                                {{ $totalTransactions }} transactions found
                            </div>
                        </div>
                    </div>
                    
                    <div class="p-6">
                        @if($totalTransactions > 0)
                        <div class="space-y-6">
                            <!-- Outgoing Transfers -->
                            @if($account->outgoingTransfers->count() > 0)
                            <div>
                                <h4 class="text-md font-medium text-gray-900 mb-3 flex items-center">
                                    <div class="w-8 h-8 bg-red-100 rounded-lg flex items-center justify-center mr-2">
                                        <i class="fas fa-arrow-up text-red-600"></i>
                                    </div>
                                    Outgoing Transfers ({{ $account->outgoingTransfers->count() }})
                                </h4>
                                <div class="overflow-x-auto">
                                    <table class="w-full text-sm">
                                        <thead class="bg-gray-50">
                                            <tr>
                                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">To Account</th>
                                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Reference</th>
                                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Amount</th>
                                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody class="divide-y divide-gray-200">
                                            @foreach($account->outgoingTransfers->take(5) as $transfer)
                                            <tr class="hover:bg-gray-50">
                                                <td class="px-4 py-3">{{ \Carbon\Carbon::parse($transfer->transactiondate)->format('M d, Y') }}</td>
                                                <td class="px-4 py-3">
                                                    <div class="font-medium">{{ $transfer->toAccount->accountName ?? 'N/A' }}</div>
                                                    <div class="text-xs text-gray-500">{{ $transfer->toAccount->accountType ?? '' }}</div>
                                                </td>
                                                <td class="px-4 py-3">
                                                    <span class="font-mono text-xs">{{ $transfer->reference ?? 'N/A' }}</span>
                                                </td>
                                                <td class="px-4 py-3">
                                                    <span class="text-red-600 font-medium">
                                                        -{{ number_format($transfer->amountsent, 2) }} {{ $transfer->currency }}
                                                    </span>
                                                </td>
                                                <td class="px-4 py-3">
                                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium 
                                                        {{ $transfer->transferstatus == 'Sent' ? 'bg-green-100 text-green-800' : 
                                                           ($transfer->transferstatus == 'Pending' ? 'bg-yellow-100 text-yellow-800' : 'bg-gray-100 text-gray-800') }}">
                                                        {{ $transfer->transferstatus }}
                                                    </span>
                                                </td>
                                                <td class="px-4 py-3">
                                                    <a href="{{ route('admin.accounting.cash-banking.internal-transfers.show', $transfer->id) }}" 
                                                       class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                                                        View
                                                    </a>
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                @if($account->outgoingTransfers->count() > 5)
                                <div class="mt-3 text-center">
                                    <a href="{{ route('admin.accounting.cash-banking.internal-transfers.index', ['account' => $account->cashBankId, 'type' => 'outgoing']) }}" 
                                       class="text-blue-600 hover:text-blue-700 text-sm font-medium">
                                        View all {{ $account->outgoingTransfers->count() }} outgoing transfers
                                    </a>
                                </div>
                                @endif
                            </div>
                            @endif

                            <!-- Incoming Transfers -->
                            @if($account->incomingTransfers->count() > 0)
                            <div>
                                <h4 class="text-md font-medium text-gray-900 mb-3 flex items-center">
                                    <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center mr-2">
                                        <i class="fas fa-arrow-down text-green-600"></i>
                                    </div>
                                    Incoming Transfers ({{ $account->incomingTransfers->count() }})
                                </h4>
                                <div class="overflow-x-auto">
                                    <table class="w-full text-sm">
                                        <thead class="bg-gray-50">
                                            <tr>
                                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">From Account</th>
                                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Reference</th>
                                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Amount</th>
                                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody class="divide-y divide-gray-200">
                                            @foreach($account->incomingTransfers->take(5) as $transfer)
                                            <tr class="hover:bg-gray-50">
                                                <td class="px-4 py-3">{{ \Carbon\Carbon::parse($transfer->transactiondate)->format('M d, Y') }}</td>
                                                <td class="px-4 py-3">
                                                    <div class="font-medium">{{ $transfer->fromAccount->accountName ?? 'N/A' }}</div>
                                                    <div class="text-xs text-gray-500">{{ $transfer->fromAccount->accountType ?? '' }}</div>
                                                </td>
                                                <td class="px-4 py-3">
                                                    <span class="font-mono text-xs">{{ $transfer->reference ?? 'N/A' }}</span>
                                                </td>
                                                <td class="px-4 py-3">
                                                    <span class="text-green-600 font-medium">
                                                        +{{ number_format($transfer->amountreceived, 2) }} {{ $transfer->currency }}
                                                    </span>
                                                </td>
                                                <td class="px-4 py-3">
                                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium 
                                                        {{ $transfer->transferstatus == 'Sent' ? 'bg-green-100 text-green-800' : 
                                                           ($transfer->transferstatus == 'Pending' ? 'bg-yellow-100 text-yellow-800' : 'bg-gray-100 text-gray-800') }}">
                                                        {{ $transfer->transferstatus }}
                                                    </span>
                                                </td>
                                                <td class="px-4 py-3">
                                                    <a href="{{ route('admin.accounting.cash-banking.internal-transfers.show', $transfer->id) }}" 
                                                       class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                                                        View
                                                    </a>
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                @if($account->incomingTransfers->count() > 5)
                                <div class="mt-3 text-center">
                                    <a href="{{ route('admin.accounting.cash-banking.internal-transfers.index', ['account' => $account->cashBankId, 'type' => 'incoming']) }}" 
                                       class="text-blue-600 hover:text-blue-700 text-sm font-medium">
                                        View all {{ $account->incomingTransfers->count() }} incoming transfers
                                    </a>
                                </div>
                                @endif
                            </div>
                            @endif

                            <!-- Petty Cash Transactions -->
                            @if($account->pettyCashTransactions->count() > 0)
                            <div>
                                <h4 class="text-md font-medium text-gray-900 mb-3 flex items-center">
                                    <div class="w-8 h-8 bg-blue-100 rounded-lg flex items-center justify-center mr-2">
                                        <i class="fas fa-receipt text-blue-600"></i>
                                    </div>
                                    Petty Cash Transactions ({{ $account->pettyCashTransactions->count() }})
                                </h4>
                                <div class="overflow-x-auto">
                                    <table class="w-full text-sm">
                                        <thead class="bg-gray-50">
                                            <tr>
                                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Description</th>
                                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Category</th>
                                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Amount</th>
                                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Type</th>
                                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody class="divide-y divide-gray-200">
                                            @foreach($account->pettyCashTransactions->take(5) as $transaction)
                                            <tr class="hover:bg-gray-50">
                                                <td class="px-4 py-3">{{ \Carbon\Carbon::parse($transaction->transactiondate)->format('M d, Y') }}</td>
                                                <td class="px-4 py-3">
                                                    <div class="font-medium">{{ $transaction->description }}</div>
                                                    <div class="text-xs text-gray-500">{{ $transaction->referenceno ?? 'No reference' }}</div>
                                                </td>
                                                <td class="px-4 py-3">{{ $transaction->category ?? 'N/A' }}</td>
                                                <td class="px-4 py-3 font-medium {{ $transaction->transactiontype == 'Expense' ? 'text-red-600' : 'text-green-600' }}">
                                                    {{ $transaction->transactiontype == 'Expense' ? '-' : '+' }}{{ number_format($transaction->amount, 2) }} {{ $transaction->currency }}
                                                </td>
                                                <td class="px-4 py-3">
                                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium 
                                                        {{ $transaction->transactiontype == 'Expense' ? 'bg-red-100 text-red-800' : 'bg-green-100 text-green-800' }}">
                                                        {{ $transaction->transactiontype }}
                                                    </span>
                                                </td>
                                                <td class="px-4 py-3">
                                                    <a href="{{ route('admin.accounting.cash-banking.petty-cash.show', $transaction->id) }}" 
                                                       class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                                                        View
                                                    </a>
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                @if($account->pettyCashTransactions->count() > 5)
                                <div class="mt-3 text-center">
                                    <a href="{{ route('admin.accounting.cash-banking.petty-cash.index', ['account' => $account->cashBankId]) }}" 
                                       class="text-blue-600 hover:text-blue-700 text-sm font-medium">
                                        View all {{ $account->pettyCashTransactions->count() }} petty cash transactions
                                    </a>
                                </div>
                                @endif
                            </div>
                            @endif
                            
                            <!-- Cash Book Transactions -->
<div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden mb-8">
    <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
        <div class="flex items-center justify-between">
            <div>
                <h3 class="text-lg font-semibold text-gray-900">Cash Book Transactions</h3>
                <p class="text-gray-600 text-sm mt-1">All transactions for this account</p>
            </div>
            <div class="text-sm text-gray-500">
                @php
                    $cashbookCount = \App\Models\CashBook::where('account_id', $account->cashBankId)->count();
                @endphp
                {{ $cashbookCount }} transactions found
            </div>
        </div>
    </div>
    
    <div class="p-6">
        @php
            $cashbookEntries = \App\Models\CashBook::where('account_id', $account->cashBankId)
                ->orderBy('transaction_date', 'desc')
                ->orderBy('created_at', 'desc')
                ->get();
        @endphp
        
        @if($cashbookEntries->count() > 0)
        <div class="overflow-x-auto">
            <table class="w-full text-sm">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Type</th>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Reference</th>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Description</th>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Debit</th>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Credit</th>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Balance</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200">
                    @foreach($cashbookEntries as $entry)
                    <tr class="hover:bg-gray-50">
                        <td class="px-4 py-3 whitespace-nowrap">
                            {{ \Carbon\Carbon::parse($entry->transaction_date)->format('M d, Y') }}
                        </td>
                        <td class="px-4 py-3">
                            {!! $entry->transaction_type_badge !!}
                        </td>
                        <td class="px-4 py-3">
                            <span class="font-mono text-xs">{{ $entry->reference_number ?? 'N/A' }}</span>
                        </td>
                        <td class="px-4 py-3">
                            <div class="text-gray-700">{{ $entry->description }}</div>
                            @if($entry->status === 'Reversed')
                            <div class="text-xs text-red-600 mt-1">
                                <i class="fas fa-undo mr-1"></i> Reversed
                            </div>
                            @endif
                        </td>
                        <td class="px-4 py-3">
                            @if($entry->amount > 0)
                            <span class="text-green-600 font-medium">
                                {{ number_format($entry->amount, 2) }}
                            </span>
                            @else
                            <span class="text-gray-400">-</span>
                            @endif
                        </td>
                        <td class="px-4 py-3">
                            @if($entry->amount < 0)
                            <span class="text-red-600 font-medium">
                                {{ number_format(abs($entry->amount), 2) }}
                            </span>
                            @else
                            <span class="text-gray-400">-</span>
                            @endif
                        </td>
                        <td class="px-4 py-3 font-medium {{ $entry->balance_after >= 0 ? 'text-blue-600' : 'text-red-600' }}">
                            {{ number_format($entry->balance_after, 2) }}
                        </td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot class="bg-gray-50">
                    <tr>
                        <td colspan="6" class="px-4 py-3 text-right text-sm font-medium text-gray-700">
                            Current Balance:
                        </td>
                        <td class="px-4 py-3 text-lg font-bold {{ $account->current_balance >= 0 ? 'text-blue-600' : 'text-red-600' }}">
                            {{ number_format($account->current_balance, 2) }} {{ $account->currency }}
                        </td>
                    </tr>
                </tfoot>
            </table>
        </div>
        @else
        <div class="text-center py-8">
            <div class="w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-3">
                <i class="fas fa-book text-gray-400 text-xl"></i>
            </div>
            <p class="text-gray-600 mb-2">No cash book transactions found</p>
            <p class="text-gray-500 text-sm">
                Transactions will appear here when recorded.
            </p>
        </div>
        @endif
    </div>
</div>
                            
                            
                            
                        </div>
                        @else
                        <div class="text-center py-8">
                            <div class="w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-3">
                                <i class="fas fa-exchange-alt text-gray-400 text-xl"></i>
                            </div>
                            <p class="text-gray-600 mb-2">No transactions found for this account</p>
                            <p class="text-gray-500 text-sm">This account hasn't been involved in any transactions yet.</p>
                            <div class="mt-4 space-x-3">
                                <a href="{{ route('admin.accounting.cash-banking.internal-transfers.create', ['from' => $account->cashBankId]) }}" 
                                   class="inline-flex items-center px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition duration-150 text-sm font-medium">
                                    <i class="fas fa-exchange-alt mr-2"></i>
                                    Make Transfer
                                </a>
                                <a href="{{ route('admin.accounting.cash-banking.petty-cash.create', ['account' => $account->cashBankId]) }}" 
                                   class="inline-flex items-center px-4 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700 transition duration-150 text-sm font-medium">
                                    <i class="fas fa-receipt mr-2"></i>
                                    Add Petty Cash
                                </a>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>

                <!-- Danger Zone (Delete Account) -->
                @can('cash-banking.accounts.delete')
                <div class="bg-white rounded-xl shadow-sm border border-red-200 overflow-hidden">
                    <div class="px-6 py-4 border-b border-red-200 bg-red-50">
                        <h3 class="text-lg font-semibold text-red-900">Danger Zone</h3>
                        <p class="text-red-700 text-sm mt-1">Irreversible actions</p>
                    </div>
                    
                    <div class="p-6">
                        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center">
                            <div class="mb-4 sm:mb-0">
                                <h4 class="font-medium text-gray-900">Delete Account</h4>
                                <p class="text-gray-600 text-sm mt-1">
                                    Once you delete an account, there is no going back. Please be certain.
                                </p>
                                @if($account->outgoingTransfers->count() > 0 || $account->incomingTransfers->count() > 0 || $account->pettyCashTransactions->count() > 0)
                                <div class="mt-2 p-3 bg-yellow-50 border border-yellow-200 rounded-lg">
                                    <div class="flex items-center">
                                        <i class="fas fa-exclamation-triangle text-yellow-500 mr-2"></i>
                                        <span class="text-yellow-700 text-sm">
                                            This account has transactions. You can only delete accounts with no transaction history.
                                            Consider deactivating it instead.
                                        </span>
                                    </div>
                                </div>
                                @endif
                            </div>
                            
                            <div class="space-x-3">
                                @can('cash-banking.accounts.toggle-status')
                                <form action="{{ route('admin.accounting.cash-banking.accounts.toggle-status', $account->cashBankId) }}" 
                                      method="POST" class="inline">
                                    @csrf
                                    <button type="submit" 
                                            class="px-4 py-2 bg-{{ $account->isActive ? 'yellow' : 'green' }}-600 hover:bg-{{ $account->isActive ? 'yellow' : 'green' }}-700 text-white rounded-lg font-medium transition duration-150">
                                        <i class="fas fa-{{ $account->isActive ? 'pause' : 'play' }} mr-2"></i>
                                        {{ $account->isActive ? 'Deactivate' : 'Activate' }} Account
                                    </button>
                                </form>
                                @endcan
                                
                                @if($account->outgoingTransfers->count() == 0 && $account->incomingTransfers->count() == 0 && $account->pettyCashTransactions->count() == 0)
                                <form action="{{ route('admin.accounting.cash-banking.accounts.destroy', $account->cashBankId) }}" 
                                      method="POST" 
                                      onsubmit="return confirmDeleteAccount()">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" 
                                            class="px-4 py-2 bg-red-600 hover:bg-red-700 text-white rounded-lg font-medium flex items-center transition duration-150">
                                        <i class="fas fa-trash mr-2"></i>
                                        Delete Account
                                    </button>
                                </form>
                                @else
                                <button type="button" 
                                        class="px-4 py-2 bg-gray-300 text-gray-700 rounded-lg font-medium flex items-center cursor-not-allowed"
                                        title="Cannot delete account with transactions">
                                    <i class="fas fa-trash mr-2"></i>
                                    Delete Account
                                </button>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
                @endcan
            </div>
        </main>
    </div>

    <script>
        // Mobile menu functionality
        const mobileMenuButton = document.getElementById('mobile-menu-button');
        const sidebar = document.getElementById('sidebar');
        
        if (mobileMenuButton && sidebar) {
            mobileMenuButton.addEventListener('click', function() {
                sidebar.classList.toggle('active');
            });
        }

        // Success message handling
        @if(session('success'))
            setTimeout(() => {
                const successAlert = document.querySelector('.bg-green-50');
                if (successAlert) {
                    successAlert.style.display = 'none';
                }
            }, 5000);
        @endif

        @if(session('error'))
            setTimeout(() => {
                const errorAlert = document.querySelector('.bg-red-50');
                if (errorAlert) {
                    errorAlert.style.display = 'none';
                }
            }, 5000);
        @endif

        // Delete confirmation
        function confirmDeleteAccount() {
            const accountName = "{{ $account->accountName }}";
            const accountType = "{{ $account->accountType }}";
            const openingBalance = "{{ number_format($account->openingBalance, 2) }}";
            const currency = "{{ $account->currency }}";
            
            const message = `Are you sure you want to delete the following account?\n\n` +
                          `Account Name: ${accountName}\n` +
                          `Account Type: ${accountType}\n` +
                          `Opening Balance: ${openingBalance} ${currency}\n\n` +
                          `This action cannot be undone and all account data will be permanently lost.\n` +
                          `Opening balance entries will be reversed in the General Ledger.`;
            
            return confirm(message);
        }

        // Toggle GL entries view
        function toggleGLEntries() {
            const glEntries = document.getElementById('glEntries');
            const toggleBtn = document.getElementById('toggleGLEntriesBtn');
            
            if (glEntries.classList.contains('hidden')) {
                glEntries.classList.remove('hidden');
                toggleBtn.innerHTML = '<i class="fas fa-eye-slash mr-2"></i>Hide GL Entries';
            } else {
                glEntries.classList.add('hidden');
                toggleBtn.innerHTML = '<i class="fas fa-eye mr-2"></i>Show GL Entries';
            }
        }
    </script>
</body>
</html>