<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cash Book Transactions | IMMIA FINANCE</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        @include('accounting.partials.header', [
            'title' => 'Cash Book Transactions', 
            'subtitle' => 'View and manage all cash and bank transactions'
        ])

        <main class="p-6">
            <!-- Success/Error Messages -->
            @if(session('success'))
                <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-check-circle text-green-500 mr-2"></i>
                        <span class="text-green-800 font-semibold">{{ session('success') }}</span>
                    </div>
                </div>
            @endif

            @if(session('error'))
                <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-exclamation-circle text-red-500 mr-2"></i>
                        <span class="text-red-800 font-semibold">{{ session('error') }}</span>
                    </div>
                </div>
            @endif

            <!-- Filter Section -->
            <div class="bg-white rounded-xl shadow-sm border mb-6">
                <div class="p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Filter Transactions</h3>
                    <form method="GET" action="{{ route('admin.accounting.cash-banking.cash-book.index') }}" class="space-y-4">
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                            <!-- Account Filter -->
                            <div>
                                <label for="account_id" class="block text-sm font-medium text-gray-700 mb-1">Account</label>
                                <select id="account_id" name="account_id" class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                                    <option value="">All Accounts</option>
                                    @foreach($accounts as $account)
                                        <option value="{{ $account->cashBankId }}" {{ $accountId == $account->cashBankId ? 'selected' : '' }}>
                                            {{ $account->accountName }} ({{ $account->accountType }})
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <!-- Transaction Type Filter -->
                            <div>
                                <label for="transaction_type" class="block text-sm font-medium text-gray-700 mb-1">Type</label>
                                <select id="transaction_type" name="transaction_type" class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                                    <option value="">All Types</option>
                                    @foreach($transactionTypes as $type)
                                        <option value="{{ $type }}" {{ $transactionType == $type ? 'selected' : '' }}>{{ $type }}</option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <!-- Start Date -->
                            <div>
                                <label for="start_date" class="block text-sm font-medium text-gray-700 mb-1">From Date</label>
                                <input type="date" id="start_date" name="start_date" value="{{ $startDate }}" 
                                       class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            </div>
                            
                            <!-- End Date -->
                            <div>
                                <label for="end_date" class="block text-sm font-medium text-gray-700 mb-1">To Date</label>
                                <input type="date" id="end_date" name="end_date" value="{{ $endDate }}" 
                                       class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            </div>
                        </div>
                        
                        <!-- Action Buttons -->
                        <div class="flex items-center justify-between pt-4 border-t border-gray-200">
                            <div class="flex items-center space-x-3">
                                <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition-colors font-medium flex items-center space-x-2">
                                    <i class="fas fa-filter"></i>
                                    <span>Apply Filters</span>
                                </button>
                                <a href="{{ route('admin.accounting.cash-banking.cash-book.index') }}" 
                                   class="bg-gray-200 text-gray-700 px-6 py-2 rounded-lg hover:bg-gray-300 transition-colors font-medium flex items-center space-x-2">
                                    <i class="fas fa-redo"></i>
                                    <span>Reset</span>
                                </a>
                            </div>
                            
                            <!-- Export Button -->
                            <a href="{{ route('admin.accounting.cash-banking.cash-book.export') }}?{{ http_build_query(request()->query()) }}" 
                               class="bg-green-600 text-white px-6 py-2 rounded-lg hover:bg-green-700 transition-colors font-medium flex items-center space-x-2">
                                <i class="fas fa-download"></i>
                                <span>Export CSV</span>
                            </a>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Summary Cards -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
                <!-- Total Transactions -->
                <div class="bg-white rounded-xl shadow-sm border p-6">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm font-medium text-gray-500">Total Transactions</p>
                            <p class="text-2xl font-bold text-blue-600 mt-2">
                                {{ number_format($summary->transaction_count ?? 0) }}
                            </p>
                        </div>
                        <div class="bg-blue-100 p-3 rounded-lg">
                            <i class="fas fa-list text-blue-600 text-xl"></i>
                        </div>
                    </div>
                </div>
                
                <!-- Total Debits -->
                <div class="bg-white rounded-xl shadow-sm border p-6">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm font-medium text-gray-500">Total Debits</p>
                            <p class="text-2xl font-bold text-green-600 mt-2">
                                {{ number_format($summary->total_debits ?? 0, 2) }}
                            </p>
                        </div>
                        <div class="bg-green-100 p-3 rounded-lg">
                            <i class="fas fa-arrow-up text-green-600 text-xl"></i>
                        </div>
                    </div>
                </div>
                
                <!-- Total Credits -->
                <div class="bg-white rounded-xl shadow-sm border p-6">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm font-medium text-gray-500">Total Credits</p>
                            <p class="text-2xl font-bold text-red-600 mt-2">
                                {{ number_format($summary->total_credits ?? 0, 2) }}
                            </p>
                        </div>
                        <div class="bg-red-100 p-3 rounded-lg">
                            <i class="fas fa-arrow-down text-red-600 text-xl"></i>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Action Bar -->
            <div class="flex justify-between items-center mb-6">
                <div>
                    <h2 class="text-xl font-bold text-gray-900">Cash Book Transactions</h2>
                    <p class="text-gray-600">
                        Showing {{ $transactions->firstItem() ?? 0 }} - {{ $transactions->lastItem() ?? 0 }} of {{ $transactions->total() }} transactions
                        @if($accountId)
                            for {{ $accounts->firstWhere('cashBankId', $accountId)->accountName ?? '' }}
                        @endif
                    </p>
                </div>
                
                <!-- Date Range Info -->
                <div class="text-right">
                    <p class="text-sm font-medium text-gray-500">Date Range</p>
                    <p class="text-sm text-gray-900">
                        {{ \Carbon\Carbon::parse($startDate)->format('d M Y') }} - {{ \Carbon\Carbon::parse($endDate)->format('d M Y') }}
                    </p>
                </div>
            </div>

            <!-- Transactions Table -->
            <div class="bg-white rounded-xl shadow-sm border">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50 border-b">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Account</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Type</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Reference</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Description</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Debit</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Credit</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Balance</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @forelse($transactions as $transaction)
                                <tr class="hover:bg-gray-50 transition-colors">
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm font-medium text-gray-900">
                                            {{ $transaction->transaction_date->format('d/m/Y') }}
                                        </div>
                                        <div class="text-xs text-gray-500">
                                            {{ $transaction->transaction_date->format('h:i A') }}
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm font-medium text-gray-900">{{ $transaction->account->accountName ?? 'N/A' }}</div>
                                        <div class="text-xs text-gray-500">{{ $transaction->account->accountType ?? '' }}</div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        @php
                                            $typeColors = [
                                                'Opening Balance' => 'bg-blue-100 text-blue-800',
                                                'Transfer In' => 'bg-green-100 text-green-800',
                                                'Transfer Out' => 'bg-red-100 text-red-800',
                                                'Petty Cash Expense' => 'bg-amber-100 text-amber-800',
                                                'Petty Cash Income' => 'bg-emerald-100 text-emerald-800',
                                                'Expense' => 'bg-red-100 text-red-800',
                                                'Income' => 'bg-green-100 text-green-800',
                                                'Adjustment' => 'bg-purple-100 text-purple-800',
                                                'Reversal' => 'bg-gray-100 text-gray-800',
                                                'Other' => 'bg-gray-100 text-gray-800',
                                            ];
                                            $color = $typeColors[$transaction->transaction_type] ?? 'bg-gray-100 text-gray-800';
                                        @endphp
                                        <span class="inline-flex items-center px-2 py-1 text-xs font-medium rounded-full {{ $color }}">
                                            {{ $transaction->transaction_type }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        {{ $transaction->reference_number ?? 'N/A' }}
                                    </td>
                                    <td class="px-6 py-4">
                                        <div class="text-sm text-gray-900 max-w-xs">
                                            {{ $transaction->description }}
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-right">
                                        @if($transaction->amount > 0)
                                            <span class="font-medium text-green-600">
                                                {{ number_format($transaction->amount, 2) }}
                                            </span>
                                        @else
                                            <span class="text-gray-400">-</span>
                                        @endif
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-right">
                                        @if($transaction->amount < 0)
                                            <span class="font-medium text-red-600">
                                                {{ number_format(abs($transaction->amount), 2) }}
                                            </span>
                                        @else
                                            <span class="text-gray-400">-</span>
                                        @endif
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-right">
                                            <div class="text-sm font-medium text-gray-900">
                                                {{ number_format($transaction->balance_after, 2) }}
                                            </div>
                                            <div class="text-xs text-gray-500">
                                                Prev: {{ number_format($transaction->balance_before, 2) }}
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        @php
                                            $statusColors = [
                                                'Posted' => 'bg-green-100 text-green-800',
                                                'Pending' => 'bg-yellow-100 text-yellow-800',
                                                'Reversed' => 'bg-red-100 text-red-800',
                                                'Cancelled' => 'bg-gray-100 text-gray-800',
                                            ];
                                            $color = $statusColors[$transaction->status] ?? 'bg-gray-100 text-gray-800';
                                        @endphp
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $color }}">
                                            {{ $transaction->status }}
                                        </span>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="9" class="px-6 py-4 text-center text-sm text-gray-500">
                                        <div class="flex flex-col items-center justify-center py-12">
                                            <i class="fas fa-book text-4xl text-gray-300 mb-4"></i>
                                            <p class="text-gray-500 text-lg mb-2">No transactions found</p>
                                            <p class="text-gray-400 text-sm">Try adjusting your filters or date range</p>
                                        </div>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                @if($transactions->hasPages())
                    <div class="px-6 py-4 border-t border-gray-200">
                        {{ $transactions->appends(request()->query())->links() }}
                    </div>
                @endif
            </div>
        </main>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Mobile menu functionality
            const mobileMenuButton = document.getElementById('mobile-menu-button');
            const sidebar = document.getElementById('sidebar');
            
            if (mobileMenuButton && sidebar) {
                mobileMenuButton.addEventListener('click', function() {
                    sidebar.classList.toggle('active');
                });
            }

            // Success/Error message auto-hide
            @if(session('success'))
                setTimeout(() => {
                    const successAlert = document.querySelector('.bg-green-50');
                    if (successAlert) {
                        successAlert.style.display = 'none';
                    }
                }, 5000);
            @endif

            @if(session('error'))
                setTimeout(() => {
                    const errorAlert = document.querySelector('.bg-red-50');
                    if (errorAlert) {
                        errorAlert.style.display = 'none';
                    }
                }, 5000);
            @endif

            // Date validation
            const startDateInput = document.getElementById('start_date');
            const endDateInput = document.getElementById('end_date');
            const filterForm = document.querySelector('form');

            // Set max date to today for both inputs
            const today = new Date().toISOString().split('T')[0];
            if (startDateInput) startDateInput.max = today;
            if (endDateInput) endDateInput.max = today;

            // Validate date range on form submit
            if (filterForm) {
                filterForm.addEventListener('submit', function(e) {
                    const startDate = startDateInput.value;
                    const endDate = endDateInput.value;
                    
                    if (startDate && endDate) {
                        if (new Date(startDate) > new Date(endDate)) {
                            e.preventDefault();
                            alert('Start date cannot be after end date');
                            return false;
                        }
                    }
                });
            }

            // Quick date range buttons functionality
            const quickDateButtons = document.querySelectorAll('[data-days]');
            quickDateButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const days = parseInt(this.dataset.days);
                    const endDate = new Date();
                    const startDate = new Date();
                    startDate.setDate(startDate.getDate() - days);
                    
                    if (startDateInput) {
                        startDateInput.value = startDate.toISOString().split('T')[0];
                    }
                    if (endDateInput) {
                        endDateInput.value = endDate.toISOString().split('T')[0];
                    }
                    
                    filterForm.submit();
                });
            });
        });
    </script>
</body>
</html>