<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cash & Banking | IMMIA FINANCE</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        @include('accounting.partials.header', ['title' => 'Cash & Banking', 'subtitle' => 'Manage your cash, mobile money, and bank accounts'])

        <main class="p-6">
            <!-- Success/Error Messages -->
            @if(session('success'))
                <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-check-circle text-green-500 mr-2"></i>
                        <span class="text-green-800 font-semibold">{{ session('success') }}</span>
                    </div>
                </div>
            @endif

            @if(session('error'))
                <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-exclamation-circle text-red-500 mr-2"></i>
                        <span class="text-red-800 font-semibold">{{ session('error') }}</span>
                    </div>
                </div>
            @endif

            <!-- Balance Summary Cards -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
                <div class="bg-blue-600 text-white rounded-xl p-6 shadow-sm">
                    <div class="flex justify-between items-start">
                        <div>
                            <p class="text-blue-100 text-sm font-medium">Total Balance</p>
                            <h3 class="text-2xl font-bold mt-1">{{ number_format($totalBalance, 2) }}</h3>
                        </div>
                        <div class="bg-blue-500 p-3 rounded-lg">
                            <i class="fas fa-wallet text-xl"></i>
                        </div>
                    </div>
                </div>

                <div class="bg-green-600 text-white rounded-xl p-6 shadow-sm">
                    <div class="flex justify-between items-start">
                        <div>
                            <p class="text-green-100 text-sm font-medium">Cash Balance</p>
                            <h3 class="text-2xl font-bold mt-1">{{ number_format($cashBalance, 2) }}</h3>
                        </div>
                        <div class="bg-green-500 p-3 rounded-lg">
                            <i class="fas fa-money-bill text-xl"></i>
                        </div>
                    </div>
                </div>

                <div class="bg-indigo-600 text-white rounded-xl p-6 shadow-sm">
                    <div class="flex justify-between items-start">
                        <div>
                            <p class="text-indigo-100 text-sm font-medium">Bank Balance</p>
                            <h3 class="text-2xl font-bold mt-1">{{ number_format($bankBalance, 2) }}</h3>
                        </div>
                        <div class="bg-indigo-500 p-3 rounded-lg">
                            <i class="fas fa-university text-xl"></i>
                        </div>
                    </div>
                </div>

                <div class="bg-amber-600 text-white rounded-xl p-6 shadow-sm">
                    <div class="flex justify-between items-start">
                        <div>
                            <p class="text-amber-100 text-sm font-medium">Mobile Money</p>
                            <h3 class="text-2xl font-bold mt-1">{{ number_format($mobileMoneyBalance, 2) }}</h3>
                        </div>
                        <div class="bg-amber-500 p-3 rounded-lg">
                            <i class="fas fa-mobile-alt text-xl"></i>
                        </div>
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <!-- Accounts List -->
                <div class="lg:col-span-2">
                    <div class="bg-white rounded-xl shadow-sm border">
                        <div class="p-6 border-b border-gray-200">
                            <div class="flex justify-between items-center">
                                <h3 class="text-lg font-semibold text-gray-900">Accounts</h3>
                                @can('cash-banking.accounts.view')
                                <a href="{{ route('admin.accounting.cash-banking.accounts.index') }}" 
                                   class="text-blue-600 hover:text-blue-700 text-sm font-medium">
                                    View All
                                </a>
                                @endcan
                            </div>
                        </div>
                        <div class="overflow-x-auto">
                            <table class="w-full">
                                <thead class="bg-gray-50 border-b">
                                    <tr>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Account Name</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Type</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Account Number</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Balance</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-200">
                                    @foreach($accounts as $account)
                                    <tr class="hover:bg-gray-50">
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            <div class="flex items-center">
                                                @can('cash-banking.accounts.view')
                                                <a href="{{ route('admin.accounting.cash-banking.accounts.show', $account->cashBankId) }}" 
                                                   class="text-sm font-medium text-blue-600 hover:text-blue-900">
                                                    {{ $account->accountName }}
                                                </a>
                                                @else
                                                <span class="text-sm font-medium text-gray-900">{{ $account->accountName }}</span>
                                                @endcan
                                                @if($account->isDefault)
                                                <span class="ml-2 inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-blue-100 text-blue-800">
                                                    Default
                                                </span>
                                                @endif
                                            </div>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium 
                                                {{ $account->accountType == 'Cash' ? 'bg-green-100 text-green-800' : '' }}
                                                {{ $account->accountType == 'Bank' ? 'bg-blue-100 text-blue-800' : '' }}
                                                {{ $account->accountType == 'Mobile Money' ? 'bg-amber-100 text-amber-800' : '' }}">
                                                {{ $account->accountType }}
                                            </span>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                            {{ $account->accountNumber ?? 'N/A' }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                            {{ number_format($account->current_balance, 2) }} {{ $account->currency }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $account->isActive ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                                {{ $account->isActive ? 'Active' : 'Inactive' }}
                                            </span>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Recent Activity Sidebar -->
                <div class="space-y-6">
                    <!-- Recent Transfers -->
                    <div class="bg-white rounded-xl shadow-sm border">
                        <div class="p-6 border-b border-gray-200">
                            <div class="flex justify-between items-center">
                                <h3 class="text-lg font-semibold text-gray-900">Recent Transfers</h3>
                                @can('cash-banking.internal-transfers.view')
                                <a href="{{ route('admin.accounting.cash-banking.internal-transfers.index') }}" 
                                   class="text-blue-600 hover:text-blue-700 text-sm font-medium">
                                    View All
                                </a>
                                @endcan
                            </div>
                        </div>
                        <div class="p-6 space-y-4">
                            @if($recentTransfers->count() > 0)
                                @foreach($recentTransfers as $transfer)
                                <div class="flex items-start space-x-3">
                                    <div class="flex-shrink-0 mt-1">
                                        <i class="fas fa-exchange-alt text-blue-500"></i>
                                    </div>
                                    <div class="flex-1 min-w-0">
                                        <p class="text-sm font-medium text-gray-900">
                                            {{ number_format($transfer->amountsent, 2) }} {{ $transfer->currency }}
                                        </p>
                                        <p class="text-sm text-gray-500 truncate">
                                            {{ $transfer->fromAccount->accountName }} → {{ $transfer->toAccount->accountName }}
                                        </p>
                                        <p class="text-xs text-gray-400 mt-1">
                                            {{ $transfer->transactiondate->format('M d, Y') }}
                                        </p>
                                    </div>
                                    <div class="flex-shrink-0">
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $transfer->transferstatus == 'Sent' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' }}">
                                            {{ $transfer->transferstatus }}
                                        </span>
                                    </div>
                                </div>
                                @endforeach
                            @else
                                <p class="text-gray-500 text-center py-4">No recent transfers</p>
                            @endif
                        </div>
                    </div>

                    <!-- Recent Petty Cash -->
                    <div class="bg-white rounded-xl shadow-sm border">
                        <div class="p-6 border-b border-gray-200">
                            <div class="flex justify-between items-center">
                                <h3 class="text-lg font-semibold text-gray-900">Recent Petty Cash</h3>
                                @can('pettycash.view')
                                <a href="{{ route('admin.accounting.cash-banking.petty-cash.index') }}" 
                                   class="text-blue-600 hover:text-blue-700 text-sm font-medium">
                                    View All
                                </a>
                                @endcan
                            </div>
                        </div>
                        <div class="p-6 space-y-4">
                            @if($recentPettyCash->count() > 0)
                                @foreach($recentPettyCash as $pettyCash)
                                <div class="flex items-start space-x-3">
                                    <div class="flex-shrink-0 mt-1">
                                        <i class="fas fa-money-bill-wave text-green-500"></i>
                                    </div>
                                    <div class="flex-1 min-w-0">
                                        <p class="text-sm font-medium text-gray-900">
                                            {{ number_format($pettyCash->amount, 2) }} {{ $pettyCash->currency }}
                                        </p>
                                        <p class="text-sm text-gray-500 truncate">
                                            {{ Str::limit($pettyCash->payee, 20) }}
                                        </p>
                                        <p class="text-xs text-gray-400 mt-1">
                                            {{ $pettyCash->transaction_date->format('M d, Y') }}
                                        </p>
                                    </div>
                                    <div class="flex-shrink-0">
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-{{ $pettyCash->getStatusBadgeClass() }}-100 text-{{ $pettyCash->getStatusBadgeClass() }}-800">
                                            {{ $pettyCash->status }}
                                        </span>
                                    </div>
                                </div>
                                @endforeach
                            @else
                                <p class="text-gray-500 text-center py-4">No recent petty cash</p>
                            @endif
                        </div>
                    </div>

                    <!-- Quick Actions -->
                    <div class="bg-white rounded-xl shadow-sm border">
                        <div class="p-6 border-b border-gray-200">
                            <h3 class="text-lg font-semibold text-gray-900">Quick Actions</h3>
                        </div>
                        <div class="p-6 space-y-3">
                            @can('cash-banking.accounts.create')
                            <a href="{{ route('admin.accounting.cash-banking.accounts.create') }}" 
                               class="w-full flex items-center justify-center px-4 py-2 border border-transparent text-sm font-medium rounded-lg text-white bg-blue-600 hover:bg-blue-700 transition duration-150">
                                <i class="fas fa-plus mr-2"></i>New Account
                            </a>
                            @endcan
                            
                            @can('cash-banking.internal-transfers.create')
                            <a href="{{ route('admin.accounting.cash-banking.internal-transfers.create') }}" 
                               class="w-full flex items-center justify-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-lg text-gray-700 bg-white hover:bg-gray-50 transition duration-150">
                                <i class="fas fa-exchange-alt mr-2"></i>New Transfer
                            </a>
                            @endcan
                            
                            @can('pettycash.manage')
                            <a href="{{ route('admin.accounting.cash-banking.petty-cash.create') }}" 
                               class="w-full flex items-center justify-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-lg text-gray-700 bg-white hover:bg-gray-50 transition duration-150">
                                <i class="fas fa-money-bill-wave mr-2"></i>New Petty Cash
                            </a>
                            @endcan
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <script>
        // Mobile menu functionality
        const mobileMenuButton = document.getElementById('mobile-menu-button');
        const sidebar = document.getElementById('sidebar');
        
        if (mobileMenuButton && sidebar) {
            mobileMenuButton.addEventListener('click', function() {
                sidebar.classList.toggle('active');
            });
        }

        // Success message handling
        @if(session('success'))
            setTimeout(() => {
                const successAlert = document.querySelector('.bg-green-50');
                if (successAlert) {
                    successAlert.style.display = 'none';
                }
            }, 5000);
        @endif

        @if(session('error'))
            setTimeout(() => {
                const errorAlert = document.querySelector('.bg-red-50');
                if (errorAlert) {
                    errorAlert.style.display = 'none';
                }
            }, 5000);
        @endif
    </script>
</body>
</html>