<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Internal Transfers | IMMIA FINANCE</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
</head>
<body class="bg-gray-50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        @include('accounting.partials.header', ['title' => 'Internal Transfers', 'subtitle' => 'Manage internal transfers between cash and bank accounts'])

        <main class="p-6">
            <!-- Success/Error Messages -->
            @if(session('success'))
                <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-check-circle text-green-500 mr-2"></i>
                        <span class="text-green-800 font-semibold">{{ session('success') }}</span>
                    </div>
                </div>
            @endif

            @if(session('error'))
                <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-exclamation-circle text-red-500 mr-2"></i>
                        <span class="text-red-800 font-semibold">{{ session('error') }}</span>
                    </div>
                </div>
            @endif

            <!-- Action Bar -->
            <div class="flex flex-col lg:flex-row justify-between items-start lg:items-center mb-6 gap-4">
                <div>
                    <h2 class="text-2xl font-bold text-gray-900">Internal Transfers</h2>
                    <p class="text-gray-600">Transfer funds between your accounts</p>
                </div>
                <div class="flex items-center gap-4">
                    <a href="{{ route('admin.accounting.cash-banking.internal-transfers.create') }}" 
                       class="bg-gradient-to-r from-blue-600 to-blue-700 hover:from-blue-700 hover:to-blue-800 text-white px-5 py-3 rounded-lg font-semibold flex items-center space-x-2 transition duration-150 shadow-md hover:shadow-lg">
                        <i class="fas fa-exchange-alt"></i>
                        <span>New Transfer</span>
                    </a>
                </div>
            </div>

            <!-- Filters Card -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 mb-6">
                <div class="p-6 border-b border-gray-200">
                    <h3 class="text-lg font-semibold text-gray-900">Filters & Search</h3>
                </div>
                <form method="GET" action="{{ route('admin.accounting.cash-banking.internal-transfers.index') }}" class="p-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                        <!-- Search -->
                        <div>
                            <label for="search" class="block text-sm font-medium text-gray-700 mb-1">Search</label>
                            <div class="relative">
                                <input type="text" name="search" id="search" value="{{ request('search') }}" 
                                       class="pl-10 pr-4 py-2 border border-gray-300 rounded-lg w-full focus:ring-blue-500 focus:border-blue-500"
                                       placeholder="Search transfers...">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <i class="fas fa-search text-gray-400"></i>
                                </div>
                            </div>
                        </div>

                        <!-- Date Range -->
                        <div>
                            <label for="date_range" class="block text-sm font-medium text-gray-700 mb-1">Date Range</label>
                            <div class="flex space-x-2">
                                <input type="text" name="date_from" id="date_from" value="{{ request('date_from') }}" 
                                       class="flex-1 px-4 py-2 border border-gray-300 rounded-lg focus:ring-blue-500 focus:border-blue-500 datepicker"
                                       placeholder="From Date">
                                <input type="text" name="date_to" id="date_to" value="{{ request('date_to') }}" 
                                       class="flex-1 px-4 py-2 border border-gray-300 rounded-lg focus:ring-blue-500 focus:border-blue-500 datepicker"
                                       placeholder="To Date">
                            </div>
                        </div>

                        <!-- Account Filter -->
                        <div>
                            <label for="account_id" class="block text-sm font-medium text-gray-700 mb-1">Account</label>
                            <select name="account_id" id="account_id" 
                                    class="px-4 py-2 border border-gray-300 rounded-lg w-full focus:ring-blue-500 focus:border-blue-500">
                                <option value="">All Accounts</option>
                                @foreach($accounts as $account)
                                <option value="{{ $account->cashBankId }}" {{ request('account_id') == $account->cashBankId ? 'selected' : '' }}>
                                    {{ $account->accountName }} ({{ $account->accountType }})
                                </option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Status Filter -->
                        <div>
                            <label for="status" class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                            <select name="status" id="status" 
                                    class="px-4 py-2 border border-gray-300 rounded-lg w-full focus:ring-blue-500 focus:border-blue-500">
                                <option value="">All Status</option>
                                <option value="Pending" {{ request('status') == 'Pending' ? 'selected' : '' }}>Pending</option>
                                <option value="Sent" {{ request('status') == 'Sent' ? 'selected' : '' }}>Sent</option>
                            </select>
                        </div>
                    </div>

                    <div class="flex justify-end space-x-3 mt-6">
                        <a href="{{ route('admin.accounting.cash-banking.internal-transfers.index') }}" 
                           class="px-5 py-2 border border-gray-300 rounded-lg font-medium text-gray-700 bg-white hover:bg-gray-50 transition duration-150">
                            Clear Filters
                        </a>
                        <button type="submit" 
                                class="px-5 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-lg font-semibold transition duration-150 flex items-center space-x-2">
                            <i class="fas fa-filter"></i>
                            <span>Apply Filters</span>
                        </button>
                    </div>
                </form>
            </div>

            <!-- Stats Cards -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
                <div class="bg-gradient-to-r from-blue-500 to-blue-600 text-white rounded-xl p-6 shadow-sm">
                    <div class="flex justify-between items-center">
                        <div>
                            <p class="text-blue-100 text-sm font-medium">Total Transfers</p>
                            <h3 class="text-2xl font-bold mt-1">{{ $transfers->total() }}</h3>
                        </div>
                        <div class="bg-blue-400/30 p-3 rounded-lg">
                            <i class="fas fa-exchange-alt text-xl"></i>
                        </div>
                    </div>
                </div>

                <div class="bg-gradient-to-r from-green-500 to-green-600 text-white rounded-xl p-6 shadow-sm">
                    <div class="flex justify-between items-center">
                        <div>
                            <p class="text-green-100 text-sm font-medium">Total Sent</p>
                            <h3 class="text-2xl font-bold mt-1">ZMW {{ number_format($transfers->where('transferstatus', 'Sent')->sum('amountsent'), 2) }}</h3>
                        </div>
                        <div class="bg-green-400/30 p-3 rounded-lg">
                            <i class="fas fa-check-circle text-xl"></i>
                        </div>
                    </div>
                </div>

                <div class="bg-gradient-to-r from-amber-500 to-amber-600 text-white rounded-xl p-6 shadow-sm">
                    <div class="flex justify-between items-center">
                        <div>
                            <p class="text-amber-100 text-sm font-medium">Pending Transfers</p>
                            <h3 class="text-2xl font-bold mt-1">{{ $transfers->where('transferstatus', 'Pending')->count() }}</h3>
                        </div>
                        <div class="bg-amber-400/30 p-3 rounded-lg">
                            <i class="fas fa-clock text-xl"></i>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Transfers Table -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-200">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50 border-b">
                            <tr>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Transfer Details</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Amount</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Status</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Date</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @forelse($transfers as $transfer)
                            <tr class="hover:bg-gray-50 transition duration-150">
                                <td class="px-6 py-4">
                                    <div>
                                        <div class="text-sm font-semibold text-gray-900">Transfer #{{ $transfer->transferid }}</div>
                                        <div class="mt-1">
                                            <div class="flex items-center text-sm text-gray-600">
                                                <i class="fas fa-arrow-right-from-bracket text-red-500 mr-2"></i>
                                                <span class="font-medium">{{ $transfer->fromAccount->accountName }}</span>
                                                <i class="fas fa-arrow-right mx-2 text-gray-400"></i>
                                                <i class="fas fa-arrow-right-to-bracket text-green-500 mr-2"></i>
                                                <span class="font-medium">{{ $transfer->toAccount->accountName }}</span>
                                            </div>
                                            @if($transfer->details)
                                            <p class="text-sm text-gray-500 mt-1">{{ Str::limit($transfer->details, 50) }}</p>
                                            @endif
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="text-sm">
                                        <div class="font-bold text-gray-900">{{ number_format($transfer->amountsent, 2) }} {{ $transfer->currency }}</div>
                                        @if($transfer->exchangerate != 1)
                                        <div class="text-xs text-gray-500 mt-1">
                                            Rate: {{ number_format($transfer->exchangerate, 4) }}<br>
                                            Received: {{ number_format($transfer->amountreceived, 2) }}
                                        </div>
                                        @endif
                                    </div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="flex items-center">
                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium {{ $transfer->transferstatus == 'Sent' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' }}">
                                            @if($transfer->transferstatus == 'Sent')
                                            <i class="fas fa-check-circle mr-1.5"></i>
                                            @else
                                            <i class="fas fa-clock mr-1.5"></i>
                                            @endif
                                            {{ $transfer->transferstatus }}
                                        </span>
                                    </div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="text-sm text-gray-900">{{ $transfer->transactiondate->format('M d, Y') }}</div>
                                    <div class="text-xs text-gray-500">{{ $transfer->transactiondate->format('h:i A') }}</div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="flex items-center space-x-2">
                                        <a href="{{ route('admin.accounting.cash-banking.internal-transfers.show', $transfer->transferid) }}" 
                                           class="inline-flex items-center px-3 py-1.5 border border-blue-600 text-blue-600 rounded-lg hover:bg-blue-50 transition duration-150 text-sm font-medium"
                                           title="View Details">
                                            <i class="fas fa-eye mr-1.5"></i> View
                                        </a>
                                        
                                        @if($transfer->transferstatus === 'Pending')
                                        <a href="{{ route('admin.accounting.cash-banking.internal-transfers.edit', $transfer->transferid) }}" 
                                           class="inline-flex items-center px-3 py-1.5 border border-green-600 text-green-600 rounded-lg hover:bg-green-50 transition duration-150 text-sm font-medium"
                                           title="Edit">
                                            <i class="fas fa-edit mr-1.5"></i> Edit
                                        </a>
                                        
                                        <!-- Send Button -->
                                        <form action="{{ route('admin.accounting.cash-banking.internal-transfers.send', $transfer->transferid) }}" 
                                              method="POST" 
                                              class="inline"
                                              onsubmit="return confirm('Are you sure you want to send this transfer? This will post it to the ledger and cannot be undone.')">
                                            @csrf
                                            <button type="submit" 
                                                    class="inline-flex items-center px-3 py-1.5 border border-green-600 text-green-600 rounded-lg hover:bg-green-50 transition duration-150 text-sm font-medium"
                                                    title="Send Transfer">
                                                <i class="fas fa-paper-plane mr-1.5"></i> Send
                                            </button>
                                        </form>
                                        
                                        <form action="{{ route('admin.accounting.cash-banking.internal-transfers.destroy', $transfer->transferid) }}" 
                                              method="POST" class="inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" 
                                                    class="inline-flex items-center px-3 py-1.5 border border-red-600 text-red-600 rounded-lg hover:bg-red-50 transition duration-150 text-sm font-medium"
                                                    onclick="return confirm('Are you sure you want to delete this transfer? This action cannot be undone.')"
                                                    title="Delete">
                                                <i class="fas fa-trash mr-1.5"></i> Delete
                                            </button>
                                        </form>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="5" class="px-6 py-12 text-center">
                                    <div class="flex flex-col items-center justify-center">
                                        <div class="w-24 h-24 bg-gray-100 rounded-full flex items-center justify-center mb-4">
                                            <i class="fas fa-exchange-alt text-3xl text-gray-400"></i>
                                        </div>
                                        <h3 class="text-lg font-semibold text-gray-900 mb-2">No transfers found</h3>
                                        <p class="text-gray-500 mb-6">Get started by creating your first internal transfer</p>
                                        <a href="{{ route('admin.accounting.cash-banking.internal-transfers.create') }}" 
                                           class="bg-blue-600 hover:bg-blue-700 text-white px-5 py-2.5 rounded-lg font-semibold flex items-center space-x-2 transition duration-150">
                                            <i class="fas fa-plus"></i>
                                            <span>Create New Transfer</span>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                @if($transfers->hasPages())
                <div class="px-6 py-4 border-t border-gray-200">
                    <div class="flex items-center justify-between">
                        <div class="text-sm text-gray-700">
                            Showing {{ $transfers->firstItem() }} to {{ $transfers->lastItem() }} of {{ $transfers->total() }} results
                        </div>
                        <div class="flex items-center space-x-2">
                            {{ $transfers->links() }}
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </main>
    </div>

    <script>
        // Mobile menu functionality
        const mobileMenuButton = document.getElementById('mobile-menu-button');
        const sidebar = document.getElementById('sidebar');
        
        if (mobileMenuButton && sidebar) {
            mobileMenuButton.addEventListener('click', function() {
                sidebar.classList.toggle('active');
            });
        }

        // Initialize date pickers
        flatpickr('.datepicker', {
            dateFormat: 'Y-m-d',
            allowInput: true
        });

        // Success message handling
        @if(session('success'))
            setTimeout(() => {
                const successAlert = document.querySelector('.bg-green-50');
                if (successAlert) {
                    successAlert.style.display = 'none';
                }
            }, 5000);
        @endif

        @if(session('error'))
            setTimeout(() => {
                const errorAlert = document.querySelector('.bg-red-50');
                if (errorAlert) {
                    errorAlert.style.display = 'none';
                }
            }, 5000);
        @endif
    </script>
</body>
</html>