<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Petty Cash | IMMIA FINANCE</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        @include('accounting.partials.header', ['title' => 'Petty Cash Management', 'subtitle' => 'Manage petty cash requests and payments'])

        <main class="p-6">
            <!-- Success/Error Messages -->
            @if(session('success'))
                <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-check-circle text-green-500 mr-2"></i>
                        <span class="text-green-800 font-semibold">{{ session('success') }}</span>
                    </div>
                </div>
            @endif

            @if(session('error'))
                <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-exclamation-circle text-red-500 mr-2"></i>
                        <span class="text-red-800 font-semibold">{{ session('error') }}</span>
                    </div>
                </div>
            @endif

            <!-- Action Bar -->
            <div class="flex justify-between items-center mb-6">
                <div>
                    <h2 class="text-xl font-bold text-gray-900">Petty Cash Requests</h2>
                    <p class="text-gray-600">{{ $pettyCash->total() }} requests found</p>
                </div>
                <a href="{{ route('admin.accounting.cash-banking.petty-cash.create') }}" 
                   class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg font-semibold flex items-center space-x-2 transition duration-150">
                    <i class="fas fa-plus"></i>
                    <span>New Petty Cash</span>
                </a>
            </div>

            <!-- Filters -->
            <div class="bg-white rounded-xl shadow-sm border mb-6">
                <div class="p-6">
                    <form action="{{ route('admin.accounting.cash-banking.petty-cash.index') }}" method="GET">
                        <div class="grid grid-cols-1 md:grid-cols-5 gap-4">
                            <div>
                                <label for="search" class="block text-sm font-medium text-gray-700 mb-1">Search</label>
                                <input type="text" id="search" name="search" value="{{ request('search') }}" 
                                       class="w-full border border-gray-300 rounded-lg px-3 py-2 text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                                       placeholder="Number, payee, description...">
                            </div>
                            <div>
                                <label for="status" class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                                <select id="status" name="status" class="w-full border border-gray-300 rounded-lg px-3 py-2 text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                                    <option value="">All Status</option>
                                    <option value="Draft" {{ request('status') == 'Draft' ? 'selected' : '' }}>Draft</option>
                                    <option value="Submitted" {{ request('status') == 'Submitted' ? 'selected' : '' }}>Submitted</option>
                                    <option value="Approved" {{ request('status') == 'Approved' ? 'selected' : '' }}>Approved</option>
                                    <option value="Rejected" {{ request('status') == 'Rejected' ? 'selected' : '' }}>Rejected</option>
                                    <option value="Paid" {{ request('status') == 'Paid' ? 'selected' : '' }}>Paid</option>
                                    <option value="Reimbursed" {{ request('status') == 'Reimbursed' ? 'selected' : '' }}>Reimbursed</option>
                                    <option value="Reversed" {{ request('status') == 'Reversed' ? 'selected' : '' }}>Reversed</option>
                                    <option value="Cancelled" {{ request('status') == 'Cancelled' ? 'selected' : '' }}>Cancelled</option>
                                </select>
                            </div>
                            <div>
                                <label for="start_date" class="block text-sm font-medium text-gray-700 mb-1">From Date</label>
                                <input type="date" id="start_date" name="start_date" value="{{ request('start_date') }}" 
                                       class="w-full border border-gray-300 rounded-lg px-3 py-2 text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            </div>
                            <div>
                                <label for="end_date" class="block text-sm font-medium text-gray-700 mb-1">To Date</label>
                                <input type="date" id="end_date" name="end_date" value="{{ request('end_date') }}" 
                                       class="w-full border border-gray-300 rounded-lg px-3 py-2 text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            </div>
                            <div class="flex items-end space-x-2">
                                <button type="submit" class="w-full bg-blue-600 text-white px-4 py-2 rounded-lg text-sm font-medium hover:bg-blue-700 transition duration-150 flex items-center justify-center">
                                    <i class="fas fa-search mr-2"></i> Filter
                                </button>
                                <a href="{{ route('admin.accounting.cash-banking.petty-cash.export', request()->query()) }}" 
                                   class="w-full bg-green-600 text-white px-4 py-2 rounded-lg text-sm font-medium hover:bg-green-700 transition duration-150 flex items-center justify-center">
                                    <i class="fas fa-file-export mr-2"></i> Export
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Petty Cash Table -->
            <div class="bg-white rounded-xl shadow-sm border">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50 border-b">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">PC Number</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Payee</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Description</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Source Account</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Requested By</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @forelse($pettyCash as $item)
                            <tr class="hover:bg-gray-50">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium text-gray-900">{{ $item->petty_cash_number }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ $item->transaction_date->format('M d, Y') }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ Str::limit($item->payee, 20) }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ Str::limit($item->description, 30) }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                    {{ number_format($item->amount, 2) }} {{ $item->currency }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ $item->sourceAccount->accountName ?? 'N/A' }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium 
                                        {{ $item->status === 'Draft' ? 'bg-gray-100 text-gray-800' : '' }}
                                        {{ $item->status === 'Submitted' ? 'bg-blue-100 text-blue-800' : '' }}
                                        {{ $item->status === 'Approved' ? 'bg-green-100 text-green-800' : '' }}
                                        {{ $item->status === 'Rejected' ? 'bg-red-100 text-red-800' : '' }}
                                        {{ $item->status === 'Paid' ? 'bg-purple-100 text-purple-800' : '' }}
                                        {{ $item->status === 'Reimbursed' ? 'bg-teal-100 text-teal-800' : '' }}
                                        {{ $item->status === 'Reversed' ? 'bg-yellow-100 text-yellow-800' : '' }}
                                        {{ $item->status === 'Cancelled' ? 'bg-gray-800 text-white' : '' }}">
                                        {{ $item->status }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ $item->requester->name ?? 'N/A' }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                    <div class="flex items-center space-x-2">
                                        <!-- View button - always show to poweruser -->
                                        @if(auth()->user()->can('poweruser') || auth()->user()->can('pettycash.view') || $item->requested_by == auth()->id())
                                            <a href="{{ route('admin.accounting.cash-banking.petty-cash.show', $item->petty_cash_id) }}" 
                                               class="text-blue-600 hover:text-blue-900 transition duration-150" title="View">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        @endif
                                        
                                        @if($item->canEdit())
                                            <!-- Edit button - show to creator or poweruser -->
                                            @if($item->requested_by == auth()->id() || auth()->user()->can('poweruser'))
                                                <a href="{{ route('admin.accounting.cash-banking.petty-cash.edit', $item->petty_cash_id) }}" 
                                                   class="text-green-600 hover:text-green-900 transition duration-150" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                            @endif
                                        @endif
                                        
                                        @if($item->status === 'Draft')
                                            <!-- Submit button - show to creator or poweruser -->
                                            @if($item->requested_by == auth()->id() || auth()->user()->can('poweruser'))
                                                <form action="{{ route('admin.accounting.cash-banking.petty-cash.submit', $item->petty_cash_id) }}" 
                                                      method="POST" class="inline">
                                                    @csrf
                                                    <button type="submit" 
                                                            class="text-amber-600 hover:text-amber-900 transition duration-150"
                                                            title="Submit for Approval">
                                                        <i class="fas fa-paper-plane"></i>
                                                    </button>
                                                </form>
                                            @endif
                                        @endif
                                        
                                        @if($item->status === 'Submitted')
                                            <!-- Approve button - show to poweruser or users with approve permission -->
                                            @if(auth()->user()->can('poweruser') || auth()->user()->can('pettycash.approve'))
                                                <button type="button" 
                                                        class="text-green-600 hover:text-green-900 transition duration-150"
                                                        onclick="openApproveModal({{ $item->petty_cash_id }})"
                                                        title="Approve">
                                                    <i class="fas fa-check"></i>
                                                </button>
                                            @endif
                                            
                                            <!-- Reject button - show to poweruser or users with reject permission -->
                                            @if(auth()->user()->can('poweruser') || auth()->user()->can('pettycash.reject'))
                                                <button type="button" 
                                                        class="text-red-600 hover:text-red-900 transition duration-150"
                                                        onclick="openRejectModal({{ $item->petty_cash_id }})"
                                                        title="Reject">
                                                    <i class="fas fa-times"></i>
                                                </button>
                                            @endif
                                        @endif
                                        
                                        @if($item->status === 'Approved')
                                            <!-- Mark as Paid button - show to poweruser or users with approve permission -->
                                            @if(auth()->user()->can('poweruser') || auth()->user()->can('pettycash.approve'))
                                                <form action="{{ route('admin.accounting.cash-banking.petty-cash.mark-paid', $item->petty_cash_id) }}" 
                                                      method="POST" class="inline">
                                                    @csrf
                                                    <button type="submit" 
                                                            class="text-purple-600 hover:text-purple-900 transition duration-150"
                                                            title="Mark as Paid">
                                                        <i class="fas fa-money-bill-wave"></i>
                                                    </button>
                                                </form>
                                            @endif
                                        @endif
                                        
                                        @if($item->status === 'Paid')
                                            <!-- Reimburse button - show to poweruser -->
                                            @if(auth()->user()->can('poweruser'))
                                                <form action="{{ route('admin.accounting.cash-banking.petty-cash.reimburse', $item->petty_cash_id) }}" 
                                                      method="POST" class="inline">
                                                    @csrf
                                                    <button type="submit" 
                                                            class="text-teal-600 hover:text-teal-900 transition duration-150"
                                                            title="Reimburse">
                                                        <i class="fas fa-exchange-alt"></i>
                                                    </button>
                                                </form>
                                            @endif
                                        @endif
                                        
                                        @if($item->canReverse())
                                            <!-- Reverse button - show to poweruser or users with approve/reject permission -->
                                            @if(auth()->user()->can('poweruser') || auth()->user()->can('pettycash.approve') || auth()->user()->can('pettycash.reject'))
                                                <button type="button" 
                                                        class="text-red-600 hover:text-red-900 transition duration-150"
                                                        onclick="openReverseModal({{ $item->petty_cash_id }})"
                                                        title="Reverse">
                                                    <i class="fas fa-undo"></i>
                                                </button>
                                            @endif
                                        @endif
                                        
                                        @if($item->canEdit())
                                            <!-- Delete button - show to creator or poweruser -->
                                            @if($item->requested_by == auth()->id() || auth()->user()->can('poweruser'))
                                                <form action="{{ route('admin.accounting.cash-banking.petty-cash.destroy', $item->petty_cash_id) }}" 
                                                      method="POST" class="inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" 
                                                            class="text-red-600 hover:text-red-900 transition duration-150"
                                                            onclick="return confirm('Are you sure you want to delete this petty cash request?')"
                                                            title="Delete">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            @endif
                                        @endif
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="9" class="px-6 py-4 text-center text-sm text-gray-500">
                                    <div class="flex flex-col items-center justify-center py-8">
                                        <i class="fas fa-money-bill-wave text-4xl text-gray-300 mb-4"></i>
                                        <p class="text-gray-500">No petty cash requests found</p>
                                        <a href="{{ route('admin.accounting.cash-banking.petty-cash.create') }}" 
                                           class="mt-2 text-blue-600 hover:text-blue-700 font-medium transition duration-150">
                                            Create your first petty cash request
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                @if($pettyCash->hasPages())
                <div class="px-6 py-4 border-t border-gray-200">
                    {{ $pettyCash->links() }}
                </div>
                @endif
            </div>
        </main>
    </div>

    <!-- Approve Modal -->
    <div id="approveModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden z-50">
        <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
            <div class="mt-3">
                <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-green-100">
                    <i class="fas fa-check text-green-600 text-xl"></i>
                </div>
                <div class="mt-2 text-center">
                    <h3 class="text-lg font-medium text-gray-900">Approve Petty Cash</h3>
                    <div class="mt-2 px-7 py-3">
                        <p class="text-sm text-gray-500" id="modalText">Approve petty cash request: <strong id="pcNumber"></strong></p>
                        <form id="approveForm" method="POST" class="mt-4">
                            @csrf
                            <div class="text-left">
                                <label for="approval_notes" class="block text-sm font-medium text-gray-700 mb-1">Approval Notes (Optional)</label>
                                <textarea id="approval_notes" name="approval_notes" rows="3" 
                                          class="w-full border border-gray-300 rounded-lg px-3 py-2 text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500"></textarea>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="items-center px-4 py-3 flex justify-center space-x-3">
                    <button id="cancelBtn" class="px-4 py-2 bg-gray-300 text-gray-700 text-base font-medium rounded-lg hover:bg-gray-400 transition duration-150">
                        Cancel
                    </button>
                    <button id="approveBtn" class="px-4 py-2 bg-green-600 text-white text-base font-medium rounded-lg hover:bg-green-700 transition duration-150">
                        Approve
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Reject Modal -->
    <div id="rejectModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden z-50">
        <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
            <div class="mt-3">
                <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-red-100">
                    <i class="fas fa-times text-red-600 text-xl"></i>
                </div>
                <div class="mt-2 text-center">
                    <h3 class="text-lg font-medium text-gray-900">Reject Petty Cash</h3>
                    <div class="mt-2 px-7 py-3">
                        <p class="text-sm text-gray-500" id="rejectModalText">Reject petty cash request: <strong id="rejectPcNumber"></strong></p>
                        <form id="rejectForm" method="POST" class="mt-4">
                            @csrf
                            <div class="text-left">
                                <label for="rejection_reason" class="block text-sm font-medium text-gray-700 mb-1">
                                    Rejection Reason <span class="text-red-500">*</span>
                                </label>
                                <textarea id="rejection_reason" name="rejection_reason" rows="3" required
                                          placeholder="Please provide a reason for rejection..."
                                          class="w-full border border-gray-300 rounded-lg px-3 py-2 text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500"></textarea>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="items-center px-4 py-3 flex justify-center space-x-3">
                    <button id="cancelRejectBtn" class="px-4 py-2 bg-gray-300 text-gray-700 text-base font-medium rounded-lg hover:bg-gray-400 transition duration-150">
                        Cancel
                    </button>
                    <button id="confirmRejectBtn" class="px-4 py-2 bg-red-600 text-white text-base font-medium rounded-lg hover:bg-red-700 transition duration-150">
                        Reject
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Reverse Modal -->
    <div id="reverseModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden z-50">
        <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
            <div class="mt-3">
                <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-red-100">
                    <i class="fas fa-undo text-red-600 text-xl"></i>
                </div>
                <div class="mt-2 text-center">
                    <h3 class="text-lg font-medium text-gray-900">Reverse Transaction</h3>
                    <div class="mt-2 px-7 py-3">
                        <p class="text-sm text-gray-500 mb-4" id="reversePcNumber"></p>
                        <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4 mb-4">
                            <div class="flex">
                                <i class="fas fa-exclamation-triangle text-yellow-500 mr-3 mt-1"></i>
                                <div>
                                    <p class="text-sm font-medium text-yellow-800">Warning!</p>
                                    <p class="text-xs text-yellow-700 mt-1">
                                        This will reverse all accounting entries and restore the account balances.
                                        This action should only be used for correcting errors.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <form id="reverseForm" method="POST" class="mt-4">
                            @csrf
                            <div class="text-left">
                                <label for="reversal_reason" class="block text-sm font-medium text-gray-700 mb-1">
                                    Reversal Reason <span class="text-red-500">*</span>
                                </label>
                                <textarea id="reversal_reason" name="reversal_reason" rows="3" required
                                          placeholder="Explain why you are reversing this transaction..."
                                          class="w-full border border-gray-300 rounded-lg px-3 py-2 text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500"></textarea>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="items-center px-4 py-3 flex justify-center space-x-3">
                    <button id="cancelReverseBtn" class="px-4 py-2 bg-gray-300 text-gray-700 text-base font-medium rounded-lg hover:bg-gray-400 transition duration-150">
                        Cancel
                    </button>
                    <button id="confirmReverseBtn" class="px-4 py-2 bg-red-600 text-white text-base font-medium rounded-lg hover:bg-red-700 transition duration-150">
                        Reverse Transaction
                    </button>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Mobile menu functionality
        const mobileMenuButton = document.getElementById('mobile-menu-button');
        const sidebar = document.getElementById('sidebar');
        
        if (mobileMenuButton && sidebar) {
            mobileMenuButton.addEventListener('click', function() {
                sidebar.classList.toggle('active');
            });
        }

        // Success message handling
        @if(session('success'))
            setTimeout(() => {
                const successAlert = document.querySelector('.bg-green-50');
                if (successAlert) {
                    successAlert.style.display = 'none';
                }
            }, 5000);
        @endif

        @if(session('error'))
            setTimeout(() => {
                const errorAlert = document.querySelector('.bg-red-50');
                if (errorAlert) {
                    errorAlert.style.display = 'none';
                }
            }, 5000);
        @endif

        // Approve modal functionality
        function openApproveModal(pettyCashId) {
            const modal = document.getElementById('approveModal');
            const pcNumber = document.querySelector(`tr:has(a[href*="${pettyCashId}"]) td:first-child .text-sm`).textContent;
            
            document.getElementById('pcNumber').textContent = pcNumber;
            document.getElementById('approveForm').action = `/admin/accounting/cash-banking/petty-cash/${pettyCashId}/approve`;
            modal.classList.remove('hidden');
        }

        document.getElementById('cancelBtn').addEventListener('click', function() {
            document.getElementById('approveModal').classList.add('hidden');
        });

        document.getElementById('approveBtn').addEventListener('click', function() {
            document.getElementById('approveForm').submit();
        });

        // Reject modal functionality
        function openRejectModal(pettyCashId) {
            const modal = document.getElementById('rejectModal');
            const pcNumber = document.querySelector(`tr:has(a[href*="${pettyCashId}"]) td:first-child .text-sm`).textContent;
            
            document.getElementById('rejectPcNumber').textContent = pcNumber;
            document.getElementById('rejectForm').action = `/admin/accounting/cash-banking/petty-cash/${pettyCashId}/reject`;
            modal.classList.remove('hidden');
        }

        document.getElementById('cancelRejectBtn').addEventListener('click', function() {
            document.getElementById('rejectModal').classList.add('hidden');
        });

        document.getElementById('confirmRejectBtn').addEventListener('click', function() {
            const reason = document.getElementById('rejection_reason').value.trim();
            if (!reason) {
                alert('Please provide a rejection reason.');
                return;
            }
            document.getElementById('rejectForm').submit();
        });

        // Reverse modal functionality
        function openReverseModal(pettyCashId) {
            const modal = document.getElementById('reverseModal');
            const pcNumber = document.querySelector(`tr:has(a[href*="${pettyCashId}"]) td:first-child .text-sm`).textContent;
            const status = document.querySelector(`tr:has(a[href*="${pettyCashId}"]) td:nth-child(7) span`).textContent;
            
            document.getElementById('reversePcNumber').innerHTML = `Reverse transaction for: <strong>${pcNumber}</strong> (Current status: ${status})`;
            document.getElementById('reverseForm').action = `/admin/accounting/cash-banking/petty-cash/${pettyCashId}/reverse`;
            modal.classList.remove('hidden');
        }

        document.getElementById('cancelReverseBtn').addEventListener('click', function() {
            document.getElementById('reverseModal').classList.add('hidden');
        });

        document.getElementById('confirmReverseBtn').addEventListener('click', function() {
            const reason = document.getElementById('reversal_reason').value.trim();
            if (!reason) {
                alert('Please provide a reversal reason.');
                return;
            }
            document.getElementById('reverseForm').submit();
        });

        // Close modals when clicking outside
        const modals = ['approveModal', 'rejectModal', 'reverseModal'];
        modals.forEach(modalId => {
            document.getElementById(modalId).addEventListener('click', function(e) {
                if (e.target.id === modalId) {
                    this.classList.add('hidden');
                }
            });
        });
    </script>
</body>
</html>