<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Petty Cash Details | IMMIA FINANCE</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        /* QuickBooks Online Styling - Aligned with create/edit views */
        .quickbooks-input {
            border: 1px solid #8C8C8C;
            border-radius: 4px;
            padding: 8px 12px;
            font-size: 14px;
            color: #323130;
            background: white;
            width: 100%;
            transition: all 0.2s;
        }
        
        .quickbooks-input:focus {
            outline: 2px solid #146CAA;
            outline-offset: -1px;
            border-color: #146CAA;
        }
        
        .quickbooks-input:disabled {
            background-color: #F3F2F1;
            color: #A19F9D;
            cursor: not-allowed;
        }
        
        .quickbooks-select {
            border: 1px solid #8C8C8C;
            border-radius: 4px;
            padding: 8px 12px;
            font-size: 14px;
            color: #323130;
            background: white;
            width: 100%;
            transition: all 0.2s;
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
            background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' viewBox='0 0 24 24' fill='none' stroke='%23605E5C' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'%3E%3Cpath d='m6 9 6 6 6-6'%3E%3C/path%3E%3C/svg%3E");
            background-repeat: no-repeat;
            background-position: right 12px center;
            background-size: 16px;
            padding-right: 36px;
        }
        
        .quickbooks-select:disabled {
            background-color: #F3F2F1;
            color: #A19F9D;
            cursor: not-allowed;
        }
        
        .quickbooks-textarea {
            border: 1px solid #8C8C8C;
            border-radius: 4px;
            padding: 8px 12px;
            font-size: 14px;
            color: #323130;
            background: white;
            width: 100%;
            resize: vertical;
            min-height: 80px;
            transition: all 0.2s;
        }
        
        .quickbooks-textarea:disabled {
            background-color: #F3F2F1;
            color: #A19F9D;
            cursor: not-allowed;
        }
        
        .quickbooks-table {
            border-collapse: separate;
            border-spacing: 0;
            width: 100%;
        }
        
        .quickbooks-table th {
            background-color: #F3F2F1;
            color: #323130;
            font-weight: 600;
            font-size: 13px;
            text-transform: uppercase;
            padding: 12px 16px;
            border-bottom: 1px solid #EDEBE9;
            text-align: left;
        }
        
        .quickbooks-table td {
            padding: 12px 16px;
            border-bottom: 1px solid #EDEBE9;
            font-size: 14px;
            color: #323130;
        }
        
        .quickbooks-table tbody tr:hover {
            background-color: #F3F2F1;
        }
        
        .quickbooks-button-primary {
            background-color: #146CAA;
            color: white;
            border: none;
            border-radius: 4px;
            padding: 8px 16px;
            font-size: 14px;
            font-weight: 500;
            cursor: pointer;
            transition: background-color 0.2s;
        }
        
        .quickbooks-button-primary:hover {
            background-color: #11598C;
        }
        
        .quickbooks-button-primary:disabled {
            background-color: #A19F9D;
            cursor: not-allowed;
        }
        
        .quickbooks-button-secondary {
            background-color: white;
            color: #323130;
            border: 1px solid #8C8C8C;
            border-radius: 4px;
            padding: 8px 16px;
            font-size: 14px;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.2s;
        }
        
        .quickbooks-button-secondary:hover {
            background-color: #F3F2F1;
        }
        
        .quickbooks-label {
            display: block;
            font-size: 14px;
            font-weight: 500;
            color: #323130;
            margin-bottom: 6px;
        }
        
        .quickbooks-field-help {
            display: block;
            font-size: 12px;
            color: #605E5C;
            margin-top: 4px;
        }
        
        .quickbooks-info-box {
            background-color: #F3F2F1;
            border: 1px solid #EDEBE9;
            border-radius: 4px;
            padding: 12px;
            margin-top: 8px;
            font-size: 13px;
            color: #605E5C;
        }
        
        .quickbooks-section {
            border-top: 1px solid #EDEBE9;
            padding-top: 24px;
            margin-top: 24px;
        }
        
        .quickbooks-card {
            background: white;
            border: 1px solid #EDEBE9;
            border-radius: 4px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        }
        
        .quickbooks-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
        }
        
        .quickbooks-badge-success {
            background-color: #E6F4EA;
            color: #107C10;
        }
        
        .quickbooks-badge-warning {
            background-color: #FFF4CE;
            color: #F68C1E;
        }
        
        .quickbooks-badge-error {
            background-color: #FEE;
            color: #D83B01;
        }
        
        .quickbooks-badge-info {
            background-color: #E1F0FA;
            color: #146CAA;
        }
        
        /* Status badge styles */
        .status-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 12px;
            border-radius: 4px;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
        }
        
        .status-draft {
            background-color: #E1F0FA;
            color: #146CAA;
            border: 1px solid #146CAA;
        }
        
        .status-rejected {
            background-color: #FFF4CE;
            color: #F68C1E;
            border: 1px solid #F68C1E;
        }
        
        .status-submitted {
            background-color: #FFF4CE;
            color: #F68C1E;
            border: 1px solid #F68C1E;
        }
        
        .status-approved {
            background-color: #E6F4EA;
            color: #107C10;
            border: 1px solid #107C10;
        }
        
        .status-paid {
            background-color: #E6F4EA;
            color: #107C10;
            border: 1px solid #107C10;
        }
        
        .status-reimbursed {
            background-color: #F3F2F1;
            color: #605E5C;
            border: 1px solid #605E5C;
        }
        
        .status-reversed {
            background-color: #FEE;
            color: #D83B01;
            border: 1px solid #D83B01;
        }
        
        /* Color Variables */
        :root {
            --primary: #146CAA;
            --primary-light: #E1F0FA;
            --success: #107C10;
            --warning: #F68C1E;
            --danger: #D83B01;
            --gray50: #FAF9F8;
            --gray100: #F3F2F1;
            --gray200: #EDEBE9;
            --gray300: #E1DFDD;
            --gray400: #C8C6C4;
            --gray500: #A19F9D;
            --gray600: #605E5C;
            --gray700: #323130;
            --gray900: #000000;
        }
    </style>
</head>
<body class="bg-gray50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        @include('accounting.partials.header', ['title' => 'Petty Cash Details', 'subtitle' => 'View petty cash request information'])

        <main class="p-6">
            <!-- Success/Error Messages -->
            @if(session('success'))
                <div class="mb-6 quickbooks-card p-4 border-l-4 border-success">
                    <div class="flex items-center">
                        <i class="fas fa-check-circle text-success mr-3"></i>
                        <div>
                            <p class="font-medium text-gray900">{{ session('success') }}</p>
                        </div>
                    </div>
                </div>
            @endif

            @if(session('error'))
                <div class="mb-6 quickbooks-card p-4 border-l-4 border-danger">
                    <div class="flex items-center">
                        <i class="fas fa-exclamation-circle text-danger mr-3"></i>
                        <div>
                            <p class="font-medium text-gray900">{{ session('error') }}</p>
                        </div>
                    </div>
                </div>
            @endif

            <!-- Form Container -->
            <div class="max-w-6xl mx-auto">
                <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                    <!-- Main Form -->
                    <div class="lg:col-span-3">
                        <div class="quickbooks-card p-6">
                            <!-- Form Header with Back Button on Right -->
                            <div class="flex items-center justify-between mb-6">
                                <!-- Form Title -->
                                <div class="flex-grow">
                                    <h2 class="text-xl font-semibold text-gray900">
                                        Petty Cash Request Details
                                    </h2>
                                    <p class="text-gray600 text-sm mt-1">View petty cash request information</p>
                                </div>
                                
                                <!-- Back Button on Right -->
                                <a href="{{ route('admin.accounting.cash-banking.petty-cash.index') }}" 
                                   class="quickbooks-button-secondary flex items-center ml-4">
                                    <i class="fas fa-arrow-left mr-2"></i>
                                    Back to List
                                </a>
                            </div>

                            <!-- Status & Amount Summary -->
                            <div class="bg-gray50 border border-gray200 rounded-lg p-4 mb-6">
                                <div class="flex flex-col md:flex-row md:items-center justify-between">
                                    <div>
                                        <span class="status-badge status-{{ strtolower($pettyCash->status) }}">
                                            {{ $pettyCash->status }}
                                        </span>
                                        <span class="ml-3 text-sm text-gray600">
                                            Request #: {{ $pettyCash->petty_cash_number }}
                                        </span>
                                    </div>
                                    <div class="mt-2 md:mt-0 text-right">
                                        <div class="text-lg font-semibold text-gray900">
                                            {{ number_format($pettyCash->amount, 2) }} {{ $pettyCash->currency }}
                                        </div>
                                        <div class="text-xs text-gray500">
                                            Base Amount: {{ number_format($pettyCash->base_amount, 2) }}
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Basic Information Section -->
                            <div>
                                <h3 class="text-lg font-semibold text-gray900 mb-6">Basic Information</h3>
                                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                                    <!-- Petty Cash Number (Readonly) -->
                                    <div>
                                        <label class="quickbooks-label">
                                            Petty Cash Number
                                        </label>
                                        <input type="text" 
                                               value="{{ $pettyCash->petty_cash_number }}" 
                                               readonly
                                               class="quickbooks-input bg-gray100">
                                        <p class="quickbooks-field-help">Auto-generated reference number</p>
                                    </div>

                                    <!-- Transaction Date -->
                                    <div>
                                        <label class="quickbooks-label">
                                            Transaction Date
                                        </label>
                                        <div class="relative">
                                            <input type="text" 
                                                   value="{{ $pettyCash->transaction_date->format('Y-m-d') }}" 
                                                   readonly
                                                   class="quickbooks-input bg-gray100 pl-10">
                                            <i class="fas fa-calendar-alt absolute left-3 top-1/2 transform -translate-y-1/2 text-gray500"></i>
                                        </div>
                                    </div>

                                    <!-- Status (Readonly) -->
                                    <div>
                                        <label class="quickbooks-label">
                                            Status
                                        </label>
                                        <div class="relative">
                                            <input type="text" 
                                                   value="{{ $pettyCash->status }}" 
                                                   readonly
                                                   class="quickbooks-input bg-gray100 pl-10">
                                            <i class="fas fa-info-circle absolute left-3 top-1/2 transform -translate-y-1/2 
                                                @if($pettyCash->status == 'Draft') text-primary
                                                @elseif($pettyCash->status == 'Rejected') text-warning
                                                @elseif($pettyCash->status == 'Submitted') text-warning
                                                @elseif($pettyCash->status == 'Approved') text-success
                                                @elseif($pettyCash->status == 'Paid') text-success
                                                @elseif($pettyCash->status == 'Reimbursed') text-gray600
                                                @elseif($pettyCash->status == 'Reversed') text-danger
                                                @endif"></i>
                                        </div>
                                    </div>
                                </div>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-6">
                                    <!-- Payee -->
                                    <div>
                                        <label class="quickbooks-label">
                                            Payee
                                        </label>
                                        <input type="text" 
                                               value="{{ $pettyCash->payee }}" 
                                               readonly
                                               class="quickbooks-input bg-gray100">
                                    </div>
                                </div>

                                <!-- Description -->
                                <div class="mt-6">
                                    <label class="quickbooks-label">
                                        Description
                                    </label>
                                    <textarea readonly
                                              class="quickbooks-textarea bg-gray100">{{ $pettyCash->description }}</textarea>
                                </div>
                            </div>

                            <!-- Items Section -->
                            <div class="quickbooks-section">
                                <div class="flex justify-between items-center mb-6">
                                    <h3 class="text-lg font-semibold text-gray900">Items to be Purchased</h3>
                                    <span class="text-sm text-gray600">{{ $pettyCash->items->count() }} items</span>
                                </div>
                                
                                <div class="quickbooks-card p-4">
                                    <div class="overflow-x-auto">
                                        <table class="quickbooks-table">
                                            <thead>
                                                <tr>
                                                    <th class="text-sm font-medium text-gray700">Item</th>
                                                    <th class="text-sm font-medium text-gray700">Description</th>
                                                    <th class="text-sm font-medium text-gray700">Amount</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($pettyCash->items as $item)
                                                <tr>
                                                    <td class="py-3">
                                                        <div class="text-sm text-gray900">
                                                            {{ $item->chartOfAccount->name ?? 'N/A' }}
                                                            @if($item->chartOfAccount)
                                                            <span class="text-xs text-gray500">({{ $item->chartOfAccount->code }})</span>
                                                            @endif
                                                        </div>
                                                    </td>
                                                    <td class="py-3">
                                                        <div class="text-sm text-gray900">{{ $item->item_description }}</div>
                                                    </td>
                                                    <td class="py-3">
                                                        <div class="text-sm font-medium text-gray900">
                                                            {{ number_format($item->amount, 2) }} {{ $pettyCash->currency }}
                                                        </div>
                                                    </td>
                                                </tr>
                                                @empty
                                                <tr>
                                                    <td colspan="3" class="py-3 text-center text-sm text-gray500">
                                                        No items found
                                                    </td>
                                                </tr>
                                                @endforelse
                                            </tbody>
                                            <tfoot class="bg-gray100">
                                                <tr>
                                                    <td colspan="2" class="text-right text-sm font-medium text-gray700 py-3">Total Amount:</td>
                                                    <td class="py-3">
                                                        <div class="text-lg font-semibold text-gray900">{{ number_format($pettyCash->amount, 2) }}</div>
                                                        <div class="text-xs text-gray500">Base: {{ number_format($pettyCash->base_amount, 2) }}</div>
                                                    </td>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>

                            <!-- Currency & Exchange Rate Section -->
                            <div class="quickbooks-section">
                                <h3 class="text-lg font-semibold text-gray900 mb-6">Currency & Exchange Rate</h3>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <!-- Currency -->
                                    <div>
                                        <label class="quickbooks-label">
                                            Currency
                                        </label>
                                        <div class="relative">
                                            <input type="text" 
                                                   value="{{ $pettyCash->currency }}" 
                                                   readonly
                                                   class="quickbooks-input bg-gray100 pl-10">
                                            <i class="fas fa-money-bill-wave absolute left-3 top-1/2 transform -translate-y-1/2 text-gray500"></i>
                                        </div>
                                    </div>

                                    <!-- Exchange Rate -->
                                    <div>
                                        <label class="quickbooks-label">
                                            Exchange Rate
                                        </label>
                                        <div class="relative">
                                            <input type="text" 
                                                   value="{{ number_format($pettyCash->exchange_rate, 4) }}" 
                                                   readonly
                                                   class="quickbooks-input bg-gray100 pr-20">
                                            <div class="absolute right-3 top-1/2 transform -translate-y-1/2 text-sm text-gray600">
                                                1 {{ $reportingCurrency?->code ?? 'USD' }} = 
                                            </div>
                                        </div>
                                        <p class="quickbooks-field-help">
                                            Base currency: {{ $reportingCurrency?->code ?? 'USD' }}
                                        </p>
                                    </div>
                                </div>
                            </div>

                            <!-- Payment Information Section -->
                            <div class="quickbooks-section">
                                <h3 class="text-lg font-semibold text-gray900 mb-6">Payment Information</h3>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <!-- Source Account -->
                                    <div>
                                        <label class="quickbooks-label">
                                            Source Account
                                        </label>
                                        <div class="relative">
                                            <input type="text" 
                                                   value="{{ $pettyCash->sourceAccount->accountType }} - {{ $pettyCash->sourceAccount->accountName }} ({{ $pettyCash->sourceAccount->currency }})" 
                                                   readonly
                                                   class="quickbooks-input bg-gray100 pl-10">
                                            <i class="fas fa-university absolute left-3 top-1/2 transform -translate-y-1/2 text-gray500"></i>
                                        </div>
                                        <div class="mt-3 quickbooks-info-box">
                                            <div class="flex items-center justify-between">
                                                <span class="text-sm text-gray600">Available Balance:</span>
                                                <span class="text-sm font-medium text-gray900">{{ number_format($pettyCash->sourceAccount->current_balance, 2) }}</span>
                                                <span class="text-sm text-gray600">{{ $pettyCash->sourceAccount->currency }}</span>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Receipting Account -->
                                    <div>
                                        <label class="quickbooks-label">
                                            Receipting Account
                                        </label>
                                        <div class="relative">
                                            <input type="text" 
                                                   value="{{ $pettyCash->receiptingAccount->accountType ?? '' }} - {{ $pettyCash->receiptingAccount->accountName ?? 'N/A' }} ({{ $pettyCash->receiptingAccount->currency ?? '' }})" 
                                                   readonly
                                                   class="quickbooks-input bg-gray100 pl-10">
                                            <i class="fas fa-receipt absolute left-3 top-1/2 transform -translate-y-1/2 text-gray500"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Audit Information Section -->
                            <div class="quickbooks-section">
                                <h3 class="text-lg font-semibold text-gray900 mb-6">Audit Information</h3>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div>
                                        <label class="quickbooks-label">Requested By</label>
                                        <div class="relative">
                                            <input type="text" 
                                                   value="{{ $pettyCash->requester->name ?? 'N/A' }}" 
                                                   readonly
                                                   class="quickbooks-input bg-gray100 pl-10">
                                            <i class="fas fa-user absolute left-3 top-1/2 transform -translate-y-1/2 text-gray500"></i>
                                        </div>
                                        <p class="quickbooks-field-help">
                                            {{ $pettyCash->created_at->format('M d, Y H:i') }}
                                        </p>
                                    </div>

                                    @if($pettyCash->approved_by)
                                    <div>
                                        <label class="quickbooks-label">Approved By</label>
                                        <div class="relative">
                                            <input type="text" 
                                                   value="{{ $pettyCash->approver->name ?? 'N/A' }}" 
                                                   readonly
                                                   class="quickbooks-input bg-gray100 pl-10">
                                            <i class="fas fa-check-circle absolute left-3 top-1/2 transform -translate-y-1/2 text-success"></i>
                                        </div>
                                        <p class="quickbooks-field-help">
                                            {{ $pettyCash->approved_at->format('M d, Y H:i') }}
                                        </p>
                                    </div>
                                    @endif
                                </div>

                                <!-- Notes Section -->
                                <div class="mt-6 space-y-4">
                                    @if($pettyCash->approval_notes)
                                    <div>
                                        <label class="quickbooks-label">Approval Notes</label>
                                        <textarea readonly
                                                  class="quickbooks-textarea bg-gray100">{{ $pettyCash->approval_notes }}</textarea>
                                    </div>
                                    @endif

                                    @if($pettyCash->rejection_reason)
                                    <div>
                                        <label class="quickbooks-label">Rejection Reason</label>
                                        <textarea readonly
                                                  class="quickbooks-textarea bg-gray100 border-l-4 border-danger">{{ $pettyCash->rejection_reason }}</textarea>
                                    </div>
                                    @endif

                                    @if($pettyCash->reversal_reason)
                                    <div>
                                        <label class="quickbooks-label">Reversal Reason</label>
                                        <textarea readonly
                                                  class="quickbooks-textarea bg-gray100 border-l-4 border-warning">{{ $pettyCash->reversal_reason }}</textarea>
                                    </div>
                                    @endif
                                </div>
                            </div>

                            <!-- Action Buttons -->
                            <div class="border-t border-gray200 pt-6 mt-6">
                                <div class="flex justify-between items-center">
                                    <div class="flex space-x-3">
                                        @if($pettyCash->canEdit())
                                            <a href="{{ route('admin.accounting.cash-banking.petty-cash.edit', $pettyCash->petty_cash_id) }}" 
                                               class="quickbooks-button-primary flex items-center">
                                                <i class="fas fa-edit mr-2"></i>
                                                Edit Request
                                            </a>
                                        @endif
                                        
                                        @if($pettyCash->status === 'Draft')
                                            <form action="{{ route('admin.accounting.cash-banking.petty-cash.submit', $pettyCash->petty_cash_id) }}" 
                                                  method="POST" class="inline">
                                                @csrf
                                                <button type="submit" 
                                                        class="quickbooks-button-secondary flex items-center">
                                                    <i class="fas fa-paper-plane mr-2"></i>
                                                    Submit for Approval
                                                </button>
                                            </form>
                                        @endif
                                    </div>
                                    
                                    <div class="flex space-x-3">
                                        @if($pettyCash->status === 'Submitted')
                                            <button type="button" 
                                                    onclick="openApproveModal()"
                                                    class="quickbooks-button-primary flex items-center">
                                                <i class="fas fa-check mr-2"></i>
                                                Approve
                                            </button>
                                            <button type="button" 
                                                    onclick="openRejectModal()"
                                                    class="quickbooks-button-secondary flex items-center border-danger text-danger">
                                                <i class="fas fa-times mr-2"></i>
                                                Reject
                                            </button>
                                        @endif
                                        
                                        @if($pettyCash->status === 'Approved')
                                            <form action="{{ route('admin.accounting.cash-banking.petty-cash.mark-paid', $pettyCash->petty_cash_id) }}" 
                                                  method="POST" class="inline">
                                                @csrf
                                                <button type="submit" 
                                                        class="quickbooks-button-primary flex items-center">
                                                    <i class="fas fa-money-bill-wave mr-2"></i>
                                                    Mark as Paid
                                                </button>
                                            </form>
                                        @endif
                                        
                                        @if($pettyCash->status === 'Paid')
                                            <form action="{{ route('admin.accounting.cash-banking.petty-cash.reimburse', $pettyCash->petty_cash_id) }}" 
                                                  method="POST" class="inline">
                                                @csrf
                                                <button type="submit" 
                                                        class="quickbooks-button-secondary flex items-center">
                                                    <i class="fas fa-exchange-alt mr-2"></i>
                                                    Reimburse
                                                </button>
                                            </form>
                                        @endif
                                        
                                        @if($pettyCash->canReverse())
                                            <button type="button" 
                                                    onclick="openReverseModal()"
                                                    class="quickbooks-button-secondary flex items-center border-danger text-danger">
                                                <i class="fas fa-undo mr-2"></i>
                                                Reverse
                                            </button>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <!-- Approve Modal -->
    <div id="approveModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden z-50">
        <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
            <div class="mt-3">
                <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-green-100">
                    <i class="fas fa-check text-green-600 text-xl"></i>
                </div>
                <div class="mt-2 text-center">
                    <h3 class="text-lg font-medium text-gray-900">Approve Petty Cash</h3>
                    <div class="mt-2 px-7 py-3">
                        <p class="text-sm text-gray-500">Approve petty cash request: <strong>{{ $pettyCash->petty_cash_number }}</strong></p>
                        <form id="approveForm" method="POST" action="{{ route('admin.accounting.cash-banking.petty-cash.approve', $pettyCash->petty_cash_id) }}" class="mt-4">
                            @csrf
                            <div class="text-left">
                                <label for="approval_notes" class="quickbooks-label">Approval Notes (Optional)</label>
                                <textarea id="approval_notes" name="approval_notes" rows="3" 
                                          class="quickbooks-textarea"></textarea>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="items-center px-4 py-3 flex justify-center space-x-3">
                    <button onclick="closeApproveModal()" class="quickbooks-button-secondary">
                        Cancel
                    </button>
                    <button onclick="document.getElementById('approveForm').submit()" class="quickbooks-button-primary">
                        Approve
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Reject Modal -->
    <div id="rejectModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden z-50">
        <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
            <div class="mt-3">
                <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-red-100">
                    <i class="fas fa-times text-red-600 text-xl"></i>
                </div>
                <div class="mt-2 text-center">
                    <h3 class="text-lg font-medium text-gray-900">Reject Petty Cash</h3>
                    <div class="mt-2 px-7 py-3">
                        <p class="text-sm text-gray-500">Reject petty cash request: <strong>{{ $pettyCash->petty_cash_number }}</strong></p>
                        <form id="rejectForm" method="POST" action="{{ route('admin.accounting.cash-banking.petty-cash.reject', $pettyCash->petty_cash_id) }}" class="mt-4">
                            @csrf
                            <div class="text-left">
                                <label for="rejection_reason" class="quickbooks-label">Rejection Reason <span class="text-danger">*</span></label>
                                <textarea id="rejection_reason" name="rejection_reason" rows="3" required
                                          class="quickbooks-textarea"></textarea>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="items-center px-4 py-3 flex justify-center space-x-3">
                    <button onclick="closeRejectModal()" class="quickbooks-button-secondary">
                        Cancel
                    </button>
                    <button onclick="submitRejectForm()" class="quickbooks-button-secondary border-danger text-danger">
                        Reject
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Reverse Modal -->
    <div id="reverseModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden z-50">
        <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
            <div class="mt-3">
                <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-red-100">
                    <i class="fas fa-undo text-red-600 text-xl"></i>
                </div>
                <div class="mt-2 text-center">
                    <h3 class="text-lg font-medium text-gray-900">Reverse Transaction</h3>
                    <div class="mt-2 px-7 py-3">
                        <p class="text-sm text-gray-500 mb-4">Reverse transaction for: <strong>{{ $pettyCash->petty_cash_number }}</strong></p>
                        <div class="quickbooks-info-box border-warning">
                            <div class="flex">
                                <i class="fas fa-exclamation-triangle text-warning mr-3 mt-1"></i>
                                <div>
                                    <p class="text-sm font-medium text-gray900">Warning!</p>
                                    <p class="text-xs text-gray600 mt-1">
                                        This will reverse all accounting entries and restore the account balances.
                                        This action should only be used for correcting errors.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <form id="reverseForm" method="POST" action="{{ route('admin.accounting.cash-banking.petty-cash.reverse', $pettyCash->petty_cash_id) }}" class="mt-4">
                            @csrf
                            <div class="text-left">
                                <label for="reversal_reason" class="quickbooks-label">
                                    Reversal Reason <span class="text-danger">*</span>
                                </label>
                                <textarea id="reversal_reason" name="reversal_reason" rows="3" required
                                          placeholder="Explain why you are reversing this transaction..."
                                          class="quickbooks-textarea"></textarea>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="items-center px-4 py-3 flex justify-center space-x-3">
                    <button onclick="closeReverseModal()" class="quickbooks-button-secondary">
                        Cancel
                    </button>
                    <button onclick="submitReverseForm()" class="quickbooks-button-secondary border-danger text-danger">
                        Reverse Transaction
                    </button>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Mobile menu functionality
        const mobileMenuButton = document.getElementById('mobile-menu-button');
        const sidebar = document.getElementById('sidebar');
        
        if (mobileMenuButton && sidebar) {
            mobileMenuButton.addEventListener('click', function() {
                sidebar.classList.toggle('active');
            });
        }

        // Modal Functions
        function openApproveModal() {
            document.getElementById('approveModal').classList.remove('hidden');
        }

        function closeApproveModal() {
            document.getElementById('approveModal').classList.add('hidden');
        }

        function openRejectModal() {
            document.getElementById('rejectModal').classList.remove('hidden');
        }

        function closeRejectModal() {
            document.getElementById('rejectModal').classList.add('hidden');
        }

        function submitRejectForm() {
            const reason = document.getElementById('rejection_reason').value.trim();
            if (!reason) {
                alert('Please provide a rejection reason.');
                return;
            }
            document.getElementById('rejectForm').submit();
        }

        function openReverseModal() {
            document.getElementById('reverseModal').classList.remove('hidden');
        }

        function closeReverseModal() {
            document.getElementById('reverseModal').classList.add('hidden');
        }

        function submitReverseForm() {
            const reason = document.getElementById('reversal_reason').value.trim();
            if (!reason) {
                alert('Please provide a reversal reason.');
                return;
            }
            document.getElementById('reverseForm').submit();
        }

        // Close modals when clicking outside
        document.getElementById('approveModal').addEventListener('click', function(e) {
            if (e.target.id === 'approveModal') {
                closeApproveModal();
            }
        });

        document.getElementById('rejectModal').addEventListener('click', function(e) {
            if (e.target.id === 'rejectModal') {
                closeRejectModal();
            }
        });

        document.getElementById('reverseModal').addEventListener('click', function(e) {
            if (e.target.id === 'reverseModal') {
                closeReverseModal();
            }
        });

        // Success message timeout
        @if(session('success') || session('error'))
            setTimeout(() => {
                const alerts = document.querySelectorAll('.quickbooks-card.border-l-4');
                alerts.forEach(alert => {
                    alert.style.display = 'none';
                });
            }, 5000);
        @endif
    </script>
</body>
</html>