<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Account | IMMIA FINANCE</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        @include('accounting.partials.header', ['title' => 'Create New Account', 'subtitle' => 'Add a new account to chart of accounts'])

        <main class="p-6">
            <div class="max-w-4xl mx-auto">
                <!-- Success/Error Messages -->
                @if(session('success'))
                    <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4">
                        <div class="flex items-center">
                            <i class="fas fa-check-circle text-green-500 mr-2"></i>
                            <span class="text-green-800 font-semibold">{{ session('success') }}</span>
                        </div>
                    </div>
                @endif

                @if(session('error'))
                    <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4">
                        <div class="flex items-center">
                            <i class="fas fa-exclamation-circle text-red-500 mr-2"></i>
                            <span class="text-red-800 font-semibold">{{ session('error') }}</span>
                        </div>
                    </div>
                @endif

                <div class="bg-white rounded-xl shadow-sm border">
                    <div class="p-6 border-b border-gray-200">
                        <h2 class="text-xl font-bold text-gray-900">Account Information</h2>
                        <p class="text-gray-600">Fill in the details for the new account</p>
                    </div>

                    <form action="{{ route('admin.accounting.chart-of-accounts.store') }}" method="POST" class="p-6" id="accountForm">
                        @csrf

                        <!-- Validation Errors -->
                        @if($errors->any())
                            <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4">
                                <div class="flex items-center">
                                    <i class="fas fa-exclamation-circle text-red-500 mr-2"></i>
                                    <h3 class="text-red-800 font-semibold">Please fix the following errors:</h3>
                                </div>
                                <ul class="mt-2 list-disc list-inside text-red-600">
                                    @foreach($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Account Code -->
                            <div>
                                <label for="code" class="block text-sm font-medium text-gray-700 mb-2">Account Code *</label>
                                <input type="text" 
                                       name="code" 
                                       id="code"
                                       value="{{ old('code') }}"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                                       placeholder="e.g., 1001"
                                       required>
                                @error('code')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <!-- Account Name -->
                            <div>
                                <label for="name" class="block text-sm font-medium text-gray-700 mb-2">Account Name *</label>
                                <input type="text" 
                                       name="name" 
                                       id="name"
                                       value="{{ old('name') }}"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                                       placeholder="e.g., Cash in Bank"
                                       required>
                                @error('name')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <!-- Account Type -->
                            <div>
                                <label for="account_type_id" class="block text-sm font-medium text-gray-700 mb-2">Account Type *</label>
                                <select name="account_type_id" 
                                        id="account_type_id"
                                        class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                                        required>
                                    <option value="">Select Account Type</option>
                                    @foreach($accountTypes as $type)
                                        <option value="{{ $type->id }}" 
                                                data-account-group="{{ $type->accountGroup->name ?? 'N/A' }}"
                                                data-normal-balance="{{ $type->normal_balance ?? 'debit' }}"
                                                {{ old('account_type_id') == $type->id ? 'selected' : '' }}>
                                            {{ $type->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('account_type_id')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <!-- Account Group (Read-only) -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Account Group</label>
                                <input type="text" 
                                       id="account_group_display"
                                       value="Select an Account Type first"
                                       readonly
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg bg-gray-50 text-gray-500 cursor-not-allowed">
                                <small class="text-gray-400">Automatically determined by Account Type</small>
                            </div>

                            <!-- Normal Balance (Read-only) -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Normal Balance</label>
                                <input type="text" 
                                       id="normal_balance_display"
                                       value="Select an Account Type first"
                                       readonly
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg bg-gray-50 text-gray-500 cursor-not-allowed">
                                <small class="text-gray-400">Automatically determined by Account Type</small>
                            </div>

                            <!-- Opening Balance -->
                            <div>
                                <label for="opening_balance" class="block text-sm font-medium text-gray-700 mb-2">Opening Balance *</label>
                                <input type="number" 
                                       name="opening_balance" 
                                       id="opening_balance"
                                       value="{{ old('opening_balance', 0) }}"
                                       step="0.01"
                                       min="0"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                                       placeholder="0.00"
                                       required>
                                @error('opening_balance')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <!-- Description -->
                            <div class="md:col-span-2">
                                <label for="description" class="block text-sm font-medium text-gray-700 mb-2">Description</label>
                                <textarea name="description" 
                                          id="description"
                                          rows="3"
                                          class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                                          placeholder="Optional account description">{{ old('description') }}</textarea>
                                @error('description')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <!-- Status -->
                            <div class="md:col-span-2">
                                <div class="flex items-center">
                                    <input type="checkbox" 
                                           name="is_active" 
                                           id="is_active"
                                           value="1"
                                           {{ old('is_active', true) ? 'checked' : '' }}
                                           class="w-4 h-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                                    <label for="is_active" class="ml-2 block text-sm text-gray-700">
                                        Account is active
                                    </label>
                                </div>
                                @error('is_active')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>

                        <!-- Form Actions -->
                        <div class="mt-8 flex justify-end space-x-3">
                            <a href="{{ route('admin.accounting.chart-of-accounts.index') }}" 
                               class="px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition duration-150">
                                Cancel
                            </a>
                            <button type="submit" 
                                    id="submitBtn"
                                    class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 transition duration-150 flex items-center">
                                <i class="fas fa-plus mr-2"></i>
                                Create Account
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </main>
    </div>

    <script>
        // Mobile menu functionality
        const mobileMenuButton = document.getElementById('mobile-menu-button');
        const sidebar = document.getElementById('sidebar');
        
        if (mobileMenuButton && sidebar) {
            mobileMenuButton.addEventListener('click', function() {
                sidebar.classList.toggle('active');
            });
        }

        // Account Type change handler
        const accountTypeSelect = document.getElementById('account_type_id');
        const accountGroupDisplay = document.getElementById('account_group_display');
        const normalBalanceDisplay = document.getElementById('normal_balance_display');

        accountTypeSelect.addEventListener('change', function() {
            const selectedOption = this.options[this.selectedIndex];
            const accountGroup = selectedOption.getAttribute('data-account-group');
            const normalBalance = selectedOption.getAttribute('data-normal-balance');
            
            accountGroupDisplay.value = accountGroup || 'N/A';
            normalBalanceDisplay.value = normalBalance ? normalBalance.charAt(0).toUpperCase() + normalBalance.slice(1) : 'N/A';
        });

        // Initialize displays if there are old values
        document.addEventListener('DOMContentLoaded', function() {
            if (accountTypeSelect.value) {
                const selectedOption = accountTypeSelect.options[accountTypeSelect.selectedIndex];
                const accountGroup = selectedOption.getAttribute('data-account-group');
                const normalBalance = selectedOption.getAttribute('data-normal-balance');
                
                accountGroupDisplay.value = accountGroup || 'N/A';
                normalBalanceDisplay.value = normalBalance ? normalBalance.charAt(0).toUpperCase() + normalBalance.slice(1) : 'N/A';
            }
        });

        // Form validation and submission
        document.getElementById('accountForm').addEventListener('submit', function(e) {
            const submitBtn = document.getElementById('submitBtn');
            const code = document.getElementById('code').value.trim();
            const name = document.getElementById('name').value.trim();
            const accountTypeId = document.getElementById('account_type_id').value;
            const openingBalance = document.getElementById('opening_balance').value;

            // Basic validation
            if (!code || !name || !accountTypeId || openingBalance === '') {
                e.preventDefault();
                alert('Please fill in all required fields.');
                return false;
            }

            // Show loading state
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i> Creating...';
        });
    </script>
</body>
</html>