<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Company Profile | IMMIA FINANCE</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        @include('accounting.partials.header', [
            'title' => 'Company Profile', 
            'subtitle' => 'Manage company information and reporting settings'
        ])

        <main class="p-6">
            <!-- Success/Error Messages -->
            @if(session('success'))
                <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-check-circle text-green-500 mr-2"></i>
                        <span class="text-green-800 font-semibold">{{ session('success') }}</span>
                    </div>
                </div>
            @endif

            @if(session('error'))
                <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-exclamation-circle text-red-500 mr-2"></i>
                        <span class="text-red-800 font-semibold">{{ session('error') }}</span>
                    </div>
                </div>
            @endif

            <!-- Vertical Layout Container -->
            <div class="space-y-6">
                
                <!-- Company Information Card -->
                <div class="bg-white rounded-xl shadow-sm border">
                    <div class="p-6 border-b border-gray-200">
                        <div class="flex items-center justify-between">
                            <h2 class="text-xl font-bold text-gray-900">Company Information</h2>
                            <button onclick="toggleEditForm()" class="text-blue-600 hover:text-blue-800 font-medium">
                                <i class="fas fa-edit mr-1"></i> Edit Profile
                            </button>
                        </div>
                    </div>
                    
                    <div class="p-6">
                        <!-- View Mode -->
                        <div id="viewMode">
                            <div class="flex flex-col md:flex-row md:items-start space-y-6 md:space-y-0 md:space-x-6">
                                <!-- Company Logo in View Mode -->
                                <div class="flex-shrink-0">
                                    <div class="w-32 h-32 rounded-lg border border-gray-200 overflow-hidden bg-gray-100 relative group">
                                        <img src="{{ $company->logo_url }}" alt="Company Logo" 
                                             class="w-full h-full object-cover">
                                        @if($company->hasLogo())
                                            <div class="absolute inset-0 bg-black bg-opacity-50 opacity-0 group-hover:opacity-100 transition-opacity flex items-center justify-center">
                                                <a href="{{ $company->logo_url }}" target="_blank" 
                                                   class="text-white hover:text-blue-300 mr-3" title="View Full Size">
                                                    <i class="fas fa-expand"></i>
                                                </a>
                                                <a href="{{ $company->logo_url }}" download 
                                                   class="text-white hover:text-green-300" title="Download Logo">
                                                    <i class="fas fa-download"></i>
                                                </a>
                                            </div>
                                        @endif
                                    </div>
                                    @if($company->hasLogo())
                                        <p class="text-xs text-gray-500 text-center mt-2">
                                            Click edit to change logo
                                        </p>
                                    @endif
                                </div>
                                
                                <!-- Company Details -->
                                <div class="flex-1">
                                    <h3 class="text-2xl font-bold text-gray-900 mb-2">{{ $company->name }}</h3>
                                    
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
                                        <div>
                                            <p class="text-sm font-medium text-gray-500">Company Email</p>
                                            <p class="text-gray-900">{{ $company->email }}</p>
                                        </div>
                                        <div>
                                            <p class="text-sm font-medium text-gray-500">Phone Number</p>
                                            <p class="text-gray-900">{{ $company->phone ?? 'Not set' }}</p>
                                        </div>
                                        <div>
                                            <p class="text-sm font-medium text-gray-500">Address</p>
                                            <p class="text-gray-900">{{ $company->formatted_address }}</p>
                                        </div>
                                        <div>
                                            <p class="text-sm font-medium text-gray-500">Industry</p>
                                            <p class="text-gray-900">{{ $company->industry ?? 'Not specified' }}</p>
                                        </div>
                                        <div>
                                            <p class="text-sm font-medium text-gray-500">Company Size</p>
                                            <p class="text-gray-900">{{ $company->company_size }} employees</p>
                                        </div>
                                        <div>
                                            <p class="text-sm font-medium text-gray-500">Website</p>
                                            <p class="text-gray-900">
                                                @if($company->website)
                                                    <a href="{{ $company->website }}" target="_blank" class="text-blue-600 hover:text-blue-800">
                                                        {{ $company->website }}
                                                    </a>
                                                @else
                                                    Not set
                                                @endif
                                            </p>
                                        </div>
                                        <div>
                                            <p class="text-sm font-medium text-gray-500">Contact Person</p>
                                            <p class="text-gray-900">{{ $company->contact_person ?? 'Not set' }}</p>
                                        </div>
                                        <div>
                                            <p class="text-sm font-medium text-gray-500">Contact Email</p>
                                            <p class="text-gray-900">{{ $company->contact_person_email ?? 'Not set' }}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Edit Mode (Hidden by default) -->
                        <div id="editMode" class="hidden">
                            <form action="{{ route('admin.accounting.company.update-profile') }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="space-y-4">
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-1">Company Name *</label>
                                            <input type="text" name="name" value="{{ old('name', $company->name) }}" 
                                                   class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-blue-500 focus:border-blue-500" required>
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-1">Company Email *</label>
                                            <input type="email" name="email" value="{{ old('email', $company->email) }}" 
                                                   class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-blue-500 focus:border-blue-500" required>
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-1">Phone Number</label>
                                            <input type="text" name="phone" value="{{ old('phone', $company->phone) }}" 
                                                   class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-1">Country *</label>
                                            <input type="text" name="country" value="{{ old('country', $company->country) }}" 
                                                   class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-blue-500 focus:border-blue-500" required>
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-1">Address</label>
                                            <textarea name="address" rows="2" class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-blue-500 focus:border-blue-500">{{ old('address', $company->address) }}</textarea>
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-1">Town/City</label>
                                            <input type="text" name="town" value="{{ old('town', $company->town) }}" 
                                                   class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-1">Postal Code</label>
                                            <input type="text" name="postal_code" value="{{ old('postal_code', $company->postal_code) }}" 
                                                   class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-1">Industry</label>
                                            <input type="text" name="industry" value="{{ old('industry', $company->industry) }}" 
                                                   class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-1">Website</label>
                                            <input type="url" name="website" value="{{ old('website', $company->website) }}" 
                                                   class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-1">Company Size *</label>
                                            <select name="company_size" class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-blue-500 focus:border-blue-500" required>
                                                <option value="1-10" {{ $company->company_size == '1-10' ? 'selected' : '' }}>1-10 employees</option>
                                                <option value="11-50" {{ $company->company_size == '11-50' ? 'selected' : '' }}>11-50 employees</option>
                                                <option value="51-200" {{ $company->company_size == '51-200' ? 'selected' : '' }}>51-200 employees</option>
                                                <option value="201-500" {{ $company->company_size == '201-500' ? 'selected' : '' }}>201-500 employees</option>
                                                <option value="500+" {{ $company->company_size == '500+' ? 'selected' : '' }}>500+ employees</option>
                                            </select>
                                        </div>
                                        
                                        <!-- Company Logo Section -->
                                        <div class="md:col-span-2">
                                            <label class="block text-sm font-medium text-gray-700 mb-1">Company Logo</label>
                                            
                                            <!-- Current Logo Preview -->
                                            @if($company->hasLogo())
                                                <div class="mb-4">
                                                    <p class="text-sm text-gray-600 mb-2">Current Logo:</p>
                                                    <div class="flex items-center space-x-4">
                                                        <div class="w-32 h-32 rounded-lg border border-gray-200 overflow-hidden bg-gray-100">
                                                            <img src="{{ $company->logo_url }}" alt="Current Company Logo" 
                                                                 class="w-full h-full object-cover" id="currentLogoPreview">
                                                        </div>
                                                        <div>
                                                            <button type="button" onclick="removeLogo()" 
                                                                    class="text-red-600 hover:text-red-800 text-sm font-medium">
                                                                <i class="fas fa-trash mr-1"></i> Remove Logo
                                                            </button>
                                                            <input type="hidden" name="remove_logo" id="removeLogo" value="0">
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif
                                            
                                            <!-- Logo Upload Area -->
                                            <div class="border-2 border-dashed border-gray-300 rounded-lg p-6 text-center hover:border-gray-400 transition-colors"
                                                 onclick="document.getElementById('logoUpload').click()"
                                                 style="cursor: pointer;"
                                                 id="logoUploadContainer">
                                                <div id="logoUploadArea">
                                                    <i class="fas fa-cloud-upload-alt text-4xl text-gray-400 mb-3"></i>
                                                    <p class="text-sm text-gray-600 mb-1">
                                                        <span class="font-medium text-blue-600">Click to upload</span> or drag and drop
                                                    </p>
                                                    <p class="text-xs text-gray-500">
                                                        PNG, JPG, GIF, SVG up to 5MB
                                                    </p>
                                                    <input type="file" name="company_logo" id="logoUpload" 
                                                           accept="image/*" 
                                                           class="hidden" 
                                                           onchange="previewLogo(event)">
                                                </div>
                                                
                                                <!-- New Logo Preview -->
                                                <div id="newLogoPreview" class="hidden mt-4">
                                                    <p class="text-sm text-gray-600 mb-2">New Logo Preview:</p>
                                                    <div class="w-32 h-32 rounded-lg border border-gray-200 overflow-hidden bg-gray-100 mx-auto">
                                                        <img id="logoPreview" alt="New Logo Preview" class="w-full h-full object-cover">
                                                    </div>
                                                    <button type="button" onclick="cancelLogoUpload()" 
                                                            class="mt-2 text-red-600 hover:text-red-800 text-sm font-medium">
                                                        <i class="fas fa-times mr-1"></i> Cancel Upload
                                                    </button>
                                                </div>
                                            </div>
                                            
                                            <!-- Error Message -->
                                            @error('company_logo')
                                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                            @enderror
                                        </div>
                                        
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-1">Contact Person</label>
                                            <input type="text" name="contact_person" value="{{ old('contact_person', $company->contact_person) }}" 
                                                   class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-1">Contact Person Email</label>
                                            <input type="email" name="contact_person_email" value="{{ old('contact_person_email', $company->contact_person_email) }}" 
                                                   class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                                        </div>
                                    </div>
                                    
                                    <div class="flex justify-end space-x-3 pt-4">
                                        <button type="button" onclick="toggleEditForm()" 
                                                class="px-6 py-2 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 font-medium">
                                            Cancel
                                        </button>
                                        <button type="submit" 
                                                class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 font-medium">
                                            Save Changes
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                
                <!-- Settings History Card -->
                <div class="bg-white rounded-xl shadow-sm border">
                    <div class="p-6 border-b border-gray-200">
                        <div class="flex items-center justify-between">
                            <h2 class="text-xl font-bold text-gray-900">Recent Settings Changes</h2>
                            <a href="{{ route('admin.accounting.company.history') }}" class="text-blue-600 hover:text-blue-800 font-medium text-sm">
                                View All History
                            </a>
                        </div>
                    </div>
                    
                    <div class="p-6">
                        @if($settingsHistory->count() > 0)
                            <div class="space-y-4">
                                @foreach($settingsHistory as $history)
                                    <div class="flex items-start space-x-4 p-3 bg-gray-50 rounded-lg">
                                        <div class="flex-shrink-0 w-10 h-10 bg-blue-100 rounded-full flex items-center justify-center">
                                            @if($history->setting_type == 'reporting_currency')
                                                <i class="fas fa-money-bill-wave text-blue-600"></i>
                                            @else
                                                <i class="fas fa-calendar-alt text-blue-600"></i>
                                            @endif
                                        </div>
                                        <div class="flex-1">
                                            <div class="flex items-center justify-between">
                                                <p class="font-medium text-gray-900">{{ $history->setting_type_label }}</p>
                                                <span class="text-xs text-gray-500">{{ $history->created_at->format('M d, Y h:i A') }}</span>
                                            </div>
                                            <p class="text-sm text-gray-600 mt-1">{{ $history->change_description }}</p>
                                            @if($history->reason)
                                                <p class="text-xs text-gray-500 mt-1">Reason: {{ $history->reason }}</p>
                                            @endif
                                            <p class="text-xs text-gray-500 mt-1">Changed by: {{ $history->changedBy->name ?? 'System' }}</p>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @else
                            <div class="text-center py-8">
                                <i class="fas fa-history text-4xl text-gray-300 mb-4"></i>
                                <p class="text-gray-500">No settings changes recorded yet</p>
                            </div>
                        @endif
                    </div>
                </div>
                
                <!-- Reporting Currency Card -->
                <div class="bg-white rounded-xl shadow-sm border">
                    <div class="p-6 border-b border-gray-200">
                        <h2 class="text-xl font-bold text-gray-900">Reporting Currency</h2>
                        <p class="text-sm text-gray-600 mt-1">Set your default currency for financial reporting</p>
                    </div>
                    
                    <div class="p-6">
                        <div class="mb-4">
                            <p class="text-sm font-medium text-gray-700 mb-1">Current Reporting Currency</p>
                            <p class="text-lg font-semibold text-gray-900">
                                {{ $company->reportingCurrencyName }}
                            </p>
                        </div>
                        
                        <form action="{{ route('admin.accounting.company.update-currency') }}" method="POST">
                            @csrf
                            <div class="space-y-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Select New Currency</label>
                                    <select name="currency_id" class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-blue-500 focus:border-blue-500" required>
                                        <option value="">Choose a currency</option>
                                        @foreach($currencies as $currency)
                                            <option value="{{ $currency->id }}" {{ $company->reporting_currency_id == $currency->id ? 'selected' : '' }}>
                                                {{ $currency->code }} - {{ $currency->name }} ({{ $currency->symbol }})
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Reason for Change (Optional)</label>
                                    <textarea name="reason" rows="2" placeholder="Why are you changing the reporting currency?" 
                                              class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-blue-500 focus:border-blue-500"></textarea>
                                </div>
                                
                                <button type="submit" class="w-full bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 font-medium transition-colors">
                                    Update Reporting Currency
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
                
                <!-- Financial Year Card -->
                <div class="bg-white rounded-xl shadow-sm border">
                    <div class="p-6 border-b border-gray-200">
                        <h2 class="text-xl font-bold text-gray-900">Current Financial Year</h2>
                        <p class="text-sm text-gray-600 mt-1">Set the active financial year for reporting</p>
                    </div>
                    
                    <div class="p-6">
                        <div class="mb-4">
                            <p class="text-sm font-medium text-gray-700 mb-1">Current Financial Year</p>
                            <p class="text-lg font-semibold text-gray-900">
                                {{ $company->currentFinancialYearName }}
                            </p>
                        </div>
                        
                        <form action="{{ route('admin.accounting.company.update-financial-year') }}" method="POST">
                            @csrf
                            <div class="space-y-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Select Financial Year</label>
                                    <select name="financial_year_id" class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-blue-500 focus:border-blue-500" required>
                                        <option value="">Choose a financial year</option>
                                        @foreach($financialYears as $year)
                                            <option value="{{ $year->id }}" {{ $company->current_financial_year_id == $year->id ? 'selected' : '' }}>
                                                {{ $year->year }} ({{ $year->start_date->format('M Y') }} - {{ $year->end_date->format('M Y') }})
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Reason for Change (Optional)</label>
                                    <textarea name="reason" rows="2" placeholder="Why are you changing the financial year?" 
                                              class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-blue-500 focus:border-blue-500"></textarea>
                                </div>
                                
                                <button type="submit" class="w-full bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 font-medium transition-colors">
                                    Update Financial Year
                                </button>
                            </div>
                        </form>
                        
                        @if($financialYears->isEmpty())
                            <div class="mt-4 p-3 bg-yellow-50 border border-yellow-200 rounded-lg">
                                <p class="text-sm text-yellow-800">
                                    <i class="fas fa-exclamation-triangle mr-1"></i>
                                    No financial years found. Please create financial years in the settings.
                                </p>
                            </div>
                        @endif
                    </div>
                </div>
                
                <!-- Company Summary Card -->
                <div class="bg-white rounded-xl shadow-sm border">
                    <div class="p-6 border-b border-gray-200">
                        <h2 class="text-xl font-bold text-gray-900">Company Summary</h2>
                    </div>
                    
                    <div class="p-6 space-y-3">
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-gray-600">Company ID</span>
                            <span class="font-medium">{{ $company->id }}</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-gray-600">Status</span>
                            <span class="font-medium {{ $company->is_active ? 'text-green-600' : 'text-red-600' }}">
                                {{ $company->is_active ? 'Active' : 'Inactive' }}
                            </span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-gray-600">Company Type</span>
                            <span class="font-medium">{{ $company->company_type ?? 'Not specified' }}</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-gray-600">Timezone</span>
                            <span class="font-medium">{{ $company->timezone }}</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-gray-600">Created</span>
                            <span class="font-medium">{{ $company->created_at->format('M d, Y') }}</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-gray-600">Last Updated</span>
                            <span class="font-medium">{{ $company->updated_at->format('M d, Y') }}</span>
                        </div>
                    </div>
                </div>
                
            </div> <!-- End of vertical layout container -->
        </main>
    </div>

    <script>
        // Mobile menu functionality
        const mobileMenuButton = document.getElementById('mobile-menu-button');
        const sidebar = document.getElementById('sidebar');
        
        if (mobileMenuButton && sidebar) {
            mobileMenuButton.addEventListener('click', function() {
                sidebar.classList.toggle('active');
            });
        }

        // Success message handling
        @if(session('success'))
            setTimeout(() => {
                const successAlert = document.querySelector('.bg-green-50');
                if (successAlert) {
                    successAlert.style.display = 'none';
                }
            }, 5000);
        @endif

        @if(session('error'))
            setTimeout(() => {
                const errorAlert = document.querySelector('.bg-red-50');
                if (errorAlert) {
                    errorAlert.style.display = 'none';
                }
            }, 5000);
        @endif

        // Toggle edit form
        function toggleEditForm() {
            const viewMode = document.getElementById('viewMode');
            const editMode = document.getElementById('editMode');
            
            if (viewMode && editMode) {
                viewMode.classList.toggle('hidden');
                editMode.classList.toggle('hidden');
                
                // Reset logo upload if canceling
                if (viewMode.classList.contains('hidden')) {
                    // We're entering edit mode
                } else {
                    // We're canceling edit mode
                    cancelLogoUpload();
                    document.getElementById('removeLogo').value = '0';
                }
            }
        }

        // Logo handling functions
        function previewLogo(event) {
            const file = event.target.files[0];
            if (file) {
                // Validate file size (5MB max)
                if (file.size > 5 * 1024 * 1024) {
                    alert('File size must be less than 5MB');
                    cancelLogoUpload();
                    return;
                }
                
                // Validate file type
                const validTypes = ['image/jpeg', 'image/png', 'image/gif', 'image/svg+xml'];
                if (!validTypes.includes(file.type)) {
                    alert('Please upload a valid image file (JPEG, PNG, GIF, SVG)');
                    cancelLogoUpload();
                    return;
                }
                
                const reader = new FileReader();
                reader.onload = function(e) {
                    // Show preview
                    document.getElementById('logoPreview').src = e.target.result;
                    document.getElementById('newLogoPreview').classList.remove('hidden');
                    document.getElementById('logoUploadArea').classList.add('hidden');
                    
                    // Hide current logo preview if exists
                    const currentLogoPreview = document.getElementById('currentLogoPreview');
                    if (currentLogoPreview) {
                        currentLogoPreview.parentElement.parentElement.classList.add('hidden');
                    }
                    
                    // Reset remove logo flag
                    document.getElementById('removeLogo').value = '0';
                };
                reader.readAsDataURL(file);
            }
        }

        function cancelLogoUpload() {
            // Reset file input
            document.getElementById('logoUpload').value = '';
            
            // Show upload area
            document.getElementById('newLogoPreview').classList.add('hidden');
            document.getElementById('logoUploadArea').classList.remove('hidden');
            
            // Show current logo preview if it exists and wasn't removed
            const currentLogoPreview = document.getElementById('currentLogoPreview');
            const removeLogoFlag = document.getElementById('removeLogo');
            
            if (currentLogoPreview && removeLogoFlag.value === '0') {
                currentLogoPreview.parentElement.parentElement.classList.remove('hidden');
            }
        }

        function removeLogo() {
            if (confirm('Are you sure you want to remove the company logo?')) {
                document.getElementById('removeLogo').value = '1';
                const currentLogoPreview = document.getElementById('currentLogoPreview');
                if (currentLogoPreview) {
                    currentLogoPreview.parentElement.parentElement.classList.add('hidden');
                }
                document.getElementById('logoUploadArea').classList.remove('hidden');
                document.getElementById('newLogoPreview').classList.add('hidden');
                document.getElementById('logoUpload').value = '';
            }
        }

        // Add drag and drop functionality for logo upload
        document.addEventListener('DOMContentLoaded', function() {
            const uploadContainer = document.getElementById('logoUploadContainer');
            const fileInput = document.getElementById('logoUpload');
            
            if (uploadContainer && fileInput) {
                // Prevent default drag behaviors
                ['dragenter', 'dragover', 'dragleave', 'drop'].forEach(eventName => {
                    uploadContainer.addEventListener(eventName, preventDefaults, false);
                    document.body.addEventListener(eventName, preventDefaults, false);
                });
                
                // Highlight drop area when item is dragged over it
                ['dragenter', 'dragover'].forEach(eventName => {
                    uploadContainer.addEventListener(eventName, highlight, false);
                });
                
                ['dragleave', 'drop'].forEach(eventName => {
                    uploadContainer.addEventListener(eventName, unhighlight, false);
                });
                
                // Handle dropped files
                uploadContainer.addEventListener('drop', handleDrop, false);
                
                function preventDefaults(e) {
                    e.preventDefault();
                    e.stopPropagation();
                }
                
                function highlight() {
                    uploadContainer.classList.add('border-blue-500', 'bg-blue-50');
                    uploadContainer.classList.remove('border-gray-300');
                }
                
                function unhighlight() {
                    uploadContainer.classList.remove('border-blue-500', 'bg-blue-50');
                    uploadContainer.classList.add('border-gray-300');
                }
                
                function handleDrop(e) {
                    const dt = e.dataTransfer;
                    const files = dt.files;
                    
                    if (files.length > 0) {
                        fileInput.files = files;
                        previewLogo({ target: { files: files } });
                    }
                    
                    unhighlight();
                }
            }

            // Initialize select2 for better dropdowns (optional)
            // You can add select2 initialization here if needed
        });

        // Form validation before submission
        document.addEventListener('DOMContentLoaded', function() {
            const editForm = document.querySelector('#editMode form');
            if (editForm) {
                editForm.addEventListener('submit', function(e) {
                    // Validate required fields
                    const requiredFields = editForm.querySelectorAll('[required]');
                    let isValid = true;
                    
                    requiredFields.forEach(field => {
                        if (!field.value.trim()) {
                            field.classList.add('border-red-500');
                            isValid = false;
                        } else {
                            field.classList.remove('border-red-500');
                        }
                    });
                    
                    if (!isValid) {
                        e.preventDefault();
                        alert('Please fill in all required fields marked with *');
                    }
                });
            }
        });
    </script>
</body>
</html>