<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Vendor | {{ config('app.name', 'Laravel') }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .quickbooks-input {
            border: 1px solid #8C8C8C;
            border-radius: 4px;
            padding: 6px 12px;
            font-size: 14px;
        }
        .quickbooks-input:focus {
            outline: 2px solid #146CAA;
            outline-offset: -1px;
            border-color: #146CAA;
        }
        .quickbooks-checkbox {
            width: 18px;
            height: 18px;
            border: 2px solid #605E5C;
            border-radius: 3px;
        }
        .quickbooks-checkbox:checked {
            background-color: #146CAA;
            border-color: #146CAA;
        }
    </style>
</head>
<body class="bg-gray-50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        @include('accounting.partials.header', ['title' => 'Edit Vendor', 'subtitle' => 'Update vendor details'])

        <main class="p-6">
            <!-- Success/Error Messages -->
            @if(session('success'))
                <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-check-circle text-green-500 mr-2"></i>
                        <span class="text-green-800 font-semibold">{{ session('success') }}</span>
                    </div>
                </div>
            @endif

            @if(session('error'))
                <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-exclamation-circle text-red-500 mr-2"></i>
                        <span class="text-red-800 font-semibold">{{ session('error') }}</span>
                    </div>
                </div>
            @endif

            <div class="bg-white rounded-lg shadow-lg p-6">
                <form action="{{ route('admin.accounting.expenses.vendors.update', $vendor->id) }}" method="POST">
                    @csrf
                    @method('PUT')
                    
                    <!-- Basic Information -->
                    <div class="mb-8">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Basic Information</h3>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">
                                    Display Name *
                                </label>
                                <input type="text" 
                                       name="display_name" 
                                       value="{{ old('display_name', $vendor->display_name) }}"
                                       class="quickbooks-input w-full" 
                                       required>
                                @error('display_name')
                                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                @enderror
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">
                                    Company Name
                                </label>
                                <input type="text" 
                                       name="company_name" 
                                       value="{{ old('company_name', $vendor->company_name) }}"
                                       class="quickbooks-input w-full">
                            </div>
                        </div>
                    </div>

                    <!-- Contact Information -->
                    <div class="mb-8">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Contact Information</h3>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">
                                    Email
                                </label>
                                <input type="email" 
                                       name="email" 
                                       value="{{ old('email', $vendor->email) }}"
                                       class="quickbooks-input w-full">
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">
                                    Mobile Phone
                                </label>
                                <input type="tel" 
                                       name="mobile_phone" 
                                       value="{{ old('mobile_phone', $vendor->mobile_phone) }}"
                                       class="quickbooks-input w-full">
                            </div>
                        </div>
                    </div>

                    <!-- Additional Information -->
                    <div class="mb-8">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Additional Information</h3>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">
                                    Account Number
                                </label>
                                <input type="text" 
                                       name="account_number" 
                                       value="{{ old('account_number', $vendor->account_number) }}"
                                       class="quickbooks-input w-full">
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">
                                    Chart of Account
                                </label>
                                <select name="chart_of_account_id" class="quickbooks-input w-full">
                                    <option value="">Select Account</option>
                                    @foreach($accounts as $account)
                                        <option value="{{ $account->id }}" 
                                            {{ old('chart_of_account_id', $vendor->chart_of_account_id) == $account->id ? 'selected' : '' }}>
                                            {{ $account->code }} - {{ $account->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">
                                    Currency *
                                </label>
                                <select name="currency_id" class="quickbooks-input w-full" required>
                                    <option value="">Select Currency</option>
                                    @foreach($currencies as $currency)
                                        <option value="{{ $currency->id }}" 
                                            {{ old('currency_id', $vendor->currency_id) == $currency->id ? 'selected' : '' }}>
                                            {{ $currency->code }} - {{ $currency->name }} ({{ $currency->symbol }})
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">
                                    Payment Terms
                                </label>
                                <select name="payment_terms" class="quickbooks-input w-full">
                                    <option value="">Select Payment Terms</option>
                                    <option value="net_15" {{ old('payment_terms', $vendor->payment_terms) == 'net_15' ? 'selected' : '' }}>Net 15</option>
                                    <option value="net_30" {{ old('payment_terms', $vendor->payment_terms) == 'net_30' ? 'selected' : '' }}>Net 30</option>
                                    <option value="net_45" {{ old('payment_terms', $vendor->payment_terms) == 'net_45' ? 'selected' : '' }}>Net 45</option>
                                    <option value="net_60" {{ old('payment_terms', $vendor->payment_terms) == 'net_60' ? 'selected' : '' }}>Net 60</option>
                                    <option value="due_on_receipt" {{ old('payment_terms', $vendor->payment_terms) == 'due_on_receipt' ? 'selected' : '' }}>Due on receipt</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <!-- Tax Information -->
                    <div class="mb-8">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Tax Information</h3>
                        
                        <div class="flex items-center mb-4">
                            <input type="checkbox" 
                                   id="vendor_1099" 
                                   name="vendor_1099" 
                                   value="1"
                                   class="quickbooks-checkbox mr-2"
                                   {{ old('vendor_1099', $vendor->vendor_1099) ? 'checked' : '' }}>
                            <label for="vendor_1099" class="text-sm text-gray-600">
                                This vendor is eligible for 1099
                            </label>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Tax ID (SSN/EIN)
                            </label>
                            <input type="text" 
                                   name="tax_id" 
                                   value="{{ old('tax_id', $vendor->tax_id) }}"
                                   class="quickbooks-input w-full">
                        </div>
                    </div>

                    <!-- Status -->
                    <div class="mb-8">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Status</h3>
                        
                        <div class="flex items-center space-x-6">
                            <div class="flex items-center">
                                <input type="radio" 
                                       id="active" 
                                       name="active" 
                                       value="1"
                                       class="mr-2"
                                       {{ old('active', $vendor->active) ? 'checked' : '' }}>
                                <label for="active" class="text-sm text-gray-600">Active</label>
                            </div>
                            <div class="flex items-center">
                                <input type="radio" 
                                       id="inactive" 
                                       name="active" 
                                       value="0"
                                       class="mr-2"
                                       {{ !old('active', $vendor->active) ? 'checked' : '' }}>
                                <label for="inactive" class="text-sm text-gray-600">Inactive</label>
                            </div>
                        </div>
                    </div>

                    <!-- Form Actions -->
                    <div class="border-t border-gray-200 pt-6 mt-6 flex justify-end space-x-3">
                        <a href="{{ route('admin.accounting.expenses.vendors.index') }}" 
                           class="px-4 py-2 border border-gray-300 rounded text-sm font-medium text-gray-700 hover:bg-gray-50">
                            Cancel
                        </a>
                        <button type="submit" 
                                class="px-4 py-2 bg-blue-600 text-white rounded text-sm font-medium hover:bg-blue-700">
                            Update Vendor
                        </button>
                    </div>
                </form>
            </div>
        </main>
    </div>

    <script>
        // Add any JavaScript functionality here
        document.addEventListener('DOMContentLoaded', function() {
            // Auto-calculate full name from parts
            const firstName = document.querySelector('input[name="first_name"]');
            const middleName = document.querySelector('input[name="middle_name"]');
            const lastName = document.querySelector('input[name="last_name"]');
            const suffix = document.querySelector('input[name="suffix"]');
            
            function updateFullName() {
                const parts = [];
                if (firstName && firstName.value) parts.push(firstName.value);
                if (middleName && middleName.value) parts.push(middleName.value);
                if (lastName && lastName.value) parts.push(lastName.value);
                if (suffix && suffix.value) parts.push(suffix.value);
                
                const fullNameField = document.querySelector('input[name="full_name"]');
                if (fullNameField) {
                    fullNameField.value = parts.join(' ');
                }
            }
            
            [firstName, middleName, lastName, suffix].forEach(field => {
                if (field) {
                    field.addEventListener('input', updateFullName);
                }
            });
        });
    </script>
</body>
</html>