<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Accounting | IMMIA FINANCE LIMITED</title>
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        .card-hover {
            transition: all 0.3s ease;
        }
        
        .card-hover:hover {
            transform: translateY(-4px);
            box-shadow: 0 12px 30px rgba(0, 0, 0, 0.15);
        }
        
        .module-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(320px, 1fr));
            gap: 1.5rem;
        }
        
        /* Ensure content doesn't get hidden under sidebar */
        @media (min-width: 1024px) {
            .lg\:ml-64 {
                margin-left: 16rem;
            }
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64 min-h-screen">
        @include('accounting.partials.header', [
            'title' => 'Accounting Module', 
            'subtitle' => 'Financial management and reporting'
        ])

        <!-- Main Content Area -->
        <main class="p-6">
            <!-- Financial Overview Cards -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
                <!-- Total Assets -->
                <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-200 card-hover">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-gray-600 text-sm">Total Assets</p>
                            <p class="text-2xl font-bold text-green-600">ZMW {{ number_format($totalAssets ?? 0, 2) }}</p>
                        </div>
                        <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-chart-line text-green-600 text-xl"></i>
                        </div>
                    </div>
                    <div class="mt-4">
                        <div class="w-full bg-gray-200 rounded-full h-2">
                            <div class="bg-green-600 h-2 rounded-full" style="width: {{ min(100, ($totalAssets / max(1, $totalAssets + $totalLiabilities)) * 100) }}%"></div>
                        </div>
                    </div>
                </div>

                <!-- Total Liabilities -->
                <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-200 card-hover">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-gray-600 text-sm">Total Liabilities</p>
                            <p class="text-2xl font-bold text-red-600">ZMW {{ number_format($totalLiabilities ?? 0, 2) }}</p>
                        </div>
                        <div class="w-12 h-12 bg-red-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-exclamation-triangle text-red-600 text-xl"></i>
                        </div>
                    </div>
                    <div class="mt-4">
                        <div class="w-full bg-gray-200 rounded-full h-2">
                            <div class="bg-red-600 h-2 rounded-full" style="width: {{ min(100, ($totalLiabilities / max(1, $totalAssets + $totalLiabilities)) * 100) }}%"></div>
                        </div>
                    </div>
                </div>

                <!-- Net Income -->
                <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-200 card-hover">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-gray-600 text-sm">Net Income</p>
                            <p class="text-2xl font-bold text-blue-600">ZMW {{ number_format($netIncome ?? 0, 2) }}</p>
                        </div>
                        <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-money-bill-wave text-blue-600 text-xl"></i>
                        </div>
                    </div>
                    <div class="mt-4">
                        <div class="w-full bg-gray-200 rounded-full h-2">
                            <div class="bg-blue-600 h-2 rounded-full" style="width: {{ min(100, max(0, ($netIncome / max(1, $totalAssets)) * 100)) }}%"></div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Accounting Modules Grid -->
            <div class="module-grid mb-8">
                <!-- Chart of Accounts -->
                <a href="{{ route('admin.accounting.chart-of-accounts.index') }}" class="bg-white rounded-xl p-6 shadow-sm border border-gray-200 card-hover group">
                    <div class="flex items-center justify-between mb-4">
                        <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center group-hover:bg-blue-200 transition-colors">
                            <i class="fas fa-chart-pie text-blue-600 text-xl"></i>
                        </div>
                        <i class="fas fa-arrow-right text-gray-400 group-hover:text-blue-600 transition-colors transform group-hover:translate-x-1"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Chart of Accounts</h3>
                    <p class="text-gray-600 text-sm mb-4">Manage your account structure and categories</p>
                    <div class="mt-4 flex items-center text-sm text-gray-500">
                        <span class="bg-blue-100 text-blue-600 px-3 py-1 rounded-full font-medium">{{ $accountsCount ?? 0 }} Accounts</span>
                    </div>
                </a>

                <!-- Cash & Banking -->
                <a href="{{ route('admin.accounting.cash-banking.index') }}" class="bg-white rounded-xl p-6 shadow-sm border border-gray-200 card-hover group">
                    <div class="flex items-center justify-between mb-4">
                        <div class="w-12 h-12 bg-cyan-100 rounded-lg flex items-center justify-center group-hover:bg-cyan-200 transition-colors">
                            <i class="fas fa-wallet text-cyan-600 text-xl"></i>
                        </div>
                        <i class="fas fa-arrow-right text-gray-400 group-hover:text-cyan-600 transition-colors transform group-hover:translate-x-1"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Cash & Banking</h3>
                    <p class="text-gray-600 text-sm mb-4">Manage cash, bank and mobile money accounts</p>
                    <div class="mt-4 flex items-center text-sm text-gray-500">
                        <span class="bg-cyan-100 text-cyan-600 px-3 py-1 rounded-full font-medium">ZMW {{ number_format($totalCashBalance ?? 0, 2) }}</span>
                    </div>
                </a>

                <!-- Receivables -->
                <a href="{{ route('admin.accounting.receivables.index') }}" class="bg-white rounded-xl p-6 shadow-sm border border-gray-200 card-hover group">
                    <div class="flex items-center justify-between mb-4">
                        <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center group-hover:bg-green-200 transition-colors">
                            <i class="fas fa-hand-holding-usd text-green-600 text-xl"></i>
                        </div>
                        <i class="fas fa-arrow-right text-gray-400 group-hover:text-green-600 transition-colors transform group-hover:translate-x-1"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Receivables</h3>
                    <p class="text-gray-600 text-sm mb-4">Manage money owed to your business</p>
                    <div class="mt-4 flex items-center text-sm text-gray-500">
                        <span class="bg-green-100 text-green-600 px-3 py-1 rounded-full font-medium">ZMW {{ number_format($totalReceivables ?? 0, 2) }}</span>
                    </div>
                </a>

                <!-- Payables -->
                <a href="{{ route('admin.accounting.payables.index') }}" class="bg-white rounded-xl p-6 shadow-sm border border-gray-200 card-hover group">
                    <div class="flex items-center justify-between mb-4">
                        <div class="w-12 h-12 bg-red-100 rounded-lg flex items-center justify-center group-hover:bg-red-200 transition-colors">
                            <i class="fas fa-file-invoice-dollar text-red-600 text-xl"></i>
                        </div>
                        <i class="fas fa-arrow-right text-gray-400 group-hover:text-red-600 transition-colors transform group-hover:translate-x-1"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Payables</h3>
                    <p class="text-gray-600 text-sm mb-4">Manage money you owe to suppliers</p>
                    <div class="mt-4 flex items-center text-sm text-gray-500">
                        <span class="bg-red-100 text-red-600 px-3 py-1 rounded-full font-medium">ZMW {{ number_format($totalPayables ?? 0, 2) }}</span>
                    </div>
                </a>

                <!-- Journals -->
                <a href="{{ route('admin.accounting.journals.index') }}" class="bg-white rounded-xl p-6 shadow-sm border border-gray-200 card-hover group">
                    <div class="flex items-center justify-between mb-4">
                        <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center group-hover:bg-purple-200 transition-colors">
                            <i class="fas fa-book text-purple-600 text-xl"></i>
                        </div>
                        <i class="fas fa-arrow-right text-gray-400 group-hover:text-purple-600 transition-colors transform group-hover:translate-x-1"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Journal Entries</h3>
                    <p class="text-gray-600 text-sm mb-4">Record financial transactions</p>
                    <div class="mt-4 flex items-center text-sm text-gray-500">
                        <span class="bg-purple-100 text-purple-600 px-3 py-1 rounded-full font-medium">{{ $journalEntriesCount ?? 0 }} Entries</span>
                    </div>
                </a>

                <!-- Reports -->
                <a href="{{ route('admin.accounting.reports.index') }}" class="bg-white rounded-xl p-6 shadow-sm border border-gray-200 card-hover group">
                    <div class="flex items-center justify-between mb-4">
                        <div class="w-12 h-12 bg-indigo-100 rounded-lg flex items-center justify-center group-hover:bg-indigo-200 transition-colors">
                            <i class="fas fa-chart-bar text-indigo-600 text-xl"></i>
                        </div>
                        <i class="fas fa-arrow-right text-gray-400 group-hover:text-indigo-600 transition-colors transform group-hover:translate-x-1"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Financial Reports</h3>
                    <p class="text-gray-600 text-sm mb-4">Generate financial statements and reports</p>
                    <div class="mt-4 flex items-center text-sm text-gray-500">
                        <span class="bg-indigo-100 text-indigo-600 px-3 py-1 rounded-full font-medium">5+ Reports</span>
                    </div>
                </a>
            </div>

            <!-- Cash & Banking Dashboard Section -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 mb-8">
                <div class="p-6 border-b border-gray-200 flex justify-between items-center">
                    <div>
                        <h2 class="text-xl font-bold text-gray-900">Cash & Banking Dashboard</h2>
                        <p class="text-gray-600">Real-time cash, bank, and mobile money overview</p>
                    </div>
                    <a href="{{ route('admin.accounting.cash-banking.index') }}" 
                       class="text-cyan-600 hover:text-cyan-700 font-medium text-sm flex items-center bg-cyan-50 hover:bg-cyan-100 px-4 py-2 rounded-lg transition-colors">
                        <span>View Full Dashboard</span>
                        <i class="fas fa-arrow-right ml-2"></i>
                    </a>
                </div>
                
                <!-- Balance Summary -->
                <div class="p-6 border-b border-gray-200">
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                        <div class="bg-cyan-600 text-white rounded-xl p-4 shadow-sm">
                            <div class="flex justify-between items-start">
                                <div>
                                    <p class="text-cyan-100 text-xs font-medium">Total Balance</p>
                                    <h3 class="text-xl font-bold mt-1">ZMW {{ number_format($totalCashBalance, 2) }}</h3>
                                </div>
                                <div class="bg-cyan-500 p-2 rounded-lg">
                                    <i class="fas fa-wallet"></i>
                                </div>
                            </div>
                        </div>

                        <div class="bg-green-600 text-white rounded-xl p-4 shadow-sm">
                            <div class="flex justify-between items-start">
                                <div>
                                    <p class="text-green-100 text-xs font-medium">Cash Balance</p>
                                    <h3 class="text-xl font-bold mt-1">ZMW {{ number_format($cashBalance, 2) }}</h3>
                                </div>
                                <div class="bg-green-500 p-2 rounded-lg">
                                    <i class="fas fa-money-bill"></i>
                                </div>
                            </div>
                        </div>

                        <div class="bg-blue-600 text-white rounded-xl p-4 shadow-sm">
                            <div class="flex justify-between items-start">
                                <div>
                                    <p class="text-blue-100 text-xs font-medium">Bank Balance</p>
                                    <h3 class="text-xl font-bold mt-1">ZMW {{ number_format($bankBalance, 2) }}</h3>
                                </div>
                                <div class="bg-blue-500 p-2 rounded-lg">
                                    <i class="fas fa-university"></i>
                                </div>
                            </div>
                        </div>

                        <div class="bg-amber-600 text-white rounded-xl p-4 shadow-sm">
                            <div class="flex justify-between items-start">
                                <div>
                                    <p class="text-amber-100 text-xs font-medium">Mobile Money</p>
                                    <h3 class="text-xl font-bold mt-1">ZMW {{ number_format($mobileMoneyBalance, 2) }}</h3>
                                </div>
                                <div class="bg-amber-500 p-2 rounded-lg">
                                    <i class="fas fa-mobile-alt"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Accounts and Recent Activity -->
                <div class="p-6 grid grid-cols-1 lg:grid-cols-3 gap-6">
                    <!-- Accounts List -->
                    <div class="lg:col-span-2">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Recent Accounts</h3>
                        @if($cashBankAccounts->count() > 0)
                        <div class="space-y-3">
                            @foreach($cashBankAccounts as $account)
                            <div class="flex items-center justify-between p-4 border border-gray-200 rounded-lg hover:bg-gray-50 transition-colors">
                                <div class="flex items-center space-x-4">
                                    <div class="w-10 h-10 rounded-lg flex items-center justify-center 
                                        {{ $account->accountType == 'Cash' ? 'bg-green-100' : '' }}
                                        {{ $account->accountType == 'Bank' ? 'bg-blue-100' : '' }}
                                        {{ $account->accountType == 'Mobile Money' ? 'bg-amber-100' : '' }}">
                                        <i class="fas 
                                            {{ $account->accountType == 'Cash' ? 'fa-money-bill text-green-600' : '' }}
                                            {{ $account->accountType == 'Bank' ? 'fa-university text-blue-600' : '' }}
                                            {{ $account->accountType == 'Mobile Money' ? 'fa-mobile-alt text-amber-600' : '' }}
                                            "></i>
                                    </div>
                                    <div>
                                        <h4 class="font-semibold text-gray-900">{{ $account->accountName }}</h4>
                                        <div class="flex items-center space-x-2 mt-1">
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium 
                                                {{ $account->accountType == 'Cash' ? 'bg-green-100 text-green-800' : '' }}
                                                {{ $account->accountType == 'Bank' ? 'bg-blue-100 text-blue-800' : '' }}
                                                {{ $account->accountType == 'Mobile Money' ? 'bg-amber-100 text-amber-800' : '' }}">
                                                {{ $account->accountType }}
                                            </span>
                                            <span class="text-xs text-gray-500">{{ $account->accountNumber ?? 'N/A' }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="text-right">
                                    <p class="font-semibold text-gray-900">ZMW {{ number_format($account->current_balance, 2) }}</p>
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $account->isActive ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                        {{ $account->isActive ? 'Active' : 'Inactive' }}
                                    </span>
                                </div>
                            </div>
                            @endforeach
                        </div>
                        @else
                        <div class="text-center py-8 border border-gray-300 border-dashed rounded-lg">
                            <i class="fas fa-wallet text-4xl text-gray-300 mb-4"></i>
                            <p class="text-gray-500">No cash or bank accounts found</p>
                            <a href="{{ route('admin.accounting.cash-banking.accounts.create') }}" 
                               class="inline-block mt-2 text-cyan-600 hover:text-cyan-700 font-medium">
                                Create your first account
                            </a>
                        </div>
                        @endif
                    </div>

                    <!-- Recent Activity -->
                    <div class="space-y-6">
                        <!-- Recent Transfers -->
                        <div class="bg-gray-50 rounded-lg p-4">
                            <h3 class="text-lg font-semibold text-gray-900 mb-3">Recent Transfers</h3>
                            @if($recentCashTransfers->count() > 0)
                            <div class="space-y-3">
                                @foreach($recentCashTransfers as $transfer)
                                <div class="flex items-center justify-between p-3 bg-white rounded-lg border border-gray-200">
                                    <div class="flex items-center space-x-3">
                                        <div class="w-8 h-8 bg-blue-100 rounded-lg flex items-center justify-center">
                                            <i class="fas fa-exchange-alt text-blue-600 text-sm"></i>
                                        </div>
                                        <div>
                                            <p class="text-sm font-medium text-gray-900">ZMW {{ number_format($transfer->amountsent, 2) }}</p>
                                            <p class="text-xs text-gray-500">{{ $transfer->currency }}</p>
                                        </div>
                                    </div>
                                    <span class="text-xs px-2 py-1 rounded-full {{ $transfer->transferstatus == 'Sent' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' }}">
                                        {{ $transfer->transferstatus }}
                                    </span>
                                </div>
                                @endforeach
                            </div>
                            @else
                            <p class="text-gray-500 text-center py-4 text-sm">No recent transfers</p>
                            @endif
                        </div>

                        <!-- Quick Actions -->
                        <div class="bg-gray-50 rounded-lg p-4">
                            <h3 class="text-lg font-semibold text-gray-900 mb-3">Quick Actions</h3>
                            <div class="space-y-2">
                                <a href="{{ route('admin.accounting.cash-banking.accounts.create') }}" 
                                   class="w-full flex items-center justify-center px-4 py-2 border border-transparent text-sm font-medium rounded-lg text-white bg-cyan-600 hover:bg-cyan-700 transition duration-150">
                                    <i class="fas fa-plus mr-2"></i>New Account
                                </a>
                                <a href="{{ route('admin.accounting.cash-banking.internal-transfers.create') }}" 
                                   class="w-full flex items-center justify-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-lg text-gray-700 bg-white hover:bg-gray-50 transition duration-150">
                                    <i class="fas fa-exchange-alt mr-2"></i>New Transfer
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Recent Activity & Quick Stats -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                <!-- Recent Journal Entries -->
                <div class="bg-white rounded-xl shadow-sm border border-gray-200">
                    <div class="p-6 border-b border-gray-200">
                        <h2 class="text-xl font-bold text-gray-900">Recent Journal Entries</h2>
                        <p class="text-gray-600">Latest accounting transactions</p>
                    </div>
                    <div class="p-6">
                        @if($recentJournalEntries && $recentJournalEntries->count() > 0)
                        <div class="space-y-4">
                            @foreach($recentJournalEntries as $entry)
                            <div class="flex items-center justify-between p-4 border border-gray-200 rounded-lg hover:bg-gray-50 transition-colors">
                                <div class="flex items-center space-x-4">
                                    <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center">
                                        <i class="fas fa-book text-purple-600"></i>
                                    </div>
                                    <div>
                                        <h3 class="font-semibold text-gray-900">JE-{{ $entry->entry_number ?? $entry->id }}</h3>
                                        <p class="text-gray-600 text-sm">{{ $entry->description ?? 'No description' }}</p>
                                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                                            {{ $entry->entry_date ? $entry->entry_date->format('M d, Y') : 'No date' }}
                                        </span>
                                    </div>
                                </div>
                                <div class="text-right">
                                    <p class="font-semibold text-gray-900">ZMW {{ number_format($entry->total_amount ?? 0, 2) }}</p>
                                    <p class="text-gray-600 text-sm">{{ ucfirst($entry->status ?? 'unknown') }}</p>
                                    <a href="{{ route('admin.accounting.journals.show', $entry->id) }}" class="text-purple-600 hover:text-purple-700 text-sm font-medium inline-flex items-center">
                                        View <i class="fas fa-external-link-alt ml-1 text-xs"></i>
                                    </a>
                                </div>
                            </div>
                            @endforeach
                        </div>
                        @else
                        <div class="text-center py-8">
                            <i class="fas fa-book text-4xl text-gray-300 mb-4"></i>
                            <p class="text-gray-500">No recent journal entries</p>
                            <a href="{{ route('admin.accounting.journals.create') }}" class="inline-block mt-2 text-purple-600 hover:text-purple-700 font-medium">
                                Create your first journal entry
                            </a>
                        </div>
                        @endif
                        
                        <div class="mt-6">
                            <a href="{{ route('admin.accounting.journals.index') }}" class="block w-full bg-purple-600 hover:bg-purple-700 text-white text-center py-3 rounded-lg font-semibold transition-colors">
                                View All Journal Entries
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Accounting Overview -->
                <div class="bg-white rounded-xl shadow-sm border border-gray-200">
                    <div class="p-6 border-b border-gray-200">
                        <h2 class="text-xl font-bold text-gray-900">Financial Position</h2>
                        <p class="text-gray-600">Assets, liabilities and equity breakdown</p>
                    </div>
                    <div class="p-6">
                        <div class="space-y-6">
                            <!-- Assets -->
                            <div>
                                <div class="flex justify-between items-center mb-2">
                                    <h3 class="font-semibold text-green-600">Assets</h3>
                                    <span class="font-bold text-green-600">ZMW {{ number_format($totalAssets ?? 0, 2) }}</span>
                                </div>
                                <div class="w-full bg-gray-200 rounded-full h-2">
                                    <div class="bg-green-600 h-2 rounded-full" style="width: {{ min(100, ($totalAssets / max(1, $totalAssets + $totalLiabilities)) * 100) }}%"></div>
                                </div>
                            </div>

                            <!-- Liabilities -->
                            <div>
                                <div class="flex justify-between items-center mb-2">
                                    <h3 class="font-semibold text-red-600">Liabilities</h3>
                                    <span class="font-bold text-red-600">ZMW {{ number_format($totalLiabilities ?? 0, 2) }}</span>
                                </div>
                                <div class="w-full bg-gray-200 rounded-full h-2">
                                    <div class="bg-red-600 h-2 rounded-full" style="width: {{ min(100, ($totalLiabilities / max(1, $totalAssets + $totalLiabilities)) * 100) }}%"></div>
                                </div>
                            </div>

                            <!-- Equity -->
                            <div>
                                <div class="flex justify-between items-center mb-2">
                                    <h3 class="font-semibold text-blue-600">Equity</h3>
                                    <span class="font-bold text-blue-600">ZMW {{ number_format($totalEquity ?? 0, 2) }}</span>
                                </div>
                                <div class="w-full bg-gray-200 rounded-full h-2">
                                    <div class="bg-blue-600 h-2 rounded-full" style="width: {{ min(100, ($totalEquity / max(1, $totalAssets)) * 100) }}%"></div>
                                </div>
                            </div>
                        </div>

                        <!-- Quick Actions -->
                        <div class="mt-8 grid grid-cols-2 gap-4">
                            <a href="{{ route('admin.accounting.journals.create') }}" class="bg-blue-600 hover:bg-blue-700 text-white text-center py-3 rounded-lg font-semibold transition-colors flex items-center justify-center space-x-2">
                                <i class="fas fa-plus"></i>
                                <span>New Journal Entry</span>
                            </a>
                            <a href="{{ route('admin.accounting.reports.balance-sheet') }}" class="bg-green-600 hover:bg-green-700 text-white text-center py-3 rounded-lg font-semibold transition-colors flex items-center justify-center space-x-2">
                                <i class="fas fa-chart-bar"></i>
                                <span>View Reports</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
</body>
</html>