<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Notification Settings | IMMIA FINANCE</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .toggle-checkbox:checked + .toggle-label { background-color: #003366; }
        .toggle-checkbox:checked + .toggle-label .toggle-dot { transform: translateX(100%); border-color: #003366; }
    </style>
</head>
<body class="bg-gray-50">
    @include('accounting.partials.sidebar')
    <div class="lg:ml-64">
        @include('accounting.partials.header', ['title' => 'Notification Settings', 'subtitle' => 'Configure Email & SMS Alerts'])

        <main class="p-4">
            @if(session('success'))
                <div class="mb-4 bg-green-50 border border-green-200 text-green-800 p-3 rounded-lg text-sm shadow-sm">
                    <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
                </div>
            @endif

            <form action="{{ route('admin.settings.notifications.update') }}" method="POST">
                @csrf
                <div class="space-y-4">
                    @foreach(['email' => ['Email Alerts', 'fa-envelope', 'bg-blue-100', 'text-blue-700'], 
                              'sms' => ['SMS Alerts', 'fa-comment', 'bg-green-100', 'text-green-700']] as $channel => $meta)
                    <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden">
                        <div class="px-4 py-2 border-b border-gray-200 flex items-center gap-3 bg-gray-50/50">
                            <div class="w-7 h-7 {{ $meta[2] }} rounded flex items-center justify-center {{ $meta[3] }}">
                                <i class="fas {{ $meta[1] }} text-sm"></i>
                            </div>
                            <h3 class="text-sm font-bold text-gray-900">{{ $meta[0] }}</h3>
                        </div>
                        
                        <div class="p-1 divide-y divide-gray-100">
                            @foreach($events as $event)
                            <div class="p-3 hover:bg-gray-50 transition-all">
                                <div class="flex items-center justify-between">
                                    <div class="flex flex-col">
                                        <div class="flex items-center gap-3">
                                            <i class="fas {{ $event->icon }} text-gray-400 text-xs w-4 text-center"></i>
                                            <span class="text-sm font-medium text-gray-700">{{ $event->label }}</span>
                                        </div>
                                        
                                        @if($event->event_key === 'payment_due')
                                            <div class="ml-7 mt-1 flex items-center gap-2 text-[11px] text-gray-500">
                                                <span>Remind</span>
                                                <input type="number" name="reminder_days" value="{{ $event->reminder_days }}" class="w-10 border border-gray-300 rounded px-1 outline-none">
                                                <span>days before due date</span>
                                            </div>
                                        @elseif($event->event_key === 'payment_overdue')
                                            <div class="ml-7 mt-1 flex items-center gap-2 text-[11px] text-gray-500">
                                                <span>Alert every</span>
                                                <input type="number" name="overdue_frequency_days" value="{{ $event->overdue_frequency_days }}" class="w-10 border border-gray-300 rounded px-1 outline-none">
                                                <span>day(s) after overdue</span>
                                            </div>
                                        @endif
                                    </div>

                                    <div class="relative inline-block w-10 align-middle select-none">
                                        <input type="checkbox" name="{{ $channel }}_{{ $event->event_key }}" id="{{ $channel }}_{{ $event->event_key }}" 
                                               class="toggle-checkbox absolute block w-6 h-6 rounded-full bg-white border-4 appearance-none cursor-pointer z-10"
                                               {{ (isset($settings[$channel][$event->event_key]) && $settings[$channel][$event->event_key]) ? 'checked' : '' }}/>
                                        <label for="{{ $channel }}_{{ $event->event_key }}" class="toggle-label block overflow-hidden h-6 rounded-full bg-gray-300 cursor-pointer">
                                            <span class="toggle-dot block h-6 w-6 rounded-full bg-white border-2 border-gray-300 transition-transform duration-200"></span>
                                        </label>
                                    </div>
                                </div>

                                @if($channel === 'sms')
                                <div class="mt-2 ml-7">
                                    <label class="text-[10px] uppercase font-bold text-gray-400">SMS Message Content</label>
                                    <textarea name="sms_template_{{ $event->event_key }}" rows="2" 
                                              class="w-full mt-1 p-2 border border-gray-200 rounded text-xs text-gray-600 focus:ring-1 focus:ring-blue-900 outline-none">{{ $event->sms_template }}</textarea>
                                </div>
                                @endif
                            </div>
                            @endforeach
                        </div>
                    </div>
                    @endforeach

                    <div class="flex justify-end pt-2">
                        <button type="submit" class="px-8 py-2 bg-[#003366] hover:bg-black text-white rounded text-sm font-semibold shadow-md flex items-center gap-2 transition-all">
                            <i class="fas fa-save"></i> Save All Notification Settings
                        </button>
                    </div>
                </div>
            </form>
        </main>
    </div>
</body>
</html>