@php
    // Define variables for header partial and view
    $pageTitle = 'Edit Offer';
    $pageSubtitle = 'Updating offer for: ' . (
        ($products->where('id', $offer->product_id)->first()->product ?? 'N/A') . 
        ' (' . 
        ($creditScoreTiers->where('id', $offer->credit_score_tier_id)->first()->name ?? 'N/A') . 
        ')'
    );
    
    // Helper accessors for last updated date
    $lastUpdated = \Carbon\Carbon::parse($offer->updated_at)->format('M d, Y H:i');
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $pageTitle }} | {{ config('app.name', 'IMMIA FINANCE') }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#146CAA',
                        primaryLight: '#E1F0FA',
                        secondary: '#6b7280',
                        success: '#107C10',
                        warning: '#F68C1E',
                        danger: '#D83B01',
                        info: '#0078D4',
                        gray50: '#FAF9F8',
                        gray100: '#F3F2F1',
                        gray200: '#EDEBE9',
                        gray300: '#E1DFDD',
                        gray400: '#C8C6C4',
                        gray500: '#A19F9D',
                        gray600: '#605E5C',
                        gray700: '#323130',
                        gray800: '#201F1E',
                        gray900: '#000000'
                    }
                }
            }
        }
    </script>
    <style>
        .quickbooks-input {
            border: 1px solid #E1DFDD;
            border-radius: 4px;
            padding: 8px 12px;
            font-size: 14px;
            transition: border-color 0.2s;
            width: 100%;
        }
        .quickbooks-input:focus {
            outline: none;
            border-color: #146CAA;
            box-shadow: 0 0 0 2px rgba(20, 108, 170, 0.1);
        }
        .quickbooks-input.error {
            border-color: #D83B01;
        }
        .error-message {
            color: #D83B01;
            font-size: 12px;
            margin-top: 4px;
        }
        .quickbooks-input-readonly {
            background-color: #F3F2F1;
            color: #605E5C;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .animate-fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }
        .lg\:ml-64 { margin-left: 16rem; }
        @media (max-width: 1024px) { .lg\:ml-64 { margin-left: 0 !important; } }
    </style>
</head>
<body class="bg-gray50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        
        {{-- DEDICATED HEADER PARTIAL --}}
        @include('accounting.partials.header', [
            'title' => $pageTitle,
            'subtitle' => $pageSubtitle
        ])

        <main class="p-6">
            
            @if(session('success'))
                <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4 animate-fade-in">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <i class="fas fa-check-circle text-success mr-2"></i>
                            <span class="text-green-800 font-medium">{{ session('success') }}</span>
                        </div>
                        <button onclick="this.parentElement.parentElement.remove()" class="text-green-600 hover:text-green-800">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
            @endif

            @if($errors->any() || session('error'))
                <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4 animate-fade-in">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <i class="fas fa-exclamation-circle text-danger mr-2"></i>
                            <span class="text-red-800 font-medium">Please fix the following errors:</span>
                        </div>
                        <button onclick="this.parentElement.parentElement.remove()" class="text-red-600 hover:text-red-800">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                    @if($errors->any())
                        <ul class="mt-2 text-red-700 text-sm list-disc list-inside">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    @endif
                    @if(session('error') && !$errors->any())
                        <p class="mt-2 text-red-700 text-sm">{{ session('error') }}</p>
                    @endif
                </div>
            @endif

            <div class="max-w-4xl mx-auto">
                <div class="bg-white rounded-lg border border-gray200 overflow-hidden animate-fade-in">
                    <div class="border-b border-gray200 p-6">
                        <h2 class="text-lg font-semibold text-gray900">Edit Offer Information</h2>
                        <p class="text-gray600 text-sm mt-1">Update the offer details below</p>
                    </div>
                    
                    <div class="p-6">
                        <form action="{{ route('admin.accounting.offers.update', $offer->id) }}" method="POST" id="offerForm">
                            @csrf
                            @method('PUT')
                            
                            <input type="hidden" name="is_active" value="{{ $offer->is_active ? '1' : '0' }}">
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
                                <div>
                                    <label class="block text-sm font-medium text-gray700 mb-2">Product</label>
                                    <input type="text" class="quickbooks-input quickbooks-input-readonly" 
                                           value="{{ $products->where('id', $offer->product_id)->first()->product ?? 'N/A' }}" readonly>
                                    <div class="text-xs text-gray500 mt-1">Product cannot be changed</div>
                                </div>
                                
                                <div>
                                    <label class="block text-sm font-medium text-gray700 mb-2">Credit Score Tier</label>
                                    <input type="text" class="quickbooks-input quickbooks-input-readonly" 
                                           value="{{ $creditScoreTiers->where('id', $offer->credit_score_tier_id)->first()->name ?? 'N/A' }}" readonly>
                                    <div class="text-xs text-gray500 mt-1">Tier cannot be changed</div>
                                </div>
                            </div>
                            
                            <div class="mb-8">
                                <h3 class="text-sm font-semibold text-gray900 mb-4 flex items-center">
                                    <i class="fas fa-money-bill-wave mr-2 text-primary"></i>
                                    Loan Amount Range
                                </h3>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div>
                                        <label class="block text-sm font-medium text-gray700 mb-2">
                                            Minimum Amount (ZMW) *
                                        </label>
                                        <input type="number" step="0.01" min="0" name="min_amount" 
                                               class="quickbooks-input @error('min_amount') error @enderror" 
                                               value="{{ old('min_amount', $offer->min_amount) }}" 
                                               placeholder="e.g., 1000.00" required>
                                        @error('min_amount')
                                        <div class="error-message">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    
                                    <div>
                                        <label class="block text-sm font-medium text-gray700 mb-2">
                                            Maximum Amount (ZMW) *
                                        </label>
                                        <input type="number" step="0.01" min="0" name="max_amount" 
                                               class="quickbooks-input @error('max_amount') error @enderror" 
                                               value="{{ old('max_amount', $offer->max_amount) }}" 
                                               placeholder="e.g., 50000.00" required>
                                        @error('max_amount')
                                        <div class="error-message">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="mb-8">
                                <h3 class="text-sm font-semibold text-gray900 mb-4 flex items-center">
                                    <i class="fas fa-clock mr-2 text-primary"></i>
                                    Loan Duration (Days)
                                </h3>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div>
                                        <label class="block text-sm font-medium text-gray700 mb-2">
                                            Minimum Duration (Days) *
                                        </label>
                                        <input type="number" step="1" min="1" name="min_duration" 
                                               class="quickbooks-input @error('min_duration') error @enderror" 
                                               value="{{ old('min_duration', $offer->min_duration) }}" 
                                               placeholder="e.g., 7" required>
                                        @error('min_duration')
                                        <div class="error-message">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    
                                    <div>
                                        <label class="block text-sm font-medium text-gray700 mb-2">
                                            Maximum Duration (Days) *
                                        </label>
                                        <input type="number" step="1" min="1" name="max_duration" 
                                               class="quickbooks-input @error('max_duration') error @enderror" 
                                               value="{{ old('max_duration', $offer->max_duration) }}" 
                                               placeholder="e.g., 365" required>
                                        @error('max_duration')
                                        <div class="error-message">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mb-8">
                                <h3 class="text-sm font-semibold text-gray900 mb-4 flex items-center">
                                    <i class="fas fa-percentage mr-2 text-primary"></i>
                                    Interest Rates
                                </h3>
                                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                                    {{-- ONLY DAILY RATE IS KEPT --}}
                                    <div>
                                        <label class="block text-sm font-medium text-gray700 mb-2">
                                            Daily Rate (%) *
                                        </label>
                                        <input type="number" step="0.01" min="0" max="100" name="daily_rate" 
                                               class="quickbooks-input @error('daily_rate') error @enderror" 
                                               value="{{ old('daily_rate', $offer->daily_rate) }}" 
                                               placeholder="e.g., 0.83" required>
                                        @error('daily_rate')
                                        <div class="error-message">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            
                            <div class="flex items-center justify-between pt-6 border-t border-gray200">
                                <div class="text-sm text-gray500">
                                    Last updated: {{ $lastUpdated }}
                                </div>
                                <div class="flex space-x-3">
                                    <a href="{{ route('admin.accounting.offers.index') }}" 
                                       class="px-4 py-2 border border-gray300 text-gray700 rounded text-sm font-medium hover:bg-gray100">
                                        Cancel
                                    </a>
                                    <button type="submit" 
                                            class="px-4 py-2 bg-primary text-white rounded text-sm font-medium hover:bg-primary/90 flex items-center gap-2">
                                        <i class="fas fa-save"></i>
                                        Update Offer
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const minAmountInput = document.querySelector('input[name="min_amount"]');
            const maxAmountInput = document.querySelector('input[name="max_amount"]');
            const minDurationInput = document.querySelector('input[name="min_duration"]');
            const maxDurationInput = document.querySelector('input[name="max_duration"]');

            // Form validation
            const form = document.getElementById('offerForm');
            form.addEventListener('submit', function(e) {
                const minAmount = parseFloat(minAmountInput.value);
                const maxAmount = parseFloat(maxAmountInput.value);
                const minDuration = parseFloat(minDurationInput.value);
                const maxDuration = parseFloat(maxDurationInput.value);
                let isValid = true;
                
                if (minAmount >= maxAmount) {
                    e.preventDefault();
                    alert('Maximum amount must be greater than minimum amount.');
                    minAmountInput.focus();
                    isValid = false;
                }
                
                if (minDuration >= maxDuration) {
                    e.preventDefault();
                    alert('Maximum duration must be greater than minimum duration.');
                    maxDurationInput.focus();
                    isValid = false;
                }

                if (!isValid) return false;
                
                return true;
            });
            
            // Auto-hide alerts after 5 seconds
            setTimeout(() => {
                const alerts = document.querySelectorAll('.bg-green-50, .bg-red-50');
                alerts.forEach(alert => {
                    if (alert) {
                        alert.style.opacity = '0';
                        alert.style.transition = 'opacity 0.5s ease';
                        setTimeout(() => {
                            if (alert.parentNode) {
                                alert.parentNode.removeChild(alert);
                            }
                        }, 500);
                    }
                });
            }, 5000);
        });
    </script>
</body>
</html>