<header class="bg-zedbank-blue shadow-sm border-b border-zedbank-blue-dark">
    <div class="flex justify-between items-center px-6 py-4">
        <div>
            <h1 class="text-2xl font-bold text-white">{{ $title ?? 'Accounting' }}</h1>
            <p class="text-gray-300">{{ $subtitle ?? 'Dashboard' }}</p>
        </div>
        
        <div class="flex items-center space-x-4">
            <div class="relative">
                <button id="user-menu-button" type="button" class="flex items-center space-x-3 p-2 rounded-lg hover:bg-zedbank-blue-dark transition-colors focus:outline-none">
                    <div class="w-8 h-8 bg-zedbank-blue-dark rounded-full flex items-center justify-center">
                        <i class="fas fa-user text-white"></i>
                    </div>
                    <span class="text-white font-medium">{{ auth()->user()->name }}</span>
                    <i class="fas fa-cog text-gray-300 pointer-events-none"></i>
                </button>
                
                <div id="user-dropdown" class="hidden absolute right-0 top-full mt-2 w-64 bg-white rounded-lg shadow-xl border border-gray-200 z-50">
                    <div class="py-2 max-h-[85vh] overflow-y-auto">
                        
                        <div class="border-b border-gray-200 pb-2 mb-2">
                            <p class="px-4 py-1 text-xs font-semibold text-gray-500 uppercase tracking-wider">Accounting Settings</p>
                            <a href="{{ route('admin.accounting.settings.report-types.index') }}" class="flex items-center space-x-3 px-4 py-2 text-gray-700 hover:bg-gray-100 transition-colors">
                                <i class="fas fa-chart-bar w-4 text-gray-400"></i>
                                <span>Report Types</span>
                            </a>
                            <a href="{{ route('admin.accounting.settings.primary-categories.index') }}" class="flex items-center space-x-3 px-4 py-2 text-gray-700 hover:bg-gray-100 transition-colors">
                                <i class="fas fa-layer-group w-4 text-gray-400"></i>
                                <span>Primary Categories</span>
                            </a>
                            <a href="{{ route('admin.accounting.settings.account-groups.index') }}" class="flex items-center space-x-3 px-4 py-2 text-gray-700 hover:bg-gray-100 transition-colors">
                                <i class="fas fa-object-group w-4 text-gray-400"></i>
                                <span>Account Groups</span>
                            </a>
                            <a href="{{ route('admin.accounting.settings.account-types.index') }}" class="flex items-center space-x-3 px-4 py-2 text-gray-700 hover:bg-gray-100 transition-colors">
                                <i class="fas fa-tags w-4 text-gray-400"></i>
                                <span>Account Types</span>
                            </a>
                            <a href="{{ route('admin.accounting.settings.financial-years.index') }}" class="flex items-center space-x-3 px-4 py-2 text-gray-700 hover:bg-gray-100 transition-colors">
                                <i class="fas fa-calendar-alt w-4 text-gray-400"></i>
                                <span>Financial Years</span>
                            </a>
                            <a href="{{ route('admin.accounting.settings.currencies.index') }}" class="flex items-center space-x-3 px-4 py-2 text-gray-700 hover:bg-gray-100 transition-colors">
                                <i class="fas fa-money-bill-wave w-4 text-gray-400"></i>
                                <span>Currencies</span>
                            </a>
                            <a href="{{ route('admin.accounting.settings.currency-rates.index') }}" class="flex items-center space-x-3 px-4 py-2 text-gray-700 hover:bg-gray-100 transition-colors">
                                <i class="fas fa-exchange-alt w-4 text-gray-400"></i>
                                <span>Currency Rates</span>
                            </a>
                            <a href="{{ route('admin.accounting.settings.business-process-mappings.index') }}" class="flex items-center space-x-3 px-4 py-2 text-gray-700 hover:bg-gray-100 transition-colors">
                                <i class="fas fa-sitemap w-4 text-gray-400"></i>
                                <span>Process Account Mapping</span>
                            </a>
                            <a href="{{ route('admin.accounting.settings.credit-score-tiers.index') }}" class="flex items-center space-x-3 px-4 py-2 text-gray-700 hover:bg-gray-100 transition-colors">
                                <i class="fas fa-chart-line w-4 text-gray-400"></i>
                                <span>Credit Score Tiers</span>
                            </a>
                        </div>

                        <div class="border-b border-gray-200 pb-2 mb-2">
                            <p class="px-4 py-1 text-xs font-semibold text-gray-500 uppercase tracking-wider">System Settings</p>
                            <a href="{{ route('admin.settings.users') }}" class="flex items-center space-x-3 px-4 py-2 text-gray-700 hover:bg-gray-100 transition-colors">
                                <i class="fas fa-users w-4 text-gray-400"></i>
                                <span>User Management</span>
                            </a>
                            <a href="{{ route('admin.settings.branches') }}" class="flex items-center space-x-3 px-4 py-2 text-gray-700 hover:bg-gray-100 transition-colors">
                                <i class="fas fa-code-branch w-4 text-gray-400"></i>
                                <span>Branch Settings</span>
                            </a>
                            <a href="{{ route('admin.settings.permissions') }}" class="flex items-center space-x-3 px-4 py-2 text-gray-700 hover:bg-gray-100 transition-colors">
                                <i class="fas fa-shield-alt w-4 text-gray-400"></i>
                                <span>Permissions</span>
                            </a>
                            <a href="{{ route('admin.settings.notifications') }}" class="flex items-center space-x-3 px-4 py-2 text-gray-700 hover:bg-gray-100 transition-colors">
                                <i class="fas fa-bell w-4 text-gray-400"></i>
                                <span>Notification Settings</span>
                            </a>
                        </div>
                        
                        <div class="border-b border-gray-200 pb-2 mb-2">
                           <p class="px-4 py-1 text-xs font-semibold text-gray-500 uppercase tracking-wider">Products & Requirements</p>
                           <a href="{{ route('admin.accounting.products.index') }}" class="flex items-center space-x-3 px-4 py-2 text-gray-700 hover:bg-gray-100 transition-colors">
                               <i class="fas fa-box w-4 text-gray-400"></i>
                               <span>Loan Products</span>
                            </a>
                            <a href="{{ route('admin.accounting.application-requirements.index') }}" class="flex items-center space-x-3 px-4 py-2 text-gray-700 hover:bg-gray-100 transition-colors">
                              <i class="fas fa-file-alt w-4 text-gray-400"></i>
                              <span>Application Requirements</span>
                            </a>
                            <a href="{{ route('admin.disbursements-channel.index') }}" class="flex items-center space-x-3 px-4 py-2 text-gray-700 hover:bg-gray-100 transition-colors">
                                <i class="fas fa-money-check-alt w-4 text-gray-400"></i>
                                <span>Disbursements Channel</span>
                            </a>
                        </div>

                        <div class="px-4 py-2">
                            <form method="POST" action="{{ route('admin.logout') }}">
                                @csrf
                                <button type="submit" class="flex items-center space-x-3 w-full text-left text-red-600 hover:text-red-700 transition-colors">
                                    <i class="fas fa-sign-out-alt w-4"></i>
                                    <span>Logout</span>
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const userMenuButton = document.getElementById('user-menu-button');
        const userDropdown = document.getElementById('user-dropdown');
        
        if (userMenuButton && userDropdown) {
            userMenuButton.addEventListener('click', function(e) {
                e.stopPropagation();
                userDropdown.classList.toggle('hidden');
            });
            
            document.addEventListener('click', function(event) {
                if (!userDropdown.contains(event.target) && !userMenuButton.contains(event.target)) {
                    userDropdown.classList.add('hidden');
                }
            });
            
            document.addEventListener('keydown', function(event) {
                if (event.key === 'Escape') {
                    userDropdown.classList.add('hidden');
                }
            });
        }
    });
</script>