<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $employee->first_name }} {{ $employee->last_name }} | {{ config('app.name', 'IMMIA FINANCE') }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#146CAA',
                        primaryLight: '#E1F0FA',
                        secondary: '#6b7280',
                        success: '#107C10',
                        warning: '#F68C1E',
                        danger: '#D83B01',
                        info: '#0078D4',
                        gray50: '#FAF9F8',
                        gray100: '#F3F2F1',
                        gray200: '#EDEBE9',
                        gray300: '#E1DFDD',
                        gray400: '#C8C6C4',
                        gray500: '#A19F9D',
                        gray600: '#605E5C',
                        gray700: '#323130',
                        gray800: '#201F1E',
                        gray900: '#000000'
                    }
                }
            }
        }
    </script>
    <style>
        /* Form Section Styling */
        .form-section {
            background: white;
            border-radius: 8px;
            padding: 24px;
            margin-bottom: 16px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            border: 1px solid #EDEBE9;
        }
        .form-section h3 {
            font-size: 18px;
            font-weight: 600;
            color: #323130;
            margin-bottom: 20px;
            padding-bottom: 12px;
            border-bottom: 1px solid #EDEBE9;
        }
        .form-group {
            margin-bottom: 20px;
        }
        .form-label {
            display: block;
            font-size: 14px;
            font-weight: 500;
            color: #605E5C;
            margin-bottom: 6px;
        }
        .form-value {
            font-size: 15px;
            color: #323130;
            font-weight: 500;
            padding: 8px 0;
            min-height: 36px;
            display: flex;
            align-items: center;
        }
        .empty-value {
            color: #A19F9D;
            font-style: italic;
        }
        .quickbooks-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
        }
        .quickbooks-table {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0;
        }
        .quickbooks-table th {
            background-color: #F3F2F1;
            color: #323130;
            font-weight: 600;
            font-size: 13px;
            text-transform: uppercase;
            padding: 12px 16px;
            border-bottom: 1px solid #EDEBE9;
            text-align: left;
        }
        .quickbooks-table td {
            padding: 12px 16px;
            border-bottom: 1px solid #EDEBE9;
            font-size: 14px;
            color: #323130;
            vertical-align: middle;
        }
        .quickbooks-table tbody tr:hover {
            background-color: #f8fafc;
        }
    </style>
</head>
<body class="bg-gray50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        @include('accounting.partials.header', ['title' => $employee->first_name . ' ' . $employee->last_name, 'subtitle' => 'Employee Details'])

        <main class="p-6">
            <!-- Back Button -->
            <div class="mb-6">
                <a href="{{ route('admin.accounting.payroll.employees.index') }}" 
                   class="text-primary hover:text-primary/90 font-medium text-sm flex items-center">
                    <i class="fas fa-arrow-left mr-2"></i>Back to Employees
                </a>
            </div>

            <!-- Employee Header -->
            <div class="bg-white rounded-lg border border-gray200 p-6 mb-6 shadow-sm">
                <div class="flex flex-col md:flex-row md:items-center justify-between">
                    <div class="flex items-center mb-4 md:mb-0">
                        <div class="w-16 h-16 {{ $employee->is_active ? 'bg-primaryLight' : 'bg-gray200' }} rounded-full flex items-center justify-center mr-4">
                            <span class="{{ $employee->is_active ? 'text-primary' : 'text-gray600' }} font-semibold text-xl">
                                {{ strtoupper(substr($employee->first_name, 0, 1)) }}{{ strtoupper(substr($employee->last_name, 0, 1)) }}
                            </span>
                        </div>
                        <div>
                            <h1 class="text-2xl font-bold text-gray900">{{ $employee->first_name }} {{ $employee->last_name }}</h1>
                            <div class="flex items-center space-x-3 mt-2">
                                <span class="quickbooks-badge bg-blue-100 text-blue-800">
                                    {{ $employee->employee_number }}
                                </span>
                                @php
                                    $typeColors = [
                                        'permanent' => 'bg-green-100 text-green-800',
                                        'contract' => 'bg-blue-100 text-blue-800',
                                        'temporary' => 'bg-yellow-100 text-yellow-800',
                                        'casual' => 'bg-purple-100 text-purple-800'
                                    ];
                                    $typeColor = $typeColors[$employee->employment_type] ?? 'bg-gray-100 text-gray-800';
                                @endphp
                                <span class="quickbooks-badge {{ $typeColor }}">
                                    {{ ucfirst($employee->employment_type) }}
                                </span>
                                @if($employee->is_active)
                                    <span class="quickbooks-badge bg-green-100 text-green-800">Active</span>
                                @else
                                    <span class="quickbooks-badge bg-red-100 text-red-800">Inactive</span>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="flex space-x-3">
                        <a href="{{ route('admin.accounting.payroll.employees.edit', $employee->id) }}" 
                           class="bg-primary text-white px-4 py-2 rounded text-sm font-medium hover:bg-primary/90 flex items-center">
                            <i class="fas fa-edit mr-2"></i>Edit
                        </a>
                        <button onclick="openDeleteModal({{ $employee->id }})" 
                                class="border border-red-300 text-red-700 px-4 py-2 rounded text-sm font-medium hover:bg-red-50 flex items-center">
                            <i class="fas fa-trash mr-2"></i>Delete
                        </button>
                    </div>
                </div>
            </div>

            <!-- Main Content -->
            <div class="space-y-6">
                <!-- Personal Information -->
                <div class="form-section">
                    <h3>Personal Information</h3>
                    
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
                        <div class="form-group">
                            <label class="form-label">First Name</label>
                            <div class="form-value">{{ $employee->first_name }}</div>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Middle Name</label>
                            <div class="form-value {{ !$employee->middle_name ? 'empty-value' : '' }}">
                                {{ $employee->middle_name ?: '—' }}
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Last Name</label>
                            <div class="form-value">{{ $employee->last_name }}</div>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                        <div class="form-group">
                            <label class="form-label">Employee Number</label>
                            <div class="form-value">{{ $employee->employee_number }}</div>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Email Address</label>
                            <div class="form-value {{ !$employee->email ? 'empty-value' : '' }}">
                                {{ $employee->email ?: '—' }}
                            </div>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                        <div class="form-group">
                            <label class="form-label">Phone Number</label>
                            <div class="form-value {{ !$employee->phone ? 'empty-value' : '' }}">
                                {{ $employee->phone ?: '—' }}
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Date of Birth</label>
                            <div class="form-value {{ !$employee->date_of_birth ? 'empty-value' : '' }}">
                                {{ $employee->date_of_birth ? $employee->date_of_birth->format('M d, Y') : '—' }}
                            </div>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="form-group">
                            <label class="form-label">Gender</label>
                            <div class="form-value {{ !$employee->gender ? 'empty-value' : '' }}">
                                {{ ucfirst($employee->gender) ?: '—' }}
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="form-label">National ID</label>
                            <div class="form-value {{ !$employee->national_id ? 'empty-value' : '' }}">
                                {{ $employee->national_id ?: '—' }}
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Employment Details -->
                <div class="form-section">
                    <h3>Employment Details</h3>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                        <div class="form-group">
                            <label class="form-label">Hire Date</label>
                            <div class="form-value">
                                {{ $employee->hire_date->format('M d, Y') }}
                                <span class="text-gray500 text-sm ml-2">
                                    ({{ $employee->hire_date->diffInYears(now()) }} years)
                                </span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Employment Type</label>
                            <div class="form-value">
                                <span class="quickbooks-badge {{ $typeColor }}">
                                    {{ ucfirst($employee->employment_type) }}
                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="form-group">
                            <label class="form-label">Department</label>
                            <div class="form-value {{ !$employee->department ? 'empty-value' : '' }}">
                                {{ $employee->department ?: '—' }}
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Position/Title</label>
                            <div class="form-value {{ !$employee->position ? 'empty-value' : '' }}">
                                {{ $employee->position ?: '—' }}
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Earnings Section -->
                <div class="form-section">
                    <h3>Earnings</h3>
                    
                    <div class="border border-gray200 rounded-lg overflow-hidden">
                        <table class="quickbooks-table">
                            <thead>
                                <tr>
                                    <th>Earning Type</th>
                                    <th>Amount</th>
                                    <th>Frequency</th>
                                    <th>Effective Date</th>
                                    <th>Taxable</th>
                                    <th>Recurring</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($employee->earnings as $earning)
                                    <tr>
                                        <td>
                                            <div class="font-medium">{{ $earning->earningType->name ?? '—' }}</div>
                                            <div class="text-xs text-gray500">{{ $earning->earningType->code ?? '' }}</div>
                                        </td>
                                        <td class="font-medium">
                                            {{ $company->currency_symbol ?? 'K' }}{{ number_format($earning->amount, 2) }}
                                        </td>
                                        <td>
                                            @php
                                                $frequencyLabels = [
                                                    'monthly' => 'Monthly',
                                                    'quarterly' => 'Quarterly',
                                                    'annually' => 'Annually',
                                                    'one-time' => 'One Time'
                                                ];
                                            @endphp
                                            {{ $frequencyLabels[$earning->frequency] ?? ucfirst($earning->frequency) }}
                                        </td>
                                        <td>{{ $earning->effective_date->format('M d, Y') }}</td>
                                        <td class="text-center">
                                            @if($earning->is_taxable)
                                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                                    Yes
                                                </span>
                                            @else
                                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                                    No
                                                </span>
                                            @endif
                                        </td>
                                        <td class="text-center">
                                            @if($earning->is_recurring)
                                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                                    Yes
                                                </span>
                                            @else
                                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                                                    No
                                                </span>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="6" class="text-center py-4 text-gray500">
                                            No earnings added
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                            <tfoot class="bg-gray100">
                                <tr>
                                    <td colspan="2" class="text-right text-sm font-medium text-gray700 py-3">
                                        <div>Total Gross Salary:</div>
                                        <div class="text-xs text-gray500">Taxable Earnings:</div>
                                        <div class="text-xs text-gray500">Non-Taxable Earnings:</div>
                                    </td>
                                    <td colspan="4" class="py-3">
                                        <div class="text-lg font-semibold text-gray900">
                                            {{ $company->currency_symbol ?? 'K' }}{{ number_format($employee->gross_salary, 2) }}
                                        </div>
                                        <div class="text-sm text-red-600">
                                            {{ $company->currency_symbol ?? 'K' }}{{ number_format($employee->earnings->where('is_taxable', true)->sum('amount'), 2) }}
                                        </div>
                                        <div class="text-sm text-green-600">
                                            {{ $company->currency_symbol ?? 'K' }}{{ number_format($employee->earnings->where('is_taxable', false)->sum('amount'), 2) }}
                                        </div>
                                    </td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>

                <!-- Statutory Information -->
                <div class="form-section">
                    <h3>Statutory Information</h3>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="form-group">
                            <label class="form-label">NAPSA Number</label>
                            <div class="form-value {{ !$employee->napsa_number ? 'empty-value' : '' }}">
                                {{ $employee->napsa_number ?: '—' }}
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="form-label">NHIMA Number</label>
                            <div class="form-value {{ !$employee->nhima_number ? 'empty-value' : '' }}">
                                {{ $employee->nhima_number ?: '—' }}
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Payment Details -->
                <div class="form-section">
                    <h3>Payment Details</h3>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                        <div class="form-group">
                            <label class="form-label">Payment Method</label>
                            <div class="form-value">
                                <span class="quickbooks-badge bg-gray-100 text-gray-800">
                                    {{ ucfirst($employee->payment_method) }}
                                </span>
                            </div>
                        </div>
                        
                        @if($employee->payment_method === 'bank')
                            <div class="form-group">
                                <label class="form-label">Bank Name</label>
                                <div class="form-value {{ !$employee->bank_name ? 'empty-value' : '' }}">
                                    {{ $employee->bank_name ?: '—' }}
                                </div>
                            </div>
                        @endif
                    </div>

                    @if($employee->payment_method === 'bank')
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                            <div class="form-group">
                                <label class="form-label">Bank Account Number</label>
                                <div class="form-value {{ !$employee->bank_account_number ? 'empty-value' : '' }}">
                                    {{ $employee->bank_account_number ?: '—' }}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="form-label">Bank Account Name</label>
                                <div class="form-value {{ !$employee->bank_account_name ? 'empty-value' : '' }}">
                                    {{ $employee->bank_account_name ?: '—' }}
                                </div>
                            </div>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div class="form-group">
                                <label class="form-label">Bank Branch</label>
                                <div class="form-value {{ !$employee->bank_branch ? 'empty-value' : '' }}">
                                    {{ $employee->bank_branch ?: '—' }}
                                </div>
                            </div>
                        </div>
                    @endif
                </div>

                <!-- Additional Information -->
                <div class="form-section">
                    <h3>Additional Information</h3>
                    
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <div class="form-group">
                            <label class="form-label">Employee Status</label>
                            <div class="form-value">
                                @if($employee->is_active)
                                    <span class="quickbooks-badge bg-green-100 text-green-800">Active</span>
                                @else
                                    <span class="quickbooks-badge bg-red-100 text-red-800">Inactive</span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Created On</label>
                            <div class="form-value">{{ $employee->created_at->format('M d, Y') }}</div>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Last Updated</label>
                            <div class="form-value">{{ $employee->updated_at->format('M d, Y') }}</div>
                        </div>
                    </div>

                    <div class="form-group mt-4">
                        <label class="form-label">Notes</label>
                        <div class="form-value bg-gray50 p-4 rounded border border-gray200 min-h-[80px] {{ !$employee->notes ? 'empty-value' : '' }}">
                            {{ $employee->notes ?: 'No notes added' }}
                        </div>
                    </div>
                </div>
            </div>

            <!-- Payroll History -->
            <div class="mt-8">
                <div class="bg-white rounded-lg border border-gray200 overflow-hidden">
                    <div class="border-b border-gray200 p-6">
                        <h3 class="text-lg font-semibold text-gray900">Recent Payroll History</h3>
                    </div>
                    
                    <div class="overflow-x-auto">
                        <table class="w-full">
                            <thead>
                                <tr class="bg-gray50">
                                    <th class="text-left py-3 px-6 text-sm font-medium text-gray700">Period</th>
                                    <th class="text-left py-3 px-6 text-sm font-medium text-gray700">Run #</th>
                                    <th class="text-left py-3 px-6 text-sm font-medium text-gray700">Gross Salary</th>
                                    <th class="text-left py-3 px-6 text-sm font-medium text-gray700">PAYE</th>
                                    <th class="text-left py-3 px-6 text-sm font-medium text-gray700">NAPSA</th>
                                    <th class="text-left py-3 px-6 text-sm font-medium text-gray700">NHIMA</th>
                                    <th class="text-left py-3 px-6 text-sm font-medium text-gray700">Net Pay</th>
                                    <th class="text-left py-3 px-6 text-sm font-medium text-gray700">Status</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray200">
                                @forelse($payrollEntries as $entry)
                                    <tr class="hover:bg-gray50">
                                        <td class="py-3 px-6 text-sm text-gray900">
                                            {{ $entry->payrollPeriod->period_name ?? 'N/A' }}
                                        </td>
                                        <td class="py-3 px-6 text-sm text-gray600">
                                            {{ $entry->payrollRun->run_number ?? 'N/A' }}
                                        </td>
                                        <td class="py-3 px-6 text-sm font-medium text-gray900">
                                            {{ $company->currency_symbol ?? 'K' }}{{ number_format($entry->gross_salary, 2) }}
                                        </td>
                                        <td class="py-3 px-6 text-sm text-danger">
                                            {{ $company->currency_symbol ?? 'K' }}{{ number_format($entry->paye_tax, 2) }}
                                        </td>
                                        <td class="py-3 px-6 text-sm text-gray600">
                                            {{ $company->currency_symbol ?? 'K' }}{{ number_format($entry->napsa_employee, 2) }}
                                        </td>
                                        <td class="py-3 px-6 text-sm text-gray600">
                                            {{ $company->currency_symbol ?? 'K' }}{{ number_format($entry->nhima_employee, 2) }}
                                        </td>
                                        <td class="py-3 px-6 text-sm font-medium text-success">
                                            {{ $company->currency_symbol ?? 'K' }}{{ number_format($entry->net_pay, 2) }}
                                        </td>
                                        <td class="py-3 px-6 text-sm">
                                            @php
                                                $statusColors = [
                                                    'pending' => 'bg-yellow-100 text-yellow-800',
                                                    'paid' => 'bg-green-100 text-green-800',
                                                    'failed' => 'bg-red-100 text-red-800'
                                                ];
                                                $statusColor = $statusColors[$entry->payment_status] ?? 'bg-gray-100 text-gray-800';
                                            @endphp
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $statusColor }}">
                                                {{ ucfirst($entry->payment_status) }}
                                            </span>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="py-8 text-center text-gray600">
                                            No payroll history found
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <!-- Delete Confirmation Modal -->
    <div id="deleteModal" class="fixed inset-0 bg-gray900 bg-opacity-50 hidden items-center justify-center z-50 p-4">
        <div class="bg-white rounded-lg shadow-lg max-w-md w-full">
            <div class="p-6">
                <div class="flex items-center mb-4">
                    <div class="w-10 h-10 bg-red-100 rounded-lg flex items-center justify-center mr-3">
                        <i class="fas fa-exclamation-triangle text-danger"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray900">Delete Employee</h3>
                        <p class="text-gray600 text-sm">Are you sure you want to delete this employee? This action cannot be undone.</p>
                    </div>
                </div>
            </div>
            
            <div class="border-t border-gray200 p-6 flex justify-end space-x-3">
                <button onclick="closeDeleteModal()" class="px-4 py-2 text-gray700 hover:bg-gray100 rounded text-sm font-medium">
                    Cancel
                </button>
                <form id="deleteForm" method="POST" action="{{ route('admin.accounting.payroll.employees.destroy', $employee->id) }}" style="display: none;">
                    @csrf
                    @method('DELETE')
                </form>
                <button onclick="confirmDelete()" class="bg-danger text-white px-4 py-2 rounded text-sm font-medium hover:bg-danger/90">
                    Delete
                </button>
            </div>
        </div>
    </div>

    <script>
        function openDeleteModal(employeeId) {
            document.getElementById('deleteModal').classList.remove('hidden');
        }

        function closeDeleteModal() {
            document.getElementById('deleteModal').classList.add('hidden');
        }

        function confirmDelete() {
            document.getElementById('deleteForm').submit();
        }
    </script>
</body>
</html>