<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Leave Management | {{ config('app.name', 'IMMIA FINANCE') }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#146CAA',
                        primaryLight: '#E1F0FA',
                        secondary: '#6b7280',
                        success: '#107C10',
                        warning: '#F68C1E',
                        danger: '#D83B01',
                        info: '#0078D4',
                        gray50: '#FAF9F8',
                        gray100: '#F3F2F1',
                        gray200: '#EDEBE9',
                        gray300: '#E1DFDD',
                        gray400: '#C8C6C4',
                        gray500: '#A19F9D',
                        gray600: '#605E5C',
                        gray700: '#323130',
                        gray800: '#201F1E',
                        gray900: '#000000'
                    }
                }
            }
        }
    </script>
    <style>
        .quickbooks-table {
            border-collapse: separate;
            border-spacing: 0;
            width: 100%;
        }
        .quickbooks-table th {
            background-color: #F3F2F1;
            color: #323130;
            font-weight: 600;
            font-size: 13px;
            text-transform: uppercase;
            padding: 12px 16px;
            border-bottom: 1px solid #EDEBE9;
            text-align: left;
        }
        .quickbooks-table td {
            padding: 12px 16px;
            border-bottom: 1px solid #EDEBE9;
            font-size: 14px;
            color: #323130;
        }
        .quickbooks-table tbody tr:hover {
            background-color: #F3F2F1;
        }
        .quickbooks-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
        }
        .action-btn {
            width: 32px;
            height: 32px;
            border-radius: 4px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            margin: 0 2px;
            transition: all 0.2s;
        }
        .action-btn:hover {
            transform: translateY(-1px);
        }
        .action-btn-view {
            background-color: #F3F2F1;
            color: #323130;
        }
        .action-btn-view:hover {
            background-color: #146CAA;
            color: white;
        }
        .action-btn-edit {
            background-color: #E1F0FA;
            color: #146CAA;
        }
        .action-btn-edit:hover {
            background-color: #146CAA;
            color: white;
        }
        .action-btn-delete {
            background-color: #FEE8E6;
            color: #D83B01;
        }
        .action-btn-delete:hover {
            background-color: #D83B01;
            color: white;
        }
        .action-btn-approve {
            background-color: #E1F0FA;
            color: #107C10;
        }
        .action-btn-approve:hover {
            background-color: #107C10;
            color: white;
        }
        .action-btn-reject {
            background-color: #FEE8E6;
            color: #D83B01;
        }
        .action-btn-reject:hover {
            background-color: #D83B01;
            color: white;
        }
        .modal-overlay {
            display: none;
            position: fixed;
            inset: 0;
            background: rgba(0, 0, 0, 0.5);
            backdrop-filter: blur(4px);
            z-index: 1000;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .modal-overlay.active {
            display: flex !important;
        }
        
        .modal-content {
            background: white;
            border-radius: 8px;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 500px;
            margin: 1rem;
            max-height: 90vh;
            overflow-y: auto;
            position: relative;
            z-index: 1001;
            transform: translateZ(0);
            animation: modalSlideIn 0.3s ease-out;
        }
        
        @keyframes modalSlideIn {
            from {
                opacity: 0;
                transform: translateY(-20px) scale(0.95);
            }
            to {
                opacity: 1;
                transform: translateY(0) scale(1);
            }
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .animate-fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }

        body.no-scroll {
            overflow: hidden;
        }

        .quickbooks-input {
            border: 1px solid #E1DFDD;
            border-radius: 4px;
            padding: 8px 12px;
            font-size: 14px;
            transition: border-color 0.2s;
            width: 100%;
        }
        .quickbooks-input:focus {
            outline: none;
            border-color: #146CAA;
            box-shadow: 0 0 0 2px rgba(20, 108, 170, 0.1);
        }
        
        .status-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 12px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
        }
        
        .badge-pending {
            background-color: #FEF7E0;
            color: #F68C1E;
        }
        
        .badge-approved {
            background-color: #E1F0FA;
            color: #107C10;
        }
        
        .badge-rejected {
            background-color: #FEE8E6;
            color: #D83B01;
        }
        
        .badge-cancelled {
            background-color: #F3F2F1;
            color: #605E5C;
        }
        
        .stat-card {
            transition: transform 0.2s;
        }
        
        .stat-card:hover {
            transform: translateY(-2px);
        }
        
        .stat-icon {
            width: 48px;
            height: 48px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
    </style>
</head>
<body class="bg-gray50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        <!-- Header -->
        <header class="bg-white border-b border-gray200 py-4 px-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-xl font-bold text-gray900">Leave Management</h1>
                    <nav class="flex space-x-2 text-sm text-gray600 mt-1">
                        <a href="{{ route('admin.accounting.index') }}" class="hover:text-primary">Dashboard</a>
                        <span>/</span>
                        <a href="{{ route('admin.accounting.payroll.index') }}" class="hover:text-primary">Payroll</a>
                        <span>/</span>
                        <span class="text-gray900">Leave Management</span>
                    </nav>
                </div>
                <div class="flex items-center space-x-3">
                    <div class="relative">
                        <button class="flex items-center space-x-2 px-4 py-2 bg-primaryLight text-primary rounded-lg text-sm font-medium hover:bg-primaryLight/80">
                            <i class="fas fa-calculator"></i>
                            <span>Process Accrual</span>
                        </button>
                    </div>
                    <button onclick="location.href='{{ route('admin.accounting.payroll.leave.requests.create') }}'" 
                            class="flex items-center space-x-2 px-4 py-2 bg-primary text-white rounded-lg text-sm font-medium hover:bg-primary/90">
                        <i class="fas fa-plus"></i>
                        <span>New Leave Request</span>
                    </button>
                </div>
            </div>
        </header>

        <main class="p-6">
            <!-- Success/Error Messages -->
            @if(session('success'))
                <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4 animate-fade-in">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <i class="fas fa-check-circle text-green-500 mr-2"></i>
                            <span class="text-green-800 font-medium">{{ session('success') }}</span>
                        </div>
                        <button onclick="this.parentElement.parentElement.remove()" class="text-green-600 hover:text-green-800">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
            @endif

            @if(session('error'))
                <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4 animate-fade-in">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <i class="fas fa-exclamation-circle text-red-500 mr-2"></i>
                            <span class="text-red-800 font-medium">{{ session('error') }}</span>
                        </div>
                        <button onclick="this.parentElement.parentElement.remove()" class="text-red-600 hover:text-red-800">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
            @endif

            <!-- Stats Cards -->
            <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
                <div class="stat-card bg-white rounded-lg border border-gray200 p-6 hover:shadow-md cursor-pointer" 
                     onclick="location.href='{{ route('admin.accounting.payroll.leave.requests.index') }}'">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-gray600 text-sm font-medium mb-1">Total Requests</p>
                            <h3 class="text-2xl font-bold text-gray900">{{ number_format($totalRequests) }}</h3>
                        </div>
                        <div class="stat-icon bg-blue-100">
                            <i class="fas fa-file-alt text-blue-600 text-xl"></i>
                        </div>
                    </div>
                </div>
                
                <div class="stat-card bg-white rounded-lg border border-gray200 p-6 hover:shadow-md cursor-pointer"
                     onclick="location.href='{{ route('admin.accounting.payroll.leave.pending-review') }}'">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-gray600 text-sm font-medium mb-1">Pending Review</p>
                            <h3 class="text-2xl font-bold text-gray900">{{ number_format($pendingRequests) }}</h3>
                        </div>
                        <div class="stat-icon bg-yellow-100">
                            <i class="fas fa-clock text-yellow-600 text-xl"></i>
                        </div>
                    </div>
                </div>
                
                <div class="stat-card bg-white rounded-lg border border-gray200 p-6 hover:shadow-md cursor-pointer"
                     onclick="location.href='{{ route('admin.accounting.payroll.leave.approved-leave') }}'">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-gray600 text-sm font-medium mb-1">Approved Leave</p>
                            <h3 class="text-2xl font-bold text-gray900">{{ number_format($approvedRequests) }}</h3>
                        </div>
                        <div class="stat-icon bg-green-100">
                            <i class="fas fa-check-circle text-green-600 text-xl"></i>
                        </div>
                    </div>
                </div>
                
                <div class="stat-card bg-white rounded-lg border border-gray200 p-6 hover:shadow-md cursor-pointer"
                     onclick="location.href='{{ route('admin.accounting.payroll.leave.taken-leaves') }}'">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-gray600 text-sm font-medium mb-1">Taken Leaves</p>
                            <h3 class="text-2xl font-bold text-gray900">{{ number_format($takenLeaves) }} days</h3>
                        </div>
                        <div class="stat-icon bg-purple-100">
                            <i class="fas fa-calendar-check text-purple-600 text-xl"></i>
                        </div>
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <!-- Recent Leave Requests -->
                <div class="lg:col-span-2">
                    <div class="bg-white rounded-lg border border-gray200">
                        <div class="flex items-center justify-between p-6 border-b border-gray200">
                            <h2 class="text-lg font-semibold text-gray900">Recent Leave Requests</h2>
                            <a href="{{ route('admin.accounting.payroll.leave.requests.index') }}" 
                               class="text-primary text-sm font-medium hover:text-primary/80">
                                View All
                            </a>
                        </div>
                        <div class="overflow-x-auto">
                            <table class="quickbooks-table">
                                <thead>
                                    <tr>
                                        <th>Employee</th>
                                        <th>Leave Type</th>
                                        <th>Dates</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($recentRequests as $request)
                                    <tr class="hover:bg-gray100 cursor-pointer" 
                                        onclick="location.href='{{ route('admin.accounting.payroll.leave.requests.show', $request->id) }}'">
                                        <td>
                                            <div class="flex items-center space-x-3">
                                                <div class="w-8 h-8 rounded-full bg-primaryLight flex items-center justify-center">
                                                    <span class="text-primary text-sm font-medium">
                                                        {{ substr($request->employee->first_name, 0, 1) }}{{ substr($request->employee->last_name, 0, 1) }}
                                                    </span>
                                                </div>
                                                <div>
                                                    <div class="font-medium text-gray900">{{ $request->employee->full_name }}</div>
                                                    <div class="text-xs text-gray500">{{ $request->employee->employee_number }}</div>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="text-sm text-gray900">{{ $request->leaveType->name }}</div>
                                            <div class="text-xs text-gray500">{{ $request->total_days }} days</div>
                                        </td>
                                        <td>
                                            <div class="text-sm text-gray900">{{ $request->formatted_start_date }}</div>
                                            <div class="text-xs text-gray500">to {{ $request->formatted_end_date }}</div>
                                        </td>
                                        <td>
                                            <span class="status-badge {{ $request->status_badge_class }}">
                                                {{ ucfirst($request->status) }}
                                            </span>
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="4" class="text-center py-12">
                                            <div class="text-center text-gray500">
                                                <i class="fas fa-calendar-times text-4xl mb-3"></i>
                                                <p>No leave requests found</p>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Quick Actions -->
                <div>
                    <div class="bg-white rounded-lg border border-gray200">
                        <div class="p-6 border-b border-gray200">
                            <h2 class="text-lg font-semibold text-gray900">Quick Actions</h2>
                        </div>
                        <div class="p-4">
                            <div class="space-y-2">
                                <button onclick="location.href='{{ route('admin.accounting.payroll.leave.requests.create') }}'" 
                                        class="w-full flex items-center justify-between p-4 text-left bg-gray50 hover:bg-gray100 rounded-lg transition-colors">
                                    <div class="flex items-center space-x-3">
                                        <div class="w-8 h-8 rounded-lg bg-blue-100 flex items-center justify-center">
                                            <i class="fas fa-plus text-blue-600"></i>
                                        </div>
                                        <div>
                                            <div class="font-medium text-gray900">New Leave Request</div>
                                            <div class="text-xs text-gray500">Submit a new leave request</div>
                                        </div>
                                    </div>
                                    <i class="fas fa-chevron-right text-gray400"></i>
                                </button>
                                
                                <button onclick="location.href='{{ route('admin.accounting.payroll.leave.pending-review') }}'" 
                                        class="w-full flex items-center justify-between p-4 text-left bg-gray50 hover:bg-gray100 rounded-lg transition-colors">
                                    <div class="flex items-center space-x-3">
                                        <div class="w-8 h-8 rounded-lg bg-yellow-100 flex items-center justify-center">
                                            <i class="fas fa-clock text-yellow-600"></i>
                                        </div>
                                        <div>
                                            <div class="font-medium text-gray900">Review Pending</div>
                                            <div class="text-xs text-gray500">{{ $pendingRequests }} requests pending</div>
                                        </div>
                                    </div>
                                    <i class="fas fa-chevron-right text-gray400"></i>
                                </button>
                                
                                <button onclick="location.href='{{ route('admin.accounting.payroll.leave.balances.index') }}'" 
                                        class="w-full flex items-center justify-between p-4 text-left bg-gray50 hover:bg-gray100 rounded-lg transition-colors">
                                    <div class="flex items-center space-x-3">
                                        <div class="w-8 h-8 rounded-lg bg-green-100 flex items-center justify-center">
                                            <i class="fas fa-balance-scale text-green-600"></i>
                                        </div>
                                        <div>
                                            <div class="font-medium text-gray900">Leave Balances</div>
                                            <div class="text-xs text-gray500">Check employee balances</div>
                                        </div>
                                    </div>
                                    <i class="fas fa-chevron-right text-gray400"></i>
                                </button>
                                
                                <button onclick="location.href='{{ route('admin.accounting.payroll.leave.settings.index') }}'" 
                                        class="w-full flex items-center justify-between p-4 text-left bg-gray50 hover:bg-gray100 rounded-lg transition-colors">
                                    <div class="flex items-center space-x-3">
                                        <div class="w-8 h-8 rounded-lg bg-purple-100 flex items-center justify-center">
                                            <i class="fas fa-cog text-purple-600"></i>
                                        </div>
                                        <div>
                                            <div class="font-medium text-gray900">Leave Settings</div>
                                            <div class="text-xs text-gray500">Configure leave types</div>
                                        </div>
                                    </div>
                                    <i class="fas fa-chevron-right text-gray400"></i>
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Leave Types Summary -->
                    <div class="bg-white rounded-lg border border-gray200 mt-6">
                        <div class="flex items-center justify-between p-6 border-b border-gray200">
                            <h2 class="text-lg font-semibold text-gray900">Leave Types</h2>
                            <a href="{{ route('admin.accounting.payroll.leave.settings.index') }}" 
                               class="text-primary text-sm font-medium hover:text-primary/80">
                                Manage
                            </a>
                        </div>
                        <div class="p-4">
                            <div class="space-y-3">
                                @foreach($leaveTypes as $type)
                                <div class="flex items-center justify-between p-3 bg-gray50 rounded-lg">
                                    <div>
                                        <div class="font-medium text-gray900">{{ $type->name }}</div>
                                        <div class="text-xs text-gray500">{{ $type->accrual_description }}</div>
                                    </div>
                                    <div class="text-right">
                                        <div class="font-semibold text-gray900">{{ $type->max_days_per_year ?: '∞' }}</div>
                                        <div class="text-xs text-gray500">days/year</div>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <script>
        // Auto-hide alerts after 5 seconds
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(() => {
                const alerts = document.querySelectorAll('.bg-green-50, .bg-red-50');
                alerts.forEach(alert => {
                    if (alert) {
                        alert.style.opacity = '0';
                        alert.style.transition = 'opacity 0.5s ease';
                        setTimeout(() => {
                            if (alert.parentNode) {
                                alert.parentNode.removeChild(alert);
                            }
                        }, 500);
                    }
                });
            }, 5000);
            
            // Add hover effects to stat cards
            const statCards = document.querySelectorAll('.stat-card');
            statCards.forEach(card => {
                card.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-2px)';
                });
                card.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0)';
                });
            });
        });
    </script>
</body>
</html>