<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Leave Requests | {{ config('app.name', 'IMMIA FINANCE') }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#146CAA',
                        primaryLight: '#E1F0FA',
                        secondary: '#6b7280',
                        success: '#107C10',
                        warning: '#F68C1E',
                        danger: '#D83B01',
                        info: '#0078D4',
                        gray50: '#FAF9F8',
                        gray100: '#F3F2F1',
                        gray200: '#EDEBE9',
                        gray300: '#E1DFDD',
                        gray400: '#C8C6C4',
                        gray500: '#A19F9D',
                        gray600: '#605E5C',
                        gray700: '#323130',
                        gray800: '#201F1E',
                        gray900: '#000000'
                    }
                }
            }
        }
    </script>
    <style>
        .quickbooks-table {
            border-collapse: separate;
            border-spacing: 0;
            width: 100%;
        }
        .quickbooks-table th {
            background-color: #F3F2F1;
            color: #323130;
            font-weight: 600;
            font-size: 13px;
            text-transform: uppercase;
            padding: 12px 16px;
            border-bottom: 1px solid #EDEBE9;
            text-align: left;
        }
        .quickbooks-table td {
            padding: 12px 16px;
            border-bottom: 1px solid #EDEBE9;
            font-size: 14px;
            color: #323130;
        }
        .quickbooks-table tbody tr:hover {
            background-color: #F3F2F1;
        }
        .quickbooks-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
        }
        .action-btn {
            width: 32px;
            height: 32px;
            border-radius: 4px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            margin: 0 2px;
            transition: all 0.2s;
        }
        .action-btn:hover {
            transform: translateY(-1px);
        }
        .action-btn-view {
            background-color: #F3F2F1;
            color: #323130;
        }
        .action-btn-view:hover {
            background-color: #146CAA;
            color: white;
        }
        .action-btn-approve {
            background-color: #E1F0FA;
            color: #107C10;
        }
        .action-btn-approve:hover {
            background-color: #107C10;
            color: white;
        }
        .action-btn-reject {
            background-color: #FEE8E6;
            color: #D83B01;
        }
        .action-btn-reject:hover {
            background-color: #D83B01;
            color: white;
        }
        .action-btn-cancel {
            background-color: #F3F2F1;
            color: #605E5C;
        }
        .action-btn-cancel:hover {
            background-color: #605E5C;
            color: white;
        }
        .quickbooks-input {
            border: 1px solid #E1DFDD;
            border-radius: 4px;
            padding: 8px 12px;
            font-size: 14px;
            transition: border-color 0.2s;
            width: 100%;
        }
        .quickbooks-input:focus {
            outline: none;
            border-color: #146CAA;
            box-shadow: 0 0 0 2px rgba(20, 108, 170, 0.1);
        }
        
        .status-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 12px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
        }
        
        .badge-pending {
            background-color: #FEF7E0;
            color: #F68C1E;
        }
        
        .badge-approved {
            background-color: #E1F0FA;
            color: #107C10;
        }
        
        .badge-rejected {
            background-color: #FEE8E6;
            color: #D83B01;
        }
        
        .badge-cancelled {
            background-color: #F3F2F1;
            color: #605E5C;
        }
    </style>
</head>
<body class="bg-gray50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        <!-- Header -->
        <header class="bg-white border-b border-gray200 py-4 px-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-xl font-bold text-gray900">Leave Requests</h1>
                    <nav class="flex space-x-2 text-sm text-gray600 mt-1">
                        <a href="{{ route('admin.accounting.index') }}" class="hover:text-primary">Dashboard</a>
                        <span>/</span>
                        <a href="{{ route('admin.accounting.payroll.index') }}" class="hover:text-primary">Payroll</a>
                        <span>/</span>
                        <a href="{{ route('admin.accounting.payroll.leave.index') }}" class="hover:text-primary">Leave Management</a>
                        <span>/</span>
                        <span class="text-gray900">Leave Requests</span>
                    </nav>
                </div>
                <button onclick="location.href='{{ route('admin.accounting.payroll.leave.requests.create') }}'" 
                        class="flex items-center space-x-2 px-4 py-2 bg-primary text-white rounded-lg text-sm font-medium hover:bg-primary/90">
                    <i class="fas fa-plus"></i>
                    <span>New Leave Request</span>
                </button>
            </div>
        </header>

        <main class="p-6">
            <!-- Success/Error Messages -->
            @if(session('success'))
                <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4 animate-fade-in">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <i class="fas fa-check-circle text-green-500 mr-2"></i>
                            <span class="text-green-800 font-medium">{{ session('success') }}</span>
                        </div>
                        <button onclick="this.parentElement.parentElement.remove()" class="text-green-600 hover:text-green-800">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
            @endif

            @if(session('error'))
                <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4 animate-fade-in">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <i class="fas fa-exclamation-circle text-red-500 mr-2"></i>
                            <span class="text-red-800 font-medium">{{ session('error') }}</span>
                        </div>
                        <button onclick="this.parentElement.parentElement.remove()" class="text-red-600 hover:text-red-800">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
            @endif

            <!-- Filters -->
            <div class="bg-white rounded-lg border border-gray200 p-6 mb-6">
                <form method="GET" action="{{ route('admin.accounting.payroll.leave.requests.index') }}">
                    <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray700 mb-2">Status</label>
                            <select name="status" class="quickbooks-input" onchange="this.form.submit()">
                                <option value="all" {{ request('status') == 'all' ? 'selected' : '' }}>All Status</option>
                                <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                                <option value="approved" {{ request('status') == 'approved' ? 'selected' : '' }}>Approved</option>
                                <option value="rejected" {{ request('status') == 'rejected' ? 'selected' : '' }}>Rejected</option>
                                <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                            </select>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray700 mb-2">Leave Type</label>
                            <select name="leave_type_id" class="quickbooks-input" onchange="this.form.submit()">
                                <option value="all" {{ request('leave_type_id') == 'all' ? 'selected' : '' }}>All Types</option>
                                @foreach($leaveTypes as $type)
                                <option value="{{ $type->id }}" {{ request('leave_type_id') == $type->id ? 'selected' : '' }}>
                                    {{ $type->name }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray700 mb-2">Employee</label>
                            <select name="employee_id" class="quickbooks-input" onchange="this.form.submit()">
                                <option value="all" {{ request('employee_id') == 'all' ? 'selected' : '' }}>All Employees</option>
                                @foreach($employees as $employee)
                                <option value="{{ $employee->id }}" {{ request('employee_id') == $employee->id ? 'selected' : '' }}>
                                    {{ $employee->full_name }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        
                        <div class="flex items-end">
                            <button type="submit" class="w-full bg-primary text-white px-4 py-2 rounded text-sm font-medium hover:bg-primary/90">
                                <i class="fas fa-filter mr-2"></i>Filter
                            </button>
                        </div>
                    </div>
                </form>
            </div>

            <!-- Leave Requests Table -->
            <div class="bg-white rounded-lg border border-gray200 overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="quickbooks-table">
                        <thead>
                            <tr>
                                <th>Employee</th>
                                <th>Leave Type</th>
                                <th>Dates</th>
                                <th>Duration</th>
                                <th>Status</th>
                                <th>Requested</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($leaveRequests as $request)
                            <tr class="hover:bg-gray100">
                                <td>
                                    <div class="flex items-center space-x-3">
                                        <div class="w-8 h-8 rounded-full bg-primaryLight flex items-center justify-center">
                                            <span class="text-primary text-sm font-medium">
                                                {{ substr($request->employee->first_name, 0, 1) }}{{ substr($request->employee->last_name, 0, 1) }}
                                            </span>
                                        </div>
                                        <div>
                                            <a href="{{ route('admin.accounting.payroll.leave.requests.show', $request->id) }}" 
                                               class="font-medium text-gray900 hover:text-primary">
                                                {{ $request->employee->full_name }}
                                            </a>
                                            <div class="text-xs text-gray500">{{ $request->employee->employee_number }}</div>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="text-sm text-gray900">{{ $request->leaveType->name }}</div>
                                    @if($request->leaveType->is_paid)
                                    <div class="text-xs text-green-600">Paid Leave</div>
                                    @else
                                    <div class="text-xs text-gray500">Unpaid Leave</div>
                                    @endif
                                </td>
                                <td>
                                    <div class="text-sm text-gray900">{{ $request->formatted_start_date }}</div>
                                    <div class="text-xs text-gray500">to {{ $request->formatted_end_date }}</div>
                                </td>
                                <td>
                                    <div class="text-sm font-medium text-gray900">{{ $request->total_days }} days</div>
                                </td>
                                <td>
                                    <span class="status-badge {{ $request->status_badge_class }}">
                                        {{ ucfirst($request->status) }}
                                    </span>
                                </td>
                                <td>
                                    <div class="text-sm text-gray900">{{ $request->formatted_created_at }}</div>
                                </td>
                                <td>
                                    <div class="flex items-center">
                                        <a href="{{ route('admin.accounting.payroll.leave.requests.show', $request->id) }}" 
                                           class="action-btn action-btn-view"
                                           title="View Details">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        
                                        @if($request->status == 'pending')
                                            <a href="{{ route('admin.accounting.payroll.leave.requests.approve', $request->id) }}" 
                                               class="action-btn action-btn-approve"
                                               title="Approve"
                                               onclick="return confirm('Are you sure you want to approve this leave request?')">
                                                <i class="fas fa-check"></i>
                                            </a>
                                            <a href="{{ route('admin.accounting.payroll.leave.requests.reject', $request->id) }}" 
                                               class="action-btn action-btn-reject"
                                               title="Reject"
                                               onclick="return confirm('Are you sure you want to reject this leave request?')">
                                                <i class="fas fa-times"></i>
                                            </a>
                                        @endif
                                        
                                        @if(in_array($request->status, ['pending', 'approved']))
                                            <a href="{{ route('admin.accounting.payroll.leave.requests.cancel', $request->id) }}" 
                                               class="action-btn action-btn-cancel"
                                               title="Cancel"
                                               onclick="return confirm('Are you sure you want to cancel this leave request?')">
                                                <i class="fas fa-ban"></i>
                                            </a>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="7" class="text-center py-12">
                                    <div class="text-center text-gray500">
                                        <i class="fas fa-inbox text-4xl mb-3"></i>
                                        <p>No leave requests found</p>
                                        @if(request()->hasAny(['status', 'leave_type_id', 'employee_id']))
                                        <p class="text-sm mt-2">Try changing your filters</p>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                @if($leaveRequests->hasPages())
                <div class="p-6 border-t border-gray200">
                    <div class="flex items-center justify-between">
                        <div class="text-sm text-gray600">
                            Showing {{ $leaveRequests->firstItem() }} to {{ $leaveRequests->lastItem() }} of {{ $leaveRequests->total() }} entries
                        </div>
                        <div class="flex space-x-2">
                            @if($leaveRequests->onFirstPage())
                            <span class="px-3 py-1 rounded bg-gray100 text-gray500 text-sm">Previous</span>
                            @else
                            <a href="{{ $leaveRequests->previousPageUrl() }}" class="px-3 py-1 rounded bg-gray100 hover:bg-gray200 text-gray700 text-sm">Previous</a>
                            @endif
                            
                            @foreach($leaveRequests->getUrlRange(1, $leaveRequests->lastPage()) as $page => $url)
                                @if($page == $leaveRequests->currentPage())
                                <span class="px-3 py-1 rounded bg-primary text-white text-sm">{{ $page }}</span>
                                @else
                                <a href="{{ $url }}" class="px-3 py-1 rounded bg-gray100 hover:bg-gray200 text-gray700 text-sm">{{ $page }}</a>
                                @endif
                            @endforeach
                            
                            @if($leaveRequests->hasMorePages())
                            <a href="{{ $leaveRequests->nextPageUrl() }}" class="px-3 py-1 rounded bg-gray100 hover:bg-gray200 text-gray700 text-sm">Next</a>
                            @else
                            <span class="px-3 py-1 rounded bg-gray100 text-gray500 text-sm">Next</span>
                            @endif
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </main>
    </div>

    <script>
        // Auto-hide alerts after 5 seconds
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(() => {
                const alerts = document.querySelectorAll('.bg-green-50, .bg-red-50');
                alerts.forEach(alert => {
                    if (alert) {
                        alert.style.opacity = '0';
                        alert.style.transition = 'opacity 0.5s ease';
                        setTimeout(() => {
                            if (alert.parentNode) {
                                alert.parentNode.removeChild(alert);
                            }
                        }, 500);
                    }
                });
            }, 5000);
            
            // Add status badge colors
            const statusBadges = document.querySelectorAll('.status-badge');
            statusBadges.forEach(badge => {
                const status = badge.textContent.toLowerCase().trim();
                if (status.includes('pending')) {
                    badge.classList.add('badge-pending');
                } else if (status.includes('approved')) {
                    badge.classList.add('badge-approved');
                } else if (status.includes('rejected')) {
                    badge.classList.add('badge-rejected');
                } else if (status.includes('cancelled')) {
                    badge.classList.add('badge-cancelled');
                }
            });
        });
    </script>
</body>
</html>