<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Leave Request Details | {{ config('app.name', 'IMMIA FINANCE') }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#146CAA',
                        primaryLight: '#E1F0FA',
                        secondary: '#6b7280',
                        success: '#107C10',
                        warning: '#F68C1E',
                        danger: '#D83B01',
                        info: '#0078D4',
                        gray50: '#FAF9F8',
                        gray100: '#F3F2F1',
                        gray200: '#EDEBE9',
                        gray300: '#E1DFDD',
                        gray400: '#C8C6C4',
                        gray500: '#A19F9D',
                        gray600: '#605E5C',
                        gray700: '#323130',
                        gray800: '#201F1E',
                        gray900: '#000000'
                    }
                }
            }
        }
    </script>
    <style>
        .status-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 12px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
        }
        
        .badge-pending {
            background-color: #FEF7E0;
            color: #F68C1E;
        }
        
        .badge-approved {
            background-color: #E1F0FA;
            color: #107C10;
        }
        
        .badge-rejected {
            background-color: #FEE8E6;
            color: #D83B01;
        }
        
        .badge-cancelled {
            background-color: #F3F2F1;
            color: #605E5C;
        }
        
        .info-card {
            background-color: white;
            border: 1px solid #EDEBE9;
            border-radius: 8px;
            padding: 20px;
        }
        
        .info-label {
            font-size: 12px;
            font-weight: 600;
            color: #605E5C;
            text-transform: uppercase;
            margin-bottom: 4px;
        }
        
        .info-value {
            font-size: 14px;
            font-weight: 500;
            color: #323130;
        }
        
        .modal-overlay {
            display: none;
            position: fixed;
            inset: 0;
            background: rgba(0, 0, 0, 0.5);
            backdrop-filter: blur(4px);
            z-index: 1000;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .modal-overlay.active {
            display: flex !important;
        }
        
        .modal-content {
            background: white;
            border-radius: 8px;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 500px;
            margin: 1rem;
            max-height: 90vh;
            overflow-y: auto;
            position: relative;
            z-index: 1001;
            transform: translateZ(0);
            animation: modalSlideIn 0.3s ease-out;
        }
        
        @keyframes modalSlideIn {
            from {
                opacity: 0;
                transform: translateY(-20px) scale(0.95);
            }
            to {
                opacity: 1;
                transform: translateY(0) scale(1);
            }
        }
        
        .quickbooks-input {
            border: 1px solid #E1DFDD;
            border-radius: 4px;
            padding: 8px 12px;
            font-size: 14px;
            transition: border-color 0.2s;
            width: 100%;
        }
        .quickbooks-input:focus {
            outline: none;
            border-color: #146CAA;
            box-shadow: 0 0 0 2px rgba(20, 108, 170, 0.1);
        }
    </style>
</head>
<body class="bg-gray50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        <!-- Header -->
        <header class="bg-white border-b border-gray200 py-4 px-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-xl font-bold text-gray900">Leave Request Details</h1>
                    <nav class="flex space-x-2 text-sm text-gray600 mt-1">
                        <a href="{{ route('admin.accounting.index') }}" class="hover:text-primary">Dashboard</a>
                        <span>/</span>
                        <a href="{{ route('admin.accounting.payroll.index') }}" class="hover:text-primary">Payroll</a>
                        <span>/</span>
                        <a href="{{ route('admin.accounting.payroll.leave.index') }}" class="hover:text-primary">Leave Management</a>
                        <span>/</span>
                        <a href="{{ route('admin.accounting.payroll.leave.requests.index') }}" class="hover:text-primary">Leave Requests</a>
                        <span>/</span>
                        <span class="text-gray900">Details</span>
                    </nav>
                </div>
                <div class="flex items-center space-x-3">
                    <a href="{{ route('admin.accounting.payroll.leave.requests.index') }}" 
                       class="px-4 py-2 text-gray700 hover:bg-gray100 rounded text-sm font-medium">
                        Back to List
                    </a>
                </div>
            </div>
        </header>

        <main class="p-6">
            <!-- Success/Error Messages -->
            @if(session('success'))
                <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4 animate-fade-in">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <i class="fas fa-check-circle text-green-500 mr-2"></i>
                            <span class="text-green-800 font-medium">{{ session('success') }}</span>
                        </div>
                        <button onclick="this.parentElement.parentElement.remove()" class="text-green-600 hover:text-green-800">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
            @endif

            @if(session('error'))
                <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4 animate-fade-in">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <i class="fas fa-exclamation-circle text-red-500 mr-2"></i>
                            <span class="text-red-800 font-medium">{{ session('error') }}</span>
                        </div>
                        <button onclick="this.parentElement.parentElement.remove()" class="text-red-600 hover:text-red-800">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
            @endif

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <!-- Main Information -->
                <div class="lg:col-span-2 space-y-6">
                    <!-- Status Card -->
                    <div class="info-card">
                        <div class="flex items-center justify-between mb-6">
                            <div>
                                <h2 class="text-lg font-semibold text-gray900">Leave Request Status</h2>
                                <p class="text-gray600 text-sm mt-1">Request ID: LR-{{ str_pad($leaveRequest->id, 6, '0', STR_PAD_LEFT) }}</p>
                            </div>
                            <div>
                                <span class="status-badge {{ $leaveRequest->status_badge_class }}">
                                    {{ ucfirst($leaveRequest->status) }}
                                </span>
                            </div>
                        </div>
                        
                        <!-- Action Buttons -->
                        @if($leaveRequest->status == 'pending')
                        <div class="flex space-x-3">
                            <form method="POST" action="{{ route('admin.accounting.payroll.leave.requests.approve', $leaveRequest->id) }}" 
                                  class="flex-1">
                                @csrf
                                <button type="button" 
                                        onclick="openApproveModal()"
                                        class="w-full bg-success text-white px-4 py-3 rounded-lg text-sm font-medium hover:bg-success/90 flex items-center justify-center gap-2">
                                    <i class="fas fa-check"></i>
                                    Approve Leave Request
                                </button>
                            </form>
                            
                            <form method="POST" action="{{ route('admin.accounting.payroll.leave.requests.reject', $leaveRequest->id) }}" 
                                  class="flex-1">
                                @csrf
                                <button type="button" 
                                        onclick="openRejectModal()"
                                        class="w-full bg-danger text-white px-4 py-3 rounded-lg text-sm font-medium hover:bg-danger/90 flex items-center justify-center gap-2">
                                    <i class="fas fa-times"></i>
                                    Reject Leave Request
                                </button>
                            </form>
                        </div>
                        @endif
                        
                        @if(in_array($leaveRequest->status, ['pending', 'approved']))
                        <div class="mt-3">
                            <form method="POST" action="{{ route('admin.accounting.payroll.leave.requests.cancel', $leaveRequest->id) }}">
                                @csrf
                                <button type="submit" 
                                        onclick="return confirm('Are you sure you want to cancel this leave request?')"
                                        class="w-full bg-gray200 text-gray700 px-4 py-3 rounded-lg text-sm font-medium hover:bg-gray300 flex items-center justify-center gap-2">
                                    <i class="fas fa-ban"></i>
                                    Cancel Leave Request
                                </button>
                            </form>
                        </div>
                        @endif
                    </div>

                    <!-- Leave Details -->
                    <div class="info-card">
                        <h2 class="text-lg font-semibold text-gray900 mb-6">Leave Details</h2>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <div class="mb-4">
                                    <div class="info-label">Employee</div>
                                    <div class="info-value">{{ $leaveRequest->employee->full_name }}</div>
                                    <div class="text-sm text-gray500">{{ $leaveRequest->employee->employee_number }}</div>
                                </div>
                                
                                <div class="mb-4">
                                    <div class="info-label">Department</div>
                                    <div class="info-value">{{ $leaveRequest->employee->department->name ?? 'Not Assigned' }}</div>
                                </div>
                                
                                <div class="mb-4">
                                    <div class="info-label">Employment Type</div>
                                    <div class="info-value">{{ ucfirst($leaveRequest->employee->employment_type) }}</div>
                                </div>
                            </div>
                            
                            <div>
                                <div class="mb-4">
                                    <div class="info-label">Leave Type</div>
                                    <div class="info-value">{{ $leaveRequest->leaveType->name }}</div>
                                    @if($leaveRequest->leaveType->is_paid)
                                    <div class="text-sm text-green-600">Paid Leave</div>
                                    @else
                                    <div class="text-sm text-gray500">Unpaid Leave</div>
                                    @endif
                                </div>
                                
                                <div class="mb-4">
                                    <div class="info-label">Duration</div>
                                    <div class="info-value">{{ $leaveRequest->total_days }} days</div>
                                </div>
                                
                                <div class="mb-4">
                                    <div class="info-label">Date Range</div>
                                    <div class="info-value">{{ $leaveRequest->formatted_start_date }} to {{ $leaveRequest->formatted_end_date }}</div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Reason -->
                        <div class="mt-6 pt-6 border-t border-gray200">
                            <div class="info-label">Reason for Leave</div>
                            <div class="info-value whitespace-pre-line">{{ $leaveRequest->reason }}</div>
                        </div>
                    </div>
                </div>

                <!-- Side Panel -->
                <div class="space-y-6">
                    <!-- Request Information -->
                    <div class="info-card">
                        <h2 class="text-lg font-semibold text-gray900 mb-6">Request Information</h2>
                        
                        <div class="space-y-4">
                            <div>
                                <div class="info-label">Requested By</div>
                                <div class="info-value">{{ $leaveRequest->requester->name ?? 'System' }}</div>
                            </div>
                            
                            <div>
                                <div class="info-label">Requested On</div>
                                <div class="info-value">{{ $leaveRequest->formatted_created_at }}</div>
                            </div>
                            
                            @if($leaveRequest->status == 'approved')
                            <div>
                                <div class="info-label">Approved By</div>
                                <div class="info-value">{{ $leaveRequest->approver->name ?? 'System' }}</div>
                            </div>
                            
                            <div>
                                <div class="info-label">Approved On</div>
                                <div class="info-value">{{ $leaveRequest->approved_at ? $leaveRequest->approved_at->format('M d, Y H:i') : 'N/A' }}</div>
                            </div>
                            
                            @if($leaveRequest->approval_notes)
                            <div>
                                <div class="info-label">Approval Notes</div>
                                <div class="info-value">{{ $leaveRequest->approval_notes }}</div>
                            </div>
                            @endif
                            @endif
                            
                            @if($leaveRequest->status == 'rejected')
                            <div>
                                <div class="info-label">Rejected By</div>
                                <div class="info-value">{{ $leaveRequest->rejector->name ?? 'System' }}</div>
                            </div>
                            
                            <div>
                                <div class="info-label">Rejected On</div>
                                <div class="info-value">{{ $leaveRequest->rejected_at ? $leaveRequest->rejected_at->format('M d, Y H:i') : 'N/A' }}</div>
                            </div>
                            
                            @if($leaveRequest->rejection_reason)
                            <div>
                                <div class="info-label">Rejection Reason</div>
                                <div class="info-value">{{ $leaveRequest->rejection_reason }}</div>
                            </div>
                            @endif
                            @endif
                        </div>
                    </div>

                    <!-- Employee Balance -->
                    <div class="info-card">
                        <h2 class="text-lg font-semibold text-gray900 mb-6">Leave Balance</h2>
                        
                        <div class="space-y-4">
                            <div class="flex items-center justify-between">
                                <div>
                                    <div class="info-label">Available Balance</div>
                                    <div class="info-value" id="balanceValue">Loading...</div>
                                </div>
                                <div class="text-right">
                                    <div class="info-label">Total Accrued</div>
                                    <div class="info-value" id="totalAccrued">Loading...</div>
                                </div>
                            </div>
                            
                            <div class="pt-4 border-t border-gray200">
                                <div class="info-label">Days Taken</div>
                                <div class="info-value" id="daysTaken">Loading...</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <!-- Approve Modal -->
    <div id="approveModal" class="modal-overlay">
        <div class="modal-content">
            <div class="flex items-center justify-between p-6 border-b border-gray200">
                <div class="flex items-center">
                    <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                        <i class="fas fa-check text-green-600"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray900">Approve Leave Request</h3>
                        <p class="text-gray600 text-sm mt-1">Add optional approval notes</p>
                    </div>
                </div>
                <button onclick="closeApproveModal()" class="text-gray500 hover:text-gray700">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            
            <div class="p-6">
                <form method="POST" action="{{ route('admin.accounting.payroll.leave.requests.approve', $leaveRequest->id) }}">
                    @csrf
                    
                    <div class="mb-4">
                        <label for="approval_notes" class="block text-sm font-medium text-gray700 mb-2">Approval Notes (Optional)</label>
                        <textarea name="approval_notes" 
                                  id="approval_notes"
                                  rows="3"
                                  class="quickbooks-input resize-none"
                                  placeholder="Add any notes or comments about this approval"></textarea>
                    </div>
                    
                    <div class="flex justify-end gap-3 mt-6 pt-6 border-t border-gray200">
                        <button type="button" 
                                onclick="closeApproveModal()" 
                                class="px-4 py-2 text-gray700 hover:bg-gray100 rounded text-sm font-medium">
                            Cancel
                        </button>
                        <button type="submit" 
                                class="bg-success text-white px-4 py-2 rounded text-sm font-medium hover:bg-success/90 flex items-center gap-2">
                            <i class="fas fa-check"></i>
                            Approve Request
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Reject Modal -->
    <div id="rejectModal" class="modal-overlay">
        <div class="modal-content">
            <div class="flex items-center justify-between p-6 border-b border-gray200">
                <div class="flex items-center">
                    <div class="w-10 h-10 bg-red-100 rounded-lg flex items-center justify-center mr-3">
                        <i class="fas fa-times text-red-600"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray900">Reject Leave Request</h3>
                        <p class="text-gray600 text-sm mt-1">Provide a reason for rejection</p>
                    </div>
                </div>
                <button onclick="closeRejectModal()" class="text-gray500 hover:text-gray700">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            
            <div class="p-6">
                <form method="POST" action="{{ route('admin.accounting.payroll.leave.requests.reject', $leaveRequest->id) }}">
                    @csrf
                    
                    <div class="mb-4">
                        <label for="rejection_reason" class="block text-sm font-medium text-gray700 mb-2">Rejection Reason *</label>
                        <textarea name="rejection_reason" 
                                  id="rejection_reason"
                                  rows="3"
                                  class="quickbooks-input resize-none"
                                  placeholder="Please provide a reason for rejecting this leave request"
                                  required></textarea>
                    </div>
                    
                    <div class="flex justify-end gap-3 mt-6 pt-6 border-t border-gray200">
                        <button type="button" 
                                onclick="closeRejectModal()" 
                                class="px-4 py-2 text-gray700 hover:bg-gray100 rounded text-sm font-medium">
                            Cancel
                        </button>
                        <button type="submit" 
                                class="bg-danger text-white px-4 py-2 rounded text-sm font-medium hover:bg-danger/90 flex items-center gap-2">
                            <i class="fas fa-times"></i>
                            Reject Request
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        // Modal Functions
        function openApproveModal() {
            const modal = document.getElementById('approveModal');
            modal.classList.add('active');
            document.body.classList.add('no-scroll');
            
            setTimeout(() => {
                const notesInput = document.getElementById('approval_notes');
                if (notesInput) notesInput.focus();
            }, 100);
        }

        function closeApproveModal() {
            const modal = document.getElementById('approveModal');
            modal.classList.remove('active');
            document.body.classList.remove('no-scroll');
        }

        function openRejectModal() {
            const modal = document.getElementById('rejectModal');
            modal.classList.add('active');
            document.body.classList.add('no-scroll');
            
            setTimeout(() => {
                const reasonInput = document.getElementById('rejection_reason');
                if (reasonInput) reasonInput.focus();
            }, 100);
        }

        function closeRejectModal() {
            const modal = document.getElementById('rejectModal');
            modal.classList.remove('active');
            document.body.classList.remove('no-scroll');
        }

        // Close modals with Escape key
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                closeApproveModal();
                closeRejectModal();
            }
        });

        // Load employee leave balance
        document.addEventListener('DOMContentLoaded', function() {
            loadLeaveBalance();
            
            // Auto-hide alerts after 5 seconds
            setTimeout(() => {
                const alerts = document.querySelectorAll('.bg-green-50, .bg-red-50');
                alerts.forEach(alert => {
                    if (alert) {
                        alert.style.opacity = '0';
                        alert.style.transition = 'opacity 0.5s ease';
                        setTimeout(() => {
                            if (alert.parentNode) {
                                alert.parentNode.removeChild(alert);
                            }
                        }, 500);
                    }
                });
            }, 5000);
        });
        
        async function loadLeaveBalance() {
            const employeeId = {{ $leaveRequest->employee_id }};
            const leaveTypeId = {{ $leaveRequest->leave_type_id }};
            
            try {
                const response = await fetch(`{{ url('/') }}/admin/accounting/payroll/leave/balance/${employeeId}/${leaveTypeId}`);
                const data = await response.json();
                
                if (data.success) {
                    document.getElementById('balanceValue').textContent = data.balance + ' days';
                    document.getElementById('totalAccrued').textContent = data.total_accrued + ' days';
                    document.getElementById('daysTaken').textContent = data.total_taken + ' days';
                } else {
                    throw new Error(data.message || 'Failed to load balance');
                }
            } catch (error) {
                console.error('Error loading leave balance:', error);
                document.getElementById('balanceValue').textContent = 'Error';
                document.getElementById('totalAccrued').textContent = 'Error';
                document.getElementById('daysTaken').textContent = 'Error';
            }
        }
    </script>
</body>
</html>