<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Leave Type | {{ config('app.name', 'IMMIA FINANCE') }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#146CAA',
                        primaryLight: '#E1F0FA',
                        secondary: '#6b7280',
                        success: '#107C10',
                        warning: '#F68C1E',
                        danger: '#D83B01',
                        info: '#0078D4',
                        gray50: '#FAF9F8',
                        gray100: '#F3F2F1',
                        gray200: '#EDEBE9',
                        gray300: '#E1DFDD',
                        gray400: '#C8C6C4',
                        gray500: '#A19F9D',
                        gray600: '#605E5C',
                        gray700: '#323130',
                        gray800: '#201F1E',
                        gray900: '#000000'
                    }
                }
            }
        }
    </script>
    <style>
        .quickbooks-input {
            border: 1px solid #E1DFDD;
            border-radius: 4px;
            padding: 8px 12px;
            font-size: 14px;
            transition: border-color 0.2s;
            width: 100%;
        }
        .quickbooks-input:focus {
            outline: none;
            border-color: #146CAA;
            box-shadow: 0 0 0 2px rgba(20, 108, 170, 0.1);
        }
        .quickbooks-textarea {
            border: 1px solid #E1DFDD;
            border-radius: 4px;
            padding: 8px 12px;
            font-size: 14px;
            transition: border-color 0.2s;
            width: 100%;
            resize: vertical;
            min-height: 100px;
        }
        .quickbooks-textarea:focus {
            outline: none;
            border-color: #146CAA;
            box-shadow: 0 0 0 2px rgba(20, 108, 170, 0.1);
        }
        .form-label {
            display: block;
            font-size: 14px;
            font-weight: 600;
            color: #323130;
            margin-bottom: 8px;
        }
        .required::after {
            content: "*";
            color: #D83B01;
            margin-left: 4px;
        }
    </style>
</head>
<body class="bg-gray50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        <!-- Header -->
        <header class="bg-white border-b border-gray200 py-4 px-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-xl font-bold text-gray900">Edit Leave Type</h1>
                    <nav class="flex space-x-2 text-sm text-gray600 mt-1">
                        <a href="{{ route('admin.accounting.index') }}" class="hover:text-primary">Dashboard</a>
                        <span>/</span>
                        <a href="{{ route('admin.accounting.payroll.index') }}" class="hover:text-primary">Payroll</a>
                        <span>/</span>
                        <a href="{{ route('admin.accounting.payroll.leave.index') }}" class="hover:text-primary">Leave Management</a>
                        <span>/</span>
                        <a href="{{ route('admin.accounting.payroll.leave.settings.index') }}" class="hover:text-primary">Leave Settings</a>
                        <span>/</span>
                        <span class="text-gray900">Edit</span>
                    </nav>
                </div>
            </div>
        </header>

        <main class="p-6">
            <!-- Success/Error Messages -->
            @if(session('success'))
                <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4 animate-fade-in">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <i class="fas fa-check-circle text-green-500 mr-2"></i>
                            <span class="text-green-800 font-medium">{{ session('success') }}</span>
                        </div>
                        <button onclick="this.parentElement.parentElement.remove()" class="text-green-600 hover:text-green-800">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
            @endif

            @if($errors->any())
                <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4 animate-fade-in">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <i class="fas fa-exclamation-circle text-red-500 mr-2"></i>
                            <div>
                                <span class="text-red-800 font-medium">Please fix the following errors:</span>
                                <ul class="text-red-700 text-sm mt-1">
                                    @foreach($errors->all() as $error)
                                    <li class="ml-4">{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                        <button onclick="this.parentElement.parentElement.remove()" class="text-red-600 hover:text-red-800">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
            @endif

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <!-- Form -->
                <div class="lg:col-span-2">
                    <div class="bg-white rounded-lg border border-gray200">
                        <div class="p-6 border-b border-gray200">
                            <h2 class="text-lg font-semibold text-gray900">Edit Leave Type</h2>
                            <p class="text-gray600 text-sm mt-1">Update leave type configuration</p>
                        </div>
                        
                        <form method="POST" action="{{ route('admin.accounting.payroll.leave.settings.update', $leaveType->id) }}" class="p-6">
                            @csrf
                            @method('PUT')
                            
                            <div class="space-y-6">
                                <!-- Name -->
                                <div>
                                    <label for="name" class="form-label required">Name</label>
                                    <input type="text" 
                                           name="name" 
                                           id="name"
                                           class="quickbooks-input"
                                           value="{{ old('name', $leaveType->name) }}"
                                           placeholder="e.g., Annual Leave, Sick Leave, Maternity Leave"
                                           required>
                                </div>

                                <!-- Code -->
                                <div>
                                    <label for="code" class="form-label required">Code</label>
                                    <input type="text" 
                                           name="code" 
                                           id="code"
                                           class="quickbooks-input"
                                           value="{{ old('code', $leaveType->code) }}"
                                           placeholder="e.g., AL, SL, ML"
                                           required>
                                </div>

                                <!-- Description -->
                                <div>
                                    <label for="description" class="form-label">Description</label>
                                    <textarea name="description" 
                                              id="description"
                                              rows="2"
                                              class="quickbooks-textarea"
                                              placeholder="Optional description of this leave type">{{ old('description', $leaveType->description) }}</textarea>
                                </div>

                                <!-- Accrual Settings -->
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <div>
                                        <label for="accrual_rate_days" class="form-label">Accrual Rate (days/month)</label>
                                        <input type="number" 
                                               name="accrual_rate_days" 
                                               id="accrual_rate_days"
                                               class="quickbooks-input"
                                               value="{{ old('accrual_rate_days', $leaveType->accrual_rate_days) }}"
                                               placeholder="e.g., 1.67"
                                               step="0.01"
                                               min="0">
                                        <p class="text-xs text-gray500 mt-1">Leave empty for manual accrual</p>
                                    </div>
                                    
                                    <div>
                                        <label for="max_days_per_year" class="form-label">Annual Limit (days)</label>
                                        <input type="number" 
                                               name="max_days_per_year" 
                                               id="max_days_per_year"
                                               class="quickbooks-input"
                                               value="{{ old('max_days_per_year', $leaveType->max_days_per_year) }}"
                                               placeholder="e.g., 20"
                                               min="0">
                                        <p class="text-xs text-gray500 mt-1">Leave empty for unlimited</p>
                                    </div>
                                </div>

                                <!-- Settings -->
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <div>
                                        <label class="form-label">Payment Type</label>
                                        <div class="space-y-2">
                                            <label class="flex items-center">
                                                <input type="radio" 
                                                       name="is_paid" 
                                                       value="1"
                                                       class="mr-2"
                                                       {{ old('is_paid', $leaveType->is_paid) ? 'checked' : '' }}>
                                                <span class="text-sm text-gray700">Paid Leave</span>
                                            </label>
                                            <label class="flex items-center">
                                                <input type="radio" 
                                                       name="is_paid" 
                                                       value="0"
                                                       class="mr-2"
                                                       {{ !old('is_paid', $leaveType->is_paid) ? 'checked' : '' }}>
                                                <span class="text-sm text-gray700">Unpaid Leave</span>
                                            </label>
                                        </div>
                                    </div>
                                    
                                    <div>
                                        <label class="form-label">Approval Required</label>
                                        <div class="space-y-2">
                                            <label class="flex items-center">
                                                <input type="radio" 
                                                       name="requires_approval" 
                                                       value="1"
                                                       class="mr-2"
                                                       {{ old('requires_approval', $leaveType->requires_approval) ? 'checked' : '' }}>
                                                <span class="text-sm text-gray700">Yes</span>
                                            </label>
                                            <label class="flex items-center">
                                                <input type="radio" 
                                                       name="requires_approval" 
                                                       value="0"
                                                       class="mr-2"
                                                       {{ !old('requires_approval', $leaveType->requires_approval) ? 'checked' : '' }}>
                                                <span class="text-sm text-gray700">No (Auto-approve)</span>
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <!-- Carry Forward Settings -->
                                <div>
                                    <label class="form-label">Carry Forward</label>
                                    <div class="space-y-3">
                                        <label class="flex items-center">
                                            <input type="checkbox" 
                                                   name="can_carry_forward" 
                                                   id="can_carry_forward"
                                                   value="1"
                                                   class="mr-2"
                                                   {{ old('can_carry_forward', $leaveType->can_carry_forward) ? 'checked' : '' }}
                                                   onchange="toggleCarryForward(this)">
                                            <span class="text-sm text-gray700">Allow unused days to carry forward to next year</span>
                                        </label>
                                        
                                        <div id="carryForwardSettings" class="{{ old('can_carry_forward', $leaveType->can_carry_forward) ? '' : 'hidden' }} pl-6">
                                            <label for="max_carry_forward_days" class="form-label">Max Carry Forward Days</label>
                                            <input type="number" 
                                                   name="max_carry_forward_days" 
                                                   id="max_carry_forward_days"
                                                   class="quickbooks-input"
                                                   value="{{ old('max_carry_forward_days', $leaveType->max_carry_forward_days) }}"
                                                   placeholder="e.g., 10"
                                                   min="0">
                                            <p class="text-xs text-gray500 mt-1">Leave empty for unlimited carry forward</p>
                                        </div>
                                    </div>
                                </div>

                                <!-- Status -->
                                <div>
                                    <label class="form-label">Status</label>
                                    <div class="space-y-2">
                                        <label class="flex items-center">
                                            <input type="radio" 
                                                   name="is_active" 
                                                   value="1"
                                                   class="mr-2"
                                                   {{ old('is_active', $leaveType->is_active) ? 'checked' : '' }}>
                                            <span class="text-sm text-gray700">Active</span>
                                        </label>
                                        <label class="flex items-center">
                                            <input type="radio" 
                                                   name="is_active" 
                                                   value="0"
                                                   class="mr-2"
                                                   {{ !old('is_active', $leaveType->is_active) ? 'checked' : '' }}>
                                            <span class="text-sm text-gray700">Inactive</span>
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <div class="flex items-center justify-between pt-6 mt-6 border-t border-gray200">
                                <a href="{{ route('admin.accounting.payroll.leave.settings.index') }}" 
                                   class="px-4 py-2 text-gray700 hover:bg-gray100 rounded text-sm font-medium">
                                    Cancel
                                </a>
                                <div class="flex items-center space-x-3">
                                    <button type="submit" 
                                            id="submitBtn"
                                            class="bg-primary text-white px-4 py-2 rounded text-sm font-medium hover:bg-primary/90 flex items-center gap-2">
                                        <i class="fas fa-save"></i>
                                        Update Leave Type
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Information Panel -->
                <div>
                    <div class="bg-white rounded-lg border border-gray200">
                        <div class="p-6 border-b border-gray200">
                            <h2 class="text-lg font-semibold text-gray900">Leave Type Information</h2>
                        </div>
                        <div class="p-6">
                            <div class="space-y-4">
                                <div>
                                    <div class="text-sm font-medium text-gray700 mb-1">Current Status</div>
                                    <div>
                                        @if($leaveType->is_active)
                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                            Active
                                        </span>
                                        @else
                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                                            Inactive
                                        </span>
                                        @endif
                                    </div>
                                </div>
                                
                                <div>
                                    <div class="text-sm font-medium text-gray700 mb-1">Created</div>
                                    <div class="text-sm text-gray600">
                                        {{ $leaveType->created_at->format('M d, Y') }}
                                    </div>
                                </div>
                                
                                <div>
                                    <div class="text-sm font-medium text-gray700 mb-1">Last Updated</div>
                                    <div class="text-sm text-gray600">
                                        {{ $leaveType->updated_at->format('M d, Y') }}
                                    </div>
                                </div>
                                
                                <div class="pt-4 border-t border-gray200">
                                    <div class="text-sm font-medium text-gray700 mb-2">Usage Statistics</div>
                                    <div class="space-y-2 text-sm text-gray600">
                                        <div class="flex justify-between">
                                            <span>Total Accrued:</span>
                                            <span class="font-medium">{{ $leaveType->leaveBalances->sum('total_accrued') }} days</span>
                                        </div>
                                        <div class="flex justify-between">
                                            <span>Total Taken:</span>
                                            <span class="font-medium">{{ $leaveType->leaveBalances->sum('total_taken') }} days</span>
                                        </div>
                                        <div class="flex justify-between">
                                            <span>Current Balance:</span>
                                            <span class="font-medium">{{ $leaveType->leaveBalances->sum('balance') }} days</span>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="pt-4 border-t border-gray200">
                                    <div class="text-sm font-medium text-gray700 mb-2">Important Notes</div>
                                    <ul class="text-xs text-gray600 space-y-1">
                                        <li class="flex items-start">
                                            <i class="fas fa-info-circle text-blue-500 mt-0.5 mr-2"></i>
                                            <span>Changes affect all existing and future leave requests</span>
                                        </li>
                                        <li class="flex items-start">
                                            <i class="fas fa-exclamation-triangle text-yellow-500 mt-0.5 mr-2"></i>
                                            <span>Deactivating will prevent new requests of this type</span>
                                        </li>
                                        <li class="flex items-start">
                                            <i class="fas fa-clock text-purple-500 mt-0.5 mr-2"></i>
                                            <span>Accrual rate changes apply from next accrual period</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <script>
        // Toggle carry forward settings
        function toggleCarryForward(checkbox) {
            const settings = document.getElementById('carryForwardSettings');
            if (checkbox.checked) {
                settings.classList.remove('hidden');
            } else {
                settings.classList.add('hidden');
            }
        }

        // Form validation
        document.querySelector('form').addEventListener('submit', function(e) {
            const name = document.getElementById('name').value;
            const code = document.getElementById('code').value;
            
            if (!name || !code) {
                e.preventDefault();
                alert('Please fill in all required fields.');
                return false;
            }
            
            // Show loading state on submit button
            const submitBtn = document.getElementById('submitBtn');
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-1"></i> Updating...';
        });

        // Auto-hide alerts after 5 seconds
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(() => {
                const alerts = document.querySelectorAll('.bg-green-50, .bg-red-50');
                alerts.forEach(alert => {
                    if (alert) {
                        alert.style.opacity = '0';
                        alert.style.transition = 'opacity 0.5s ease';
                        setTimeout(() => {
                            if (alert.parentNode) {
                                alert.parentNode.removeChild(alert);
                            }
                        }, 500);
                    }
                });
            }, 5000);
            
            // Initialize carry forward settings
            const canCarryForward = document.getElementById('can_carry_forward');
            if (canCarryForward) {
                toggleCarryForward(canCarryForward);
            }
        });
    </script>
</body>
</html>