<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Leave Settings | {{ config('app.name', 'IMMIA FINANCE') }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#146CAA',
                        primaryLight: '#E1F0FA',
                        secondary: '#6b7280',
                        success: '#107C10',
                        warning: '#F68C1E',
                        danger: '#D83B01',
                        info: '#0078D4',
                        gray50: '#FAF9F8',
                        gray100: '#F3F2F1',
                        gray200: '#EDEBE9',
                        gray300: '#E1DFDD',
                        gray400: '#C8C6C4',
                        gray500: '#A19F9D',
                        gray600: '#605E5C',
                        gray700: '#323130',
                        gray800: '#201F1E',
                        gray900: '#000000'
                    }
                }
            }
        }
    </script>
    <style>
        .quickbooks-table {
            border-collapse: separate;
            border-spacing: 0;
            width: 100%;
        }
        .quickbooks-table th {
            background-color: #F3F2F1;
            color: #323130;
            font-weight: 600;
            font-size: 13px;
            text-transform: uppercase;
            padding: 12px 16px;
            border-bottom: 1px solid #EDEBE9;
            text-align: left;
        }
        .quickbooks-table td {
            padding: 12px 16px;
            border-bottom: 1px solid #EDEBE9;
            font-size: 14px;
            color: #323130;
        }
        .quickbooks-table tbody tr:hover {
            background-color: #F3F2F1;
        }
        .quickbooks-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
        }
        .action-btn {
            width: 32px;
            height: 32px;
            border-radius: 4px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            margin: 0 2px;
            transition: all 0.2s;
        }
        .action-btn:hover {
            transform: translateY(-1px);
        }
        .action-btn-view {
            background-color: #F3F2F1;
            color: #323130;
        }
        .action-btn-view:hover {
            background-color: #146CAA;
            color: white;
        }
        .action-btn-edit {
            background-color: #E1F0FA;
            color: #146CAA;
        }
        .action-btn-edit:hover {
            background-color: #146CAA;
            color: white;
        }
        .action-btn-delete {
            background-color: #FEE8E6;
            color: #D83B01;
        }
        .action-btn-delete:hover {
            background-color: #D83B01;
            color: white;
        }
        .action-btn-toggle {
            background-color: #F3F2F1;
            color: #605E5C;
        }
        .action-btn-toggle:hover {
            background-color: #605E5C;
            color: white;
        }
        .modal-overlay {
            display: none;
            position: fixed;
            inset: 0;
            background: rgba(0, 0, 0, 0.5);
            backdrop-filter: blur(4px);
            z-index: 1000;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .modal-overlay.active {
            display: flex !important;
        }
        
        .modal-content {
            background: white;
            border-radius: 8px;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 600px;
            margin: 1rem;
            max-height: 90vh;
            overflow-y: auto;
            position: relative;
            z-index: 1001;
            transform: translateZ(0);
            animation: modalSlideIn 0.3s ease-out;
        }
        
        @keyframes modalSlideIn {
            from {
                opacity: 0;
                transform: translateY(-20px) scale(0.95);
            }
            to {
                opacity: 1;
                transform: translateY(0) scale(1);
            }
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .animate-fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }

        body.no-scroll {
            overflow: hidden;
        }

        .quickbooks-input {
            border: 1px solid #E1DFDD;
            border-radius: 4px;
            padding: 8px 12px;
            font-size: 14px;
            transition: border-color 0.2s;
            width: 100%;
        }
        .quickbooks-input:focus {
            outline: none;
            border-color: #146CAA;
            box-shadow: 0 0 0 2px rgba(20, 108, 170, 0.1);
        }
        
        .status-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 12px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
        }
        
        .badge-active {
            background-color: #E1F0FA;
            color: #107C10;
        }
        
        .badge-inactive {
            background-color: #F3F2F1;
            color: #605E5C;
        }
        
        .badge-paid {
            background-color: #E1F0FA;
            color: #146CAA;
        }
        
        .badge-unpaid {
            background-color: #F3F2F1;
            color: #605E5C;
        }
        
        .badge-approval {
            background-color: #FEF7E0;
            color: #F68C1E;
        }
        
        .badge-no-approval {
            background-color: #F3F2F1;
            color: #605E5C;
        }
        
        .badge-carry-forward {
            background-color: #E1F0FA;
            color: #146CAA;
        }
    </style>
</head>
<body class="bg-gray50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        <!-- Header -->
        <header class="bg-white border-b border-gray200 py-4 px-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-xl font-bold text-gray900">Leave Settings</h1>
                    <nav class="flex space-x-2 text-sm text-gray600 mt-1">
                        <a href="{{ route('admin.accounting.index') }}" class="hover:text-primary">Dashboard</a>
                        <span>/</span>
                        <a href="{{ route('admin.accounting.payroll.index') }}" class="hover:text-primary">Payroll</a>
                        <span>/</span>
                        <a href="{{ route('admin.accounting.payroll.leave.index') }}" class="hover:text-primary">Leave Management</a>
                        <span>/</span>
                        <span class="text-gray900">Leave Settings</span>
                    </nav>
                </div>
                <button onclick="openCreateModal()" 
                        class="flex items-center space-x-2 px-4 py-2 bg-primary text-white rounded-lg text-sm font-medium hover:bg-primary/90">
                    <i class="fas fa-plus"></i>
                    <span>New Leave Type</span>
                </button>
            </div>
        </header>

        <main class="p-6">
            <!-- Success/Error Messages -->
            @if(session('success'))
                <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4 animate-fade-in">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <i class="fas fa-check-circle text-green-500 mr-2"></i>
                            <span class="text-green-800 font-medium">{{ session('success') }}</span>
                        </div>
                        <button onclick="this.parentElement.parentElement.remove()" class="text-green-600 hover:text-green-800">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
            @endif

            @if(session('error'))
                <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4 animate-fade-in">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <i class="fas fa-exclamation-circle text-red-500 mr-2"></i>
                            <span class="text-red-800 font-medium">{{ session('error') }}</span>
                        </div>
                        <button onclick="this.parentElement.parentElement.remove()" class="text-red-600 hover:text-red-800">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
            @endif

            <!-- Leave Types Table -->
            <div class="bg-white rounded-lg border border-gray200 overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="quickbooks-table">
                        <thead>
                            <tr>
                                <th>Leave Type</th>
                                <th>Code</th>
                                <th>Accrual Rate</th>
                                <th>Annual Limit</th>
                                <th>Settings</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($leaveTypes as $type)
                            <tr class="hover:bg-gray100">
                                <td>
                                    <div class="flex items-center space-x-3">
                                        <div class="w-8 h-8 rounded-lg bg-blue-100 flex items-center justify-center">
                                            <i class="fas fa-umbrella-beach text-blue-600"></i>
                                        </div>
                                        <div>
                                            <div class="font-medium text-gray900">{{ $type->name }}</div>
                                            @if($type->description)
                                            <div class="text-xs text-gray500 truncate max-w-xs">{{ $type->description }}</div>
                                            @endif
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="font-mono text-sm text-gray900">{{ $type->code }}</div>
                                </td>
                                <td>
                                    @if($type->accrual_rate_days)
                                    <div class="text-sm text-gray900">{{ $type->accrual_rate_days }} days/month</div>
                                    @else
                                    <div class="text-sm text-gray500">Manual</div>
                                    @endif
                                </td>
                                <td>
                                    @if($type->max_days_per_year)
                                    <div class="text-sm font-medium text-gray900">{{ $type->max_days_per_year }} days</div>
                                    @else
                                    <div class="text-sm text-gray500">Unlimited</div>
                                    @endif
                                </td>
                                <td>
                                    <div class="flex flex-wrap gap-1">
                                        <span class="status-badge {{ $type->is_paid ? 'badge-paid' : 'badge-unpaid' }}">
                                            {{ $type->is_paid ? 'Paid' : 'Unpaid' }}
                                        </span>
                                        <span class="status-badge {{ $type->requires_approval ? 'badge-approval' : 'badge-no-approval' }}">
                                            {{ $type->requires_approval ? 'Approval Required' : 'Auto-Approved' }}
                                        </span>
                                        @if($type->can_carry_forward)
                                        <span class="status-badge badge-carry-forward">
                                            Carry Forward
                                            @if($type->max_carry_forward_days)
                                            ({{ $type->max_carry_forward_days }} days)
                                            @endif
                                        </span>
                                        @endif
                                    </div>
                                </td>
                                <td>
                                    <span class="status-badge {{ $type->is_active ? 'badge-active' : 'badge-inactive' }}">
                                        {{ $type->is_active ? 'Active' : 'Inactive' }}
                                    </span>
                                </td>
                                <td>
                                    <div class="flex items-center">
                                        <button onclick="openEditModal({{ $type->id }})" 
                                                class="action-btn action-btn-edit"
                                                title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <form method="POST" action="{{ route('admin.accounting.payroll.leave.settings.destroy', $type->id) }}" 
                                              class="inline" onsubmit="return confirm('Are you sure you want to delete this leave type?')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" 
                                                    class="action-btn action-btn-delete"
                                                    title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="7" class="text-center py-12">
                                    <div class="text-center text-gray500">
                                        <i class="fas fa-cog text-4xl mb-3"></i>
                                        <p>No leave types configured</p>
                                        <p class="text-sm mt-2">Create your first leave type to get started</p>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                @if($leaveTypes->hasPages())
                <div class="p-6 border-t border-gray200">
                    <div class="flex items-center justify-between">
                        <div class="text-sm text-gray600">
                            Showing {{ $leaveTypes->firstItem() }} to {{ $leaveTypes->lastItem() }} of {{ $leaveTypes->total() }} entries
                        </div>
                        <div class="flex space-x-2">
                            @if($leaveTypes->onFirstPage())
                            <span class="px-3 py-1 rounded bg-gray100 text-gray500 text-sm">Previous</span>
                            @else
                            <a href="{{ $leaveTypes->previousPageUrl() }}" class="px-3 py-1 rounded bg-gray100 hover:bg-gray200 text-gray700 text-sm">Previous</a>
                            @endif
                            
                            @foreach($leaveTypes->getUrlRange(1, $leaveTypes->lastPage()) as $page => $url)
                                @if($page == $leaveTypes->currentPage())
                                <span class="px-3 py-1 rounded bg-primary text-white text-sm">{{ $page }}</span>
                                @else
                                <a href="{{ $url }}" class="px-3 py-1 rounded bg-gray100 hover:bg-gray200 text-gray700 text-sm">{{ $page }}</a>
                                @endif
                            @endforeach
                            
                            @if($leaveTypes->hasMorePages())
                            <a href="{{ $leaveTypes->nextPageUrl() }}" class="px-3 py-1 rounded bg-gray100 hover:bg-gray200 text-gray700 text-sm">Next</a>
                            @else
                            <span class="px-3 py-1 rounded bg-gray100 text-gray500 text-sm">Next</span>
                            @endif
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </main>
    </div>

    <!-- Create Modal -->
    <div id="createModal" class="modal-overlay">
        <div class="modal-content">
            <div class="flex items-center justify-between p-6 border-b border-gray200">
                <div class="flex items-center">
                    <div class="w-10 h-10 bg-primaryLight rounded-lg flex items-center justify-center mr-3">
                        <i class="fas fa-plus text-primary"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray900">Create Leave Type</h3>
                        <p class="text-gray600 text-sm mt-1">Configure a new leave type for your organization</p>
                    </div>
                </div>
                <button onclick="closeCreateModal()" class="text-gray500 hover:text-gray700">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            
            <div class="p-6">
                <form id="createForm" method="POST" action="{{ route('admin.accounting.payroll.leave.settings.store') }}">
                    @csrf
                    <div class="space-y-4">
                        <!-- Name -->
                        <div>
                            <label for="create_name" class="block text-sm font-medium text-gray700 mb-2 required">Name *</label>
                            <input type="text" 
                                   name="name" 
                                   id="create_name"
                                   class="quickbooks-input"
                                   placeholder="e.g., Annual Leave, Sick Leave, Maternity Leave"
                                   required>
                        </div>

                        <!-- Code -->
                        <div>
                            <label for="create_code" class="block text-sm font-medium text-gray700 mb-2 required">Code *</label>
                            <input type="text" 
                                   name="code" 
                                   id="create_code"
                                   class="quickbooks-input"
                                   placeholder="e.g., AL, SL, ML"
                                   required>
                        </div>

                        <!-- Description -->
                        <div>
                            <label for="create_description" class="block text-sm font-medium text-gray700 mb-2">Description</label>
                            <textarea name="description" 
                                      id="create_description"
                                      rows="2"
                                      class="quickbooks-input resize-none"
                                      placeholder="Optional description of this leave type"></textarea>
                        </div>

                        <!-- Accrual Settings -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="create_accrual_rate_days" class="block text-sm font-medium text-gray700 mb-2">Accrual Rate (days/month)</label>
                                <input type="number" 
                                       name="accrual_rate_days" 
                                       id="create_accrual_rate_days"
                                       class="quickbooks-input"
                                       placeholder="e.g., 1.67"
                                       step="0.01"
                                       min="0">
                                <p class="text-xs text-gray500 mt-1">Leave empty for manual accrual</p>
                            </div>
                            
                            <div>
                                <label for="create_max_days_per_year" class="block text-sm font-medium text-gray700 mb-2">Annual Limit (days)</label>
                                <input type="number" 
                                       name="max_days_per_year" 
                                       id="create_max_days_per_year"
                                       class="quickbooks-input"
                                       placeholder="e.g., 20"
                                       min="0">
                                <p class="text-xs text-gray500 mt-1">Leave empty for unlimited</p>
                            </div>
                        </div>

                        <!-- Settings -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray700 mb-2">Payment Type</label>
                                <div class="space-y-2">
                                    <label class="flex items-center">
                                        <input type="radio" 
                                               name="is_paid" 
                                               value="1"
                                               class="mr-2"
                                               checked>
                                        <span class="text-sm text-gray700">Paid Leave</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="radio" 
                                               name="is_paid" 
                                               value="0"
                                               class="mr-2">
                                        <span class="text-sm text-gray700">Unpaid Leave</span>
                                    </label>
                                </div>
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray700 mb-2">Approval Required</label>
                                <div class="space-y-2">
                                    <label class="flex items-center">
                                        <input type="radio" 
                                               name="requires_approval" 
                                               value="1"
                                               class="mr-2"
                                               checked>
                                        <span class="text-sm text-gray700">Yes</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="radio" 
                                               name="requires_approval" 
                                               value="0"
                                               class="mr-2">
                                        <span class="text-sm text-gray700">No (Auto-approve)</span>
                                    </label>
                                </div>
                            </div>
                        </div>

                        <!-- Carry Forward Settings -->
                        <div>
                            <label class="block text-sm font-medium text-gray700 mb-2">Carry Forward</label>
                            <div class="space-y-3">
                                <label class="flex items-center">
                                    <input type="checkbox" 
                                           name="can_carry_forward" 
                                           id="create_can_carry_forward"
                                           value="1"
                                           class="mr-2"
                                           onchange="toggleCarryForward(this)">
                                    <span class="text-sm text-gray700">Allow unused days to carry forward to next year</span>
                                </label>
                                
                                <div id="carryForwardSettings" class="hidden pl-6">
                                    <label for="create_max_carry_forward_days" class="block text-sm font-medium text-gray700 mb-2">Max Carry Forward Days</label>
                                    <input type="number" 
                                           name="max_carry_forward_days" 
                                           id="create_max_carry_forward_days"
                                           class="quickbooks-input"
                                           placeholder="e.g., 10"
                                           min="0">
                                    <p class="text-xs text-gray500 mt-1">Leave empty for unlimited carry forward</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="flex justify-end gap-3 mt-6 pt-6 border-t border-gray200">
                        <button type="button" 
                                onclick="closeCreateModal()" 
                                class="px-4 py-2 text-gray700 hover:bg-gray100 rounded text-sm font-medium">
                            Cancel
                        </button>
                        <button type="submit" 
                                id="createSubmitBtn"
                                class="bg-primary text-white px-4 py-2 rounded text-sm font-medium hover:bg-primary/90 flex items-center gap-2">
                            <i class="fas fa-plus"></i>
                            Create Leave Type
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Edit Modal -->
    <div id="editModal" class="modal-overlay">
        <div class="modal-content">
            <div class="flex items-center justify-between p-6 border-b border-gray200">
                <div class="flex items-center">
                    <div class="w-10 h-10 bg-primaryLight rounded-lg flex items-center justify-center mr-3">
                        <i class="fas fa-edit text-primary"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray900">Edit Leave Type</h3>
                        <p class="text-gray600 text-sm mt-1">Update leave type configuration</p>
                    </div>
                </div>
                <button onclick="closeEditModal()" class="text-gray500 hover:text-gray700">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            
            <div class="p-6">
                <form id="editForm" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="space-y-4">
                        <!-- Name -->
                        <div>
                            <label for="edit_name" class="block text-sm font-medium text-gray700 mb-2 required">Name *</label>
                            <input type="text" 
                                   name="name" 
                                   id="edit_name"
                                   class="quickbooks-input"
                                   required>
                        </div>

                        <!-- Code -->
                        <div>
                            <label for="edit_code" class="block text-sm font-medium text-gray700 mb-2 required">Code *</label>
                            <input type="text" 
                                   name="code" 
                                   id="edit_code"
                                   class="quickbooks-input"
                                   required>
                        </div>

                        <!-- Description -->
                        <div>
                            <label for="edit_description" class="block text-sm font-medium text-gray700 mb-2">Description</label>
                            <textarea name="description" 
                                      id="edit_description"
                                      rows="2"
                                      class="quickbooks-input resize-none"></textarea>
                        </div>

                        <!-- Accrual Settings -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="edit_accrual_rate_days" class="block text-sm font-medium text-gray700 mb-2">Accrual Rate (days/month)</label>
                                <input type="number" 
                                       name="accrual_rate_days" 
                                       id="edit_accrual_rate_days"
                                       class="quickbooks-input"
                                       step="0.01"
                                       min="0">
                                <p class="text-xs text-gray500 mt-1">Leave empty for manual accrual</p>
                            </div>
                            
                            <div>
                                <label for="edit_max_days_per_year" class="block text-sm font-medium text-gray700 mb-2">Annual Limit (days)</label>
                                <input type="number" 
                                       name="max_days_per_year" 
                                       id="edit_max_days_per_year"
                                       class="quickbooks-input"
                                       min="0">
                                <p class="text-xs text-gray500 mt-1">Leave empty for unlimited</p>
                            </div>
                        </div>

                        <!-- Settings -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray700 mb-2">Payment Type</label>
                                <div class="space-y-2" id="edit_is_paid">
                                    <label class="flex items-center">
                                        <input type="radio" 
                                               name="is_paid" 
                                               value="1"
                                               class="mr-2">
                                        <span class="text-sm text-gray700">Paid Leave</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="radio" 
                                               name="is_paid" 
                                               value="0"
                                               class="mr-2">
                                        <span class="text-sm text-gray700">Unpaid Leave</span>
                                    </label>
                                </div>
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray700 mb-2">Approval Required</label>
                                <div class="space-y-2" id="edit_requires_approval">
                                    <label class="flex items-center">
                                        <input type="radio" 
                                               name="requires_approval" 
                                               value="1"
                                               class="mr-2">
                                        <span class="text-sm text-gray700">Yes</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="radio" 
                                               name="requires_approval" 
                                               value="0"
                                               class="mr-2">
                                        <span class="text-sm text-gray700">No (Auto-approve)</span>
                                    </label>
                                </div>
                            </div>
                        </div>

                        <!-- Carry Forward Settings -->
                        <div>
                            <label class="block text-sm font-medium text-gray700 mb-2">Carry Forward</label>
                            <div class="space-y-3">
                                <label class="flex items-center">
                                    <input type="checkbox" 
                                           name="can_carry_forward" 
                                           id="edit_can_carry_forward"
                                           value="1"
                                           class="mr-2"
                                           onchange="toggleCarryForwardEdit(this)">
                                    <span class="text-sm text-gray700">Allow unused days to carry forward to next year</span>
                                </label>
                                
                                <div id="editCarryForwardSettings" class="hidden pl-6">
                                    <label for="edit_max_carry_forward_days" class="block text-sm font-medium text-gray700 mb-2">Max Carry Forward Days</label>
                                    <input type="number" 
                                           name="max_carry_forward_days" 
                                           id="edit_max_carry_forward_days"
                                           class="quickbooks-input"
                                           min="0">
                                    <p class="text-xs text-gray500 mt-1">Leave empty for unlimited carry forward</p>
                                </div>
                            </div>
                        </div>

                        <!-- Status -->
                        <div>
                            <label class="block text-sm font-medium text-gray700 mb-2">Status</label>
                            <div class="space-y-2" id="edit_is_active">
                                <label class="flex items-center">
                                    <input type="radio" 
                                           name="is_active" 
                                           value="1"
                                           class="mr-2">
                                    <span class="text-sm text-gray700">Active</span>
                                </label>
                                <label class="flex items-center">
                                    <input type="radio" 
                                           name="is_active" 
                                           value="0"
                                           class="mr-2">
                                    <span class="text-sm text-gray700">Inactive</span>
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="flex justify-end gap-3 mt-6 pt-6 border-t border-gray200">
                        <button type="button" 
                                onclick="closeEditModal()" 
                                class="px-4 py-2 text-gray700 hover:bg-gray100 rounded text-sm font-medium">
                            Cancel
                        </button>
                        <button type="submit" 
                                id="editSubmitBtn"
                                class="bg-primary text-white px-4 py-2 rounded text-sm font-medium hover:bg-primary/90 flex items-center gap-2">
                            <i class="fas fa-save"></i>
                            Update Leave Type
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        // Base URL configuration
        const BASE_URL = '{{ url('/') }}';

        // Modal Functions
        function openCreateModal() {
            const modal = document.getElementById('createModal');
            modal.classList.add('active');
            document.body.classList.add('no-scroll');
            
            setTimeout(() => {
                const nameInput = document.getElementById('create_name');
                if (nameInput) nameInput.focus();
            }, 100);
        }

        function closeCreateModal() {
            const modal = document.getElementById('createModal');
            modal.classList.remove('active');
            document.body.classList.remove('no-scroll');
            const createForm = document.getElementById('createForm');
            if (createForm) createForm.reset();
            document.getElementById('carryForwardSettings').classList.add('hidden');
        }

        function openEditModal(id) {
            const modal = document.getElementById('editModal');
            modal.classList.add('active');
            document.body.classList.add('no-scroll');
            
            // Show loading state
            const editSubmitBtn = document.getElementById('editSubmitBtn');
            if (editSubmitBtn) {
                editSubmitBtn.disabled = true;
                editSubmitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-1"></i> Loading...';
            }
            
            // Set form action
            const editForm = document.getElementById('editForm');
            if (editForm) {
                editForm.action = `${BASE_URL}/admin/accounting/payroll/leave/settings/${id}`;
            }
            
            // Fetch leave type data
            fetch(`${BASE_URL}/admin/accounting/payroll/leave/settings/${id}/data`)
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        const leaveType = data.leaveType;
                        
                        // Populate form fields
                        document.getElementById('edit_name').value = leaveType.name || '';
                        document.getElementById('edit_code').value = leaveType.code || '';
                        document.getElementById('edit_description').value = leaveType.description || '';
                        document.getElementById('edit_accrual_rate_days').value = leaveType.accrual_rate_days || '';
                        document.getElementById('edit_max_days_per_year').value = leaveType.max_days_per_year || '';
                        
                        // Set radio buttons
                        setRadioValue('edit_is_paid', leaveType.is_paid);
                        setRadioValue('edit_requires_approval', leaveType.requires_approval);
                        setRadioValue('edit_is_active', leaveType.is_active);
                        
                        // Handle carry forward
                        const canCarryForward = document.getElementById('edit_can_carry_forward');
                        const carryForwardSettings = document.getElementById('editCarryForwardSettings');
                        if (canCarryForward && carryForwardSettings) {
                            canCarryForward.checked = leaveType.can_carry_forward;
                            if (leaveType.can_carry_forward) {
                                carryForwardSettings.classList.remove('hidden');
                                document.getElementById('edit_max_carry_forward_days').value = leaveType.max_carry_forward_days || '';
                            } else {
                                carryForwardSettings.classList.add('hidden');
                            }
                        }
                        
                        // Reset button state
                        if (editSubmitBtn) {
                            editSubmitBtn.disabled = false;
                            editSubmitBtn.innerHTML = '<i class="fas fa-save mr-1"></i> Update Leave Type';
                        }
                        
                        setTimeout(() => {
                            const nameInput = document.getElementById('edit_name');
                            if (nameInput) nameInput.focus();
                        }, 100);
                    } else {
                        throw new Error(data.error || 'Failed to load leave type data');
                    }
                })
                .catch(error => {
                    console.error('Error loading leave type data:', error);
                    alert('Error loading leave type data: ' + error.message);
                    closeEditModal();
                });
        }

        function closeEditModal() {
            const modal = document.getElementById('editModal');
            modal.classList.remove('active');
            document.body.classList.remove('no-scroll');
        }

        // Helper function to set radio button value
        function setRadioValue(containerId, value) {
            const container = document.getElementById(containerId);
            if (container) {
                const radios = container.querySelectorAll('input[type="radio"]');
                radios.forEach(radio => {
                    radio.checked = (radio.value == value);
                });
            }
        }

        // Toggle carry forward settings
        function toggleCarryForward(checkbox) {
            const settings = document.getElementById('carryForwardSettings');
            if (checkbox.checked) {
                settings.classList.remove('hidden');
            } else {
                settings.classList.add('hidden');
            }
        }

        function toggleCarryForwardEdit(checkbox) {
            const settings = document.getElementById('editCarryForwardSettings');
            if (checkbox.checked) {
                settings.classList.remove('hidden');
            } else {
                settings.classList.add('hidden');
            }
        }

        // Close modals with Escape key
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                closeCreateModal();
                closeEditModal();
            }
        });

        // Form submission handlers
        const createForm = document.getElementById('createForm');
        if (createForm) {
            createForm.addEventListener('submit', function(e) {
                const submitBtn = document.getElementById('createSubmitBtn');
                const name = document.getElementById('create_name').value;
                const code = document.getElementById('create_code').value;
                
                if (!name || !code) {
                    e.preventDefault();
                    alert('Please fill in all required fields.');
                    return false;
                }
                
                if (submitBtn) {
                    submitBtn.disabled = true;
                    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-1"></i> Creating...';
                }
            });
        }

        const editForm = document.getElementById('editForm');
        if (editForm) {
            editForm.addEventListener('submit', function(e) {
                const submitBtn = document.getElementById('editSubmitBtn');
                const name = document.getElementById('edit_name').value;
                const code = document.getElementById('edit_code').value;
                
                if (!name || !code) {
                    e.preventDefault();
                    alert('Please fill in all required fields.');
                    return false;
                }
                
                if (submitBtn) {
                    submitBtn.disabled = true;
                    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-1"></i> Updating...';
                }
            });
        }

        // Auto-hide alerts after 5 seconds
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(() => {
                const alerts = document.querySelectorAll('.bg-green-50, .bg-red-50');
                alerts.forEach(alert => {
                    if (alert) {
                        alert.style.opacity = '0';
                        alert.style.transition = 'opacity 0.5s ease';
                        setTimeout(() => {
                            if (alert.parentNode) {
                                alert.parentNode.removeChild(alert);
                            }
                        }, 500);
                    }
                });
            }, 5000);
            
            // Add status badge colors
            const statusBadges = document.querySelectorAll('.status-badge');
            statusBadges.forEach(badge => {
                const text = badge.textContent.toLowerCase();
                if (text.includes('active')) {
                    badge.classList.add('badge-active');
                } else if (text.includes('inactive')) {
                    badge.classList.add('badge-inactive');
                } else if (text.includes('paid')) {
                    badge.classList.add('badge-paid');
                } else if (text.includes('unpaid')) {
                    badge.classList.add('badge-unpaid');
                } else if (text.includes('approval')) {
                    badge.classList.add('badge-approval');
                } else if (text.includes('auto')) {
                    badge.classList.add('badge-no-approval');
                } else if (text.includes('carry')) {
                    badge.classList.add('badge-carry-forward');
                }
            });
        });
    </script>
</body>
</html>