<div class="fixed inset-0 bg-gray-900 bg-opacity-50 z-50 overflow-y-auto">
    <div class="min-h-screen px-4 py-8">
        <div class="bg-white rounded-lg shadow-xl max-w-7xl mx-auto">
            <!-- Modal Header -->
            <div class="sticky top-0 bg-white border-b border-gray200 p-6 z-10">
                <div class="flex justify-between items-center">
                    <div>
                        <h2 class="text-2xl font-bold text-gray900">Payroll Adjustments</h2>
                        <div class="flex flex-wrap items-center gap-4 mt-2">
                            <span class="inline-flex items-center text-sm text-gray600">
                                <i class="fas fa-user-tie mr-1"></i>
                                {{ $employee->first_name }} {{ $employee->last_name }} ({{ $employee->employee_number }})
                            </span>
                            <span class="inline-flex items-center text-sm text-gray600">
                                <i class="fas fa-calendar-alt mr-1"></i>
                                {{ $period->period_name }}
                            </span>
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium 
                                {{ $period->status === 'open' ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                                {{ ucfirst($period->status) }}
                            </span>
                        </div>
                    </div>
                    <button onclick="closeAdjustmentsModal()" 
                            class="text-gray-500 hover:text-gray-700 text-2xl">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
            
            <!-- Modal Content -->
            <div class="p-6">
                <!-- Success/Error Messages -->
                @if(session('success'))
                    <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4">
                        <div class="flex items-center">
                            <i class="fas fa-check-circle text-green-500 mr-2"></i>
                            <span class="text-green-800 font-semibold">{{ session('success') }}</span>
                        </div>
                    </div>
                @endif

                @if(session('error'))
                    <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4">
                        <div class="flex items-center">
                            <i class="fas fa-exclamation-circle text-red-500 mr-2"></i>
                            <span class="text-red-800 font-semibold">{{ session('error') }}</span>
                        </div>
                    </div>
                @endif

                <!-- Two Column Layout -->
                <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                    <!-- Left Column: Add Adjustment Form -->
                    <div class="lg:col-span-2">
                        <!-- Add Adjustment Form -->
                        <div class="form-section">
                            <h3>Add New Adjustment</h3>
                            
                            <form id="addAdjustmentForm" action="{{ route('admin.accounting.payroll.preparation.store', $period->id) }}" method="POST">
                                @csrf
                                <input type="hidden" name="employee_id" value="{{ $employee->id }}">
                                
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                                    <div>
                                        <label class="block text-sm font-medium text-gray700 mb-2 required-field">Adjustment Type</label>
                                        <select name="earning_type_id" class="quickbooks-select" required>
                                            <option value="">Select Type</option>
                                            @foreach($earningTypes as $type)
                                                <option value="{{ $type->id }}" data-taxable="{{ $type->is_taxable }}">
                                                    {{ $type->name }} ({{ $type->code }})
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium text-gray700 mb-2 required-field">Description</label>
                                        <input type="text" 
                                               name="description" 
                                               class="quickbooks-input" 
                                               placeholder="e.g., Overtime for weekend work, Year-end bonus"
                                               required>
                                    </div>
                                </div>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                                    <div>
                                        <label class="block text-sm font-medium text-gray700 mb-2 required-field">Amount</label>
                                        <div class="relative">
                                            <input type="number" 
                                                   name="amount" 
                                                   class="quickbooks-input pl-8" 
                                                   placeholder="0.00"
                                                   step="0.01"
                                                   min="0"
                                                   required>
                                            <span class="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-500 text-sm">{{ $company->currency_symbol ?? 'K' }}</span>
                                        </div>
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium text-gray700 mb-2">Notes (Optional)</label>
                                        <input type="text" 
                                               name="notes" 
                                               class="quickbooks-input" 
                                               placeholder="Additional information about this adjustment">
                                    </div>
                                </div>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                                    <div>
                                        <label class="block text-sm font-medium text-gray700 mb-4">Taxable</label>
                                        <div class="flex items-center space-x-4">
                                            <div class="flex items-center">
                                                <input type="radio" id="taxable_yes" name="is_taxable" value="1" class="quickbooks-checkbox mr-2" checked>
                                                <label for="taxable_yes" class="text-sm text-gray600">Yes</label>
                                            </div>
                                            <div class="flex items-center">
                                                <input type="radio" id="taxable_no" name="is_taxable" value="0" class="quickbooks-checkbox mr-2">
                                                <label for="taxable_no" class="text-sm text-gray600">No</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium text-gray700 mb-4">Adjustment Type</label>
                                        <div class="flex items-center space-x-4">
                                            <div class="flex items-center">
                                                <input type="radio" id="one_time_yes" name="is_one_time" value="1" class="quickbooks-checkbox mr-2" checked>
                                                <label for="one_time_yes" class="text-sm text-gray600">One-time</label>
                                            </div>
                                            <div class="flex items-center">
                                                <input type="radio" id="one_time_no" name="is_one_time" value="0" class="quickbooks-checkbox mr-2">
                                                <label for="one_time_no" class="text-sm text-gray600">Recurring (for this period)</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="flex justify-end space-x-3">
                                    <button type="button" 
                                            onclick="resetForm()"
                                            class="bg-gray-200 text-gray-700 px-6 py-2 rounded text-sm font-medium hover:bg-gray-300 flex items-center">
                                        <i class="fas fa-redo mr-2"></i> Reset Form
                                    </button>
                                    <button type="submit" 
                                            class="bg-primary text-white px-6 py-2 rounded text-sm font-medium hover:bg-primary/90 flex items-center">
                                        <i class="fas fa-plus mr-2"></i> Add Adjustment
                                    </button>
                                </div>
                            </form>
                        </div>

                        <!-- Existing Adjustments -->
                        <div id="adjustmentsSection" class="form-section">
                            <div class="flex justify-between items-center mb-6">
                                <h3>Existing Adjustments</h3>
                                <div class="text-sm text-gray600">
                                    <span id="adjustmentsCount">{{ $adjustments->count() }}</span> adjustment(s)
                                </div>
                            </div>

                            @if($adjustments->count() > 0)
                                <div class="border border-gray200 rounded-lg overflow-hidden">
                                    <table class="quickbooks-table">
                                        <thead>
                                            <tr>
                                                <th>Type</th>
                                                <th>Description</th>
                                                <th>Amount</th>
                                                <th>Taxable</th>
                                                <th>Status</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($adjustments as $adjustment)
                                                <tr>
                                                    <td>
                                                        <div>{{ $adjustment->earningType->name }}</div>
                                                        <div class="text-xs text-gray500">{{ $adjustment->earningType->code }}</div>
                                                        <div class="text-xs">
                                                            @if($adjustment->is_one_time)
                                                                <span class="text-yellow-600">One-time</span>
                                                            @else
                                                                <span class="text-purple-600">Period Recurring</span>
                                                            @endif
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="font-medium">{{ $adjustment->description }}</div>
                                                        @if($adjustment->notes)
                                                            <div class="text-xs text-gray500">{{ $adjustment->notes }}</div>
                                                        @endif
                                                    </td>
                                                    <td class="font-medium">
                                                        {{ $company->currency_symbol ?? 'K' }}{{ number_format($adjustment->amount, 2) }}
                                                    </td>
                                                    <td>
                                                        @if($adjustment->is_taxable)
                                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                                                Yes
                                                            </span>
                                                        @else
                                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                                                No
                                                            </span>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if($adjustment->isApproved())
                                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                                                <i class="fas fa-check mr-1"></i> Approved
                                                            </span>
                                                        @else
                                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800">
                                                                <i class="fas fa-clock mr-1"></i> Pending
                                                            </span>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        <div class="flex space-x-2">
                                                            @if(!$adjustment->isApproved())
                                                                <form action="{{ route('admin.accounting.payroll.preparation.approve', $adjustment->id) }}" method="POST" class="inline">
                                                                    @csrf
                                                                    <button type="submit" class="text-green-600 hover:text-green-800" title="Approve">
                                                                        <i class="fas fa-check"></i>
                                                                    </button>
                                                                </form>
                                                                <button onclick="editAdjustment({{ $adjustment->id }})" class="text-blue-600 hover:text-blue-800" title="Edit">
                                                                    <i class="fas fa-edit"></i>
                                                                </button>
                                                            @else
                                                                <form action="{{ route('admin.accounting.payroll.preparation.unapprove', $adjustment->id) }}" method="POST" class="inline">
                                                                    @csrf
                                                                    <button type="submit" class="text-yellow-600 hover:text-yellow-800" title="Unapprove">
                                                                        <i class="fas fa-undo"></i>
                                                                    </button>
                                                                </form>
                                                            @endif
                                                            <form action="{{ route('admin.accounting.payroll.preparation.destroy', $adjustment->id) }}" method="POST" class="inline" onsubmit="return confirm('Are you sure you want to delete this adjustment?');">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="submit" class="text-red-600 hover:text-red-800" title="Delete">
                                                                    <i class="fas fa-trash"></i>
                                                                </button>
                                                            </form>
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>

                                <!-- Bulk Actions -->
                                @if($adjustments->whereNull('approved_by')->count() > 0)
                                    <div id="bulkActionsContainer" class="mt-6 p-4 bg-gray50 border border-gray200 rounded-lg">
                                        <form action="{{ route('admin.accounting.payroll.preparation.bulk-approve', $period->id) }}" method="POST" id="bulkApproveForm">
                                            @csrf
                                            <input type="hidden" name="adjustment_ids" id="bulkAdjustmentIds" value="{{ $adjustments->whereNull('approved_by')->pluck('id')->toJson() }}">
                                            <div class="flex items-center justify-between">
                                                <div class="text-sm text-gray600">
                                                    <span id="pendingAdjustmentsCount">{{ $adjustments->whereNull('approved_by')->count() }}</span> pending adjustment(s)
                                                </div>
                                                <button type="submit" 
                                                        class="bg-green-600 text-white px-4 py-2 rounded text-sm font-medium hover:bg-green-700 flex items-center">
                                                    <i class="fas fa-check-double mr-2"></i> Approve All Pending
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                @endif
                            @else
                                <div class="text-center py-8 text-gray500">
                                    <i class="fas fa-file-invoice-dollar text-3xl mb-3 text-gray300"></i>
                                    <p>No adjustments for this employee</p>
                                    <p class="text-sm mt-1">Add adjustments using the form above</p>
                                </div>
                            @endif
                        </div>
                    </div>

                    <!-- Right Column: Summary -->
                    <div>
                        <!-- Employee Info Card -->
                        <div class="form-section">
                            <h3>Employee Information</h3>
                            
                            <div class="space-y-3">
                                <div class="flex items-center">
                                    <div class="w-10 h-10 bg-blue-100 rounded-full flex items-center justify-center mr-3">
                                        <span class="text-blue-600 font-semibold">
                                            {{ strtoupper(substr($employee->first_name, 0, 1)) }}{{ strtoupper(substr($employee->last_name, 0, 1)) }}
                                        </span>
                                    </div>
                                    <div>
                                        <div class="font-medium">{{ $employee->first_name }} {{ $employee->last_name }}</div>
                                        <div class="text-sm text-gray500">{{ $employee->employee_number }}</div>
                                    </div>
                                </div>
                                
                                <div class="space-y-2 text-sm">
                                    <div class="flex justify-between">
                                        <span class="text-gray600">Email:</span>
                                        <span class="font-medium">{{ $employee->email }}</span>
                                    </div>
                                    <div class="flex justify-between">
                                        <span class="text-gray600">Phone:</span>
                                        <span class="font-medium">{{ $employee->phone ?? '—' }}</span>
                                    </div>
                                    <div class="flex justify-between">
                                        <span class="text-gray600">NRC:</span>
                                        <span class="font-medium">{{ $employee->national_id ?? '—' }}</span>
                                    </div>
                                    <div class="flex justify-between">
                                        <span class="text-gray600">Employment Type:</span>
                                        <span class="font-medium">{{ ucfirst($employee->employment_type) }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Summary Card -->
                        <div class="form-section">
                            <h3>Adjustments Summary</h3>
                            
                            @php
                                // Calculate totals
                                $totalAdjustmentAmount = $adjustments->sum('amount');
                                $adjustmentTaxable = $adjustments->where('is_taxable', true)->sum('amount');
                                $adjustmentNonTaxable = $adjustments->where('is_taxable', false)->sum('amount');
                                $approvedCount = $adjustments->whereNotNull('approved_by')->count();
                                $pendingCount = $adjustments->whereNull('approved_by')->count();
                            @endphp
                            
                            <div class="space-y-4">
                                <div class="flex justify-between items-center">
                                    <span class="text-sm text-gray600">Total Adjustments:</span>
                                    <span class="font-medium">{{ $adjustments->count() }}</span>
                                </div>
                                
                                <div class="border-t border-gray200 pt-4">
                                    <div class="flex justify-between items-center mb-2">
                                        <span class="text-sm font-medium text-gray600">Amount Summary</span>
                                    </div>
                                    <div class="flex justify-between items-center text-sm mb-1">
                                        <span class="text-gray500">Total Amount:</span>
                                        <span class="font-medium">{{ $company->currency_symbol ?? 'K' }}{{ number_format($totalAdjustmentAmount, 2) }}</span>
                                    </div>
                                    <div class="flex justify-between items-center text-xs text-gray500 mb-1">
                                        <span>Taxable: {{ $company->currency_symbol ?? 'K' }}{{ number_format($adjustmentTaxable, 2) }}</span>
                                        <span>Non-taxable: {{ $company->currency_symbol ?? 'K' }}{{ number_format($adjustmentNonTaxable, 2) }}</span>
                                    </div>
                                </div>
                                
                                <div class="border-t border-gray200 pt-4">
                                    <div class="flex justify-between items-center mb-1">
                                        <span class="text-sm text-gray600">Approved:</span>
                                        <span class="font-medium text-green-600">{{ $approvedCount }}</span>
                                    </div>
                                    <div class="flex justify-between items-center mb-1">
                                        <span class="text-sm text-gray600">Pending:</span>
                                        <span class="font-medium text-yellow-600">{{ $pendingCount }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Quick Actions -->
                        <div class="form-section">
                            <h3>Quick Actions</h3>
                            
                            <div class="space-y-3">
                                <button onclick="closeAdjustmentsModal()" 
                                        class="block w-full bg-primary text-white text-center px-4 py-3 rounded text-sm font-medium hover:bg-primary/90 flex items-center justify-center">
                                    <i class="fas fa-check mr-2"></i> Done
                                </button>
                                
                                <button onclick="resetForm()" 
                                        class="block w-full border border-gray300 text-gray700 text-center px-4 py-3 rounded text-sm font-medium hover:bg-gray50 flex items-center justify-center">
                                    <i class="fas fa-redo mr-2"></i> Reset Form
                                </button>
                                
                                <a href="{{ route('admin.accounting.payroll.earnings.employee.index', $employee->id) }}" 
                                   target="_blank"
                                   class="block w-full border border-gray300 text-gray700 text-center px-4 py-3 rounded text-sm font-medium hover:bg-gray50 flex items-center justify-center">
                                    <i class="fas fa-user-edit mr-2"></i> Manage Earnings
                                </a>
                            </div>
                        </div>
                        
                        <!-- Help/Info Card -->
                        <div class="form-section">
                            <h3 class="flex items-center">
                                <i class="fas fa-info-circle mr-2 text-info"></i>
                                Information
                            </h3>
                            
                            <div class="space-y-3 text-sm text-gray600">
                                <div class="flex items-start">
                                    <i class="fas fa-plus-circle text-primary mt-0.5 mr-2"></i>
                                    <div>
                                        <span class="font-medium">Adjustments:</span>
                                        <p class="text-xs mt-1">One-time or period-specific additions/deductions for this payroll period.</p>
                                    </div>
                                </div>
                                <div class="flex items-start">
                                    <i class="fas fa-check-circle text-green-500 mt-0.5 mr-2"></i>
                                    <div>
                                        <span class="font-medium">Approval:</span>
                                        <p class="text-xs mt-1">Adjustments must be approved before payroll processing.</p>
                                    </div>
                                </div>
                                <div class="flex items-start">
                                    <i class="fas fa-redo text-warning mt-0.5 mr-2"></i>
                                    <div>
                                        <span class="font-medium">Reset Form:</span>
                                        <p class="text-xs mt-1">Clear all selections and start over.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Auto-select taxable based on earning type selection
        const earningTypeSelect = document.querySelector('select[name="earning_type_id"]');
        const taxableYes = document.getElementById('taxable_yes');
        const taxableNo = document.getElementById('taxable_no');
        
        if (earningTypeSelect) {
            earningTypeSelect.addEventListener('change', function() {
                const selectedOption = this.options[this.selectedIndex];
                const isTaxableDefault = selectedOption.dataset.taxable === 'true';
                
                if (isTaxableDefault) {
                    taxableYes.checked = true;
                } else {
                    taxableNo.checked = true;
                }
            });
        }
        
        // Form validation
        const addAdjustmentForm = document.getElementById('addAdjustmentForm');
        if (addAdjustmentForm) {
            addAdjustmentForm.addEventListener('submit', function(e) {
                let isValid = true;
                
                // Validate required fields
                const requiredFields = addAdjustmentForm.querySelectorAll('[required]');
                requiredFields.forEach(field => {
                    if (!field.value.trim()) {
                        isValid = false;
                        field.classList.add('border-red-500');
                    } else {
                        field.classList.remove('border-red-500');
                    }
                });
                
                // Validate amount
                const amountField = addAdjustmentForm.querySelector('input[name="amount"]');
                if (amountField && (parseFloat(amountField.value) <= 0 || isNaN(parseFloat(amountField.value)))) {
                    isValid = false;
                    amountField.classList.add('border-red-500');
                }
                
                if (!isValid) {
                    e.preventDefault();
                    showNotification('Please fill in all required fields with valid values.', 'error');
                }
            });
        }
        
        // Auto-focus first field
        const firstField = addAdjustmentForm?.querySelector('[required]');
        if (firstField) {
            firstField.focus();
        }
    });
    
    function editAdjustment(adjustmentId) {
        // This would open an edit modal - you can implement this later
        alert('Edit functionality for adjustment ID: ' + adjustmentId + '\n\nIn a complete implementation, this would open an edit modal.');
    }
    
    // Function to reset the form
    function resetForm() {
        const addAdjustmentForm = document.getElementById('addAdjustmentForm');
        if (addAdjustmentForm) {
            addAdjustmentForm.reset();
            // Set default radio buttons
            document.getElementById('taxable_yes').checked = true;
            document.getElementById('one_time_yes').checked = true;
            
            showNotification('Form has been reset successfully.', 'success');
            
            // Focus on the first field
            const firstField = document.querySelector('select[name="earning_type_id"]');
            if (firstField) {
                firstField.focus();
            }
        }
    }
    
    // Function to close modal (to be called from parent page)
    function closeAdjustmentsModal() {
        const modalContainer = document.getElementById('adjustmentsModalContainer');
        if (modalContainer) {
            modalContainer.innerHTML = '';
        }
        // Also dispatch a custom event to notify parent page
        window.dispatchEvent(new Event('adjustmentsModalClosed'));
    }
    
    // Close modal when clicking outside
    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('bg-gray-900') || e.target.classList.contains('bg-opacity-50')) {
            closeAdjustmentsModal();
        }
    });
    
    // Close modal on escape key
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape') {
            closeAdjustmentsModal();
        }
    });
    
    // Handle form submissions within the modal via AJAX
    document.addEventListener('submit', function(e) {
        const form = e.target;
        
        // Only handle forms inside the modal
        if (form.closest('.bg-white.rounded-lg.shadow-xl')) {
            e.preventDefault();
            
            // Show loading state
            const submitBtn = form.querySelector('button[type="submit"]');
            const originalText = submitBtn ? submitBtn.innerHTML : '';
            if (submitBtn) {
                submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Processing...';
                submitBtn.disabled = true;
            }
            
            // Submit form via AJAX
            fetch(form.action, {
                method: form.method,
                body: new FormData(form),
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json'
                }
            })
            .then(response => {
                if (!response.ok) {
                    throw new Error('Network response was not ok');
                }
                return response.json();
            })
            .then(data => {
                if (submitBtn) {
                    submitBtn.innerHTML = originalText;
                    submitBtn.disabled = false;
                }
                
                if (data.success) {
                    showNotification(data.message || 'Operation successful', 'success');
                    
                    // Reload the modal with updated data
                    setTimeout(() => {
                        // Extract period and employee IDs from the form
                        const periodId = '{{ $period->id }}';
                        const employeeId = '{{ $employee->id }}';
                        
                        // Dispatch event to parent page to reload modal
                        window.dispatchEvent(new CustomEvent('reloadAdjustmentsModal', {
                            detail: { periodId, employeeId }
                        }));
                    }, 1500);
                } else {
                    showNotification(data.message || 'Operation failed', 'error');
                }
            })
            .catch(error => {
                console.error('Error submitting form:', error);
                if (submitBtn) {
                    submitBtn.innerHTML = originalText;
                    submitBtn.disabled = false;
                }
                showNotification('Failed to process request. Please try again.', 'error');
            });
        }
    });
    
    // Utility function to show notifications
    function showNotification(message, type = 'info') {
        // Remove existing notification
        const existing = document.querySelector('.modal-notification');
        if (existing) existing.remove();

        const colors = {
            success: 'bg-green-500',
            error: 'bg-red-500',
            info: 'bg-primary',
            warning: 'bg-yellow-500'
        };

        const icons = {
            success: 'fa-check-circle',
            error: 'fa-exclamation-circle',
            info: 'fa-info-circle',
            warning: 'fa-exclamation-triangle'
        };

        const notification = document.createElement('div');
        notification.className = `modal-notification fixed top-4 right-4 ${colors[type]} text-white px-4 py-3 rounded shadow-lg z-9999 flex items-center animate-fade-in`;
        notification.innerHTML = `
            <i class="fas ${icons[type]} mr-2"></i>
            <span>${message}</span>
        `;

        document.body.appendChild(notification);

        setTimeout(() => {
            notification.classList.add('animate-fade-out');
            setTimeout(() => {
                notification.remove();
            }, 300);
        }, 3000);
    }
    
    // Add animation styles if not present
    if (!document.querySelector('style[data-modal-animations]')) {
        const style = document.createElement('style');
        style.setAttribute('data-modal-animations', 'true');
        style.textContent = `
            @keyframes fadeIn {
                from { opacity: 0; transform: translateY(-10px); }
                to { opacity: 1; transform: translateY(0); }
            }
            @keyframes fadeOut {
                from { opacity: 1; transform: translateY(0); }
                to { opacity: 0; transform: translateY(-10px); }
            }
            .animate-fade-in {
                animation: fadeIn 0.3s ease-out;
            }
            .animate-fade-out {
                animation: fadeOut 0.3s ease-in;
            }
        `;
        document.head.appendChild(style);
    }
</script>