@if($adjustments->count() > 0)
    <div class="border border-gray200 rounded-lg overflow-hidden">
        <table class="quickbooks-table">
            <thead>
                <tr>
                    <th>Type</th>
                    <th>Description</th>
                    <th>Amount</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach($adjustments as $adjustment)
                    <tr>
                        <td>
                            <div>{{ $adjustment->earningType->name }}</div>
                            <div class="text-xs text-gray500">{{ $adjustment->earningType->code }}</div>
                            <div class="text-xs">
                                @if($adjustment->is_one_time)
                                    <span class="text-yellow-600">One-time</span>
                                @else
                                    <span class="text-purple-600">Period Recurring</span>
                                @endif
                            </div>
                        </td>
                        <td>
                            <div class="font-medium">{{ Str::limit($adjustment->description, 30) }}</div>
                            @if($adjustment->notes)
                                <div class="text-xs text-gray500">{{ Str::limit($adjustment->notes, 20) }}</div>
                            @endif
                        </td>
                        <td class="font-medium">
                            <div>{{ $company->currency_symbol ?? 'K' }}{{ number_format($adjustment->amount, 2) }}</div>
                            <div class="text-xs">
                                @if($adjustment->is_taxable)
                                    <span class="text-red-600">Taxable</span>
                                @else
                                    <span class="text-green-600">Non-Taxable</span>
                                @endif
                            </div>
                        </td>
                        <td>
                            @if($adjustment->isApproved())
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                    <i class="fas fa-check mr-1"></i> Approved
                                </span>
                            @else
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800">
                                    <i class="fas fa-clock mr-1"></i> Pending
                                </span>
                            @endif
                        </td>
                        <td>
                            <div class="flex space-x-2">
                                @if(!$adjustment->isApproved())
                                    <form action="{{ route('admin.accounting.payroll.preparation.approve', $adjustment->id) }}" method="POST" class="inline">
                                        @csrf
                                        <button type="submit" class="text-green-600 hover:text-green-800" title="Approve">
                                            <i class="fas fa-check"></i>
                                        </button>
                                    </form>
                                    <a href="#" onclick="editAdjustment({{ $adjustment->id }})" class="text-blue-600 hover:text-blue-800" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                @else
                                    <form action="{{ route('admin.accounting.payroll.preparation.unapprove', $adjustment->id) }}" method="POST" class="inline">
                                        @csrf
                                        <button type="submit" class="text-yellow-600 hover:text-yellow-800" title="Unapprove">
                                            <i class="fas fa-undo"></i>
                                        </button>
                                    </form>
                                @endif
                                <form action="{{ route('admin.accounting.payroll.preparation.destroy', $adjustment->id) }}" method="POST" class="inline" onsubmit="return confirm('Are you sure you want to delete this adjustment?');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-600 hover:text-red-800" title="Delete">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
@else
    <div class="text-center py-8 text-gray500">
        <i class="fas fa-file-invoice-dollar text-3xl mb-3 text-gray300"></i>
        <p>No adjustments for this employee</p>
        <p class="text-sm mt-1">Use the form above to add payroll adjustments</p>
    </div>
@endif