@if($recurringEarnings->count() > 0)
    <div class="overflow-x-auto">
        <table class="quickbooks-table">
            <thead>
                <tr>
                    @if(!$filteredEmployeeId)
                        <th>Employee</th>
                    @endif
                    <th>Earning Type</th>
                    <th>Frequency</th>
                    <th>Monthly Amount</th>
                    <th>Taxable</th>
                    <th>Effective Date</th>
                </tr>
            </thead>
            <tbody>
                @foreach($recurringEarnings as $earning)
                    <tr data-employee-id="{{ $earning->employee_id }}">
                        @if(!$filteredEmployeeId)
                            <td>
                                <div class="font-medium">{{ $earning->employee->first_name }} {{ $earning->employee->last_name }}</div>
                                <div class="text-xs text-gray500">#{{ $earning->employee->employee_number }}</div>
                            </td>
                        @endif
                        <td>
                            <div class="font-medium">{{ $earning->earningType->name }}</div>
                            <div class="text-xs text-gray500">{{ $earning->earningType->code }}</div>
                        </td>
                        <td>
                            <span class="text-sm font-medium capitalize">{{ $earning->frequency }}</span>
                        </td>
                        <td class="font-medium">
                            {{ $company->currency_symbol ?? 'K' }}{{ number_format($earning->getMonthlyAmount(), 2) }}
                        </td>
                        <td>
                            @if($earning->earningType->is_taxable)
                                <span class="badge bg-red-100 text-red-800">Yes</span>
                            @else
                                <span class="badge bg-green-100 text-green-800">No</span>
                            @endif
                        </td>
                        <td class="text-sm">
                            {{ $earning->effective_date->format('M d, Y') }}
                            @if($earning->end_date)
                                <div class="text-xs text-gray500">to {{ $earning->end_date->format('M d, Y') }}</div>
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
            <tfoot class="bg-gray-50">
                <tr>
                    <td colspan="{{ $filteredEmployeeId ? 2 : 3 }}" class="text-right font-medium text-gray-700 py-3">
                        Total Monthly Recurring:
                    </td>
                    <td class="font-bold text-primary py-3">
                        {{ $company->currency_symbol ?? 'K' }}{{ number_format($recurringEarnings->sum(function($e) { return $e->getMonthlyAmount(); }), 2) }}
                    </td>
                    <td colspan="2" class="py-3">
                        <div class="text-sm text-gray-600">
                            {{ $recurringEarnings->count() }} earning(s)
                        </div>
                    </td>
                </tr>
            </tfoot>
        </table>
    </div>
@else
    <div class="text-center py-8 text-gray500">
        <i class="fas fa-file-invoice-dollar text-3xl mb-3 text-gray300"></i>
        @if($filteredEmployeeId)
            <p>No recurring earnings for this employee</p>
        @else
            <p>No recurring earnings found</p>
        @endif
        <p class="text-sm mt-1">
            Recurring earnings are automatically loaded from employee profiles
        </p>
    </div>
@endif