<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Assign Requirements | {{ config('app.name', 'IMMIA FINANCE') }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#146CAA',
                        primaryLight: '#E1F0FA',
                        secondary: '#6b7280',
                        success: '#107C10',
                        warning: '#F68C1E',
                        danger: '#D83B01',
                        info: '#0078D4',
                        gray50: '#FAF9F8',
                        gray100: '#F3F2F1',
                        gray200: '#EDEBE9',
                        gray300: '#E1DFDD',
                        gray400: '#C8C6C4',
                        gray500: '#A19F9D',
                        gray600: '#605E5C',
                        gray700: '#323130',
                        gray800: '#201F1E',
                        gray900: '#000000'
                    }
                }
            }
        }
    </script>
    <style>
        .quickbooks-input {
            border: 1px solid #E1DFDD;
            border-radius: 4px;
            padding: 8px 12px;
            font-size: 14px;
            transition: border-color 0.2s;
            width: 100%;
        }
        .quickbooks-input:focus {
            outline: none;
            border-color: #146CAA;
            box-shadow: 0 0 0 2px rgba(20, 108, 170, 0.1);
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .animate-fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }
        .requirement-card {
            background: white;
            border: 2px solid #EDEBE9;
            border-radius: 8px;
            padding: 16px;
            transition: all 0.2s;
            cursor: pointer;
        }
        .requirement-card:hover {
            border-color: #146CAA;
            box-shadow: 0 4px 12px rgba(20, 108, 170, 0.1);
        }
        .requirement-card.selected {
            border-color: #146CAA;
            background-color: #F0F7FF;
        }
        .requirement-card.mandatory {
            border-color: #D83B01;
        }
        .requirement-card.mandatory.selected {
            background-color: #FEE8E6;
        }
        .category-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 8px;
            padding: 12px 16px;
            margin-bottom: 16px;
        }
        .checkbox-container {
            position: relative;
            display: inline-flex;
            align-items: center;
            cursor: pointer;
        }
        .checkbox-input {
            position: absolute;
            opacity: 0;
            cursor: pointer;
            height: 0;
            width: 0;
        }
        .checkbox-custom {
            height: 20px;
            width: 20px;
            background-color: white;
            border: 2px solid #C8C6C4;
            border-radius: 4px;
            position: relative;
            transition: all 0.2s;
        }
        .checkbox-input:checked ~ .checkbox-custom {
            background-color: #146CAA;
            border-color: #146CAA;
        }
        .checkbox-input:checked ~ .checkbox-custom:after {
            content: "";
            position: absolute;
            left: 6px;
            top: 2px;
            width: 6px;
            height: 10px;
            border: solid white;
            border-width: 0 2px 2px 0;
            transform: rotate(45deg);
        }
        .mandatory-checkbox {
            margin-left: 8px;
        }
        .mandatory-checkbox .checkbox-custom {
            border-color: #D83B01;
        }
        .mandatory-checkbox .checkbox-input:checked ~ .checkbox-custom {
            background-color: #D83B01;
            border-color: #D83B01;
        }
        .requirements-summary {
            position: sticky;
            top: 20px;
            background: white;
            border: 1px solid #EDEBE9;
            border-radius: 8px;
            padding: 20px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        }
        .summary-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
        }
        .badge-selected {
            background-color: #E1F0FA;
            color: #146CAA;
        }
        .badge-mandatory {
            background-color: #FEE8E6;
            color: #D83B01;
        }
        .badge-optional {
            background-color: #FEF7E0;
            color: #F68C1E;
        }
    </style>
</head>
<body class="bg-gray50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        <!-- Header -->
        <header class="bg-white border-b border-gray200 py-4 px-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-xl font-bold text-gray900">Assign Application Requirements</h1>
                    <nav class="flex space-x-2 text-sm text-gray600 mt-1">
                        <a href="{{ route('admin.accounting.index') }}" class="hover:text-primary">Dashboard</a>
                        <span>/</span>
                        <a href="{{ route('admin.accounting.products.index') }}" class="hover:text-primary">Products</a>
                        <span>/</span>
                        <span class="text-gray900">Assign Requirements</span>
                    </nav>
                </div>
                <div class="flex items-center space-x-3">
                    <button onclick="location.href='{{ route('admin.accounting.products.show', $loanType->id) }}'" 
                            class="flex items-center space-x-2 px-4 py-2 bg-gray100 text-gray700 rounded-lg text-sm font-medium hover:bg-gray200">
                        <i class="fas fa-arrow-left"></i>
                        <span>Back to Product</span>
                    </button>
                </div>
            </div>
        </header>

        <main class="p-6">
            <!-- Success/Error Messages -->
            @if(session('success'))
                <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4 animate-fade-in">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <i class="fas fa-check-circle text-green-500 mr-2"></i>
                            <span class="text-green-800 font-medium">{{ session('success') }}</span>
                        </div>
                        <button onclick="this.parentElement.parentElement.remove()" class="text-green-600 hover:text-green-800">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
            @endif

            @if(session('error'))
                <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4 animate-fade-in">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <i class="fas fa-exclamation-circle text-red-500 mr-2"></i>
                            <span class="text-red-800 font-medium">{{ session('error') }}</span>
                        </div>
                        <button onclick="this.parentElement.parentElement.remove()" class="text-red-600 hover:text-red-800">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
            @endif

            <div class="grid grid-cols-1 lg:grid-cols-4 gap-6">
                <!-- Requirements Selection -->
                <div class="lg:col-span-3">
                    <div class="bg-white rounded-lg border border-gray200">
                        <div class="px-6 py-4 border-b border-gray200">
                            <h2 class="text-lg font-semibold text-gray900">Select Requirements for {{ $loanType->product }}</h2>
                            <p class="text-gray600 text-sm mt-1">Check documents that are required for this loan product</p>
                        </div>
                        <div class="p-6">
                            <form id="assignForm" method="POST" action="{{ route('admin.accounting.products.update-requirements', $loanType->id) }}">
                                @csrf
                                
                                <!-- Search Requirements -->
                                <div class="mb-6">
                                    <div class="relative">
                                        <input type="text" 
                                               id="searchRequirements"
                                               placeholder="Search requirements..." 
                                               class="quickbooks-input pl-10 pr-4"
                                               onkeyup="filterRequirements()">
                                        <i class="fas fa-search absolute left-3 top-1/2 transform -translate-y-1/2 text-gray400"></i>
                                    </div>
                                </div>
                                
                                <!-- Requirements by Category -->
                                @php
                                    $groupedRequirements = [];
                                    foreach ($allRequirements as $requirement) {
                                        $documentName = strtolower($requirement->documentname);
                                        $category = 'Other Documents';
                                        
                                        foreach ($categories as $categoryName => $keywords) {
                                            foreach ($keywords as $keyword) {
                                                if (str_contains($documentName, $keyword)) {
                                                    $category = $categoryName;
                                                    break 2;
                                                }
                                            }
                                        }
                                        
                                        if (!isset($groupedRequirements[$category])) {
                                            $groupedRequirements[$category] = [];
                                        }
                                        $groupedRequirements[$category][] = $requirement;
                                    }
                                @endphp
                                
                                @foreach($groupedRequirements as $category => $requirements)
                                <div class="mb-8 requirement-category" data-category="{{ strtolower($category) }}">
                                    <div class="category-header">
                                        <h3 class="font-semibold text-lg">{{ $category }}</h3>
                                        <p class="text-sm opacity-90">{{ count($requirements) }} document(s)</p>
                                    </div>
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                        @foreach($requirements as $requirement)
                                        @php
                                            $isAssigned = in_array($requirement->id, $assignedRequirements);
                                            $isMandatory = false;
                                            if ($isAssigned) {
                                                $pivot = $loanType->requirements()->where('requirement_id', $requirement->id)->first();
                                                $isMandatory = $pivot && $pivot->pivot && $pivot->pivot->is_mandatory;
                                            }
                                        @endphp
                                        <div class="requirement-card {{ $isAssigned ? 'selected' : '' }} {{ $isMandatory ? 'mandatory' : '' }}"
                                             id="requirement-{{ $requirement->id }}"
                                             onclick="toggleRequirement({{ $requirement->id }})">
                                            <div class="flex items-start justify-between">
                                                <div class="flex-1">
                                                    <div class="flex items-center">
                                                        <label class="checkbox-container mr-3">
                                                            <input type="checkbox" 
                                                                   name="requirements[]" 
                                                                   value="{{ $requirement->id }}"
                                                                   class="checkbox-input requirement-checkbox"
                                                                   id="checkbox-{{ $requirement->id }}"
                                                                   {{ $isAssigned ? 'checked' : '' }}
                                                                   data-requirement-id="{{ $requirement->id }}">
                                                            <span class="checkbox-custom"></span>
                                                        </label>
                                                        <div>
                                                            <h4 class="font-medium text-gray900">{{ $requirement->documentname }}</h4>
                                                            <p class="text-xs text-gray500 mt-1">
                                                                Type: {{ $requirement->document_type }}
                                                                @if($requirement->product_count > 0)
                                                                • Used by {{ $requirement->product_count }} product(s)
                                                                @endif
                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="flex items-center">
                                                    <label class="checkbox-container mandatory-checkbox {{ !$isAssigned ? 'opacity-50 pointer-events-none' : '' }}">
                                                        <input type="checkbox" 
                                                               name="mandatory[]" 
                                                               value="{{ $requirement->id }}"
                                                               class="checkbox-input mandatory-checkbox-input"
                                                               id="mandatory-{{ $requirement->id }}"
                                                               {{ $isMandatory ? 'checked' : '' }}
                                                               data-requirement-id="{{ $requirement->id }}">
                                                        <span class="checkbox-custom"></span>
                                                        <span class="ml-2 text-xs font-medium text-red-600">Mandatory</span>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        @endforeach
                                    </div>
                                </div>
                                @endforeach
                                
                                <!-- Quick Actions -->
                                <div class="flex items-center justify-between p-4 bg-gray50 rounded-lg border border-gray200 mt-8">
                                    <div class="flex items-center space-x-4">
                                        <button type="button" 
                                                onclick="selectAll()"
                                                class="text-sm text-primary hover:text-primary/80 font-medium">
                                            <i class="fas fa-check-square mr-1"></i>
                                            Select All
                                        </button>
                                        <button type="button" 
                                                onclick="deselectAll()"
                                                class="text-sm text-gray600 hover:text-gray900 font-medium">
                                            <i class="fas fa-times-circle mr-1"></i>
                                            Deselect All
                                        </button>
                                        <button type="button" 
                                                onclick="selectCategory('Identification')"
                                                class="text-sm text-blue-600 hover:text-blue-800 font-medium">
                                            All ID Docs
                                        </button>
                                        <button type="button" 
                                                onclick="selectCategory('Proof of Income')"
                                                class="text-sm text-green-600 hover:text-green-800 font-medium">
                                            All Income Docs
                                        </button>
                                    </div>
                                    <div class="text-right">
                                        <span class="text-sm text-gray600">Selected: </span>
                                        <span id="selectedCount" class="font-semibold text-primary">0</span>
                                        <span class="text-sm text-gray600 ml-3">Mandatory: </span>
                                        <span id="mandatoryCount" class="font-semibold text-red-600">0</span>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Summary & Actions -->
                <div>
                    <div class="requirements-summary">
                        <h3 class="text-lg font-semibold text-gray900 mb-4">Requirements Summary</h3>
                        
                        <!-- Product Info -->
                        <div class="mb-6 p-4 bg-blue-50 rounded-lg">
                            <h4 class="font-medium text-blue-900 mb-2">{{ $loanType->product }}</h4>
                            <p class="text-sm text-blue-700">{{ $loanType->details }}</p>
                            <div class="mt-3">
                                <span class="text-xs text-blue-600">Currently assigned:</span>
                                <div class="flex items-center space-x-2 mt-1">
                                    <span class="summary-badge badge-selected">
                                        {{ $loanType->requirements_count ?? 0 }} total
                                    </span>
                                    @if(($loanType->mandatory_requirements_count ?? 0) > 0)
                                    <span class="summary-badge badge-mandatory">
                                        {{ $loanType->mandatory_requirements_count ?? 0 }} mandatory
                                    </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        
                        <!-- Selected Requirements Preview -->
                        <div class="mb-6">
                            <h4 class="font-medium text-gray900 mb-3">Selected Requirements</h4>
                            <div id="selectedRequirementsList" class="space-y-2 max-h-64 overflow-y-auto">
                                <!-- Will be populated by JavaScript -->
                                <div class="text-center py-4 text-gray500">
                                    <i class="fas fa-clipboard-list text-2xl mb-2"></i>
                                    <p class="text-sm">No requirements selected</p>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Guidelines -->
                        <div class="mb-6 p-4 bg-green-50 rounded-lg">
                            <div class="flex items-center mb-2">
                                <i class="fas fa-lightbulb text-green-600 mr-2"></i>
                                <h5 class="text-sm font-semibold text-green-900">Guidelines</h5>
                            </div>
                            <ul class="text-xs text-green-700 space-y-1">
                                <li>• Check documents required for this product</li>
                                <li>• Mark "Mandatory" for essential documents</li>
                                <li>• Consider customer convenience</li>
                                <li>• Balance thoroughness with practicality</li>
                            </ul>
                        </div>
                        
                        <!-- Form Actions -->
                        <div class="space-y-3">
                            <button type="submit" 
                                    form="assignForm"
                                    id="submitBtn"
                                    class="w-full flex items-center justify-center space-x-2 px-4 py-3 bg-primary text-white rounded-lg text-sm font-medium hover:bg-primary/90">
                                <i class="fas fa-save"></i>
                                <span>Save Requirements</span>
                            </button>
                            <button onclick="location.href='{{ route('admin.accounting.products.show', $loanType->id) }}'" 
                                    class="w-full px-4 py-3 text-gray700 hover:bg-gray100 rounded text-sm font-medium text-center">
                                Cancel
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            updateCounts();
            updateSelectedList();
            
            // Add event listeners to checkboxes
            const requirementCheckboxes = document.querySelectorAll('.requirement-checkbox');
            requirementCheckboxes.forEach(checkbox => {
                checkbox.addEventListener('change', function() {
                    const requirementId = this.getAttribute('data-requirement-id');
                    const card = document.getElementById(`requirement-${requirementId}`);
                    const mandatoryCheckbox = document.getElementById(`mandatory-${requirementId}`);
                    
                    if (this.checked) {
                        card.classList.add('selected');
                        if (mandatoryCheckbox && mandatoryCheckbox.parentElement) {
                            mandatoryCheckbox.parentElement.classList.remove('opacity-50', 'pointer-events-none');
                        }
                    } else {
                        card.classList.remove('selected', 'mandatory');
                        if (mandatoryCheckbox && mandatoryCheckbox.parentElement) {
                            mandatoryCheckbox.parentElement.classList.add('opacity-50', 'pointer-events-none');
                        }
                        if (mandatoryCheckbox) {
                            mandatoryCheckbox.checked = false;
                        }
                    }
                    
                    updateCounts();
                    updateSelectedList();
                });
            });
            
            // Add event listeners to mandatory checkboxes
            const mandatoryCheckboxes = document.querySelectorAll('.mandatory-checkbox-input');
            mandatoryCheckboxes.forEach(checkbox => {
                checkbox.addEventListener('change', function() {
                    const requirementId = this.getAttribute('data-requirement-id');
                    const card = document.getElementById(`requirement-${requirementId}`);
                    
                    if (this.checked && card) {
                        card.classList.add('mandatory');
                    } else if (card) {
                        card.classList.remove('mandatory');
                    }
                    
                    updateCounts();
                    updateSelectedList();
                });
            });
            
            // Initialize selected count
            const initiallySelected = document.querySelectorAll('.requirement-checkbox:checked');
            document.getElementById('selectedCount').textContent = initiallySelected.length;
            
            // Initialize mandatory count
            const initiallyMandatory = document.querySelectorAll('.mandatory-checkbox-input:checked');
            document.getElementById('mandatoryCount').textContent = initiallyMandatory.length;
            
            // Update selected list on load
            updateSelectedList();
        });
        
        function toggleRequirement(requirementId) {
            const checkbox = document.getElementById(`checkbox-${requirementId}`);
            if (checkbox) {
                checkbox.checked = !checkbox.checked;
                checkbox.dispatchEvent(new Event('change'));
            }
        }
        
        function updateCounts() {
            const selectedCheckboxes = document.querySelectorAll('.requirement-checkbox:checked');
            const mandatoryCheckboxes = document.querySelectorAll('.mandatory-checkbox-input:checked');
            
            document.getElementById('selectedCount').textContent = selectedCheckboxes.length;
            document.getElementById('mandatoryCount').textContent = mandatoryCheckboxes.length;
        }
        
        function updateSelectedList() {
            const container = document.getElementById('selectedRequirementsList');
            const selectedCheckboxes = document.querySelectorAll('.requirement-checkbox:checked');
            
            if (selectedCheckboxes.length === 0) {
                container.innerHTML = `
                    <div class="text-center py-4 text-gray500">
                        <i class="fas fa-clipboard-list text-2xl mb-2"></i>
                        <p class="text-sm">No requirements selected</p>
                    </div>
                `;
                return;
            }
            
            let html = '';
            selectedCheckboxes.forEach(checkbox => {
                const requirementId = checkbox.getAttribute('data-requirement-id');
                const card = document.getElementById(`requirement-${requirementId}`);
                if (!card) return;
                
                const requirementNameElement = card.querySelector('h4');
                if (!requirementNameElement) return;
                
                const requirementName = requirementNameElement.textContent;
                const isMandatory = card.classList.contains('mandatory');
                
                html += `
                    <div class="flex items-center justify-between p-2 bg-white border border-gray200 rounded">
                        <div class="flex items-center">
                            <i class="fas fa-file-alt text-gray400 mr-2"></i>
                            <span class="text-sm text-gray900 truncate" title="${requirementName}">
                                ${requirementName.substring(0, 20)}${requirementName.length > 20 ? '...' : ''}
                            </span>
                        </div>
                        ${isMandatory ? '<span class="text-xs font-medium text-red-600">Mandatory</span>' : '<span class="text-xs text-gray500">Optional</span>'}
                    </div>
                `;
            });
            
            container.innerHTML = html;
        }
        
        function filterRequirements() {
            const searchTerm = document.getElementById('searchRequirements').value.toLowerCase();
            const categories = document.querySelectorAll('.requirement-category');
            let visibleCount = 0;
            
            categories.forEach(category => {
                const categoryName = category.getAttribute('data-category');
                const requirements = category.querySelectorAll('.requirement-card');
                let categoryVisible = false;
                
                requirements.forEach(requirement => {
                    const requirementNameElement = requirement.querySelector('h4');
                    const requirementTypeElement = requirement.querySelector('.text-gray500');
                    
                    if (!requirementNameElement || !requirementTypeElement) return;
                    
                    const requirementName = requirementNameElement.textContent.toLowerCase();
                    const requirementType = requirementTypeElement.textContent.toLowerCase();
                    
                    if (requirementName.includes(searchTerm) || requirementType.includes(searchTerm)) {
                        requirement.style.display = '';
                        categoryVisible = true;
                        visibleCount++;
                    } else {
                        requirement.style.display = 'none';
                    }
                });
                
                category.style.display = categoryVisible ? '' : 'none';
            });
            
            // Show message if no results
            if (visibleCount === 0) {
                const container = document.querySelector('.lg\\:col-span-3 > div > .p-6');
                if (container) {
                    let noResults = container.querySelector('.no-results-message');
                    if (!noResults) {
                        noResults = document.createElement('div');
                        noResults.className = 'no-results-message text-center py-8 text-gray500';
                        noResults.innerHTML = `
                            <i class="fas fa-search text-3xl mb-3"></i>
                            <p>No requirements found matching "${searchTerm}"</p>
                            <p class="text-sm mt-2">Try a different search term</p>
                        `;
                        container.appendChild(noResults);
                    }
                }
            } else {
                const noResults = document.querySelector('.no-results-message');
                if (noResults) {
                    noResults.remove();
                }
            }
        }
        
        function selectAll() {
            document.querySelectorAll('.requirement-checkbox').forEach(checkbox => {
                if (!checkbox.checked) {
                    checkbox.checked = true;
                    checkbox.dispatchEvent(new Event('change'));
                }
            });
        }
        
        function deselectAll() {
            document.querySelectorAll('.requirement-checkbox').forEach(checkbox => {
                if (checkbox.checked) {
                    checkbox.checked = false;
                    checkbox.dispatchEvent(new Event('change'));
                }
            });
        }
        
        function selectCategory(categoryName) {
            const category = document.querySelector(`[data-category="${categoryName.toLowerCase()}"]`);
            if (category) {
                category.querySelectorAll('.requirement-checkbox').forEach(checkbox => {
                    if (!checkbox.checked) {
                        checkbox.checked = true;
                        checkbox.dispatchEvent(new Event('change'));
                    }
                });
            }
        }
        
        // Form submission
        const form = document.getElementById('assignForm');
        const submitBtn = document.getElementById('submitBtn');
        
        if (form && submitBtn) {
            form.addEventListener('submit', function(e) {
                const selectedCheckboxes = document.querySelectorAll('.requirement-checkbox:checked');
                
                if (selectedCheckboxes.length === 0) {
                    e.preventDefault();
                    if (confirm('No requirements selected. Are you sure you want to continue? This will remove all assigned requirements.')) {
                        submitBtn.disabled = true;
                        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-1"></i> Saving...';
                        return true;
                    } else {
                        return false;
                    }
                }
                
                submitBtn.disabled = true;
                submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-1"></i> Saving...';
            });
        }
        
        // Show selected requirements on load
        document.querySelectorAll('.requirement-checkbox:checked').forEach(checkbox => {
            checkbox.dispatchEvent(new Event('change'));
        });
    </script>
</body>
</html>