<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Self Service Dashboard | {{ config('app.name', 'IMMIA FINANCE') }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#146CAA',
                        primaryLight: '#E1F0FA',
                        secondary: '#6b7280',
                        success: '#107C10',
                        warning: '#F68C1E',
                        danger: '#D83B01',
                        info: '#0078D4',
                        gray50: '#FAF9F8',
                        gray100: '#F3F2F1',
                        gray200: '#EDEBE9',
                        gray300: '#E1DFDD',
                        gray400: '#C8C6C4',
                        gray500: '#A19F9D',
                        gray600: '#605E5C',
                        gray700: '#323130',
                        gray800: '#201F1E',
                        gray900: '#000000'
                    }
                }
            }
        }
    </script>
    <style>
        .quickbooks-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
        }
        .stat-card {
            background: white;
            border: 1px solid #EDEBE9;
            border-radius: 8px;
            padding: 20px;
            transition: all 0.3s ease;
        }
        .stat-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        }
        .stat-icon {
            width: 48px;
            height: 48px;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .animate-fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }
    </style>
</head>
<body class="bg-gray50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        @include('accounting.partials.header', ['title' => 'Self Service Dashboard', 'subtitle' => 'Your personal dashboard for payroll and leave information'])

        <main class="p-6">
            <!-- Success/Error Messages -->
            @if(session('success'))
                <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4 animate-fade-in">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <i class="fas fa-check-circle text-green-500 mr-2"></i>
                            <span class="text-green-800 font-medium">{{ session('success') }}</span>
                        </div>
                        <button onclick="this.parentElement.parentElement.remove()" class="text-green-600 hover:text-green-800">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
            @endif

            @if(session('error'))
                <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4 animate-fade-in">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <i class="fas fa-exclamation-circle text-red-500 mr-2"></i>
                            <span class="text-red-800 font-medium">{{ session('error') }}</span>
                        </div>
                        <button onclick="this.parentElement.parentElement.remove()" class="text-red-600 hover:text-red-800">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
            @endif

            <!-- Welcome Header -->
            <div class="bg-white rounded-lg border border-gray200 p-6 mb-6 animate-fade-in">
                <div class="flex flex-col md:flex-row md:items-center justify-between">
                    <div>
                        <div class="flex items-center gap-3 mb-3">
                            <div class="w-12 h-12 bg-primaryLight rounded-lg flex items-center justify-center">
                                <i class="fas fa-user-circle text-primary text-xl"></i>
                            </div>
                            <div>
                                <h1 class="text-xl font-bold text-gray900">Welcome, {{ $employee->first_name }} {{ $employee->last_name }}</h1>
                                <p class="text-gray600 text-sm">Employee #{{ $employee->employee_number }}</p>
                            </div>
                        </div>
                        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                            <div class="text-sm">
                                <span class="text-gray500">Department:</span>
                                <span class="font-medium text-gray900 ml-2">{{ $employee->department->name ?? 'N/A' }}</span>
                            </div>
                            <div class="text-sm">
                                <span class="text-gray500">Position:</span>
                                <span class="font-medium text-gray900 ml-2">{{ $employee->position ?? 'N/A' }}</span>
                            </div>
                            <div class="text-sm">
                                <span class="text-gray500">Hire Date:</span>
                                <span class="font-medium text-gray900 ml-2">{{ \Carbon\Carbon::parse($employee->hire_date)->format('M d, Y') }}</span>
                            </div>
                            <div class="text-sm">
                                <span class="text-gray500">Employment:</span>
                                <span class="font-medium text-gray900 ml-2">{{ ucfirst($employee->employment_type) }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4 md:mt-0">
                        <span class="quickbooks-badge bg-green-100 text-green-800">
                            <i class="fas fa-circle text-xs mr-1"></i>
                            Active Employee
                        </span>
                    </div>
                </div>
            </div>

            <!-- Payroll Statistics -->
            <div class="mb-8">
                <div class="flex items-center justify-between mb-4">
                    <h2 class="text-lg font-semibold text-gray900">Payroll Statistics ({{ date('Y') }})</h2>
                    <a href="{{ route('admin.accounting.self-service.payrolls.index') }}" class="text-primary hover:text-primary/90 text-sm font-medium flex items-center gap-1">
                        View All Payrolls
                        <i class="fas fa-arrow-right text-xs"></i>
                    </a>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-4">
                    <!-- Payrolls Done -->
                    <div class="stat-card animate-fade-in" style="animation-delay: 0.1s">
                        <div class="flex items-center">
                            <div class="stat-icon bg-blue-100 mr-4">
                                <i class="fas fa-money-check-alt text-blue-600 text-xl"></i>
                            </div>
                            <div>
                                <p class="text-sm text-gray600 mb-1">Payrolls Processed</p>
                                <h3 class="text-2xl font-bold text-gray900">{{ $payrollStats->payrolls_done ?? 0 }}</h3>
                            </div>
                        </div>
                    </div>

                    <!-- Total Wages -->
                    <div class="stat-card animate-fade-in" style="animation-delay: 0.2s">
                        <div class="flex items-center">
                            <div class="stat-icon bg-green-100 mr-4">
                                <i class="fas fa-money-bill-wave text-green-600 text-xl"></i>
                            </div>
                            <div>
                                <p class="text-sm text-gray600 mb-1">Total Wages</p>
                                <h3 class="text-2xl font-bold text-gray900">
                                    {{ $company->currency_symbol ?? 'K' }}{{ number_format($payrollStats->total_wages ?? 0, 2) }}
                                </h3>
                            </div>
                        </div>
                    </div>

                    <!-- Total NAPSA -->
                    <div class="stat-card animate-fade-in" style="animation-delay: 0.3s">
                        <div class="flex items-center">
                            <div class="stat-icon bg-purple-100 mr-4">
                                <i class="fas fa-shield-alt text-purple-600 text-xl"></i>
                            </div>
                            <div>
                                <p class="text-sm text-gray600 mb-1">NAPSA Contributions</p>
                                <h3 class="text-2xl font-bold text-gray900">
                                    {{ $company->currency_symbol ?? 'K' }}{{ number_format($payrollStats->total_napsa ?? 0, 2) }}
                                </h3>
                            </div>
                        </div>
                    </div>

                    <!-- Total NHIMA -->
                    <div class="stat-card animate-fade-in" style="animation-delay: 0.4s">
                        <div class="flex items-center">
                            <div class="stat-icon bg-red-100 mr-4">
                                <i class="fas fa-heartbeat text-red-600 text-xl"></i>
                            </div>
                            <div>
                                <p class="text-sm text-gray600 mb-1">NHIMA Contributions</p>
                                <h3 class="text-2xl font-bold text-gray900">
                                    {{ $company->currency_symbol ?? 'K' }}{{ number_format($payrollStats->total_nhima ?? 0, 2) }}
                                </h3>
                            </div>
                        </div>
                    </div>

                    <!-- Total Deductions -->
                    <div class="stat-card animate-fade-in" style="animation-delay: 0.5s">
                        <div class="flex items-center">
                            <div class="stat-icon bg-yellow-100 mr-4">
                                <i class="fas fa-minus-circle text-yellow-600 text-xl"></i>
                            </div>
                            <div>
                                <p class="text-sm text-gray600 mb-1">Total Deductions</p>
                                <h3 class="text-2xl font-bold text-gray900">
                                    {{ $company->currency_symbol ?? 'K' }}{{ number_format($payrollStats->total_deductions ?? 0, 2) }}
                                </h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Leave Statistics -->
            <div class="mb-8">
                <div class="flex items-center justify-between mb-4">
                    <h2 class="text-lg font-semibold text-gray900">Leave Statistics ({{ date('Y') }})</h2>
                    <a href="{{ route('admin.accounting.self-service.leave.index') }}" class="text-primary hover:text-primary/90 text-sm font-medium flex items-center gap-1">
                        Manage Leave
                        <i class="fas fa-arrow-right text-xs"></i>
                    </a>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <!-- Total Leave Days -->
                    <div class="stat-card animate-fade-in" style="animation-delay: 0.1s">
                        <div class="flex items-center">
                            <div class="stat-icon bg-blue-100 mr-4">
                                <i class="fas fa-calendar-alt text-blue-600 text-xl"></i>
                            </div>
                            <div>
                                <p class="text-sm text-gray600 mb-1">Total Leave Days</p>
                                <h3 class="text-2xl font-bold text-gray900">{{ $leaveStats->total_leave_days ?? 0 }}</h3>
                                <p class="text-xs text-blue-600">Accrued this year</p>
                            </div>
                        </div>
                    </div>

                    <!-- Leave Days Taken -->
                    <div class="stat-card animate-fade-in" style="animation-delay: 0.2s">
                        <div class="flex items-center">
                            <div class="stat-icon bg-green-100 mr-4">
                                <i class="fas fa-calendar-check text-green-600 text-xl"></i>
                            </div>
                            <div>
                                <p class="text-sm text-gray600 mb-1">Leave Days Taken</p>
                                <h3 class="text-2xl font-bold text-gray900">{{ $leaveStats->leave_days_taken ?? 0 }}</h3>
                                <p class="text-xs text-green-600">Used this year</p>
                            </div>
                        </div>
                    </div>

                    <!-- Leave Days Balance -->
                    <div class="stat-card animate-fade-in" style="animation-delay: 0.3s">
                        <div class="flex items-center">
                            <div class="stat-icon bg-purple-100 mr-4">
                                <i class="fas fa-balance-scale text-purple-600 text-xl"></i>
                            </div>
                            <div>
                                <p class="text-sm text-gray600 mb-1">Leave Days Balance</p>
                                <h3 class="text-2xl font-bold text-gray900">{{ $leaveStats->leave_days_balance ?? 0 }}</h3>
                                <p class="text-xs text-purple-600">Available balance</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                <!-- Recent Payrolls -->
                <div class="bg-white rounded-lg border border-gray200 overflow-hidden">
                    <div class="px-6 py-4 border-b border-gray200">
                        <h2 class="text-lg font-semibold text-gray900">Recent Payrolls</h2>
                        <p class="text-gray600 text-sm mt-1">Your most recent payroll entries</p>
                    </div>
                    <div class="p-6">
                        @if($recentPayrolls->count() > 0)
                            <div class="space-y-4">
                                @foreach($recentPayrolls as $payroll)
                                <div class="flex items-center justify-between p-4 bg-gray50 rounded-lg hover:bg-gray100 transition-colors">
                                    <div>
                                        <h4 class="font-medium text-gray900">{{ $payroll->payrollPeriod->period_name ?? 'N/A' }}</h4>
                                        <p class="text-sm text-gray600">
                                            {{ \Carbon\Carbon::parse($payroll->period_end_date)->format('M d, Y') }}
                                        </p>
                                    </div>
                                    <div class="text-right">
                                        <p class="font-bold text-green-600">
                                            {{ $company->currency_symbol ?? 'K' }}{{ number_format($payroll->net_pay, 2) }}
                                        </p>
                                        <span class="quickbooks-badge 
                                            @if($payroll->calculation_status == 'paid') bg-green-100 text-green-800
                                            @elseif($payroll->calculation_status == 'approved') bg-blue-100 text-blue-800
                                            @else bg-yellow-100 text-yellow-800 @endif">
                                            {{ ucfirst($payroll->calculation_status) }}
                                        </span>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                            <div class="mt-4 text-center">
                                <a href="{{ route('admin.self-service.payrolls.index') }}" 
                                   class="text-primary hover:text-primary/90 text-sm font-medium inline-flex items-center gap-1">
                                    View All Payrolls
                                    <i class="fas fa-arrow-right text-xs"></i>
                                </a>
                            </div>
                        @else
                            <div class="text-center py-8 text-gray500">
                                <div class="w-16 h-16 bg-gray100 rounded-full flex items-center justify-center mx-auto mb-4">
                                    <i class="fas fa-money-check-alt text-gray400 text-2xl"></i>
                                </div>
                                <p class="text-gray600">No payroll records found</p>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Recent Leave Requests -->
                <div class="bg-white rounded-lg border border-gray200 overflow-hidden">
                    <div class="px-6 py-4 border-b border-gray200">
                        <h2 class="text-lg font-semibold text-gray900">Recent Leave Requests</h2>
                        <p class="text-gray600 text-sm mt-1">Your most recent leave applications</p>
                    </div>
                    <div class="p-6">
                        @if($recentLeaveRequests->count() > 0)
                            <div class="space-y-4">
                                @foreach($recentLeaveRequests as $request)
                                <div class="flex items-center justify-between p-4 bg-gray50 rounded-lg hover:bg-gray100 transition-colors">
                                    <div>
                                        <h4 class="font-medium text-gray900">{{ $request->leaveType->name ?? 'N/A' }}</h4>
                                        <p class="text-sm text-gray600">
                                            {{ \Carbon\Carbon::parse($request->start_date)->format('M d') }} - 
                                            {{ \Carbon\Carbon::parse($request->end_date)->format('M d, Y') }}
                                            ({{ $request->total_days }} days)
                                        </p>
                                    </div>
                                    <div class="text-right">
                                        <span class="quickbooks-badge 
                                            @if($request->status == 'approved') bg-green-100 text-green-800
                                            @elseif($request->status == 'pending') bg-yellow-100 text-yellow-800
                                            @elseif($request->status == 'rejected') bg-red-100 text-red-800
                                            @else bg-gray-100 text-gray-800 @endif">
                                            {{ ucfirst($request->status) }}
                                        </span>
                                        <p class="text-xs text-gray600 mt-1">
                                            {{ \Carbon\Carbon::parse($request->created_at)->format('M d') }}
                                        </p>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                            <div class="mt-4 text-center">
                                <a href="{{ route('admin.self-service.leave.index') }}" 
                                   class="text-primary hover:text-primary/90 text-sm font-medium inline-flex items-center gap-1">
                                    View All Leave Requests
                                    <i class="fas fa-arrow-right text-xs"></i>
                                </a>
                            </div>
                        @else
                            <div class="text-center py-8 text-gray500">
                                <div class="w-16 h-16 bg-gray100 rounded-full flex items-center justify-center mx-auto mb-4">
                                    <i class="fas fa-calendar-alt text-gray400 text-2xl"></i>
                                </div>
                                <p class="text-gray600">No leave requests found</p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Current Running Leave -->
            @if($runningLeaves->count() > 0)
            <div class="mt-6 bg-white rounded-lg border border-gray200 overflow-hidden">
                <div class="px-6 py-4 border-b border-gray200">
                    <h2 class="text-lg font-semibold text-gray900">Current Running Leave</h2>
                    <p class="text-gray600 text-sm mt-1">Leave currently in progress</p>
                </div>
                <div class="p-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        @foreach($runningLeaves as $leave)
                        <div class="bg-blue-50 p-4 rounded-lg border border-blue-200 hover:bg-blue-100 transition-colors">
                            <div class="flex items-center justify-between mb-3">
                                <div class="flex items-center gap-3">
                                    <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center">
                                        <i class="fas fa-calendar-day text-blue-600"></i>
                                    </div>
                                    <div>
                                        <h4 class="font-medium text-blue-900">{{ $leave->leaveType->name }}</h4>
                                        <p class="text-sm text-blue-700">{{ $leave->reason }}</p>
                                    </div>
                                </div>
                                <span class="quickbooks-badge bg-blue-100 text-blue-800">
                                    Running
                                </span>
                            </div>
                            <div class="flex items-center text-sm text-blue-600 mb-2">
                                <i class="fas fa-calendar-day mr-2"></i>
                                <span>
                                    {{ \Carbon\Carbon::parse($leave->start_date)->format('M d') }} - 
                                    {{ \Carbon\Carbon::parse($leave->end_date)->format('M d, Y') }}
                                    ({{ $leave->total_days }} days)
                                </span>
                            </div>
                            <div class="mt-3 pt-3 border-t border-blue-200">
                                <div class="flex items-center text-sm text-blue-600">
                                    <i class="fas fa-clock mr-2"></i>
                                    <span>
                                        @php
                                            $daysLeft = \Carbon\Carbon::parse($leave->end_date)->diffInDays(today());
                                            $daysLeft = max(0, $daysLeft);
                                        @endphp
                                        {{ $daysLeft }} days remaining
                                    </span>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
            @endif
        </main>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Auto-refresh stats every 30 seconds
            setInterval(function() {
                fetch('{{ route("admin.accounting.self-service.api.stats") }}')
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            const stats = data.payroll_stats;
                            const leaveStats = data.leave_stats;
                            
                            // Update payroll stats
                            if (stats) {
                                updateStat('payrolls-done', stats.payrolls_done || 0);
                                updateStat('total-wages', stats.total_wages || 0);
                                updateStat('total-napsa', stats.total_napsa || 0);
                                updateStat('total-nhima', stats.total_nhima || 0);
                                updateStat('total-deductions', stats.total_deductions || 0);
                            }
                            
                            // Update leave stats
                            if (leaveStats) {
                                updateStat('total-leave-days', leaveStats.total_leave_days || 0);
                                updateStat('leave-days-taken', leaveStats.leave_days_taken || 0);
                                updateStat('leave-days-balance', leaveStats.leave_days_balance || 0);
                            }
                        }
                    })
                    .catch(error => console.error('Error fetching stats:', error));
            }, 30000);

            function updateStat(elementId, value) {
                const element = document.querySelector(`[data-stat="${elementId}"]`);
                if (element) {
                    if (typeof value === 'number') {
                        if (elementId.includes('wages') || elementId.includes('napsa') || 
                            elementId.includes('nhima') || elementId.includes('deductions')) {
                            element.textContent = (value).toLocaleString('en-US', {
                                minimumFractionDigits: 2, 
                                maximumFractionDigits: 2
                            });
                        } else {
                            element.textContent = value;
                        }
                    } else {
                        element.textContent = value;
                    }
                }
            }

            // Add animation to cards on hover
            const statCards = document.querySelectorAll('.stat-card');
            statCards.forEach(card => {
                card.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-4px)';
                });
                card.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0)';
                });
            });

            // Auto-hide alerts after 5 seconds
            setTimeout(() => {
                const alerts = document.querySelectorAll('.bg-green-50, .bg-red-50');
                alerts.forEach(alert => {
                    if (alert) {
                        alert.style.opacity = '0';
                        alert.style.transition = 'opacity 0.5s ease';
                        setTimeout(() => {
                            if (alert.parentNode) {
                                alert.parentNode.removeChild(alert);
                            }
                        }, 500);
                    }
                });
            }, 5000);
        });
    </script>
</body>
</html>