<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Apply for Leave | {{ config('app.name', 'IMMIA FINANCE') }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#146CAA',
                        primaryLight: '#E1F0FA',
                        secondary: '#6b7280',
                        success: '#107C10',
                        warning: '#F68C1E',
                        danger: '#D83B01',
                        info: '#0078D4',
                        gray50: '#FAF9F8',
                        gray100: '#F3F2F1',
                        gray200: '#EDEBE9',
                        gray300: '#E1DFDD',
                        gray400: '#C8C6C4',
                        gray500: '#A19F9D',
                        gray600: '#605E5C',
                        gray700: '#323130',
                        gray800: '#201F1E',
                        gray900: '#000000'
                    }
                }
            }
        }
    </script>
    <style>
        .quickbooks-input {
            border: 1px solid #E1DFDD;
            border-radius: 4px;
            padding: 8px 12px;
            font-size: 14px;
            transition: border-color 0.2s;
            width: 100%;
        }
        .quickbooks-input:focus {
            outline: none;
            border-color: #146CAA;
            box-shadow: 0 0 0 2px rgba(20, 108, 170, 0.1);
        }
        .balance-card {
            background: white;
            border: 1px solid #EDEBE9;
            border-radius: 8px;
            padding: 16px;
        }
        .quickbooks-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .animate-fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }
    </style>
</head>
<body class="bg-gray50">
    @include('accounting.partials.sidebar')

    <div class="lg:ml-64">
        @include('accounting.partials.header', ['title' => 'Apply for Leave', 'subtitle' => 'Submit a new leave request'])

        <main class="p-6">
            <!-- Leave Balances -->
            @if($leaveBalances->count() > 0)
            <div class="mb-6">
                <h2 class="text-lg font-semibold text-gray900 mb-4">Your Leave Balances ({{ date('Y') }})</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                    @foreach($leaveBalances as $balance)
                    <div class="balance-card animate-fade-in" id="balance-{{ $balance->leave_type_id }}">
                        <div class="flex items-center justify-between mb-3">
                            <div>
                                <h3 class="text-sm font-semibold text-gray900">{{ $balance->leaveType->name }}</h3>
                                <p class="text-xs text-gray600">{{ $balance->leaveType->code }}</p>
                            </div>
                            <div class="w-8 h-8 bg-blue-100 rounded-lg flex items-center justify-center">
                                <i class="fas fa-calendar-alt text-blue-600"></i>
                            </div>
                        </div>
                        <div class="space-y-2">
                            <div class="flex justify-between text-sm">
                                <span class="text-gray600">Available:</span>
                                <span class="font-medium text-green-600">{{ $balance->available_balance }} days</span>
                            </div>
                            <div class="flex justify-between text-sm">
                                <span class="text-gray600">Max per year:</span>
                                <span class="font-medium text-gray900">{{ $balance->leaveType->max_days_per_year ?? 'Unlimited' }} days</span>
                            </div>
                            @if($balance->leaveType->can_carry_forward && $balance->leaveType->max_carry_forward_days)
                            <div class="flex justify-between text-sm">
                                <span class="text-gray600">Carry forward:</span>
                                <span class="font-medium text-blue-600">{{ $balance->leaveType->max_carry_forward_days }} days</span>
                            </div>
                            @endif
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <!-- Application Form -->
                <div class="lg:col-span-2">
                    <div class="bg-white rounded-lg border border-gray200 overflow-hidden">
                        <div class="px-6 py-4 border-b border-gray200">
                            <h2 class="text-lg font-semibold text-gray900">Leave Application Form</h2>
                            <p class="text-gray600 text-sm mt-1">Fill in the details of your leave request</p>
                        </div>
                        <div class="p-6">
                            <form id="leaveForm" method="POST" action="{{ route('admin.accounting.self-service.leave.store') }}">
                                @csrf
                                
                                <!-- Leave Type -->
                                <div class="mb-6">
                                    <label for="leave_type_id" class="block text-sm font-medium text-gray700 mb-2">
                                        Leave Type <span class="text-red-500">*</span>
                                    </label>
                                    <select name="leave_type_id" 
                                            id="leave_type_id"
                                            class="quickbooks-input"
                                            required
                                            onchange="updateLeaveTypeInfo()">
                                        <option value="">Select leave type</option>
                                        @foreach($leaveTypes as $type)
                                            <option value="{{ $type->id }}"
                                                    data-max-days="{{ $type->max_days_per_year }}"
                                                    data-requires-approval="{{ $type->requires_approval ? '1' : '0' }}"
                                                    data-is-paid="{{ $type->is_paid ? '1' : '0' }}">
                                                {{ $type->name }} ({{ $type->code }})
                                            </option>
                                        @endforeach
                                    </select>
                                    <div id="leaveTypeInfo" class="mt-2 hidden">
                                        <div class="grid grid-cols-2 gap-2 text-xs">
                                            <div>
                                                <span class="text-gray600">Max Days:</span>
                                                <span id="maxDaysInfo" class="font-medium text-gray900 ml-1"></span>
                                            </div>
                                            <div>
                                                <span class="text-gray600">Approval:</span>
                                                <span id="approvalInfo" class="font-medium text-gray900 ml-1"></span>
                                            </div>
                                            <div>
                                                <span class="text-gray600">Paid Leave:</span>
                                                <span id="paidInfo" class="font-medium text-gray900 ml-1"></span>
                                            </div>
                                            <div>
                                                <span class="text-gray600">Carry Forward:</span>
                                                <span id="carryForwardInfo" class="font-medium text-gray900 ml-1"></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Date Range -->
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                                    <div>
                                        <label for="start_date" class="block text-sm font-medium text-gray700 mb-2">
                                            Start Date <span class="text-red-500">*</span>
                                        </label>
                                        <input type="text" 
                                               name="start_date" 
                                               id="start_date"
                                               class="quickbooks-input"
                                               required
                                               placeholder="Select start date">
                                    </div>
                                    <div>
                                        <label for="end_date" class="block text-sm font-medium text-gray700 mb-2">
                                            End Date <span class="text-red-500">*</span>
                                        </label>
                                        <input type="text" 
                                               name="end_date" 
                                               id="end_date"
                                               class="quickbooks-input"
                                               required
                                               placeholder="Select end date">
                                    </div>
                                </div>

                                <!-- Calculated Duration -->
                                <div class="mb-6">
                                    <div class="bg-gray50 p-4 rounded-lg border border-gray200">
                                        <div class="flex justify-between items-center">
                                            <div>
                                                <p class="text-sm text-gray600">Leave Duration</p>
                                                <p id="durationInfo" class="text-lg font-bold text-primary">0 days</p>
                                            </div>
                                            <div class="text-right">
                                                <p class="text-xs text-gray600">Available Balance</p>
                                                <p id="availableBalance" class="text-sm font-semibold text-gray900">0 days</p>
                                            </div>
                                        </div>
                                        <div id="durationWarning" class="mt-2 hidden">
                                            <div class="flex items-center text-sm text-red-600">
                                                <i class="fas fa-exclamation-triangle mr-2"></i>
                                                <span>Insufficient leave balance</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Reason -->
                                <div class="mb-6">
                                    <label for="reason" class="block text-sm font-medium text-gray700 mb-2">
                                        Reason for Leave <span class="text-red-500">*</span>
                                    </label>
                                    <textarea name="reason" 
                                              id="reason"
                                              rows="4"
                                              class="quickbooks-input resize-none"
                                              placeholder="Please provide a detailed reason for your leave request"
                                              required></textarea>
                                    <p class="text-xs text-gray600 mt-1">Maximum 500 characters</p>
                                </div>

                                <!-- Additional Information -->
                                <div class="bg-blue-50 p-4 rounded-lg border border-blue-200 mb-6">
                                    <div class="flex items-center mb-2">
                                        <i class="fas fa-info-circle text-blue-600 mr-2"></i>
                                        <h4 class="text-sm font-semibold text-blue-900">Important Information</h4>
                                    </div>
                                    <ul class="text-sm text-blue-700 space-y-1">
                                        <li>• Leave requests require manager approval for certain leave types</li>
                                        <li>• You will be notified via email once your request is processed</li>
                                        <li>• Ensure you have sufficient leave balance before submitting</li>
                                        <li>• Cancellation of approved leave may affect your balance</li>
                                    </ul>
                                </div>

                                <!-- Submit Buttons -->
                                <div class="flex justify-end gap-3 pt-6 border-t border-gray200">
                                    <a href="{{ route('admin.accounting.self-service.leave.index') }}" 
                                       class="px-4 py-2 text-gray700 hover:bg-gray100 rounded text-sm font-medium">
                                        Cancel
                                    </a>
                                    <button type="submit" 
                                            id="submitBtn"
                                            class="bg-primary text-white px-4 py-2 rounded text-sm font-medium hover:bg-primary/90 flex items-center gap-2">
                                        <i class="fas fa-paper-plane"></i>
                                        Submit Leave Request
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Guidelines -->
                <div>
                    <div class="bg-white rounded-lg border border-gray200 overflow-hidden">
                        <div class="px-6 py-4 border-b border-gray200">
                            <h2 class="text-lg font-semibold text-gray900">Leave Guidelines</h2>
                            <p class="text-gray600 text-sm mt-1">Important information about leave</p>
                        </div>
                        <div class="p-6">
                            <div class="space-y-4">
                                <div class="bg-gray50 p-4 rounded-lg">
                                    <div class="flex items-center gap-3 mb-2">
                                        <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center">
                                            <i class="fas fa-clock text-green-600"></i>
                                        </div>
                                        <div>
                                            <h4 class="text-sm font-semibold text-gray900">Submission Timeline</h4>
                                        </div>
                                    </div>
                                    <p class="text-xs text-gray600">
                                        Submit leave requests at least 7 days in advance for better approval chances.
                                    </p>
                                </div>

                                <div class="bg-gray50 p-4 rounded-lg">
                                    <div class="flex items-center gap-3 mb-2">
                                        <div class="w-8 h-8 bg-blue-100 rounded-lg flex items-center justify-center">
                                            <i class="fas fa-check-circle text-blue-600"></i>
                                        </div>
                                        <div>
                                            <h4 class="text-sm font-semibold text-gray900">Approval Process</h4>
                                        </div>
                                    </div>
                                    <p class="text-xs text-gray600">
                                        Approval typically takes 2-3 working days. You'll receive email notifications.
                                    </p>
                                </div>

                                <div class="bg-gray50 p-4 rounded-lg">
                                    <div class="flex items-center gap-3 mb-2">
                                        <div class="w-8 h-8 bg-yellow-100 rounded-lg flex items-center justify-center">
                                            <i class="fas fa-exclamation-triangle text-yellow-600"></i>
                                        </div>
                                        <div>
                                            <h4 class="text-sm font-semibold text-gray900">Emergency Leave</h4>
                                        </div>
                                    </div>
                                    <p class="text-xs text-gray600">
                                        For emergency leave, contact your manager directly after submitting the request.
                                    </p>
                                </div>

                                <div class="bg-gray50 p-4 rounded-lg">
                                    <div class="flex items-center gap-3 mb-2">
                                        <div class="w-8 h-8 bg-purple-100 rounded-lg flex items-center justify-center">
                                            <i class="fas fa-calendar-alt text-purple-600"></i>
                                        </div>
                                        <div>
                                            <h4 class="text-sm font-semibold text-gray900">Balance Carryover</h4>
                                        </div>
                                    </div>
                                    <p class="text-xs text-gray600">
                                        Unused leave may carry over to next year depending on your leave type policy.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize date pickers
            const startDatePicker = flatpickr("#start_date", {
                dateFormat: "Y-m-d",
                minDate: "today",
                onChange: function(selectedDates, dateStr) {
                    if (dateStr) {
                        endDatePicker.set('minDate', dateStr);
                        calculateDuration();
                    }
                }
            });

            const endDatePicker = flatpickr("#end_date", {
                dateFormat: "Y-m-d",
                minDate: "today",
                onChange: function(selectedDates, dateStr) {
                    if (dateStr) {
                        calculateDuration();
                    }
                }
            });

            // Update leave type info
            window.updateLeaveTypeInfo = function() {
                const select = document.getElementById('leave_type_id');
                const selectedOption = select.options[select.selectedIndex];
                const infoDiv = document.getElementById('leaveTypeInfo');
                
                if (selectedOption.value) {
                    infoDiv.classList.remove('hidden');
                    
                    // Update info
                    const maxDays = selectedOption.getAttribute('data-max-days');
                    const requiresApproval = selectedOption.getAttribute('data-requires-approval');
                    const isPaid = selectedOption.getAttribute('data-is-paid');
                    
                    document.getElementById('maxDaysInfo').textContent = maxDays ? maxDays + ' days' : 'Unlimited';
                    document.getElementById('approvalInfo').textContent = requiresApproval === '1' ? 'Required' : 'Auto';
                    document.getElementById('paidInfo').textContent = isPaid === '1' ? 'Yes' : 'No';
                    
                    // Also check carry forward from leave types data
                    const leaveTypeId = selectedOption.value;
                    const leaveType = @json($leaveTypes->keyBy('id')->toArray());
                    if (leaveType[leaveTypeId]) {
                        const canCarryForward = leaveType[leaveTypeId].can_carry_forward;
                        const maxCarryForward = leaveType[leaveTypeId].max_carry_forward_days;
                        document.getElementById('carryForwardInfo').textContent = canCarryForward 
                            ? (maxCarryForward ? maxCarryForward + ' days' : 'Yes') 
                            : 'No';
                    }
                    
                    // Update available balance
                    updateAvailableBalance(leaveTypeId);
                } else {
                    infoDiv.classList.add('hidden');
                }
            };

            // Calculate duration
            window.calculateDuration = function() {
                const startDate = document.getElementById('start_date').value;
                const endDate = document.getElementById('end_date').value;
                
                if (startDate && endDate) {
                    const start = new Date(startDate);
                    const end = new Date(endDate);
                    
                    // Calculate working days (excluding weekends)
                    let days = 0;
                    const current = new Date(start);
                    
                    while (current <= end) {
                        const day = current.getDay();
                        if (day !== 0 && day !== 6) { // Skip Sunday (0) and Saturday (6)
                            days++;
                        }
                        current.setDate(current.getDate() + 1);
                    }
                    
                    document.getElementById('durationInfo').textContent = days + ' days';
                    
                    // Check against available balance
                    const leaveTypeId = document.getElementById('leave_type_id').value;
                    if (leaveTypeId) {
                        checkBalance(days, leaveTypeId);
                    }
                    
                    return days;
                }
                
                return 0;
            };

            // Update available balance
            function updateAvailableBalance(leaveTypeId) {
                const balanceCard = document.getElementById(`balance-${leaveTypeId}`);
                if (balanceCard) {
                    const availableSpan = balanceCard.querySelector('span.text-green-600');
                    if (availableSpan) {
                        document.getElementById('availableBalance').textContent = availableSpan.textContent;
                    }
                }
            }

            // Check balance
            function checkBalance(requestedDays, leaveTypeId) {
                const balanceCard = document.getElementById(`balance-${leaveTypeId}`);
                if (balanceCard) {
                    const availableSpan = balanceCard.querySelector('span.text-green-600');
                    if (availableSpan) {
                        const availableDays = parseInt(availableSpan.textContent.split(' ')[0]);
                        const warningDiv = document.getElementById('durationWarning');
                        const submitBtn = document.getElementById('submitBtn');
                        
                        if (requestedDays > availableDays) {
                            warningDiv.classList.remove('hidden');
                            submitBtn.disabled = true;
                            submitBtn.classList.add('opacity-50', 'cursor-not-allowed');
                        } else {
                            warningDiv.classList.add('hidden');
                            submitBtn.disabled = false;
                            submitBtn.classList.remove('opacity-50', 'cursor-not-allowed');
                        }
                    }
                }
            }

            // Form submission
            const form = document.getElementById('leaveForm');
            const submitBtn = document.getElementById('submitBtn');
            
            form.addEventListener('submit', function(e) {
                const startDate = document.getElementById('start_date').value;
                const endDate = document.getElementById('end_date').value;
                const leaveTypeId = document.getElementById('leave_type_id').value;
                const reason = document.getElementById('reason').value;
                
                if (!startDate || !endDate || !leaveTypeId || !reason) {
                    e.preventDefault();
                    alert('Please fill in all required fields.');
                    return false;
                }
                
                if (submitBtn) {
                    submitBtn.disabled = true;
                    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-1"></i> Submitting...';
                }
            });

            // Character counter for reason
            const reasonTextarea = document.getElementById('reason');
            if (reasonTextarea) {
                reasonTextarea.addEventListener('input', function() {
                    const charCount = this.value.length;
                    const charCounter = document.getElementById('charCounter');
                    
                    if (charCount > 500) {
                        this.value = this.value.substring(0, 500);
                    }
                });
            }
        });
    </script>
</body>
</html>